/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import java.util.NoSuchElementException;

class ModelBreaker {
    private boolean done = false;
    private BreakIterator iter;
    private final String prefix;
    private final String model;
    private final String suffix;
    private final int maxLineLength;
    private int modelPos;
    private ModelBreaker nested = null;

    ModelBreaker(String string, String string2, String string3, int n) {
        if (ModelBreaker.isSingleGroup(string2)) {
            int n2 = string2.indexOf(40) + 1;
            this.prefix = string + string2.substring(0, n2);
            this.model = string2.substring(n2);
        } else {
            this.prefix = string;
            this.model = string2;
        }
        this.suffix = string3;
        this.maxLineLength = n;
        this.modelPos = 0;
    }

    boolean hasNextLine() {
        if (this.nested != null && this.nested.hasNextLine()) {
            return true;
        }
        return !this.done;
    }

    String nextLine() {
        int n;
        int n2;
        if (this.nested != null && this.nested.hasNextLine()) {
            return this.nested.nextLine();
        }
        if (this.done) {
            throw new NoSuchElementException();
        }
        int n3 = this.maxLineLength - this.prefix.length();
        boolean bl = false;
        if (this.model.length() - this.modelPos + this.suffix.length() > n3) {
            if (this.iter == null) {
                this.iter = new BreakIterator(this.model);
            }
            n2 = -1;
            while ((n = this.iter.getPos()) < this.model.length()) {
                int n4 = n - this.modelPos;
                if (n4 > 0) {
                    if (n4 > n3) {
                        if (n2 != -1) break;
                        n2 = n;
                        bl = true;
                        break;
                    }
                    n2 = n;
                }
                if (this.iter.advance()) continue;
            }
            if (n2 == -1) {
                bl = true;
                n2 = this.model.length();
            }
        } else {
            n2 = this.model.length();
        }
        n = n2 < this.model.length() && this.model.charAt(n2) == ' ' ? n2 + 1 : n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.modelPos == 0) {
            stringBuffer.append(this.prefix);
        } else {
            int n5 = this.prefix.length();
            for (int i = 0; i < n5; ++i) {
                stringBuffer.append(' ');
            }
        }
        if (bl && (this.modelPos != 0 || n2 != this.model.length())) {
            String string;
            if (n2 == this.model.length()) {
                this.done = true;
                string = this.suffix;
            } else {
                string = "";
            }
            this.nested = new ModelBreaker(stringBuffer.toString(), this.model.substring(this.modelPos, n2), string, this.maxLineLength);
            this.modelPos = n;
            return this.nested.nextLine();
        }
        stringBuffer.append(this.model.substring(this.modelPos, n2));
        if (n == this.model.length()) {
            this.done = true;
            stringBuffer.append(this.suffix);
        }
        this.modelPos = n;
        return stringBuffer.toString();
    }

    private static boolean isSingleGroup(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (string.charAt(0) == '|') {
            ++n2;
        }
        if (string.charAt(n2) != '(') {
            return false;
        }
        block7: while (n > n2) {
            switch (string.charAt(n - 1)) {
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '?': 
                case '|': {
                    --n;
                    continue block7;
                }
            }
        }
        int n3 = 0;
        ++n2;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '(': {
                    ++n3;
                    break;
                }
                case ')': {
                    if (n3 == 0) {
                        return false;
                    }
                    --n3;
                }
            }
            ++n2;
        }
        return true;
    }

    public static void main(String[] stringArray) throws NumberFormatException {
        ModelBreaker modelBreaker = new ModelBreaker(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
        while (modelBreaker.hasNextLine()) {
            System.err.println(modelBreaker.nextLine());
        }
    }

    private static class BreakIterator {
        private final String model;
        private int pos = 0;
        private final int length;

        BreakIterator(String string) {
            this.model = string;
            this.length = string.length();
        }

        int getPos() {
            return this.pos;
        }

        boolean advance() {
            boolean bl = false;
            int n = 0;
            while (this.pos < this.length) {
                switch (this.model.charAt(this.pos)) {
                    case '(': {
                        ++n;
                        break;
                    }
                    case ')': {
                        --n;
                        break;
                    }
                    case ',': {
                        if (n != 0 || ++this.pos == this.length) break;
                        return true;
                    }
                    case '|': {
                        if (n != 0 || !bl) break;
                        return true;
                    }
                    case ' ': {
                        if (n != 0 || !bl) break;
                        return true;
                    }
                }
                bl = true;
                ++this.pos;
            }
            return false;
        }
    }
}

