/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sd extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "ڪينيڊا";
        final String metaValue_FJ = "فجي";
        final String metaValue_HU = "هنگري";
        final String metaValue_LU = "لگزمبرگ";
        final String metaValue_NU = "نووي";
        final String metaValue_TV = "توالو";
        final String metaValue_ar = "عربي";
        final String metaValue_bn = "بنگلا";
        final String metaValue_el = "يوناني";
        final String metaValue_gu = "گجراتي";
        final String metaValue_he = "عبراني";
        final String metaValue_ja = "جاپاني";
        final String metaValue_km = "خمر";
        final String metaValue_kn = "ڪناڊا";
        final String metaValue_ko = "ڪوريائي";
        final String metaValue_lo = "لائو";
        final String metaValue_la = "لاطيني";
        final String metaValue_mn = "منگولي";
        final String metaValue_nqo = "نڪو";
        final String metaValue_or = "اوڊيا";
        final String metaValue_si = "سنهالا";
        final String metaValue_su = "سوڊاني";
        final String metaValue_syr = "شامي";
        final String metaValue_ta = "تامل";
        final String metaValue_te = "تلگو";
        final String metaValue_th = "ٿائي";
        final Object[][] data = new Object[][] {
            { "001", "دنيا" },
            { "002", "آفريڪا" },
            { "003", "اتر آمريڪا" },
            { "005", "ڏکڻ آمريڪا" },
            { "009", "اوشنيا" },
            { "011", "اولهه آفريقا" },
            { "013", "وچ آمريڪا" },
            { "014", "اوڀر آفريڪا" },
            { "015", "اتر آفريڪا" },
            { "017", "وچ آفريڪا" },
            { "018", "ڏاکڻي آمريڪا" },
            { "019", "آمريڪا" },
            { "021", "اترين آمريڪا" },
            { "029", "ڪيريبين" },
            { "030", "اوڀر ايشيا" },
            { "034", "ڏکڻ ايشيا" },
            { "035", "ڏکڻ اوڀر ايشيا" },
            { "039", "ڏکڻ يورپ" },
            { "053", "آسٽریلیشیا" },
            { "054", "میلانیشیا" },
            { "057", "مائڪرونيشائي خطو" },
            { "061", "پولینیشیا" },
            { "142", "ايشيا" },
            { "143", "وچ ايشيا" },
            { "145", "اولهه ايشيا" },
            { "150", "يورپ" },
            { "151", "اوڀر يورپ" },
            { "154", "اترين يورپ" },
            { "155", "اولهه يورپ" },
            { "202", "سب-سهارا آفريڪا" },
            { "419", "لاطيني آمريڪا" },
            { "AC", "طلوع ٻيٽ" },
            { "AD", "اندورا" },
            { "AE", "متحده عرب امارات" },
            { "AF", "افغانستان" },
            { "AG", "اينٽيگا ۽ باربوڊا" },
            { "AI", "انگويلا" },
            { "AL", "البانيا" },
            { "AM", "آرمينيا" },
            { "AO", "انگولا" },
            { "AQ", "انٽارڪٽيڪا" },
            { "AR", "ارجنٽينا" },
            { "AS", "آمريڪي ساموا" },
            { "AT", "آسٽريا" },
            { "AU", "آسٽريليا" },
            { "AW", "عروبا" },
            { "AX", "الند ٻيٽ" },
            { "AZ", "آذربائيجان" },
            { "BA", "بوسنيا ۽ هرزيگووينا" },
            { "BB", "باربڊوس" },
            { "BD", "بنگلاديش" },
            { "BE", "بيلجيم" },
            { "BF", "برڪينا فاسو" },
            { "BG", "بلغاريا" },
            { "BH", "بحرين" },
            { "BI", "برونڊي" },
            { "BJ", "بينن" },
            { "BL", "سینٽ برٿلیمی" },
            { "BM", "برمودا" },
            { "BN", "برونائي" },
            { "BO", "بوليويا" },
            { "BQ", "ڪيريبين نيدرلينڊ" },
            { "BR", "برازيل" },
            { "BS", "باهاماس" },
            { "BT", "ڀوٽان" },
            { "BV", "بووٽ ٻيٽ" },
            { "BW", "بوٽسوانا" },
            { "BY", "بيلاروس" },
            { "BZ", "بيليز" },
            { "CA", metaValue_CA },
            { "CC", "ڪوڪوس ٻيٽ" },
            { "CD", "ڪانگو -ڪنشاسا" },
            { "CF", "وچ آفريقي جمهوريه" },
            { "CG", "ڪانگو - برازاویل" },
            { "CH", "سوئزرلينڊ" },
            { "CI", "ڪوٽي ويرا" },
            { "CK", "ڪوڪ ٻيٽ" },
            { "CL", "چلي" },
            { "CM", "ڪيمرون" },
            { "CN", "چين" },
            { "CO", "ڪولمبيا" },
            { "CP", "ڪلپرٽن ٻيٽ" },
            { "CQ", "سارڪ" },
            { "CR", "ڪوسٽا ريڪا" },
            { "CU", "ڪيوبا" },
            { "CV", "ڪيپ وردي" },
            { "CW", "ڪيوراسائو" },
            { "CX", "ڪرسمس ٻيٽ" },
            { "CY", "سائپرس" },
            { "CZ", "چيڪيا" },
            { "DE", "جرمني" },
            { "DG", "ڊئيگو گارسيا" },
            { "DJ", "ڊجبيوتي" },
            { "DK", "ڊينمارڪ" },
            { "DM", "ڊومينيڪا" },
            { "DO", "ڊومينيڪن جمهوريه" },
            { "DZ", "الجيريا" },
            { "EA", "سیوٽا ۽ میلیلا" },
            { "EC", "ايڪواڊور" },
            { "EE", "ايسٽونيا" },
            { "EG", "مصر" },
            { "EH", "اولهه صحارا" },
            { "ER", "ايريٽيريا" },
            { "ES", "اسپين" },
            { "ET", "ايٿوپيا" },
            { "EU", "يورپين يونين" },
            { "EZ", "يورو زون" },
            { "FI", "فن لينڊ" },
            { "FJ", metaValue_FJ },
            { "FK", "فاڪ لينڊ ٻيٽ" },
            { "FM", "مائڪرونيشيا" },
            { "FO", "فارو ٻيٽ" },
            { "FR", "فرانس" },
            { "GA", "گبون" },
            { "GB", "برطانيہ" },
            { "GD", "گريناڊا" },
            { "GE", "جارجيا" },
            { "GF", "فرانسيسي گيانا" },
            { "GG", "گورنسي" },
            { "GH", "گهانا" },
            { "GI", "جبرالٽر" },
            { "GL", "گرين لينڊ" },
            { "GM", "گيمبيا" },
            { "GN", "گني" },
            { "GP", "گواڊیلوپ" },
            { "GQ", "ايڪوٽوريل گائينا" },
            { "GR", "يونان" },
            { "GS", "ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ" },
            { "GT", "گوئٽي مالا" },
            { "GU", "گوام" },
            { "GW", "گني بسائو" },
            { "GY", "گيانا" },
            { "HK", "هانگ ڪانگ SAR چين" },
            { "HM", "هرڊ ۽ مڪڊونلڊ ٻيٽ" },
            { "HN", "هنڊورس" },
            { "HR", "ڪروئيشيا" },
            { "HT", "هيٽي" },
            { "HU", metaValue_HU },
            { "IC", "ڪينري ٻيٽ" },
            { "ID", "انڊونيشيا" },
            { "IE", "آئرلينڊ" },
            { "IL", "اسرائيل" },
            { "IM", "انسانن جو ٻيٽ" },
            { "IN", "ڀارت" },
            { "IO", "برطانوي هندي سمنڊ خطو" },
            { "IQ", "عراق" },
            { "IR", "ايران" },
            { "IS", "آئس لينڊ" },
            { "IT", "اٽلي" },
            { "JE", "جرسي" },
            { "JM", "جميڪا" },
            { "JO", "اردن" },
            { "JP", "جاپان" },
            { "KE", "ڪينيا" },
            { "KG", "ڪرغستان" },
            { "KH", "ڪمبوڊيا" },
            { "KI", "ڪرباتي" },
            { "KM", "ڪوموروس" },
            { "KN", "سينٽ ڪٽس و نيوس" },
            { "KP", "اتر ڪوريا" },
            { "KR", "ڏکڻ ڪوريا" },
            { "KW", "ڪويت" },
            { "KY", "ڪي مين ٻيٽ" },
            { "KZ", "قازقستان" },
            { "LA", "لائوس" },
            { "LB", "لبنان" },
            { "LC", "سينٽ لوسيا" },
            { "LI", "لچي ٽينسٽين" },
            { "LK", "سري لنڪا" },
            { "LR", "لائبیریا" },
            { "LS", "ليسوٿو" },
            { "LT", "لٿونيا" },
            { "LU", metaValue_LU },
            { "LV", "لاتويا" },
            { "LY", "لبيا" },
            { "MA", "مراڪش" },
            { "MC", "موناڪو" },
            { "MD", "مالدووا" },
            { "ME", "مونٽي نيگرو" },
            { "MF", "سينٽ مارٽن" },
            { "MG", "مدگاسڪر" },
            { "MH", "مارشل ٻيٽ" },
            { "MK", "اتر مقدونيا" },
            { "ML", "مالي" },
            { "MM", "ميانمار (برما)" },
            { "MN", "منگوليا" },
            { "MO", "مڪائو SAR چين" },
            { "MP", "اتريان ماريانا ٻيٽ" },
            { "MQ", "مارتينڪ" },
            { "MR", "موريتانيا" },
            { "MS", "مونٽسراٽ" },
            { "MT", "مالٽا" },
            { "MU", "موريشس" },
            { "MV", "مالديپ" },
            { "MW", "مالاوي" },
            { "MX", "ميڪسيڪو" },
            { "MY", "ملائيشيا" },
            { "MZ", "موزمبیق" },
            { "NA", "نيميبيا" },
            { "NC", "نیو ڪالیڊونیا" },
            { "NE", "نائيجر" },
            { "NF", "نورفوڪ ٻيٽ" },
            { "NG", "نائيجيريا" },
            { "NI", "نڪراگوا" },
            { "NL", "نيدرلينڊ" },
            { "NO", "ناروي" },
            { "NP", "نيپال" },
            { "NR", "نائورو" },
            { "NU", metaValue_NU },
            { "NZ", "نيو زيلينڊ" },
            { "OM", "عمان" },
            { "PA", "پناما" },
            { "PE", "پيرو" },
            { "PF", "فرانسيسي پولينيشيا" },
            { "PG", "پاپوا نیو گني" },
            { "PH", "فلپائن" },
            { "PK", "پاڪستان" },
            { "PL", "پولينڊ" },
            { "PM", "سينٽ پيئر ۽ ميڪيلون" },
            { "PN", "پٽڪئرن ٻيٽ" },
            { "PR", "پيوئرٽو ريڪو" },
            { "PS", "فلسطيني علائقا" },
            { "PT", "پرتگال" },
            { "PW", "پلائو" },
            { "PY", "پيراگوءِ" },
            { "QA", "قطر" },
            { "QO", "بيروني سامونڊي" },
            { "RE", "ري يونين" },
            { "RO", "رومانيا" },
            { "RS", "سربيا" },
            { "RU", "روس" },
            { "RW", "روانڊا" },
            { "SA", "سعودي عرب" },
            { "SB", "سولومون ٻيٽَ" },
            { "SC", "شي شلز" },
            { "SD", "سوڊان" },
            { "SE", "سوئيڊن" },
            { "SG", "سنگاپور" },
            { "SH", "سينٽ ھيلينا" },
            { "SI", "سلوینیا" },
            { "SJ", "سوالبارڊ ۽ يان ماین" },
            { "SK", "سلوواڪيا" },
            { "SL", "سيرا ليون" },
            { "SM", "سان مرینو" },
            { "SN", "سينيگال" },
            { "SO", "سوماليا" },
            { "SR", "سورينام" },
            { "SS", "ڏکڻ سوڊان" },
            { "ST", "سائو ٽومي ۽ پرنسپیي" },
            { "SV", "ال سلواڊور" },
            { "SX", "سنٽ مارٽن" },
            { "SY", "شام" },
            { "SZ", "ايسواٽني" },
            { "TA", "ٽرسٽن دا ڪوها" },
            { "TC", "ترڪ ۽ ڪيڪوس ٻيٽ" },
            { "TD", "چاڊ" },
            { "TF", "فرانسيسي ڏاکڻي علائقا" },
            { "TG", "ٽوگو" },
            { "TH", "ٿائيليند" },
            { "TJ", "تاجڪستان" },
            { "TK", "ٽوڪلائو" },
            { "TL", "تيمور ليستي" },
            { "TM", "ترڪمانستان" },
            { "TN", "تيونيسيا" },
            { "TO", "ٽونگا" },
            { "TR", "ترڪييي" },
            { "TT", "ٽرينيڊاڊ ۽ ٽوباگو" },
            { "TV", metaValue_TV },
            { "TW", "تائیوان" },
            { "TZ", "تنزانيا" },
            { "UA", "يوڪرين" },
            { "UG", "يوگنڊا" },
            { "UM", "آمريڪي خارجي ٻيٽ" },
            { "UN", "گڏيل قومون" },
            { "US", "آمريڪا جون گڏيل رياستون" },
            { "UY", "يوروگوءِ" },
            { "UZ", "ازبڪستان" },
            { "VA", "ويٽڪين سٽي" },
            { "VC", "سینٽ ونسنت ۽ گریناڊینز" },
            { "VE", "وينزويلا" },
            { "VG", "برطانوي ورجن ٻيٽ" },
            { "VI", "آمريڪي ورجن ٻيٽ" },
            { "VN", "ويتنام" },
            { "VU", "وينيٽيو" },
            { "WF", "والس ۽ فتونا" },
            { "WS", "ساموا" },
            { "XA", "سوڊو-لهجا" },
            { "XB", "سوڊو-بي ڊي" },
            { "XK", "ڪوسووو" },
            { "YE", "يمن" },
            { "YT", "مياتي" },
            { "ZA", "ڏکڻ آفريقا" },
            { "ZM", "زيمبيا" },
            { "ZW", "زمبابوي" },
            { "ZZ", "اڻڄاتل خطو" },
            { "aa", "افار" },
            { "ab", "ابقازیان" },
            { "af", "آفريڪي" },
            { "ak", "اڪان" },
            { "am", "امهاري" },
            { "an", "ارگني" },
            { "ar", metaValue_ar },
            { "as", "آسامي" },
            { "av", "اويرس" },
            { "ay", "ایمارا" },
            { "az", "آزربائيجاني" },
            { "ba", metaValue_CA },
            { "be", "بيلاروسي" },
            { "bg", "بلغاريائي" },
            { "bi", "بسلاما" },
            { "bm", "بمبارا" },
            { "bn", metaValue_bn },
            { "bo", "تبيتائي" },
            { "br", "بريٽن" },
            { "bs", "بوسنيائي" },
            { "ca", "ڪيٽالان" },
            { "ce", "چیچن" },
            { "ch", "چمورو" },
            { "co", "ڪارسيڪائي" },
            { "cs", "چيڪ" },
            { "cu", "چرچ سلاوی" },
            { "cv", "چو واش" },
            { "cy", "ويلش" },
            { "da", "ڊينش" },
            { "de", "جرمن" },
            { "dv", "دويهي" },
            { "dz", "زونخا" },
            { "ee", "ايو" },
            { "el", metaValue_el },
            { "en", "انگريزي" },
            { "eo", "ايسپرانٽو" },
            { "es", "هسپانوي" },
            { "et", "ايستونائي" },
            { "eu", "باسق" },
            { "fa", "فارسي" },
            { "ff", "فلاهه" },
            { "fi", "فنش" },
            { "fj", metaValue_FJ },
            { "fo", "فيروايس" },
            { "fr", "فرانسيسي" },
            { "fy", "مغربي فريشن" },
            { "ga", "آئرش" },
            { "gd", "اسڪاٽش گيلڪ" },
            { "gl", "گليشئين" },
            { "gn", "گواراني" },
            { "gu", metaValue_gu },
            { "gv", "مينڪس" },
            { "ha", "هوسا" },
            { "he", metaValue_he },
            { "hi", "هندي" },
            { "hr", "ڪروشيائي" },
            { "ht", "هيٽي ڪرولي" },
            { "hu", metaValue_HU },
            { "hy", "ارماني" },
            { "hz", "هريرو" },
            { "ia", "انٽرلنگئا" },
            { "id", "انڊونيشي" },
            { "ie", "انٽرلنگئي" },
            { "ig", "اگبو" },
            { "ii", "سچوان يي" },
            { "io", "ادو" },
            { "is", "آئيس لينڊڪ" },
            { "it", "اطالوي" },
            { "iu", "انو ڪتوت" },
            { "ja", metaValue_ja },
            { "jv", "جاونيز" },
            { "ka", "جارجيائي" },
            { "ki", "اڪويو" },
            { "kj", "ڪنياما" },
            { "kk", "قازق" },
            { "kl", "ڪالا ليسٽ" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "ڪنوري" },
            { "ks", "ڪشميري" },
            { "ku", "ڪرمانجي" },
            { "kv", "ڪومي" },
            { "kw", "ڪورنش" },
            { "ky", "ڪرغيز" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "گاندا" },
            { "li", "لمبرگش" },
            { "ln", "لنگالا" },
            { "lo", metaValue_lo },
            { "lt", "ليٿونيائي" },
            { "lu", "لوبا-ڪتانگا" },
            { "lv", "لاتوين" },
            { "mg", "ملاگاسي" },
            { "mh", "مارشليز" },
            { "mi", "مائوري" },
            { "mk", "ميسي ڊونيائي" },
            { "ml", "مليالم" },
            { "mn", metaValue_mn },
            { "mr", "مراٺي" },
            { "ms", "ملي" },
            { "mt", "مالٽي" },
            { "my", "برمي" },
            { "na", "نائو" },
            { "nb", "نارويائي بوڪمال" },
            { "nd", "اتر دبيلي" },
            { "ne", "نيپالي" },
            { "ng", "ڊونگا" },
            { "nl", "ڊچ" },
            { "nn", "نارويائي نيوناسڪ" },
            { "no", "نارويجيائي" },
            { "nr", "ڏکڻ دبيلي" },
            { "nv", "نواجو" },
            { "ny", "نيانجا" },
            { "oc", "آڪسيٽن" },
            { "om", "اورومو" },
            { "or", metaValue_or },
            { "os", "اوسيٽڪ" },
            { "pa", "پنجابي" },
            { "pl", "پولش" },
            { "ps", "پشتو" },
            { "pt", "پورٽگليز" },
            { "qu", "ڪيچوا" },
            { "rm", "رومانش" },
            { "rn", "رونڊي" },
            { "ro", "روماني" },
            { "ru", "روسي" },
            { "rw", "ڪنيار وانڊا" },
            { "sa", "سنسڪرت" },
            { "sc", "سارڊيني" },
            { "sd", "سنڌي" },
            { "se", "اتر سامي" },
            { "sg", "سانگو" },
            { "si", metaValue_si },
            { "sk", "سلواڪي" },
            { "sl", "سلوويني" },
            { "sm", "سموئا" },
            { "sn", "شونا" },
            { "so", "سومالي" },
            { "sq", "الباني" },
            { "sr", "سربيائي" },
            { "ss", "سواتي" },
            { "st", "ڏکڻ سوٿي" },
            { "su", metaValue_su },
            { "sv", "سويڊش" },
            { "sw", "سواحيلي" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجڪ" },
            { "th", metaValue_th },
            { "ti", "تگرينيائي" },
            { "tk", "ترڪمين" },
            { "tn", "تسوانا" },
            { "to", "تونگن" },
            { "tr", "ترڪي" },
            { "ts", "سونگا" },
            { "tt", "تاتار" },
            { "ty", "تاهيتي" },
            { "ug", "يوغور" },
            { "uk", "يوڪراني" },
            { "ur", "اردو" },
            { "uz", "ازبڪ" },
            { "ve", "وينڊا" },
            { "vi", "ويتنامي" },
            { "vo", "والپڪ" },
            { "wa", "ولون" },
            { "wo", "وولوف" },
            { "xh", "زھوسا" },
            { "yi", "يدش" },
            { "yo", "يوروبا" },
            { "za", "جوئنگ" },
            { "zh", "چيني" },
            { "zu", "زولو" },
            { "ace", "اچائينيز" },
            { "ada", "ادنگمي" },
            { "ady", "اديگهي" },
            { "agq", "اگهيم" },
            { "ain", "آئينو" },
            { "ale", "اليوٽ" },
            { "alt", "ڏکڻ التائي" },
            { "ann", "اوبولو" },
            { "anp", "انجيڪا" },
            { "arn", "ماپوچي" },
            { "arp", "اراپائو" },
            { "ars", "نجدي عربي" },
            { "asa", "اسو" },
            { "ast", "اسٽورين" },
            { "atj", "اٽيڪاميڪو" },
            { "awa", "اواڌي" },
            { "bal", "بلوچي" },
            { "ban", "بالينيس" },
            { "bas", "باسا" },
            { "bem", "بيمبا" },
            { "bez", "بينا" },
            { "bgc", "ھريانوي" },
            { "bho", "ڀوجپوري" },
            { "bin", "بني" },
            { "bla", "سڪسڪا" },
            { "blo", "آنيائي" },
            { "brx", "بودو" },
            { "bug", "بگنيز" },
            { "byn", "بلن" },
            { "cay", "ڪايوگا" },
            { "ccp", "چمڪا" },
            { "ceb", "سبوانو" },
            { "cgg", "چگا" },
            { "chk", "چڪيز" },
            { "chm", "ماري" },
            { "cho", "چوڪ تو" },
            { "chp", "چائپائن" },
            { "chr", "چروڪي" },
            { "chy", "چايان" },
            { "ckb", "مرڪزي ڪردش" },
            { "clc", "چلڪوٽن" },
            { "crg", "ميچيف" },
            { "crj", "ڏکڻ اڀرندو ڪري" },
            { "crk", "پلينز ڪري" },
            { "crl", "اترين اوڀر ڪري" },
            { "crm", "موس ڪري" },
            { "crr", "ڪيرولينا الگانڪويئن" },
            { "crs", "سيسلوا ڪريئول فرانسي" },
            { "csw", "سوامپي ڪري" },
            { "dak", "ڊڪوٽا" },
            { "dar", "ڊارگوا" },
            { "dav", "تائيتا" },
            { "dgr", "داگرب" },
            { "dje", "زارما" },
            { "doi", "ڊوگري" },
            { "dsb", "لوئر سوربين" },
            { "dua", "ڊيولا" },
            { "dyo", "جولا فوني" },
            { "dzg", "دزاگا" },
            { "ebu", "ايمبيو" },
            { "efi", "ايفڪ" },
            { "eka", "ايڪاجڪ" },
            { "ewo", "اوانڊو" },
            { "fil", "فلپائني" },
            { "fon", "فون" },
            { "frc", "ڪيجن فرانسيسي" },
            { "frr", "اترين فريسين" },
            { "fur", "فرائي لئين" },
            { "gaa", "گا" },
            { "gez", "جيز" },
            { "gil", "گلبرٽيز" },
            { "gor", "گورنٽلو" },
            { "gsw", "سوئس جرمن" },
            { "guz", "گشي" },
            { "gwi", "گوچن" },
            { "hai", "ھائيڊا" },
            { "haw", "هوائي" },
            { "hax", "ڏاکڻي ھائڊا" },
            { "hil", "هلي گيانان" },
            { "hmn", "مونگ" },
            { "hsb", "اپر سربيائي" },
            { "hup", "هوپا" },
            { "hur", "ھاڪملم" },
            { "iba", "ايبن" },
            { "ibb", "ابيبيو" },
            { "ikt", "مغربي ڪينيڊين انوڪٽيٽ" },
            { "ilo", "الوڪو" },
            { "inh", "انگش" },
            { "jbo", "لوجبين" },
            { "jgo", "نغومبا" },
            { "jmc", "ميڪم" },
            { "kab", "ڪبائل" },
            { "kac", "ڪچن" },
            { "kaj", "پوڪيپسي" },
            { "kam", "ڪئمبا" },
            { "kbd", "ڪبارڊيئن" },
            { "kcg", "تياپ" },
            { "kde", "مڪوندي" },
            { "kea", "ڪيبيو ويرڊيانو" },
            { "kfo", "ڪورو" },
            { "kgp", "ڪئينگينگ" },
            { "kha", "خاسي" },
            { "khq", "ڪيورا چني" },
            { "kkj", "ڪڪو" },
            { "kln", "ڪيلين جن" },
            { "kmb", "ڪنمبونڊو" },
            { "kok", "ڪونڪي" },
            { "kpe", "ڪپيل" },
            { "krc", "ڪراچي بالڪر" },
            { "krl", "ڪريلئين" },
            { "kru", "ڪورخ" },
            { "ksb", "شمبالا" },
            { "ksf", "بافيا" },
            { "ksh", "ڪلونئين" },
            { "kum", "ڪومڪ" },
            { "kwk", "ڪئاڪ ولا" },
            { "kxv", "ڪووي" },
            { "lad", "لڊينو" },
            { "lag", "لانگي" },
            { "lez", "ليزگهين" },
            { "lij", "لگيوريئن" },
            { "lil", "ليلوئيٽ" },
            { "lkt", "لڪوٽا" },
            { "lmo", "لامبارڊ" },
            { "lou", "لوئيزيانا ڪريئول" },
            { "loz", "لوزي" },
            { "lrc", "اتر لوري" },
            { "lsm", "ساميا" },
            { "lua", "لوبا-لولوا" },
            { "lun", "لنڊا" },
            { "luo", "لو" },
            { "lus", "ميزو" },
            { "luy", "لوهيا" },
            { "mad", "مدورائي" },
            { "mag", "مگاهي" },
            { "mai", "ميٿلي" },
            { "mak", "مڪاسر" },
            { "mas", "مسائي" },
            { "mdf", "موڪشا" },
            { "men", "مينڊي" },
            { "mer", "ميرو" },
            { "mfe", "موریسیین" },
            { "mgh", "مخووا ميتو" },
            { "mgo", "ميتا" },
            { "mic", "ميڪ مڪ" },
            { "min", "مناڪابوا" },
            { "mni", "ماني پوري" },
            { "moe", "انو آئيمن" },
            { "moh", "موهاڪ" },
            { "mos", "موسي" },
            { "mua", "من دانگ" },
            { "mul", "هڪ کان وڌيڪ ٻوليون" },
            { "mus", "ڪريڪ" },
            { "mwl", "مرانڊيز" },
            { "myv", "ايريزيا" },
            { "mzn", "مزيندراني" },
            { "nap", "نيپولٽن" },
            { "naq", "ناما" },
            { "nds", "لو جرمن" },
            { "new", "نيواري" },
            { "nia", "نياس" },
            { "niu", metaValue_NU },
            { "nmg", "ڪويسيو" },
            { "nnh", "نغيمبون" },
            { "nog", "نوگائي" },
            { "nqo", metaValue_nqo },
            { "nso", "اتر سوٿو" },
            { "nus", "نيور" },
            { "nyn", "نايانڪول" },
            { "ojb", "اتر الھندي اوجيبوا" },
            { "ojc", "وچولي اوجيبوي" },
            { "ojs", "اوجي ڪري" },
            { "ojw", "مغربي اوجيبو" },
            { "oka", "اوڪاناگن" },
            { "pag", "پانگا سينان" },
            { "pam", "پيم پينگا" },
            { "pap", "پاپي امينٽو" },
            { "pau", "پلون" },
            { "pcm", "نائيجرين پجن" },
            { "pis", "پائجن" },
            { "pqm", "ماليسيٽ پاسماڪئوڊي" },
            { "prg", "پرشن" },
            { "quc", "ڪچي" },
            { "raj", "راجستاني" },
            { "rap", "ريپنوئي" },
            { "rar", "ريرو ٽينگو" },
            { "rhg", "روھنگيا" },
            { "rof", "رومبو" },
            { "rup", "ارومينين" },
            { "rwk", "روا" },
            { "sad", "سنداوي" },
            { "sah", "ساخا" },
            { "saq", "سيمبورو" },
            { "sat", "سنتالي" },
            { "sba", "نغمبي" },
            { "sbp", "سانگوو" },
            { "scn", "سسلي" },
            { "sco", "اسڪاٽس" },
            { "seh", "سينا" },
            { "ses", "ڪيورابورو سيني" },
            { "shi", "تيچل هاتي" },
            { "shn", "شان" },
            { "slh", "ڏاکڻي لشوٽسيڊ" },
            { "sma", "ڏکڻ سامي" },
            { "smj", "لولي سامي" },
            { "smn", "اناري سامي" },
            { "sms", "اسڪاٽ سامي" },
            { "snk", "سونينڪي" },
            { "srn", "سرانن تانگو" },
            { "ssy", "سهو" },
            { "str", "اسٽريٽ سليش" },
            { "suk", "سڪوما" },
            { "swb", "ڪمورين" },
            { "syr", metaValue_syr },
            { "szl", "سليسيئن" },
            { "tce", "ڏاکڻي ٽچون" },
            { "tem", "تمني" },
            { "teo", "تيسو" },
            { "tet", "تيتم" },
            { "tgx", "ٽئگِش" },
            { "tht", "ٽهلٽن" },
            { "tig", "تگري" },
            { "tlh", "ڪلون" },
            { "tli", "ٽِلنگٽ" },
            { "tok", "توڪي پونا" },
            { "tpi", "تاڪ پسن" },
            { "trv", "تاروڪو" },
            { "ttm", "اترين ٽچون" },
            { "tum", "تمبوڪا" },
            { "tvl", metaValue_TV },
            { "twq", "تساوڪي" },
            { "tyv", "تووينيائي" },
            { "tzm", "وچ اٽلس تمازائيٽ" },
            { "udm", "ادمرت" },
            { "umb", "اومبنڊو" },
            { "und", "اڻڄاتل ٻولي" },
            { "vai", "يا" },
            { "vec", "ونيشن" },
            { "vmw", "مکووا" },
            { "vun", "ونجو" },
            { "wae", "والسر" },
            { "wal", "وولايٽا" },
            { "war", "واري" },
            { "wuu", "وو چيني" },
            { "xal", "ڪيلمڪ" },
            { "xnr", "ڪينگري" },
            { "xog", "سوگا" },
            { "yav", "يانگ بين" },
            { "ybb", "ييمبا" },
            { "yrl", "نھين گاٽو" },
            { "yue", "ڪينٽونيز" },
            { "zgh", "معياري مراڪشي تامازائيٽ" },
            { "zun", "زوني" },
            { "zxx", "ڪوئي ٻولي جو مواد ڪونهي" },
            { "zza", "زازا" },
            { "Adlm", "ايڊلام" },
            { "Arab", metaValue_ar },
            { "Aran", "نستعلیق" },
            { "Armn", "عرماني" },
            { "Beng", metaValue_bn },
            { "Bopo", "بوپوموفو" },
            { "Brai", "بريل" },
            { "Cakm", "چڪما" },
            { "Cans", "يونيفائيڊ ڪينيڊيئن ابارجيني سليبڪس" },
            { "Cher", "چيروڪي" },
            { "Cyrl", "سيريلي" },
            { "Deva", "ديوناگري" },
            { "Ethi", "ايٿوپيائي" },
            { "Geor", "جيورجيائي" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گرمکي" },
            { "Hanb", "بوپوموفو سان هين" },
            { "Hang", "هنگول" },
            { "Hani", "هين" },
            { "Hans", "سادي" },
            { "Hant", "روايتي" },
            { "Hebr", metaValue_he },
            { "Hira", "هراگنا" },
            { "Hrkt", "جاپاني لکت" },
            { "Ital", "قديم اطالوي" },
            { "Jamo", "جامو" },
            { "Java", "جاوانيز" },
            { "Jpan", metaValue_ja },
            { "Kana", "ڪٽاڪانا" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "ملايالم" },
            { "Mong", metaValue_mn },
            { "Mtei", "ميئيٽي مائيڪ" },
            { "Mult", "ملتاني" },
            { "Mymr", "ميانمر" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "اول چڪي" },
            { "Orya", metaValue_or },
            { "Rohg", "ھنيفي" },
            { "Sarb", "قديم ڏاکڻي عربي" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ٽفيناگ" },
            { "Thaa", "ٿانا" },
            { "Thai", metaValue_th },
            { "Tibt", "تبيتن" },
            { "Vaii", "وائي" },
            { "Xpeo", "قديم فارسي" },
            { "Yiii", "يي" },
            { "Zmth", "رياضي جون نشانيون" },
            { "Zsye", "ايموجي" },
            { "Zsym", "نشانيون" },
            { "Zxxx", "اڻ لکيل" },
            { "Zyyy", "ڪامن" },
            { "Zzzz", "اڻڄاتل لکت" },
            { "de_AT", "آسٽريائي جرمن" },
            { "de_CH", "سوئس هائي جرمن" },
            { "en_AU", "آسٽريليائي انگريزي" },
            { "en_CA", "ڪينيڊيائي انگريزي" },
            { "en_GB", "برطانوي انگريزي" },
            { "en_US", "آمريڪي انگريزي" },
            { "es_ES", "يورپي اسپيني" },
            { "es_MX", "ميڪسيڪين اسپيني" },
            { "fa_AF", "دري" },
            { "fr_CA", "ڪينيڊيائي فرانسيسي" },
            { "fr_CH", "سوئس فرانسيسي" },
            { "nl_BE", "فليمش" },
            { "pt_BR", "برازيلي پرتگالي" },
            { "pt_PT", "يورپي پرتگالي" },
            { "ro_MD", "مالديوي" },
            { "sw_CD", "ڪونگو سواحيلي" },
            { "ar_001", "جديد معياري عربي" },
            { "es_419", "لاطيني آمريڪي اسپينش" },
            { "key.ca", "ڪئلينڊر" },
            { "key.cf", "سڪي جو فارميٽ" },
            { "key.co", "ترتيب ڇانٽي" },
            { "key.cu", "سڪو" },
            { "key.em", "ايموجي پيشڪاري" },
            { "key.hc", "ڪلاڪ سائيڪل" },
            { "key.lb", "لائن ٽوڙڻ انداز" },
            { "key.lw", "لفظن وچ ۾ لڪير ٽوڙ" },
            { "key.ms", "ماپڻ جو نظام" },
            { "key.nu", "انگ" },
            { "key.ss", "تخفيف کانپوءِ جملو ٽوڙ" },
            { "%%POSIX", "ڪمپيوٽر" },
            { "zh_Hant", "روايتي چيني" },
            { "type.ca.roc", "منگوو ڪئلينڊر" },
            { "type.hc.h11", "12 ڪلاڪ جو سسٽم (0–11)" },
            { "type.hc.h12", "12 ڪلاڪ جو سسٽم (1–12)" },
            { "type.hc.h23", "24 ڪلاڪ جو سسٽم (0–23)" },
            { "type.hc.h24", "24 ڪلاڪ جو سسٽم (1–24)" },
            { "type.nu.arab", "عربي-هندي عدد" },
            { "type.nu.armn", "ارمينيائي انگ" },
            { "type.nu.beng", "بنگلا عدد" },
            { "type.nu.cakm", "چڪما انگ اکر" },
            { "type.nu.deva", "ديوناگري عدد" },
            { "type.nu.ethi", "ايٿوپيائي انگ" },
            { "type.nu.geor", "جيارجيائي انگ" },
            { "type.nu.grek", "يوناني انگ" },
            { "type.nu.gujr", "گجراتي عدد" },
            { "type.nu.guru", "گرمکي عدد" },
            { "type.nu.hans", "آسان چيني انگ" },
            { "type.nu.hant", "روايتي چيني انگ" },
            { "type.nu.hebr", "عبراني انگ" },
            { "type.nu.java", "جاواني انگ اکر" },
            { "type.nu.jpan", "جاپاني انگ" },
            { "type.nu.khmr", "خمر عدد" },
            { "type.nu.knda", "ڪناڊا عدد" },
            { "type.nu.laoo", "لائو عدد" },
            { "type.nu.latn", "مغربي عدد" },
            { "type.nu.mlym", "مليالم عدد" },
            { "type.nu.mtei", "ميٽي مئيڪ انگ اکر" },
            { "type.nu.mymr", "ميانمار عدد" },
            { "type.nu.olck", "اول چڪي انگ اکر" },
            { "type.nu.orya", "اوڊيا عدد" },
            { "type.nu.taml", "روايتي تامل انگ" },
            { "type.nu.telu", "تيلگو عدد" },
            { "type.nu.thai", "ٿائي عدد" },
            { "type.nu.tibt", "تبتي عدد" },
            { "type.nu.vaii", "وائي انگ اکر" },
            { "type.ca.dangi", "دانگي ڪئلينڊر" },
            { "type.co.ducet", "ڊفالٽ يوني ڪوڊ ترتيب ڇانٽي" },
            { "type.lb.loose", "لوز لائن ٽوڙ انداز" },
            { "type.nu.roman", "رومي انگ" },
            { "type.ca.coptic", "ڪاپٽڪ ڪئلينڊر" },
            { "type.ca.hebrew", "عبراني ڪئلينڊر" },
            { "type.ca.indian", "هندوستاني قومي ڪئلينڊر" },
            { "type.co.search", "عام مقصد جي ڳولا" },
            { "type.lb.normal", "عام لائن ٽوڙ انداز" },
            { "type.lb.strict", "سخت لائن ٽوڙ انداز" },
            { "type.ms.metric", "ميٽرڪ نظام" },
            { "type.ca.chinese", "چيني ڪئلينڊر" },
            { "type.ca.islamic", "هجري ڪئلينڊر" },
            { "type.ca.iso8601", "ISO-8601 ڪئلينڊر" },
            { "type.ca.persian", "فارسي ڪئلينڊر" },
            { "type.cf.account", "اڪائونٽنگ سڪو فارميٽ" },
            { "type.nu.arabext", "وڌايل عربي-هندي عدد" },
            { "type.nu.armnlow", "ارمينيائي ننڍا انگ" },
            { "type.nu.greklow", "يوناني ننڍا انگ" },
            { "type.nu.hanidec", "چيني اعشاري انگ" },
            { "type.nu.hansfin", "آسان چيني مالي انگ" },
            { "type.nu.hantfin", "روايتي چيني مالي انگ" },
            { "type.nu.jpanfin", "جاپاني مالي انگ" },
            { "type.nu.tamldec", "تامل عدد" },
            { "type.ca.buddhist", "ٻڌ ڌرم جو ڪئلينڊر" },
            { "type.ca.ethiopic", "ايٿوپيائي ڪئلينڊر" },
            { "type.ca.japanese", "جاپاني ڪئلينڊر" },
            { "type.cf.standard", "معياري سڪو فارميٽ" },
            { "type.co.standard", "معياري ترتيب ڇانٽي" },
            { "type.ms.uksystem", "امپيريل ماپڻ جو نظام" },
            { "type.ms.ussystem", "آمريڪا جو ماپڻ جو نظام" },
            { "type.nu.fullwide", "پوري-ويڪر انگن" },
            { "type.nu.romanlow", "رومي ننڍا انگ" },
            { "type.ca.gregorian", "جارجيائي ڪئلينڊر" },
            { "type.ca.islamic-tbla", "هجري ڪئلينڊر (ٽيبلر، فلڪياتي دور)" },
            { "type.ca.islamic-civil", "هجري ڪئلينڊر (ٽيبل وارو، شهري دور)" },
            { "type.ca.islamic-umalqura", "هجري ڪئلينڊر (اُم القرا)" },
            { "type.ca.ethiopic-amete-alem", "ايٿوپڪ اميٽي عليم ڪئلينڊر" },
        };
        return data;
    }
}
