// Test pthread_cond_clockwait not generating false positives with tsan
// { dg-do run { target { { *-*-linux* *-*-gnu* *-*-uclinux* } && pthread } } }
// { dg-options "-fsanitize=thread -lpthread" }

#include <pthread.h>

pthread_cond_t cv;
pthread_mutex_t mtx;

void *fn(void *vp) {
    pthread_mutex_lock(&mtx);
    pthread_cond_signal(&cv);
    pthread_mutex_unlock(&mtx);
    return NULL;
}

int main() {
    pthread_mutex_lock(&mtx);

    pthread_t tid;
    pthread_create(&tid, NULL, fn, NULL);

    struct timespec ts;
    clock_gettime(CLOCK_MONOTONIC, &ts);
    ts.tv_sec += 10;
    pthread_cond_clockwait(&cv, &mtx, CLOCK_MONOTONIC, &ts);
    pthread_mutex_unlock(&mtx);

    pthread_join(tid, NULL);
    return 0;
}
