// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The start of a tool result block. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in the Amazon Bedrock User Guide.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ToolResultBlockStart {
    /// <p>The ID of the tool that was used to generate this tool result block.</p>
    pub tool_use_id: ::std::string::String,
    /// <p>The type for the tool that was used to generate this tool result block.</p>
    pub r#type: ::std::option::Option<::std::string::String>,
    /// <p>The status of the tool result block.</p>
    pub status: ::std::option::Option<crate::types::ToolResultStatus>,
}
impl ToolResultBlockStart {
    /// <p>The ID of the tool that was used to generate this tool result block.</p>
    pub fn tool_use_id(&self) -> &str {
        use std::ops::Deref;
        self.tool_use_id.deref()
    }
    /// <p>The type for the tool that was used to generate this tool result block.</p>
    pub fn r#type(&self) -> ::std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The status of the tool result block.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::ToolResultStatus> {
        self.status.as_ref()
    }
}
impl ToolResultBlockStart {
    /// Creates a new builder-style object to manufacture [`ToolResultBlockStart`](crate::types::ToolResultBlockStart).
    pub fn builder() -> crate::types::builders::ToolResultBlockStartBuilder {
        crate::types::builders::ToolResultBlockStartBuilder::default()
    }
}

/// A builder for [`ToolResultBlockStart`](crate::types::ToolResultBlockStart).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ToolResultBlockStartBuilder {
    pub(crate) tool_use_id: ::std::option::Option<::std::string::String>,
    pub(crate) r#type: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::ToolResultStatus>,
}
impl ToolResultBlockStartBuilder {
    /// <p>The ID of the tool that was used to generate this tool result block.</p>
    /// This field is required.
    pub fn tool_use_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tool_use_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the tool that was used to generate this tool result block.</p>
    pub fn set_tool_use_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tool_use_id = input;
        self
    }
    /// <p>The ID of the tool that was used to generate this tool result block.</p>
    pub fn get_tool_use_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.tool_use_id
    }
    /// <p>The type for the tool that was used to generate this tool result block.</p>
    pub fn r#type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.r#type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type for the tool that was used to generate this tool result block.</p>
    pub fn set_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type for the tool that was used to generate this tool result block.</p>
    pub fn get_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.r#type
    }
    /// <p>The status of the tool result block.</p>
    pub fn status(mut self, input: crate::types::ToolResultStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the tool result block.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ToolResultStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the tool result block.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ToolResultStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`ToolResultBlockStart`](crate::types::ToolResultBlockStart).
    /// This method will fail if any of the following fields are not set:
    /// - [`tool_use_id`](crate::types::builders::ToolResultBlockStartBuilder::tool_use_id)
    pub fn build(self) -> ::std::result::Result<crate::types::ToolResultBlockStart, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ToolResultBlockStart {
            tool_use_id: self.tool_use_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tool_use_id",
                    "tool_use_id was not specified but it is required when building ToolResultBlockStart",
                )
            })?,
            r#type: self.r#type,
            status: self.status,
        })
    }
}
