// Package oapi provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.9.1 DO NOT EDIT.
package oapi

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
	"time"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
)

// Defines values for AccessKeyType.
const (
	AccessKeyTypeRestricted AccessKeyType = "restricted"

	AccessKeyTypeUnrestricted AccessKeyType = "unrestricted"
)

// Defines values for AccessKeyVersion.
const (
	AccessKeyVersionV1 AccessKeyVersion = "v1"

	AccessKeyVersionV2 AccessKeyVersion = "v2"
)

// Defines values for AccessKeyResourceDomain.
const (
	AccessKeyResourceDomainPartner AccessKeyResourceDomain = "partner"

	AccessKeyResourceDomainSos AccessKeyResourceDomain = "sos"
)

// Defines values for AccessKeyResourceResourceType.
const (
	AccessKeyResourceResourceTypeBucket AccessKeyResourceResourceType = "bucket"

	AccessKeyResourceResourceTypeProduct AccessKeyResourceResourceType = "product"
)

// Defines values for DbaasKafkaSchemaRegistryAclEntryPermission.
const (
	DbaasKafkaSchemaRegistryAclEntryPermissionSchemaRegistryRead DbaasKafkaSchemaRegistryAclEntryPermission = "schema_registry_read"

	DbaasKafkaSchemaRegistryAclEntryPermissionSchemaRegistryWrite DbaasKafkaSchemaRegistryAclEntryPermission = "schema_registry_write"
)

// Defines values for DbaasKafkaTopicAclEntryPermission.
const (
	DbaasKafkaTopicAclEntryPermissionAdmin DbaasKafkaTopicAclEntryPermission = "admin"

	DbaasKafkaTopicAclEntryPermissionRead DbaasKafkaTopicAclEntryPermission = "read"

	DbaasKafkaTopicAclEntryPermissionReadwrite DbaasKafkaTopicAclEntryPermission = "readwrite"

	DbaasKafkaTopicAclEntryPermissionWrite DbaasKafkaTopicAclEntryPermission = "write"
)

// Defines values for DbaasNodeStateRole.
const (
	DbaasNodeStateRoleMaster DbaasNodeStateRole = "master"

	DbaasNodeStateRoleReadReplica DbaasNodeStateRole = "read-replica"

	DbaasNodeStateRoleStandby DbaasNodeStateRole = "standby"
)

// Defines values for DbaasNodeStateState.
const (
	DbaasNodeStateStateLeaving DbaasNodeStateState = "leaving"

	DbaasNodeStateStateRunning DbaasNodeStateState = "running"

	DbaasNodeStateStateSettingUpVm DbaasNodeStateState = "setting_up_vm"

	DbaasNodeStateStateSyncingData DbaasNodeStateState = "syncing_data"

	DbaasNodeStateStateUnknown DbaasNodeStateState = "unknown"
)

// Defines values for DbaasNodeStateProgressUpdatePhase.
const (
	DbaasNodeStateProgressUpdatePhaseBasebackup DbaasNodeStateProgressUpdatePhase = "basebackup"

	DbaasNodeStateProgressUpdatePhaseFinalize DbaasNodeStateProgressUpdatePhase = "finalize"

	DbaasNodeStateProgressUpdatePhasePrepare DbaasNodeStateProgressUpdatePhase = "prepare"

	DbaasNodeStateProgressUpdatePhaseStream DbaasNodeStateProgressUpdatePhase = "stream"
)

// Defines values for DbaasServiceMaintenanceDow.
const (
	DbaasServiceMaintenanceDowFriday DbaasServiceMaintenanceDow = "friday"

	DbaasServiceMaintenanceDowMonday DbaasServiceMaintenanceDow = "monday"

	DbaasServiceMaintenanceDowNever DbaasServiceMaintenanceDow = "never"

	DbaasServiceMaintenanceDowSaturday DbaasServiceMaintenanceDow = "saturday"

	DbaasServiceMaintenanceDowSunday DbaasServiceMaintenanceDow = "sunday"

	DbaasServiceMaintenanceDowThursday DbaasServiceMaintenanceDow = "thursday"

	DbaasServiceMaintenanceDowTuesday DbaasServiceMaintenanceDow = "tuesday"

	DbaasServiceMaintenanceDowWednesday DbaasServiceMaintenanceDow = "wednesday"
)

// Defines values for DbaasServiceNotificationLevel.
const (
	DbaasServiceNotificationLevelNotice DbaasServiceNotificationLevel = "notice"

	DbaasServiceNotificationLevelWarning DbaasServiceNotificationLevel = "warning"
)

// Defines values for DbaasServiceNotificationType.
const (
	DbaasServiceNotificationTypeServiceEndOfLife DbaasServiceNotificationType = "service_end_of_life"

	DbaasServiceNotificationTypeServicePoweredOffRemoval DbaasServiceNotificationType = "service_powered_off_removal"
)

// Defines values for DbaasServiceOpensearchIndexPatternsSortingAlgorithm.
const (
	DbaasServiceOpensearchIndexPatternsSortingAlgorithmAlphabetical DbaasServiceOpensearchIndexPatternsSortingAlgorithm = "alphabetical"

	DbaasServiceOpensearchIndexPatternsSortingAlgorithmCreationDate DbaasServiceOpensearchIndexPatternsSortingAlgorithm = "creation_date"
)

// Defines values for DeployTargetType.
const (
	DeployTargetTypeDedicated DeployTargetType = "dedicated"

	DeployTargetTypeEdge DeployTargetType = "edge"
)

// Defines values for DnsDomainRecordType.
const (
	DnsDomainRecordTypeA DnsDomainRecordType = "A"

	DnsDomainRecordTypeAAAA DnsDomainRecordType = "AAAA"

	DnsDomainRecordTypeALIAS DnsDomainRecordType = "ALIAS"

	DnsDomainRecordTypeCAA DnsDomainRecordType = "CAA"

	DnsDomainRecordTypeCNAME DnsDomainRecordType = "CNAME"

	DnsDomainRecordTypeHINFO DnsDomainRecordType = "HINFO"

	DnsDomainRecordTypeMX DnsDomainRecordType = "MX"

	DnsDomainRecordTypeNAPTR DnsDomainRecordType = "NAPTR"

	DnsDomainRecordTypeNS DnsDomainRecordType = "NS"

	DnsDomainRecordTypePOOL DnsDomainRecordType = "POOL"

	DnsDomainRecordTypeSOA DnsDomainRecordType = "SOA"

	DnsDomainRecordTypeSPF DnsDomainRecordType = "SPF"

	DnsDomainRecordTypeSRV DnsDomainRecordType = "SRV"

	DnsDomainRecordTypeSSHFP DnsDomainRecordType = "SSHFP"

	DnsDomainRecordTypeTXT DnsDomainRecordType = "TXT"

	DnsDomainRecordTypeURL DnsDomainRecordType = "URL"
)

// Defines values for ElasticIpAddressfamily.
const (
	ElasticIpAddressfamilyInet4 ElasticIpAddressfamily = "inet4"

	ElasticIpAddressfamilyInet6 ElasticIpAddressfamily = "inet6"
)

// Defines values for ElasticIpHealthcheckMode.
const (
	ElasticIpHealthcheckModeHttp ElasticIpHealthcheckMode = "http"

	ElasticIpHealthcheckModeHttps ElasticIpHealthcheckMode = "https"

	ElasticIpHealthcheckModeTcp ElasticIpHealthcheckMode = "tcp"
)

// Defines values for EnumComponentRoute.
const (
	EnumComponentRouteDynamic EnumComponentRoute = "dynamic"

	EnumComponentRoutePrivate EnumComponentRoute = "private"

	EnumComponentRoutePrivatelink EnumComponentRoute = "privatelink"

	EnumComponentRoutePublic EnumComponentRoute = "public"
)

// Defines values for EnumComponentUsage.
const (
	EnumComponentUsagePrimary EnumComponentUsage = "primary"

	EnumComponentUsageReplica EnumComponentUsage = "replica"
)

// Defines values for EnumIntegrationTypes.
const (
	EnumIntegrationTypesDatasource EnumIntegrationTypes = "datasource"

	EnumIntegrationTypesLogs EnumIntegrationTypes = "logs"

	EnumIntegrationTypesMetrics EnumIntegrationTypes = "metrics"
)

// Defines values for EnumKafkaAuthMethod.
const (
	EnumKafkaAuthMethodCertificate EnumKafkaAuthMethod = "certificate"

	EnumKafkaAuthMethodSasl EnumKafkaAuthMethod = "sasl"
)

// Defines values for EnumMasterLinkStatus.
const (
	EnumMasterLinkStatusDown EnumMasterLinkStatus = "down"

	EnumMasterLinkStatusUp EnumMasterLinkStatus = "up"
)

// Defines values for EnumMigrationMethod.
const (
	EnumMigrationMethodDump EnumMigrationMethod = "dump"

	EnumMigrationMethodReplication EnumMigrationMethod = "replication"
)

// Defines values for EnumMigrationStatus.
const (
	EnumMigrationStatusDone EnumMigrationStatus = "done"

	EnumMigrationStatusFailed EnumMigrationStatus = "failed"

	EnumMigrationStatusRunning EnumMigrationStatus = "running"

	EnumMigrationStatusSyncing EnumMigrationStatus = "syncing"
)

// Defines values for EnumMysqlAuthenticationPlugin.
const (
	EnumMysqlAuthenticationPluginCachingSha2Password EnumMysqlAuthenticationPlugin = "caching_sha2_password"

	EnumMysqlAuthenticationPluginMysqlNativePassword EnumMysqlAuthenticationPlugin = "mysql_native_password"
)

// Defines values for EnumOpensearchRulePermission.
const (
	EnumOpensearchRulePermissionAdmin EnumOpensearchRulePermission = "admin"

	EnumOpensearchRulePermissionDeny EnumOpensearchRulePermission = "deny"

	EnumOpensearchRulePermissionRead EnumOpensearchRulePermission = "read"

	EnumOpensearchRulePermissionReadwrite EnumOpensearchRulePermission = "readwrite"

	EnumOpensearchRulePermissionWrite EnumOpensearchRulePermission = "write"
)

// Defines values for EnumPgPoolMode.
const (
	EnumPgPoolModeSession EnumPgPoolMode = "session"

	EnumPgPoolModeStatement EnumPgPoolMode = "statement"

	EnumPgPoolModeTransaction EnumPgPoolMode = "transaction"
)

// Defines values for EnumPgSynchronousReplication.
const (
	EnumPgSynchronousReplicationOff EnumPgSynchronousReplication = "off"

	EnumPgSynchronousReplicationQuorum EnumPgSynchronousReplication = "quorum"
)

// Defines values for EnumPgVariant.
const (
	EnumPgVariantAiven EnumPgVariant = "aiven"

	EnumPgVariantTimescale EnumPgVariant = "timescale"
)

// Defines values for EnumServiceState.
const (
	EnumServiceStatePoweroff EnumServiceState = "poweroff"

	EnumServiceStateRebalancing EnumServiceState = "rebalancing"

	EnumServiceStateRebuilding EnumServiceState = "rebuilding"

	EnumServiceStateRunning EnumServiceState = "running"
)

// Defines values for EnumSortOrder.
const (
	EnumSortOrderAsc EnumSortOrder = "asc"

	EnumSortOrderDesc EnumSortOrder = "desc"
)

// Defines values for IamPolicyDefaultServiceStrategy.
const (
	IamPolicyDefaultServiceStrategyAllow IamPolicyDefaultServiceStrategy = "allow"

	IamPolicyDefaultServiceStrategyDeny IamPolicyDefaultServiceStrategy = "deny"
)

// Defines values for IamRolePermissions.
const (
	IamRolePermissionsBypassGovernanceRetention IamRolePermissions = "bypass-governance-retention"
)

// Defines values for IamServicePolicyType.
const (
	IamServicePolicyTypeAllow IamServicePolicyType = "allow"

	IamServicePolicyTypeDeny IamServicePolicyType = "deny"

	IamServicePolicyTypeRules IamServicePolicyType = "rules"
)

// Defines values for IamServicePolicyRuleAction.
const (
	IamServicePolicyRuleActionAllow IamServicePolicyRuleAction = "allow"

	IamServicePolicyRuleActionDeny IamServicePolicyRuleAction = "deny"
)

// Defines values for InstancePoolState.
const (
	InstancePoolStateCreating InstancePoolState = "creating"

	InstancePoolStateDestroying InstancePoolState = "destroying"

	InstancePoolStateRunning InstancePoolState = "running"

	InstancePoolStateScalingDown InstancePoolState = "scaling-down"

	InstancePoolStateScalingUp InstancePoolState = "scaling-up"

	InstancePoolStateSuspended InstancePoolState = "suspended"

	InstancePoolStateUpdating InstancePoolState = "updating"
)

// Defines values for InstanceState.
const (
	InstanceStateDestroyed InstanceState = "destroyed"

	InstanceStateDestroying InstanceState = "destroying"

	InstanceStateError InstanceState = "error"

	InstanceStateExpunging InstanceState = "expunging"

	InstanceStateMigrating InstanceState = "migrating"

	InstanceStateRunning InstanceState = "running"

	InstanceStateStarting InstanceState = "starting"

	InstanceStateStopped InstanceState = "stopped"

	InstanceStateStopping InstanceState = "stopping"
)

// Defines values for InstanceTypeFamily.
const (
	InstanceTypeFamilyColossus InstanceTypeFamily = "colossus"

	InstanceTypeFamilyCpu InstanceTypeFamily = "cpu"

	InstanceTypeFamilyGpu InstanceTypeFamily = "gpu"

	InstanceTypeFamilyGpu2 InstanceTypeFamily = "gpu2"

	InstanceTypeFamilyGpu3 InstanceTypeFamily = "gpu3"

	InstanceTypeFamilyMemory InstanceTypeFamily = "memory"

	InstanceTypeFamilyStandard InstanceTypeFamily = "standard"

	InstanceTypeFamilyStorage InstanceTypeFamily = "storage"
)

// Defines values for InstanceTypeSize.
const (
	InstanceTypeSizeColossus InstanceTypeSize = "colossus"

	InstanceTypeSizeExtraLarge InstanceTypeSize = "extra-large"

	InstanceTypeSizeHuge InstanceTypeSize = "huge"

	InstanceTypeSizeJumbo InstanceTypeSize = "jumbo"

	InstanceTypeSizeLarge InstanceTypeSize = "large"

	InstanceTypeSizeMedium InstanceTypeSize = "medium"

	InstanceTypeSizeMega InstanceTypeSize = "mega"

	InstanceTypeSizeMicro InstanceTypeSize = "micro"

	InstanceTypeSizeSmall InstanceTypeSize = "small"

	InstanceTypeSizeTiny InstanceTypeSize = "tiny"

	InstanceTypeSizeTitan InstanceTypeSize = "titan"
)

// Defines values for LoadBalancerState.
const (
	LoadBalancerStateCreating LoadBalancerState = "creating"

	LoadBalancerStateDeleting LoadBalancerState = "deleting"

	LoadBalancerStateError LoadBalancerState = "error"

	LoadBalancerStateMigrated LoadBalancerState = "migrated"

	LoadBalancerStateMigrating LoadBalancerState = "migrating"

	LoadBalancerStateRunning LoadBalancerState = "running"
)

// Defines values for LoadBalancerServerStatusStatus.
const (
	LoadBalancerServerStatusStatusFailure LoadBalancerServerStatusStatus = "failure"

	LoadBalancerServerStatusStatusSuccess LoadBalancerServerStatusStatus = "success"
)

// Defines values for LoadBalancerServiceProtocol.
const (
	LoadBalancerServiceProtocolTcp LoadBalancerServiceProtocol = "tcp"

	LoadBalancerServiceProtocolUdp LoadBalancerServiceProtocol = "udp"
)

// Defines values for LoadBalancerServiceState.
const (
	LoadBalancerServiceStateCreating LoadBalancerServiceState = "creating"

	LoadBalancerServiceStateDeleting LoadBalancerServiceState = "deleting"

	LoadBalancerServiceStateError LoadBalancerServiceState = "error"

	LoadBalancerServiceStateRunning LoadBalancerServiceState = "running"

	LoadBalancerServiceStateUpdating LoadBalancerServiceState = "updating"
)

// Defines values for LoadBalancerServiceStrategy.
const (
	LoadBalancerServiceStrategyRoundRobin LoadBalancerServiceStrategy = "round-robin"

	LoadBalancerServiceStrategySourceHash LoadBalancerServiceStrategy = "source-hash"
)

// Defines values for LoadBalancerServiceHealthcheckMode.
const (
	LoadBalancerServiceHealthcheckModeHttp LoadBalancerServiceHealthcheckMode = "http"

	LoadBalancerServiceHealthcheckModeHttps LoadBalancerServiceHealthcheckMode = "https"

	LoadBalancerServiceHealthcheckModeTcp LoadBalancerServiceHealthcheckMode = "tcp"
)

// Defines values for ManagerType.
const (
	ManagerTypeInstancePool ManagerType = "instance-pool"

	ManagerTypeSksNodepool ManagerType = "sks-nodepool"
)

// Defines values for OperationReason.
const (
	OperationReasonBusy OperationReason = "busy"

	OperationReasonConflict OperationReason = "conflict"

	OperationReasonFault OperationReason = "fault"

	OperationReasonForbidden OperationReason = "forbidden"

	OperationReasonIncorrect OperationReason = "incorrect"

	OperationReasonInterrupted OperationReason = "interrupted"

	OperationReasonNotFound OperationReason = "not-found"

	OperationReasonPartial OperationReason = "partial"

	OperationReasonUnavailable OperationReason = "unavailable"

	OperationReasonUnknown OperationReason = "unknown"

	OperationReasonUnsupported OperationReason = "unsupported"
)

// Defines values for OperationState.
const (
	OperationStateFailure OperationState = "failure"

	OperationStatePending OperationState = "pending"

	OperationStateSuccess OperationState = "success"

	OperationStateTimeout OperationState = "timeout"
)

// Defines values for PublicIpAssignment.
const (
	PublicIpAssignmentDual PublicIpAssignment = "dual"

	PublicIpAssignmentInet4 PublicIpAssignment = "inet4"

	PublicIpAssignmentNone PublicIpAssignment = "none"
)

// Defines values for SecurityGroupResourceVisibility.
const (
	SecurityGroupResourceVisibilityPrivate SecurityGroupResourceVisibility = "private"

	SecurityGroupResourceVisibilityPublic SecurityGroupResourceVisibility = "public"
)

// Defines values for SecurityGroupRuleFlowDirection.
const (
	SecurityGroupRuleFlowDirectionEgress SecurityGroupRuleFlowDirection = "egress"

	SecurityGroupRuleFlowDirectionIngress SecurityGroupRuleFlowDirection = "ingress"
)

// Defines values for SecurityGroupRuleProtocol.
const (
	SecurityGroupRuleProtocolAh SecurityGroupRuleProtocol = "ah"

	SecurityGroupRuleProtocolEsp SecurityGroupRuleProtocol = "esp"

	SecurityGroupRuleProtocolGre SecurityGroupRuleProtocol = "gre"

	SecurityGroupRuleProtocolIcmp SecurityGroupRuleProtocol = "icmp"

	SecurityGroupRuleProtocolIcmpv6 SecurityGroupRuleProtocol = "icmpv6"

	SecurityGroupRuleProtocolIpip SecurityGroupRuleProtocol = "ipip"

	SecurityGroupRuleProtocolTcp SecurityGroupRuleProtocol = "tcp"

	SecurityGroupRuleProtocolUdp SecurityGroupRuleProtocol = "udp"
)

// Defines values for SksClusterAddons.
const (
	SksClusterAddonsExoscaleCloudController SksClusterAddons = "exoscale-cloud-controller"

	SksClusterAddonsMetricsServer SksClusterAddons = "metrics-server"
)

// Defines values for SksClusterCni.
const (
	SksClusterCniCalico SksClusterCni = "calico"

	SksClusterCniCilium SksClusterCni = "cilium"
)

// Defines values for SksClusterLevel.
const (
	SksClusterLevelPro SksClusterLevel = "pro"

	SksClusterLevelStarter SksClusterLevel = "starter"
)

// Defines values for SksClusterState.
const (
	SksClusterStateCreating SksClusterState = "creating"

	SksClusterStateDeleting SksClusterState = "deleting"

	SksClusterStateError SksClusterState = "error"

	SksClusterStateRotatingCcmCredentials SksClusterState = "rotating-ccm-credentials"

	SksClusterStateRunning SksClusterState = "running"

	SksClusterStateSuspending SksClusterState = "suspending"

	SksClusterStateUpdating SksClusterState = "updating"

	SksClusterStateUpgrading SksClusterState = "upgrading"
)

// Defines values for SksNodepoolAddons.
const (
	SksNodepoolAddonsStorageLvm SksNodepoolAddons = "storage-lvm"
)

// Defines values for SksNodepoolState.
const (
	SksNodepoolStateCreating SksNodepoolState = "creating"

	SksNodepoolStateDeleting SksNodepoolState = "deleting"

	SksNodepoolStateError SksNodepoolState = "error"

	SksNodepoolStateRenewingToken SksNodepoolState = "renewing-token"

	SksNodepoolStateRunning SksNodepoolState = "running"

	SksNodepoolStateScaling SksNodepoolState = "scaling"

	SksNodepoolStateUpdating SksNodepoolState = "updating"
)

// Defines values for SksNodepoolTaintEffect.
const (
	SksNodepoolTaintEffectNoExecute SksNodepoolTaintEffect = "NoExecute"

	SksNodepoolTaintEffectNoSchedule SksNodepoolTaintEffect = "NoSchedule"

	SksNodepoolTaintEffectPreferNoSchedule SksNodepoolTaintEffect = "PreferNoSchedule"
)

// Defines values for SnapshotState.
const (
	SnapshotStateDeleted SnapshotState = "deleted"

	SnapshotStateDeleting SnapshotState = "deleting"

	SnapshotStateError SnapshotState = "error"

	SnapshotStateExported SnapshotState = "exported"

	SnapshotStateExporting SnapshotState = "exporting"

	SnapshotStateReady SnapshotState = "ready"

	SnapshotStateSnapshotting SnapshotState = "snapshotting"
)

// Defines values for TemplateBootMode.
const (
	TemplateBootModeLegacy TemplateBootMode = "legacy"

	TemplateBootModeUefi TemplateBootMode = "uefi"
)

// Defines values for TemplateVisibility.
const (
	TemplateVisibilityPrivate TemplateVisibility = "private"

	TemplateVisibilityPublic TemplateVisibility = "public"
)

// Defines values for ZoneName.
const (
	ZoneNameAtVie1 ZoneName = "at-vie-1"

	ZoneNameAtVie2 ZoneName = "at-vie-2"

	ZoneNameBgSof1 ZoneName = "bg-sof-1"

	ZoneNameChDk2 ZoneName = "ch-dk-2"

	ZoneNameChGva2 ZoneName = "ch-gva-2"

	ZoneNameDeFra1 ZoneName = "de-fra-1"

	ZoneNameDeMuc1 ZoneName = "de-muc-1"

	ZoneNameHrZag1 ZoneName = "hr-zag-1"
)

// IAM Access Key
type AccessKey struct {
	// IAM Access Key
	Key *string `json:"key,omitempty"`

	// IAM Access Key name
	Name *string `json:"name,omitempty"`

	// IAM Access Key operations
	Operations *[]string `json:"operations,omitempty"`

	// IAM Access Key Resources
	Resources *[]AccessKeyResource `json:"resources,omitempty"`

	// IAM Access Key Secret
	Secret *string `json:"secret,omitempty"`

	// IAM Access Key tags
	Tags *[]string `json:"tags,omitempty"`

	// IAM Access Key type
	Type *AccessKeyType `json:"type,omitempty"`

	// IAM Access Key version
	Version *AccessKeyVersion `json:"version,omitempty"`
}

// IAM Access Key type
type AccessKeyType string

// IAM Access Key version
type AccessKeyVersion string

// Access key operation
type AccessKeyOperation struct {
	// Name of the operation
	Operation *string `json:"operation,omitempty"`

	// Tags associated with the operation
	Tags *[]string `json:"tags,omitempty"`
}

// Access key resource
type AccessKeyResource struct {
	// Resource domain
	Domain *AccessKeyResourceDomain `json:"domain,omitempty"`

	// Resource name
	ResourceName *string `json:"resource-name,omitempty"`

	// Resource type
	ResourceType *AccessKeyResourceResourceType `json:"resource-type,omitempty"`
}

// Resource domain
type AccessKeyResourceDomain string

// Resource type
type AccessKeyResourceResourceType string

// Anti-affinity Group
type AntiAffinityGroup struct {
	// Anti-affinity Group description
	Description *string `json:"description,omitempty"`

	// Anti-affinity Group ID
	Id *string `json:"id,omitempty"`

	// Anti-affinity Group instances
	Instances *[]Instance `json:"instances,omitempty"`

	// Anti-affinity Group name
	Name *string `json:"name,omitempty"`
}

// DBaaS plan backup config
type DbaasBackupConfig struct {
	// Interval of taking a frequent backup in service types supporting different backup schedules
	FrequentIntervalMinutes *int64 `json:"frequent-interval-minutes,omitempty"`

	// Maximum age of the oldest frequent backup in service types supporting different backup schedules
	FrequentOldestAgeMinutes *int64 `json:"frequent-oldest-age-minutes,omitempty"`

	// Interval of taking a frequent backup in service types supporting different backup schedules
	InfrequentIntervalMinutes *int64 `json:"infrequent-interval-minutes,omitempty"`

	// Maximum age of the oldest infrequent backup in service types supporting different backup schedules
	InfrequentOldestAgeMinutes *int64 `json:"infrequent-oldest-age-minutes,omitempty"`

	// The interval, in hours, at which backups are generated.
	//                                             For some services, like PostgreSQL, this is the interval
	//                                             at which full snapshots are taken and continuous incremental
	//                                             backup stream is maintained in addition to that.
	Interval *int64 `json:"interval,omitempty"`

	// Maximum number of backups to keep. Zero when no backups are created.
	MaxCount *int64 `json:"max-count,omitempty"`

	// Mechanism how backups can be restored. 'regular'
	//                                             means a backup is restored as is so that the system
	//                                             is restored to the state it was when the backup was generated.
	//                                             'pitr' means point-in-time-recovery, which allows restoring
	//                                             the system to any state since the first available full snapshot.
	RecoveryMode *string `json:"recovery-mode,omitempty"`
}

// DbaasDatabaseName defines model for dbaas-database-name.
type DbaasDatabaseName string

// DbaasIntegration defines model for dbaas-integration.
type DbaasIntegration struct {
	// Description of the integration
	Description *string `json:"description,omitempty"`

	// Destination service name
	Dest *string `json:"dest,omitempty"`

	// Integration id
	Id *string `json:"id,omitempty"`

	// Whether the integration is active or not
	IsActive *bool `json:"is-active,omitempty"`

	// Whether the integration is enabled or not
	IsEnabled *bool `json:"is-enabled,omitempty"`

	// Integration settings
	Settings *map[string]interface{} `json:"settings,omitempty"`

	// Source service name
	Source *string `json:"source,omitempty"`

	// Integration status
	Status *string `json:"status,omitempty"`

	// Integration type
	Type *string `json:"type,omitempty"`
}

// DbaasIntegrationType defines model for dbaas-integration-type.
type DbaasIntegrationType struct {
	// The description of the destination service types.
	DestDescription *string `json:"dest-description,omitempty"`

	// A list of the destination service types the integration supports.
	DestServiceTypes *[]string `json:"dest-service-types,omitempty"`

	// A JSON schema of additional settings of the integration.
	Settings *struct {
		AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
		Properties           *map[string]interface{} `json:"properties,omitempty"`
		Title                *string                 `json:"title,omitempty"`
		Type                 *string                 `json:"type,omitempty"`
	} `json:"settings,omitempty"`

	// The description of the source service types.
	SourceDescription *string `json:"source-description,omitempty"`

	// A list of the source service types the integration supports.
	SourceServiceTypes *[]string `json:"source-service-types,omitempty"`

	// The type of the integration.
	Type *string `json:"type,omitempty"`
}

// DbaasKafkaAclId defines model for dbaas-kafka-acl-id.
type DbaasKafkaAclId string

// DbaasKafkaAcls defines model for dbaas-kafka-acls.
type DbaasKafkaAcls struct {
	SchemaRegistryAcl *[]DbaasKafkaSchemaRegistryAclEntry `json:"schema-registry-acl,omitempty"`
	TopicAcl          *[]DbaasKafkaTopicAclEntry          `json:"topic-acl,omitempty"`
}

// DbaasKafkaSchemaRegistryAclEntry defines model for dbaas-kafka-schema-registry-acl-entry.
type DbaasKafkaSchemaRegistryAclEntry struct {
	Id *DbaasKafkaAclId `json:"id,omitempty"`

	// Kafka Schema Registry permission
	Permission DbaasKafkaSchemaRegistryAclEntryPermission `json:"permission"`

	// Kafka Schema Registry name or pattern
	Resource string `json:"resource"`

	// Kafka username or username pattern
	Username string `json:"username"`
}

// Kafka Schema Registry permission
type DbaasKafkaSchemaRegistryAclEntryPermission string

// DbaasKafkaTopicAclEntry defines model for dbaas-kafka-topic-acl-entry.
type DbaasKafkaTopicAclEntry struct {
	Id *DbaasKafkaAclId `json:"id,omitempty"`

	// Kafka permission
	Permission DbaasKafkaTopicAclEntryPermission `json:"permission"`

	// Kafka topic name or pattern
	Topic string `json:"topic"`

	// Kafka username or username pattern
	Username string `json:"username"`
}

// Kafka permission
type DbaasKafkaTopicAclEntryPermission string

// DbaasMigrationStatus defines model for dbaas-migration-status.
type DbaasMigrationStatus struct {
	// Migration status per database
	Details *[]struct {
		// Migrated db name (PG) or number (Redis)
		Dbname *string `json:"dbname,omitempty"`

		// Error message in case that migration has failed
		Error *string `json:"error,omitempty"`

		// Migration method
		Method *string              `json:"method,omitempty"`
		Status *EnumMigrationStatus `json:"status,omitempty"`
	} `json:"details,omitempty"`

	// Error message in case that migration has failed
	Error *string `json:"error,omitempty"`

	// Redis only: how many seconds since last I/O with redis master
	MasterLastIoSecondsAgo *int64                `json:"master-last-io-seconds-ago,omitempty"`
	MasterLinkStatus       *EnumMasterLinkStatus `json:"master-link-status,omitempty"`

	// Migration method. Empty in case of multiple methods or error
	Method *string `json:"method,omitempty"`

	// Migration status
	Status *string `json:"status,omitempty"`
}

// DbaasMysqlDatabaseName defines model for dbaas-mysql-database-name.
type DbaasMysqlDatabaseName string

// Automatic maintenance settings
type DbaasNodeState struct {
	// Name of the service node
	Name string `json:"name"`

	// Extra information regarding the progress for current state
	ProgressUpdates *[]DbaasNodeStateProgressUpdate `json:"progress-updates,omitempty"`

	// Role of this node. Only returned for a subset of service types
	Role *DbaasNodeStateRole `json:"role,omitempty"`

	// Current state of the service node
	State DbaasNodeStateState `json:"state"`
}

// Role of this node. Only returned for a subset of service types
type DbaasNodeStateRole string

// Current state of the service node
type DbaasNodeStateState string

// Extra information regarding the progress for current state
type DbaasNodeStateProgressUpdate struct {
	// Indicates whether this phase has been completed or not
	Completed bool `json:"completed"`

	// Current progress for this phase. May be missing or null.
	Current *int64 `json:"current,omitempty"`

	// Maximum progress value for this phase. May be missing or null. May change.
	Max *int64 `json:"max,omitempty"`

	// Minimum progress value for this phase. May be missing or null.
	Min *int64 `json:"min,omitempty"`

	// Key identifying this phase
	Phase DbaasNodeStateProgressUpdatePhase `json:"phase"`

	// Unit for current/min/max values. New units may be added.
	//                         If null should be treated as generic unit
	Unit *string `json:"unit,omitempty"`
}

// Key identifying this phase
type DbaasNodeStateProgressUpdatePhase string

// DbaasOpensearchAclConfig defines model for dbaas-opensearch-acl-config.
type DbaasOpensearchAclConfig struct {
	// Enable OpenSearch ACLs. When disabled authenticated service users have unrestricted access.
	AclEnabled *bool `json:"acl-enabled,omitempty"`

	// List of OpenSearch ACLs
	Acls *[]struct {
		Rules *[]struct {
			// OpenSearch index pattern
			Index      string                        `json:"index"`
			Permission *EnumOpensearchRulePermission `json:"permission,omitempty"`
		} `json:"rules,omitempty"`
		Username *DbaasUserUsername `json:"username,omitempty"`
	} `json:"acls,omitempty"`

	// Enable to enforce index rules in a limited fashion for requests that use the _mget, _msearch, and _bulk APIs
	ExtendedAclEnabled *bool `json:"extended-acl-enabled,omitempty"`
}

// DbaasPgDatabaseName defines model for dbaas-pg-database-name.
type DbaasPgDatabaseName string

// DbaasPgPoolName defines model for dbaas-pg-pool-name.
type DbaasPgPoolName string

// DbaasPgPoolSize defines model for dbaas-pg-pool-size.
type DbaasPgPoolSize int64

// DbaasPgPoolUsername defines model for dbaas-pg-pool-username.
type DbaasPgPoolUsername string

// DBaaS plan
type DbaasPlan struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`

	// DBaaS plan backup config
	BackupConfig *DbaasBackupConfig `json:"backup-config,omitempty"`

	// DBaaS plan disk space
	DiskSpace *int64 `json:"disk-space,omitempty"`

	// DBaaS plan max memory allocated percentage
	MaxMemoryPercent *int64 `json:"max-memory-percent,omitempty"`

	// DBaaS plan name
	Name *string `json:"name,omitempty"`

	// DBaaS plan node count
	NodeCount *int64 `json:"node-count,omitempty"`

	// DBaaS plan CPU count per node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// DBaaS plan memory count per node
	NodeMemory *int64 `json:"node-memory,omitempty"`
}

// DbaasPostgresUsers defines model for dbaas-postgres-users.
type DbaasPostgresUsers struct {
	Users *[]struct {
		AllowReplication *bool             `json:"allow-replication,omitempty"`
		Username         DbaasUserUsername `json:"username"`
	} `json:"users,omitempty"`
}

// List of backups for the service
type DbaasServiceBackup struct {
	// Internal name of this backup
	BackupName string `json:"backup-name"`

	// Backup timestamp (ISO 8601)
	BackupTime time.Time `json:"backup-time"`

	// Backup's original size before compression
	DataSize int64 `json:"data-size"`
}

// DbaasServiceCommon defines model for dbaas-service-common.
type DbaasServiceCommon struct {
	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`
	Name         DbaasServiceName    `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// Subscription plan
	Plan  string            `json:"plan"`
	State *EnumServiceState `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DbaasServiceGrafana defines model for dbaas-service-grafana.
type DbaasServiceGrafana struct {
	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host string `json:"host"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// Grafana connection information properties
	ConnectionInfo *struct {
		Password *string `json:"password,omitempty"`
		Uri      *string `json:"uri,omitempty"`
		Username *string `json:"username,omitempty"`
	} `json:"connection-info,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// DbaaS service description
	Description *string `json:"description,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Grafana specific settings
	GrafanaSettings *map[string]interface{} `json:"grafana-settings,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`
	Name        DbaasServiceName         `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// Subscription plan
	Plan  string            `json:"plan"`
	State *EnumServiceState `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		Password *string `json:"password,omitempty"`
		Type     *string `json:"type,omitempty"`
		Username *string `json:"username,omitempty"`
	} `json:"users,omitempty"`

	// Grafana version
	Version *string `json:"version,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DbaasServiceKafka defines model for dbaas-service-kafka.
type DbaasServiceKafka struct {
	// Kafka authentication methods
	AuthenticationMethods *struct {
		// Whether certificate/SSL authentication is enabled
		Certificate *bool `json:"certificate,omitempty"`

		// Whether SASL authentication is enabled
		Sasl *bool `json:"sasl,omitempty"`
	} `json:"authentication-methods,omitempty"`

	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host                      string               `json:"host"`
		KafkaAuthenticationMethod *EnumKafkaAuthMethod `json:"kafka-authentication-method,omitempty"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// Kafka connection information properties
	ConnectionInfo *struct {
		AccessCert  *string   `json:"access-cert,omitempty"`
		AccessKey   *string   `json:"access-key,omitempty"`
		ConnectUri  *string   `json:"connect-uri,omitempty"`
		Nodes       *[]string `json:"nodes,omitempty"`
		RegistryUri *string   `json:"registry-uri,omitempty"`
		RestUri     *string   `json:"rest-uri,omitempty"`
	} `json:"connection-info,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Whether Kafka Connect is enabled
	KafkaConnectEnabled *bool `json:"kafka-connect-enabled,omitempty"`

	// Kafka Connect configuration values
	KafkaConnectSettings *map[string]interface{} `json:"kafka-connect-settings,omitempty"`

	// Whether Kafka REST is enabled
	KafkaRestEnabled *bool `json:"kafka-rest-enabled,omitempty"`

	// Kafka REST configuration
	KafkaRestSettings *map[string]interface{} `json:"kafka-rest-settings,omitempty"`

	// Kafka-specific settings
	KafkaSettings *map[string]interface{} `json:"kafka-settings,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`
	Name        DbaasServiceName         `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Whether Schema-Registry is enabled
	SchemaRegistryEnabled *bool `json:"schema-registry-enabled,omitempty"`

	// Schema Registry configuration
	SchemaRegistrySettings *map[string]interface{} `json:"schema-registry-settings,omitempty"`
	State                  *EnumServiceState       `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		AccessCert       *string    `json:"access-cert,omitempty"`
		AccessCertExpiry *time.Time `json:"access-cert-expiry,omitempty"`
		AccessKey        *string    `json:"access-key,omitempty"`
		Password         *string    `json:"password,omitempty"`
		Type             *string    `json:"type,omitempty"`
		Username         *string    `json:"username,omitempty"`
	} `json:"users,omitempty"`

	// Kafka version
	Version *string `json:"version,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DbaasServiceLogs defines model for dbaas-service-logs.
type DbaasServiceLogs struct {
	FirstLogOffset *string `json:"first-log-offset,omitempty"`
	Logs           *[]struct {
		Message *string `json:"message,omitempty"`
		Node    *string `json:"node,omitempty"`
		Time    *string `json:"time,omitempty"`
		Unit    *string `json:"unit,omitempty"`
	} `json:"logs,omitempty"`
	Offset *string `json:"offset,omitempty"`
}

// Automatic maintenance settings
type DbaasServiceMaintenance struct {
	// Day of week for installing updates
	Dow DbaasServiceMaintenanceDow `json:"dow"`

	// Time for installing updates, UTC
	Time string `json:"time"`

	// List of updates waiting to be installed
	Updates []DbaasServiceUpdate `json:"updates"`
}

// Day of week for installing updates
type DbaasServiceMaintenanceDow string

// DbaasServiceMysql defines model for dbaas-service-mysql.
type DbaasServiceMysql struct {
	// Backup schedule
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`

	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host string `json:"host"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// MySQL connection information properties
	ConnectionInfo *struct {
		Params *[]struct {
			AdditionalProperties map[string]string `json:"-"`
		} `json:"params,omitempty"`
		Standby *[]string `json:"standby,omitempty"`
		Uri     *[]string `json:"uri,omitempty"`
	} `json:"connection-info,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// List of MySQL databases
	Databases *[]DbaasMysqlDatabaseName `json:"databases,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`

	// MySQL-specific settings
	MysqlSettings *map[string]interface{} `json:"mysql-settings,omitempty"`
	Name          DbaasServiceName        `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// Subscription plan
	Plan  string            `json:"plan"`
	State *EnumServiceState `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		Authentication *string `json:"authentication,omitempty"`
		Password       *string `json:"password,omitempty"`
		Type           *string `json:"type,omitempty"`
		Username       *string `json:"username,omitempty"`
	} `json:"users,omitempty"`

	// MySQL version
	Version *string `json:"version,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DbaasServiceName defines model for dbaas-service-name.
type DbaasServiceName string

// Service notifications
type DbaasServiceNotification struct {
	// Notification level
	Level DbaasServiceNotificationLevel `json:"level"`

	// Human notification message
	Message string `json:"message"`

	// Notification type
	Metadata map[string]interface{} `json:"metadata"`

	// Notification type
	Type DbaasServiceNotificationType `json:"type"`
}

// Notification level
type DbaasServiceNotificationLevel string

// Notification type
type DbaasServiceNotificationType string

// DbaasServiceOpensearch defines model for dbaas-service-opensearch.
type DbaasServiceOpensearch struct {
	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host string `json:"host"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// Opensearch connection information properties
	ConnectionInfo *struct {
		DashboardUri *string   `json:"dashboard-uri,omitempty"`
		Password     *string   `json:"password,omitempty"`
		Uri          *[]string `json:"uri,omitempty"`
		Username     *string   `json:"username,omitempty"`
	} `json:"connection-info,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// DbaaS service description
	Description *string `json:"description,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like 'logs.?' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note 'logs.?' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.
	IndexPatterns *[]struct {
		// Maximum number of indexes to keep
		MaxIndexCount *int64 `json:"max-index-count,omitempty"`

		// fnmatch pattern
		Pattern *string `json:"pattern,omitempty"`

		// Deletion sorting algorithm
		SortingAlgorithm *DbaasServiceOpensearchIndexPatternsSortingAlgorithm `json:"sorting-algorithm,omitempty"`
	} `json:"index-patterns,omitempty"`

	// Template settings for all new indexes
	IndexTemplate *struct {
		// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
		MappingNestedObjectsLimit *int64 `json:"mapping-nested-objects-limit,omitempty"`

		// The number of replicas each primary shard has.
		NumberOfReplicas *int64 `json:"number-of-replicas,omitempty"`

		// The number of primary shards that an index should have.
		NumberOfShards *int64 `json:"number-of-shards,omitempty"`
	} `json:"index-template,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
	KeepIndexRefreshInterval *bool `json:"keep-index-refresh-interval,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`

	// Maximum number of indexes to keep before deleting the oldest one
	MaxIndexCount *int64           `json:"max-index-count,omitempty"`
	Name          DbaasServiceName `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// OpenSearch Dashboards settings
	OpensearchDashboards *struct {
		// Enable or disable OpenSearch Dashboards (default: true)
		Enabled *bool `json:"enabled,omitempty"`

		// Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)
		MaxOldSpaceSize *int64 `json:"max-old-space-size,omitempty"`

		// Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)
		OpensearchRequestTimeout *int64 `json:"opensearch-request-timeout,omitempty"`
	} `json:"opensearch-dashboards,omitempty"`

	// OpenSearch-specific settings
	OpensearchSettings *map[string]interface{} `json:"opensearch-settings,omitempty"`

	// Subscription plan
	Plan  string            `json:"plan"`
	State *EnumServiceState `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		Password *string `json:"password,omitempty"`
		Type     *string `json:"type,omitempty"`
		Username *string `json:"username,omitempty"`
	} `json:"users,omitempty"`

	// OpenSearch version
	Version *string `json:"version,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// Deletion sorting algorithm
type DbaasServiceOpensearchIndexPatternsSortingAlgorithm string

// DbaasServicePg defines model for dbaas-service-pg.
type DbaasServicePg struct {
	// Backup schedule
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`

	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host string `json:"host"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// PG connection information properties
	ConnectionInfo *struct {
		Params *[]struct {
			AdditionalProperties map[string]string `json:"-"`
		} `json:"params,omitempty"`
		Standby *[]string `json:"standby,omitempty"`
		Syncing *[]string `json:"syncing,omitempty"`
		Uri     *[]string `json:"uri,omitempty"`
	} `json:"connection-info,omitempty"`

	// PostgreSQL PGBouncer connection pools
	ConnectionPools *[]struct {
		// Connection URI for the DB pool
		ConnectionUri string              `json:"connection-uri"`
		Database      DbaasDatabaseName   `json:"database"`
		Mode          EnumPgPoolMode      `json:"mode"`
		Name          DbaasPgPoolName     `json:"name"`
		Size          DbaasPgPoolSize     `json:"size"`
		Username      DbaasPgPoolUsername `json:"username"`
	} `json:"connection-pools,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// List of PostgreSQL databases
	Databases *[]DbaasDatabaseName `json:"databases,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`

	// Maximum number of connections allowed to an instance
	MaxConnections *int64           `json:"max-connections,omitempty"`
	Name           DbaasServiceName `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// PostgreSQL-specific settings
	PgSettings *map[string]interface{} `json:"pg-settings,omitempty"`

	// PGBouncer connection pooling settings
	PgbouncerSettings *map[string]interface{} `json:"pgbouncer-settings,omitempty"`

	// PGLookout settings
	PglookoutSettings *map[string]interface{} `json:"pglookout-settings,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
	SharedBuffersPercentage *int64                        `json:"shared-buffers-percentage,omitempty"`
	State                   *EnumServiceState             `json:"state,omitempty"`
	SynchronousReplication  *EnumPgSynchronousReplication `json:"synchronous-replication,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// TimescaleDB extension configuration values
	TimescaledbSettings *map[string]interface{} `json:"timescaledb-settings,omitempty"`
	Type                DbaasServiceTypeName    `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		AllowReplication *bool `json:"allow-replication,omitempty"`

		// Account password. A missing field indicates a user overridden password.
		Password *string `json:"password,omitempty"`

		// Account type
		Type string `json:"type"`

		// Account username
		Username string `json:"username"`
	} `json:"users,omitempty"`

	// PostgreSQL version
	Version *string `json:"version,omitempty"`

	// Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
	WorkMem *int64 `json:"work-mem,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DbaasServiceRedis defines model for dbaas-service-redis.
type DbaasServiceRedis struct {
	// List of backups for the service
	Backups *[]DbaasServiceBackup `json:"backups,omitempty"`

	// Service component information objects
	Components *[]struct {
		// Service component name
		Component string `json:"component"`

		// DNS name for connecting to the service component
		Host string `json:"host"`

		// Port number for connecting to the service component
		Port  int64              `json:"port"`
		Route EnumComponentRoute `json:"route"`

		// Whether the endpoint is encrypted or accepts plaintext.
		//              By default endpoints are always encrypted and
		//              this property is only included for service components that may disable encryption.
		Ssl   *bool              `json:"ssl,omitempty"`
		Usage EnumComponentUsage `json:"usage"`
	} `json:"components,omitempty"`

	// Redis connection information properties
	ConnectionInfo *struct {
		Password *string   `json:"password,omitempty"`
		Slave    *[]string `json:"slave,omitempty"`
		Uri      *[]string `json:"uri,omitempty"`
	} `json:"connection-info,omitempty"`

	// Service creation timestamp (ISO 8601)
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// TODO UNIT disk space for data storage
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Service integrations
	Integrations *[]DbaasIntegration `json:"integrations,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *DbaasServiceMaintenance `json:"maintenance,omitempty"`
	Name        DbaasServiceName         `json:"name"`

	// Number of service nodes in the active plan
	NodeCount *int64 `json:"node-count,omitempty"`

	// Number of CPUs for each node
	NodeCpuCount *int64 `json:"node-cpu-count,omitempty"`

	// TODO UNIT of memory for each node
	NodeMemory *int64 `json:"node-memory,omitempty"`

	// State of individual service nodes
	NodeStates *[]DbaasNodeState `json:"node-states,omitempty"`

	// Service notifications
	Notifications *[]DbaasServiceNotification `json:"notifications,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Redis-specific settings
	RedisSettings *map[string]interface{} `json:"redis-settings,omitempty"`
	State         *EnumServiceState       `json:"state,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DbaasServiceTypeName `json:"type"`

	// Service last update timestamp (ISO 8601)
	UpdatedAt *time.Time `json:"updated-at,omitempty"`

	// URI for connecting to the service (may be absent)
	Uri *string `json:"uri,omitempty"`

	// service_uri parameterized into key-value pairs
	UriParams *map[string]interface{} `json:"uri-params,omitempty"`

	// List of service users
	Users *[]struct {
		AccessControl *struct {
			Categories *[]string `json:"categories,omitempty"`
			Channels   *[]string `json:"channels,omitempty"`
			Commands   *[]string `json:"commands,omitempty"`
			Keys       *[]string `json:"keys,omitempty"`
		} `json:"access-control,omitempty"`
		Password *string `json:"password,omitempty"`
		Type     *string `json:"type,omitempty"`
		Username *string `json:"username,omitempty"`
	} `json:"users,omitempty"`

	// Redis version
	Version *string `json:"version,omitempty"`

	// The zone where the service is running
	Zone *string `json:"zone,omitempty"`
}

// DBaaS service
type DbaasServiceType struct {
	// DbaaS service available versions
	AvailableVersions *[]string `json:"available-versions,omitempty"`

	// DbaaS service default version
	DefaultVersion *string `json:"default-version,omitempty"`

	// DbaaS service description
	Description *string               `json:"description,omitempty"`
	Name        *DbaasServiceTypeName `json:"name,omitempty"`

	// DbaaS service plans
	Plans *[]DbaasPlan `json:"plans,omitempty"`
}

// DbaasServiceTypeName defines model for dbaas-service-type-name.
type DbaasServiceTypeName string

// Update waiting to be installed
type DbaasServiceUpdate struct {
	// Deadline for installing the update
	Deadline *time.Time `json:"deadline,omitempty"`

	// Description of the update
	Description *string `json:"description,omitempty"`

	// The earliest time the update will be automatically applied
	StartAfter *time.Time `json:"start-after,omitempty"`

	// The time when the update will be automatically applied
	StartAt *time.Time `json:"start-at,omitempty"`
}

// DbaasTask defines model for dbaas-task.
type DbaasTask struct {
	CreateTime  *time.Time `json:"create-time,omitempty"`
	Id          *string    `json:"id,omitempty"`
	Result      *string    `json:"result,omitempty"`
	ResultCodes *[]struct {
		Code   *string `json:"code,omitempty"`
		Dbname *string `json:"dbname,omitempty"`
	} `json:"result-codes,omitempty"`
	Success  *bool   `json:"success,omitempty"`
	TaskType *string `json:"task-type,omitempty"`
}

// DbaasUserPassword defines model for dbaas-user-password.
type DbaasUserPassword string

// DbaasUserUsername defines model for dbaas-user-username.
type DbaasUserUsername string

// Deploy target
type DeployTarget struct {
	// Deploy Target description
	Description *string `json:"description,omitempty"`

	// Deploy Target ID
	Id string `json:"id"`

	// Deploy Target name
	Name *string `json:"name,omitempty"`

	// Deploy Target type
	Type *DeployTargetType `json:"type,omitempty"`
}

// Deploy Target type
type DeployTargetType string

// DNS domain
type DnsDomain struct {
	// DNS domain creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// DNS domain ID
	Id *string `json:"id,omitempty"`

	// DNS domain unicode name
	UnicodeName *string `json:"unicode-name,omitempty"`
}

// DNS domain record
type DnsDomainRecord struct {
	// DNS domain record content
	Content *string `json:"content,omitempty"`

	// DNS domain record creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// DNS domain record ID
	Id *string `json:"id,omitempty"`

	// DNS domain record name
	Name *string `json:"name,omitempty"`

	// DNS domain record priority
	Priority *int64 `json:"priority,omitempty"`

	// DNS domain record TTL
	Ttl *int64 `json:"ttl,omitempty"`

	// DNS domain record type
	Type *DnsDomainRecordType `json:"type,omitempty"`

	// DNS domain record update date
	UpdatedAt *time.Time `json:"updated-at,omitempty"`
}

// DNS domain record type
type DnsDomainRecordType string

// DomainName defines model for domain-name.
type DomainName string

// Elastic IP
type ElasticIp struct {
	// Elastic IP address family
	Addressfamily *ElasticIpAddressfamily `json:"addressfamily,omitempty"`

	// Elastic IP cidr
	Cidr *string `json:"cidr,omitempty"`

	// Elastic IP description
	Description *string `json:"description,omitempty"`

	// Elastic IP address healthcheck
	Healthcheck *ElasticIpHealthcheck `json:"healthcheck,omitempty"`

	// Elastic IP ID
	Id *string `json:"id,omitempty"`

	// Elastic IP address
	Ip     *string `json:"ip,omitempty"`
	Labels *Labels `json:"labels,omitempty"`
}

// Elastic IP address family
type ElasticIpAddressfamily string

// Elastic IP address healthcheck
type ElasticIpHealthcheck struct {
	// Interval between the checks in seconds (default: 10)
	Interval *int64 `json:"interval,omitempty"`

	// Health check mode
	Mode ElasticIpHealthcheckMode `json:"mode"`

	// Health check port
	Port int64 `json:"port"`

	// Number of attempts before considering the target unhealthy (default: 3)
	StrikesFail *int64 `json:"strikes-fail,omitempty"`

	// Number of attempts before considering the target healthy (default: 2)
	StrikesOk *int64 `json:"strikes-ok,omitempty"`

	// Health check timeout value in seconds (default: 2)
	Timeout *int64 `json:"timeout,omitempty"`

	// Skip TLS verification
	TlsSkipVerify *bool `json:"tls-skip-verify,omitempty"`

	// An optional domain or subdomain to check TLS against
	TlsSni *string `json:"tls-sni,omitempty"`

	// An endpoint to use for the health check, for example '/status'
	Uri *string `json:"uri,omitempty"`
}

// Health check mode
type ElasticIpHealthcheckMode string

// EnumComponentRoute defines model for enum-component-route.
type EnumComponentRoute string

// EnumComponentUsage defines model for enum-component-usage.
type EnumComponentUsage string

// EnumIntegrationTypes defines model for enum-integration-types.
type EnumIntegrationTypes string

// EnumKafkaAuthMethod defines model for enum-kafka-auth-method.
type EnumKafkaAuthMethod string

// EnumMasterLinkStatus defines model for enum-master-link-status.
type EnumMasterLinkStatus string

// EnumMigrationMethod defines model for enum-migration-method.
type EnumMigrationMethod string

// EnumMigrationStatus defines model for enum-migration-status.
type EnumMigrationStatus string

// EnumMysqlAuthenticationPlugin defines model for enum-mysql-authentication-plugin.
type EnumMysqlAuthenticationPlugin string

// EnumOpensearchRulePermission defines model for enum-opensearch-rule-permission.
type EnumOpensearchRulePermission string

// EnumPgPoolMode defines model for enum-pg-pool-mode.
type EnumPgPoolMode string

// EnumPgSynchronousReplication defines model for enum-pg-synchronous-replication.
type EnumPgSynchronousReplication string

// EnumPgVariant defines model for enum-pg-variant.
type EnumPgVariant string

// EnumServiceState defines model for enum-service-state.
type EnumServiceState string

// EnumSortOrder defines model for enum-sort-order.
type EnumSortOrder string

// A notable Mutation Event which happened on the infrastructure
type Event struct {
	// Body parameters (free form map)
	BodyParams *map[string]interface{} `json:"body-params,omitempty"`

	// Operation processing time
	ElapsedMs *int64 `json:"elapsed-ms,omitempty"`

	// Query string parameters (free form map)
	GetParams *map[string]interface{} `json:"get-params,omitempty"`

	// Operation handler name
	Handler *string `json:"handler,omitempty"`

	// Operation message
	Message *string `json:"message,omitempty"`

	// URI path parameters (free form map)
	PathParams *map[string]interface{} `json:"path-params,omitempty"`

	// Client IP address
	RemoteAddr *string `json:"remote-addr,omitempty"`

	// Operation unique identifier
	RequestId *string `json:"request-id,omitempty"`

	// Operation HTTP status
	Status *int64 `json:"status,omitempty"`

	// Time at which the event happened, millisecond resolution
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// Operation request URI
	Uri *string `json:"uri,omitempty"`

	// Operation targeted zone
	Zone *string `json:"zone,omitempty"`
}

// IAM API Key
type IamApiKey struct {
	// IAM API Key
	Key *string `json:"key,omitempty"`

	// IAM API Key name
	Name *string `json:"name,omitempty"`

	// IAM API Key Role ID
	RoleId *string `json:"role-id,omitempty"`
}

// IAM API Key
type IamApiKeyCreated struct {
	// IAM API Key
	Key *string `json:"key,omitempty"`

	// IAM API Key name
	Name *string `json:"name,omitempty"`

	// IAM API Key Role ID
	RoleId *string `json:"role-id,omitempty"`

	// IAM API Key Secret
	Secret *string `json:"secret,omitempty"`
}

// Policy
type IamPolicy struct {
	// IAM default service strategy
	DefaultServiceStrategy IamPolicyDefaultServiceStrategy `json:"default-service-strategy"`

	// IAM services
	Services IamPolicy_Services `json:"services"`
}

// IAM default service strategy
type IamPolicyDefaultServiceStrategy string

// IAM services
type IamPolicy_Services struct {
	AdditionalProperties map[string]IamServicePolicy `json:"-"`
}

// IAM Role
type IamRole struct {
	// IAM Role description
	Description *string `json:"description,omitempty"`

	// IAM Role mutability
	Editable *bool `json:"editable,omitempty"`

	// IAM Role ID
	Id     *string `json:"id,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// IAM Role name
	Name *string `json:"name,omitempty"`

	// IAM Role permissions
	Permissions *[]IamRolePermissions `json:"permissions,omitempty"`

	// Policy
	Policy *IamPolicy `json:"policy,omitempty"`
}

// IamRolePermissions defines model for IamRole.Permissions.
type IamRolePermissions string

// IamServicePolicy defines model for iam-service-policy.
type IamServicePolicy struct {
	Rules *[]IamServicePolicyRule `json:"rules,omitempty"`
	Type  *IamServicePolicyType   `json:"type,omitempty"`
}

// IamServicePolicyType defines model for IamServicePolicy.Type.
type IamServicePolicyType string

// IamServicePolicyRule defines model for iam-service-policy-rule.
type IamServicePolicyRule struct {
	Action     *IamServicePolicyRuleAction `json:"action,omitempty"`
	Expression *string                     `json:"expression,omitempty"`
	Resources  *[]string                   `json:"resources,omitempty"`
}

// IamServicePolicyRuleAction defines model for IamServicePolicyRule.Action.
type IamServicePolicyRuleAction string

// Instance
type Instance struct {
	// Instance Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Instance creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Instance disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Instance Elastic IPs
	ElasticIps *[]ElasticIp `json:"elastic-ips,omitempty"`

	// Instance ID
	Id *string `json:"id,omitempty"`

	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`

	// Instance IPv6 address
	Ipv6Address *string `json:"ipv6-address,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Resource manager
	Manager *Manager `json:"manager,omitempty"`

	// Instance name
	Name *string `json:"name,omitempty"`

	// Instance Private Networks
	PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`

	// Instance public IPv4 address
	PublicIp           *string             `json:"public-ip,omitempty"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// Instance Snapshots
	Snapshots *[]Snapshot `json:"snapshots,omitempty"`

	// SSH key
	SshKey *SshKey `json:"ssh-key,omitempty"`

	// Instance SSH Keys
	SshKeys *[]SshKey      `json:"ssh-keys,omitempty"`
	State   *InstanceState `json:"state,omitempty"`

	// Instance template
	Template *Template `json:"template,omitempty"`

	// Instance Cloud-init user-data (base64 encoded)
	UserData *string `json:"user-data,omitempty"`
}

// Instance password
type InstancePassword struct {
	// Password
	Password *string `json:"password,omitempty"`
}

// Instance Pool
type InstancePool struct {
	// Instance Pool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Instance Pool description
	Description *string `json:"description,omitempty"`

	// Instances disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Instances Elastic IPs
	ElasticIps *[]ElasticIp `json:"elastic-ips,omitempty"`

	// Instance Pool ID
	Id *string `json:"id,omitempty"`

	// The instances created by the Instance Pool will be prefixed with this value (default: pool)
	InstancePrefix *string `json:"instance-prefix,omitempty"`

	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`

	// Instances
	Instances *[]Instance `json:"instances,omitempty"`

	// Enable IPv6 for instances
	Ipv6Enabled *bool   `json:"ipv6-enabled,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Resource manager
	Manager *Manager `json:"manager,omitempty"`

	// Minimum number of running instances
	MinAvailable *int64 `json:"min-available,omitempty"`

	// Instance Pool name
	Name *string `json:"name,omitempty"`

	// Instance Pool Private Networks
	PrivateNetworks    *[]PrivateNetwork   `json:"private-networks,omitempty"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Pool Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// Number of instances
	Size *int64 `json:"size,omitempty"`

	// SSH key
	SshKey *SshKey `json:"ssh-key,omitempty"`

	// Instances SSH keys
	SshKeys *[]SshKey `json:"ssh-keys,omitempty"`

	// Instance Pool state
	State *InstancePoolState `json:"state,omitempty"`

	// Instance template
	Template *Template `json:"template,omitempty"`

	// Instances Cloud-init user-data
	UserData *string `json:"user-data,omitempty"`
}

// Instance Pool state
type InstancePoolState string

// InstanceState defines model for instance-state.
type InstanceState string

// Target Instance
type InstanceTarget struct {
	// Instance ID
	Id *string `json:"id,omitempty"`
}

// Compute instance type
type InstanceType struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`

	// CPU count
	Cpus *int64 `json:"cpus,omitempty"`

	// Instance type family
	Family *InstanceTypeFamily `json:"family,omitempty"`

	// GPU count
	Gpus *int64 `json:"gpus,omitempty"`

	// Instance type ID
	Id *string `json:"id,omitempty"`

	// Available memory
	Memory *int64 `json:"memory,omitempty"`

	// Instance type size
	Size *InstanceTypeSize `json:"size,omitempty"`

	// Instance Type available zones
	Zones *[]ZoneName `json:"zones,omitempty"`
}

// Instance type family
type InstanceTypeFamily string

// Instance type size
type InstanceTypeSize string

// Kubelet image GC options
type KubeletImageGc struct {
	HighThreshold *int64  `json:"high-threshold,omitempty"`
	LowThreshold  *int64  `json:"low-threshold,omitempty"`
	MinAge        *string `json:"min-age,omitempty"`
}

// Labels defines model for labels.
type Labels struct {
	AdditionalProperties map[string]string `json:"-"`
}

// Load Balancer
type LoadBalancer struct {
	// Load Balancer creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Load Balancer description
	Description *string `json:"description,omitempty"`

	// Load Balancer ID
	Id *string `json:"id,omitempty"`

	// Load Balancer public IP
	Ip     *string `json:"ip,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// Load Balancer name
	Name *string `json:"name,omitempty"`

	// Load Balancer Services
	Services *[]LoadBalancerService `json:"services,omitempty"`

	// Load Balancer state
	State *LoadBalancerState `json:"state,omitempty"`
}

// Load Balancer state
type LoadBalancerState string

// Load Balancer Service status
type LoadBalancerServerStatus struct {
	// Backend server public IP
	PublicIp *string `json:"public-ip,omitempty"`

	// Status of the instance's healthcheck
	Status *LoadBalancerServerStatusStatus `json:"status,omitempty"`
}

// Status of the instance's healthcheck
type LoadBalancerServerStatusStatus string

// Load Balancer Service
type LoadBalancerService struct {
	// Load Balancer Service description
	Description *string `json:"description,omitempty"`

	// Load Balancer Service healthcheck
	Healthcheck *LoadBalancerServiceHealthcheck `json:"healthcheck,omitempty"`

	// Healthcheck status per backend server
	HealthcheckStatus *[]LoadBalancerServerStatus `json:"healthcheck-status,omitempty"`

	// Load Balancer Service ID
	Id *string `json:"id,omitempty"`

	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`

	// Load Balancer Service name
	Name *string `json:"name,omitempty"`

	// Port exposed on the Load Balancer's public IP
	Port *int64 `json:"port,omitempty"`

	// Network traffic protocol
	Protocol *LoadBalancerServiceProtocol `json:"protocol,omitempty"`

	// Load Balancer Service state
	State *LoadBalancerServiceState `json:"state,omitempty"`

	// Load balancing strategy
	Strategy *LoadBalancerServiceStrategy `json:"strategy,omitempty"`

	// Port on which the network traffic will be forwarded to on the receiving instance
	TargetPort *int64 `json:"target-port,omitempty"`
}

// Network traffic protocol
type LoadBalancerServiceProtocol string

// Load Balancer Service state
type LoadBalancerServiceState string

// Load balancing strategy
type LoadBalancerServiceStrategy string

// Load Balancer Service healthcheck
type LoadBalancerServiceHealthcheck struct {
	// Healthcheck interval (default: 10). Must be greater than or equal to Timeout
	Interval *int64 `json:"interval,omitempty"`

	// Healthcheck mode
	Mode *LoadBalancerServiceHealthcheckMode `json:"mode,omitempty"`

	// Healthcheck port
	Port *int64 `json:"port,omitempty"`

	// Number of retries before considering a Service failed
	Retries *int64 `json:"retries,omitempty"`

	// Healthcheck timeout value (default: 2). Must be lower than or equal to Interval
	Timeout *int64 `json:"timeout,omitempty"`

	// SNI domain for HTTPS healthchecks
	TlsSni *string `json:"tls-sni,omitempty"`

	// An endpoint to use for the HTTP healthcheck, e.g. '/status'
	Uri *string `json:"uri,omitempty"`
}

// Healthcheck mode
type LoadBalancerServiceHealthcheckMode string

// Resource manager
type Manager struct {
	// Manager ID
	Id *string `json:"id,omitempty"`

	// Manager type
	Type *ManagerType `json:"type,omitempty"`
}

// Manager type
type ManagerType string

// Operation
type Operation struct {
	// Operation ID
	Id *string `json:"id,omitempty"`

	// Operation message
	Message *string `json:"message,omitempty"`

	// Operation failure reason
	Reason *OperationReason `json:"reason,omitempty"`

	// Related resource reference
	Reference *struct {
		// Command name
		Command *string `json:"command,omitempty"`

		// Reference ID
		Id *string `json:"id,omitempty"`

		// Link to the referenced resource
		Link *string `json:"link,omitempty"`
	} `json:"reference,omitempty"`

	// Operation status
	State *OperationState `json:"state,omitempty"`
}

// Operation failure reason
type OperationReason string

// Operation status
type OperationState string

// Private Network
type PrivateNetwork struct {
	// Private Network description
	Description *string `json:"description,omitempty"`

	// Private Network end IP address
	EndIp *string `json:"end-ip,omitempty"`

	// Private Network ID
	Id     *string `json:"id,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// Private Network leased IP addresses
	Leases *[]PrivateNetworkLease `json:"leases,omitempty"`

	// Private Network name
	Name *string `json:"name,omitempty"`

	// Private Network netmask
	Netmask *string `json:"netmask,omitempty"`

	// Private Network start IP address
	StartIp *string `json:"start-ip,omitempty"`
}

// Private Network leased IP address
type PrivateNetworkLease struct {
	// Attached instance ID
	InstanceId *string `json:"instance-id,omitempty"`

	// Private Network IP address
	Ip *string `json:"ip,omitempty"`
}

// PublicIpAssignment defines model for public-ip-assignment.
type PublicIpAssignment string

// Organization Quota
type Quota struct {
	// Resource Limit. -1 for Unlimited
	Limit *int64 `json:"limit,omitempty"`

	// Resource Name
	Resource *string `json:"resource,omitempty"`

	// Resource Usage
	Usage *int64 `json:"usage,omitempty"`
}

// ReverseDnsRecord defines model for reverse-dns-record.
type ReverseDnsRecord struct {
	DomainName *DomainName `json:"domain-name,omitempty"`
}

// Security Group
type SecurityGroup struct {
	// Security Group description
	Description *string `json:"description,omitempty"`

	// Security Group external sources
	ExternalSources *[]string `json:"external-sources,omitempty"`

	// Security Group ID
	Id *string `json:"id,omitempty"`

	// Security Group name
	Name *string `json:"name,omitempty"`

	// Security Group rules
	Rules *[]SecurityGroupRule `json:"rules,omitempty"`
}

// Security Group
type SecurityGroupResource struct {
	// Security Group ID
	Id *string `json:"id,omitempty"`

	// Security Group name
	Name *string `json:"name,omitempty"`

	// Whether this points to a public security group. This is only valid when in the context of
	//                    a rule addition which uses a public security group as a source or destination.
	Visibility *SecurityGroupResourceVisibility `json:"visibility,omitempty"`
}

// Whether this points to a public security group. This is only valid when in the context of
//
//	a rule addition which uses a public security group as a source or destination.
type SecurityGroupResourceVisibility string

// Security Group rule
type SecurityGroupRule struct {
	// Security Group rule description
	Description *string `json:"description,omitempty"`

	// End port of the range
	EndPort *int64 `json:"end-port,omitempty"`

	// Network flow direction to match
	FlowDirection *SecurityGroupRuleFlowDirection `json:"flow-direction,omitempty"`

	// ICMP details
	Icmp *struct {
		Code *int64 `json:"code,omitempty"`
		Type *int64 `json:"type,omitempty"`
	} `json:"icmp,omitempty"`

	// Security Group rule ID
	Id *string `json:"id,omitempty"`

	// CIDR-formatted network allowed
	Network *string `json:"network,omitempty"`

	// Network protocol
	Protocol *SecurityGroupRuleProtocol `json:"protocol,omitempty"`

	// Security Group
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`

	// Start port of the range
	StartPort *int64 `json:"start-port,omitempty"`
}

// Network flow direction to match
type SecurityGroupRuleFlowDirection string

// Network protocol
type SecurityGroupRuleProtocol string

// SKS Cluster
type SksCluster struct {
	// Cluster addons
	Addons *[]SksClusterAddons `json:"addons,omitempty"`

	// Enable auto upgrade of the control plane to the latest patch version available
	AutoUpgrade *bool `json:"auto-upgrade,omitempty"`

	// Cluster CNI
	Cni *SksClusterCni `json:"cni,omitempty"`

	// Cluster creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Cluster description
	Description *string `json:"description,omitempty"`

	// Cluster endpoint
	Endpoint *string `json:"endpoint,omitempty"`

	// Cluster ID
	Id     *string `json:"id,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// Cluster level
	Level *SksClusterLevel `json:"level,omitempty"`

	// Cluster name
	Name *string `json:"name,omitempty"`

	// Cluster Nodepools
	Nodepools *[]SksNodepool `json:"nodepools,omitempty"`

	// Cluster state
	State *SksClusterState `json:"state,omitempty"`

	// Control plane Kubernetes version
	Version *string `json:"version,omitempty"`
}

// SksClusterAddons defines model for SksCluster.Addons.
type SksClusterAddons string

// Cluster CNI
type SksClusterCni string

// Cluster level
type SksClusterLevel string

// Cluster state
type SksClusterState string

// SksClusterDeprecatedResource defines model for sks-cluster-deprecated-resource.
type SksClusterDeprecatedResource struct {
	AdditionalProperties map[string]string `json:"-"`
}

// Kubeconfig request for a SKS cluster
type SksKubeconfigRequest struct {
	// List of roles. The certificate present in the Kubeconfig will have these roles set in the Org field.
	Groups *[]string `json:"groups,omitempty"`

	// Validity in seconds of the Kubeconfig user certificate (default: 30 days)
	Ttl *int64 `json:"ttl,omitempty"`

	// User name in the generated Kubeconfig. The certificate present in the Kubeconfig will also have this name set for the CN field.
	User *string `json:"user,omitempty"`
}

// SKS Nodepool
type SksNodepool struct {
	// Nodepool addons
	Addons *[]SksNodepoolAddons `json:"addons,omitempty"`

	// Nodepool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Nodepool creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Nodepool description
	Description *string `json:"description,omitempty"`

	// Nodepool instances disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Nodepool ID
	Id *string `json:"id,omitempty"`

	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`

	// The instances created by the Nodepool will be prefixed with this value (default: pool)
	InstancePrefix *string `json:"instance-prefix,omitempty"`

	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`

	// Kubelet image GC options
	KubeletImageGc *KubeletImageGc `json:"kubelet-image-gc,omitempty"`
	Labels         *Labels         `json:"labels,omitempty"`

	// Nodepool name
	Name *string `json:"name,omitempty"`

	// Nodepool Private Networks
	PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`

	// Nodepool Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// Number of instances
	Size *int64 `json:"size,omitempty"`

	// Nodepool state
	State  *SksNodepoolState  `json:"state,omitempty"`
	Taints *SksNodepoolTaints `json:"taints,omitempty"`

	// Instance template
	Template *Template `json:"template,omitempty"`

	// Nodepool version
	Version *string `json:"version,omitempty"`
}

// SksNodepoolAddons defines model for SksNodepool.Addons.
type SksNodepoolAddons string

// Nodepool state
type SksNodepoolState string

// Nodepool taint
type SksNodepoolTaint struct {
	// Nodepool taint effect
	Effect SksNodepoolTaintEffect `json:"effect"`

	// Nodepool taint value
	Value string `json:"value"`
}

// Nodepool taint effect
type SksNodepoolTaintEffect string

// SksNodepoolTaints defines model for sks-nodepool-taints.
type SksNodepoolTaints struct {
	AdditionalProperties map[string]SksNodepoolTaint `json:"-"`
}

// SKS Cluster OpenID config map
type SksOidc struct {
	// OpenID client ID
	ClientId string `json:"client-id"`

	// JWT claim to use as the user's group
	GroupsClaim *string `json:"groups-claim,omitempty"`

	// Prefix prepended to group claims
	GroupsPrefix *string `json:"groups-prefix,omitempty"`

	// OpenID provider URL
	IssuerUrl string `json:"issuer-url"`

	// A key value map that describes a required claim in the ID Token
	RequiredClaim *SksOidc_RequiredClaim `json:"required-claim,omitempty"`

	// JWT claim to use as the user name
	UsernameClaim *string `json:"username-claim,omitempty"`

	// Prefix prepended to username claims
	UsernamePrefix *string `json:"username-prefix,omitempty"`
}

// A key value map that describes a required claim in the ID Token
type SksOidc_RequiredClaim struct {
	AdditionalProperties map[string]string `json:"-"`
}

// Snapshot
type Snapshot struct {
	// Snapshot creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Exported snapshot information
	Export *struct {
		// Exported snapshot disk file MD5 checksum
		Md5sum *string `json:"md5sum,omitempty"`

		// Exported snapshot disk file pre-signed URL
		PresignedUrl *string `json:"presigned-url,omitempty"`
	} `json:"export,omitempty"`

	// Snapshot ID
	Id *string `json:"id,omitempty"`

	// Instance
	Instance *Instance `json:"instance,omitempty"`

	// Snapshot name
	Name *string `json:"name,omitempty"`

	// Snapshot size in GB
	Size *int64 `json:"size,omitempty"`

	// Snapshot state
	State *SnapshotState `json:"state,omitempty"`
}

// Snapshot state
type SnapshotState string

// SOS Bucket usage
type SosBucketUsage struct {
	// SOS Bucket creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// SOS Bucket name
	Name *string `json:"name,omitempty"`

	// SOS Bucket size in B
	Size     *int64    `json:"size,omitempty"`
	ZoneName *ZoneName `json:"zone-name,omitempty"`
}

// SSH key
type SshKey struct {
	// SSH key fingerprint
	Fingerprint *string `json:"fingerprint,omitempty"`

	// SSH key name
	Name *string `json:"name,omitempty"`
}

// Instance template
type Template struct {
	// Boot mode (default: legacy)
	BootMode *TemplateBootMode `json:"boot-mode,omitempty"`

	// Template build
	Build *string `json:"build,omitempty"`

	// Template MD5 checksum
	Checksum *string `json:"checksum,omitempty"`

	// Template creation date
	CreatedAt *time.Time `json:"created-at,omitempty"`

	// Template default user
	DefaultUser *string `json:"default-user,omitempty"`

	// Template description
	Description *string `json:"description,omitempty"`

	// Template family
	Family *string `json:"family,omitempty"`

	// Template ID
	Id *string `json:"id,omitempty"`

	// Template maintainer
	Maintainer *string `json:"maintainer,omitempty"`

	// Template name
	Name *string `json:"name,omitempty"`

	// Enable password-based login
	PasswordEnabled *bool `json:"password-enabled,omitempty"`

	// Template size
	Size *int64 `json:"size,omitempty"`

	// Enable SSH key-based login
	SshKeyEnabled *bool `json:"ssh-key-enabled,omitempty"`

	// Template source URL
	Url *string `json:"url,omitempty"`

	// Template version
	Version *string `json:"version,omitempty"`

	// Template visibility
	Visibility *TemplateVisibility `json:"visibility,omitempty"`

	// Zones availability
	Zones *[]ZoneName `json:"zones,omitempty"`
}

// Boot mode (default: legacy)
type TemplateBootMode string

// Template visibility
type TemplateVisibility string

// Zone
type Zone struct {
	Name *ZoneName `json:"name,omitempty"`
}

// ZoneName defines model for zone-name.
type ZoneName string

// CreateAccessKeyJSONBody defines parameters for CreateAccessKey.
type CreateAccessKeyJSONBody struct {
	// IAM Access Key name
	Name *string `json:"name,omitempty"`

	// IAM Access Key operations
	Operations *[]string `json:"operations,omitempty"`

	// IAM Access Key Resources
	Resources *[]AccessKeyResource `json:"resources,omitempty"`

	// IAM Access Key tags
	Tags *[]string `json:"tags,omitempty"`
}

// CreateAntiAffinityGroupJSONBody defines parameters for CreateAntiAffinityGroup.
type CreateAntiAffinityGroupJSONBody struct {
	// Anti-affinity Group description
	Description *string `json:"description,omitempty"`

	// Anti-affinity Group name
	Name string `json:"name"`
}

// CreateApiKeyJSONBody defines parameters for CreateApiKey.
type CreateApiKeyJSONBody struct {
	// IAM API Key Name
	Name string `json:"name"`

	// IAM API Key Role ID
	RoleId string `json:"role-id"`
}

// CreateDbaasServiceGrafanaJSONBody defines parameters for CreateDbaasServiceGrafana.
type CreateDbaasServiceGrafanaJSONBody struct {
	ForkFromService *DbaasServiceName `json:"fork-from-service,omitempty"`

	// Grafana specific settings
	GrafanaSettings *map[string]interface{} `json:"grafana-settings,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServiceGrafanaJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// CreateDbaasServiceGrafanaJSONBodyMaintenanceDow defines parameters for CreateDbaasServiceGrafana.
type CreateDbaasServiceGrafanaJSONBodyMaintenanceDow string

// UpdateDbaasServiceGrafanaJSONBody defines parameters for UpdateDbaasServiceGrafana.
type UpdateDbaasServiceGrafanaJSONBody struct {
	// Grafana specific settings
	GrafanaSettings *map[string]interface{} `json:"grafana-settings,omitempty"`

	// Allowed CIDR address blocks for incoming connections
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServiceGrafanaJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// UpdateDbaasServiceGrafanaJSONBodyMaintenanceDow defines parameters for UpdateDbaasServiceGrafana.
type UpdateDbaasServiceGrafanaJSONBodyMaintenanceDow string

// CreateDbaasIntegrationJSONBody defines parameters for CreateDbaasIntegration.
type CreateDbaasIntegrationJSONBody struct {
	DestService     DbaasServiceName     `json:"dest-service"`
	IntegrationType EnumIntegrationTypes `json:"integration-type"`

	// Integration settings
	Settings      *map[string]interface{} `json:"settings,omitempty"`
	SourceService DbaasServiceName        `json:"source-service"`
}

// UpdateDbaasIntegrationJSONBody defines parameters for UpdateDbaasIntegration.
type UpdateDbaasIntegrationJSONBody struct {
	// Integration settings
	Settings map[string]interface{} `json:"settings"`
}

// CreateDbaasServiceKafkaJSONBody defines parameters for CreateDbaasServiceKafka.
type CreateDbaasServiceKafkaJSONBody struct {
	// Kafka authentication methods
	AuthenticationMethods *struct {
		// Enable certificate/SSL authentication
		Certificate *bool `json:"certificate,omitempty"`

		// Enable SASL authentication
		Sasl *bool `json:"sasl,omitempty"`
	} `json:"authentication-methods,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Allow clients to connect to kafka_connect from the public internet for service nodes that are in a project VPC or another type of private network
	KafkaConnectEnabled *bool `json:"kafka-connect-enabled,omitempty"`

	// Kafka Connect configuration values
	KafkaConnectSettings *map[string]interface{} `json:"kafka-connect-settings,omitempty"`

	// Enable Kafka-REST service
	KafkaRestEnabled *bool `json:"kafka-rest-enabled,omitempty"`

	// Kafka REST configuration
	KafkaRestSettings *map[string]interface{} `json:"kafka-rest-settings,omitempty"`

	// Kafka-specific settings
	KafkaSettings *map[string]interface{} `json:"kafka-settings,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServiceKafkaJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Enable Schema-Registry service
	SchemaRegistryEnabled *bool `json:"schema-registry-enabled,omitempty"`

	// Schema Registry configuration
	SchemaRegistrySettings *map[string]interface{} `json:"schema-registry-settings,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// Kafka major version
	Version *string `json:"version,omitempty"`
}

// CreateDbaasServiceKafkaJSONBodyMaintenanceDow defines parameters for CreateDbaasServiceKafka.
type CreateDbaasServiceKafkaJSONBodyMaintenanceDow string

// UpdateDbaasServiceKafkaJSONBody defines parameters for UpdateDbaasServiceKafka.
type UpdateDbaasServiceKafkaJSONBody struct {
	// Kafka authentication methods
	AuthenticationMethods *struct {
		// Enable certificate/SSL authentication
		Certificate *bool `json:"certificate,omitempty"`

		// Enable SASL authentication
		Sasl *bool `json:"sasl,omitempty"`
	} `json:"authentication-methods,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Allow clients to connect to kafka_connect from the public internet for service nodes that are in a project VPC or another type of private network
	KafkaConnectEnabled *bool `json:"kafka-connect-enabled,omitempty"`

	// Kafka Connect configuration values
	KafkaConnectSettings *map[string]interface{} `json:"kafka-connect-settings,omitempty"`

	// Enable Kafka-REST service
	KafkaRestEnabled *bool `json:"kafka-rest-enabled,omitempty"`

	// Kafka REST configuration
	KafkaRestSettings *map[string]interface{} `json:"kafka-rest-settings,omitempty"`

	// Kafka-specific settings
	KafkaSettings *map[string]interface{} `json:"kafka-settings,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServiceKafkaJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Enable Schema-Registry service
	SchemaRegistryEnabled *bool `json:"schema-registry-enabled,omitempty"`

	// Schema Registry configuration
	SchemaRegistrySettings *map[string]interface{} `json:"schema-registry-settings,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// UpdateDbaasServiceKafkaJSONBodyMaintenanceDow defines parameters for UpdateDbaasServiceKafka.
type UpdateDbaasServiceKafkaJSONBodyMaintenanceDow string

// CreateDbaasKafkaSchemaRegistryAclConfigJSONBody defines parameters for CreateDbaasKafkaSchemaRegistryAclConfig.
type CreateDbaasKafkaSchemaRegistryAclConfigJSONBody DbaasKafkaSchemaRegistryAclEntry

// CreateDbaasKafkaTopicAclConfigJSONBody defines parameters for CreateDbaasKafkaTopicAclConfig.
type CreateDbaasKafkaTopicAclConfigJSONBody DbaasKafkaTopicAclEntry

// CreateDbaasKafkaUserJSONBody defines parameters for CreateDbaasKafkaUser.
type CreateDbaasKafkaUserJSONBody struct {
	Username DbaasUserUsername `json:"username"`
}

// ResetDbaasKafkaUserPasswordJSONBody defines parameters for ResetDbaasKafkaUserPassword.
type ResetDbaasKafkaUserPasswordJSONBody struct {
	Password *DbaasUserPassword `json:"password,omitempty"`
}

// CreateDbaasServiceMysqlJSONBody defines parameters for CreateDbaasServiceMysql.
type CreateDbaasServiceMysqlJSONBody struct {
	// Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
	AdminPassword *string `json:"admin-password,omitempty"`

	// Custom username for admin user. This must be set only when a new service is being created.
	AdminUsername  *string `json:"admin-username,omitempty"`
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`

	// The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.
	BinlogRetentionPeriod *int64            `json:"binlog-retention-period,omitempty"`
	ForkFromService       *DbaasServiceName `json:"fork-from-service,omitempty"`

	// Service integrations to be enabled when creating the service.
	Integrations *[]struct {
		DestService *DbaasServiceName `json:"dest-service,omitempty"`

		// Integration settings
		Settings      *map[string]interface{} `json:"settings,omitempty"`
		SourceService *DbaasServiceName       `json:"source-service,omitempty"`

		// Integration type
		Type CreateDbaasServiceMysqlJSONBodyIntegrationsType `json:"type"`
	} `json:"integrations,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServiceMysqlJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// MySQL-specific settings
	MysqlSettings *map[string]interface{} `json:"mysql-settings,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// ISO time of a backup to recover from for services that support arbitrary times
	RecoveryBackupTime *string `json:"recovery-backup-time,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// MySQL major version
	Version *string `json:"version,omitempty"`
}

// CreateDbaasServiceMysqlJSONBodyIntegrationsType defines parameters for CreateDbaasServiceMysql.
type CreateDbaasServiceMysqlJSONBodyIntegrationsType string

// CreateDbaasServiceMysqlJSONBodyMaintenanceDow defines parameters for CreateDbaasServiceMysql.
type CreateDbaasServiceMysqlJSONBodyMaintenanceDow string

// UpdateDbaasServiceMysqlJSONBody defines parameters for UpdateDbaasServiceMysql.
type UpdateDbaasServiceMysqlJSONBody struct {
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`

	// The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.
	BinlogRetentionPeriod *int64 `json:"binlog-retention-period,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServiceMysqlJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// MySQL-specific settings
	MysqlSettings *map[string]interface{} `json:"mysql-settings,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// UpdateDbaasServiceMysqlJSONBodyMaintenanceDow defines parameters for UpdateDbaasServiceMysql.
type UpdateDbaasServiceMysqlJSONBodyMaintenanceDow string

// CreateDbaasMysqlDatabaseJSONBody defines parameters for CreateDbaasMysqlDatabase.
type CreateDbaasMysqlDatabaseJSONBody struct {
	DatabaseName DbaasDatabaseName `json:"database-name"`
}

// CreateDbaasMysqlUserJSONBody defines parameters for CreateDbaasMysqlUser.
type CreateDbaasMysqlUserJSONBody struct {
	Authentication *EnumMysqlAuthenticationPlugin `json:"authentication,omitempty"`
	Username       DbaasUserUsername              `json:"username"`
}

// ResetDbaasMysqlUserPasswordJSONBody defines parameters for ResetDbaasMysqlUserPassword.
type ResetDbaasMysqlUserPasswordJSONBody struct {
	Authentication *EnumMysqlAuthenticationPlugin `json:"authentication,omitempty"`
	Password       *DbaasUserPassword             `json:"password,omitempty"`
}

// CreateDbaasServiceOpensearchJSONBody defines parameters for CreateDbaasServiceOpensearch.
type CreateDbaasServiceOpensearchJSONBody struct {
	ForkFromService *DbaasServiceName `json:"fork-from-service,omitempty"`

	// Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like 'logs.?' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note 'logs.?' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.
	IndexPatterns *[]struct {
		// Maximum number of indexes to keep
		MaxIndexCount *int64 `json:"max-index-count,omitempty"`

		// fnmatch pattern
		Pattern *string `json:"pattern,omitempty"`

		// Deletion sorting algorithm
		SortingAlgorithm *CreateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm `json:"sorting-algorithm,omitempty"`
	} `json:"index-patterns,omitempty"`

	// Template settings for all new indexes
	IndexTemplate *struct {
		// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
		MappingNestedObjectsLimit *int64 `json:"mapping-nested-objects-limit,omitempty"`

		// The number of replicas each primary shard has.
		NumberOfReplicas *int64 `json:"number-of-replicas,omitempty"`

		// The number of primary shards that an index should have.
		NumberOfShards *int64 `json:"number-of-shards,omitempty"`
	} `json:"index-template,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
	KeepIndexRefreshInterval *bool `json:"keep-index-refresh-interval,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServiceOpensearchJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Maximum number of indexes to keep before deleting the oldest one
	MaxIndexCount *int64 `json:"max-index-count,omitempty"`

	// OpenSearch Dashboards settings
	OpensearchDashboards *struct {
		// Enable or disable OpenSearch Dashboards (default: true)
		Enabled *bool `json:"enabled,omitempty"`

		// Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)
		MaxOldSpaceSize *int64 `json:"max-old-space-size,omitempty"`

		// Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)
		OpensearchRequestTimeout *int64 `json:"opensearch-request-timeout,omitempty"`
	} `json:"opensearch-dashboards,omitempty"`

	// OpenSearch-specific settings
	OpensearchSettings *map[string]interface{} `json:"opensearch-settings,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Name of a backup to recover from for services that support backup names
	RecoveryBackupName *string `json:"recovery-backup-name,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// OpenSearch major version
	Version *string `json:"version,omitempty"`
}

// CreateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm defines parameters for CreateDbaasServiceOpensearch.
type CreateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm string

// CreateDbaasServiceOpensearchJSONBodyMaintenanceDow defines parameters for CreateDbaasServiceOpensearch.
type CreateDbaasServiceOpensearchJSONBodyMaintenanceDow string

// UpdateDbaasServiceOpensearchJSONBody defines parameters for UpdateDbaasServiceOpensearch.
type UpdateDbaasServiceOpensearchJSONBody struct {
	// Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like 'logs.?' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note 'logs.?' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.
	IndexPatterns *[]struct {
		// Maximum number of indexes to keep
		MaxIndexCount *int64 `json:"max-index-count,omitempty"`

		// fnmatch pattern
		Pattern *string `json:"pattern,omitempty"`

		// Deletion sorting algorithm
		SortingAlgorithm *UpdateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm `json:"sorting-algorithm,omitempty"`
	} `json:"index-patterns,omitempty"`

	// Template settings for all new indexes
	IndexTemplate *struct {
		// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
		MappingNestedObjectsLimit *int64 `json:"mapping-nested-objects-limit,omitempty"`

		// The number of replicas each primary shard has.
		NumberOfReplicas *int64 `json:"number-of-replicas,omitempty"`

		// The number of primary shards that an index should have.
		NumberOfShards *int64 `json:"number-of-shards,omitempty"`
	} `json:"index-template,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
	KeepIndexRefreshInterval *bool `json:"keep-index-refresh-interval,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServiceOpensearchJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Maximum number of indexes to keep before deleting the oldest one
	MaxIndexCount *int64 `json:"max-index-count,omitempty"`

	// OpenSearch Dashboards settings
	OpensearchDashboards *struct {
		// Enable or disable OpenSearch Dashboards (default: true)
		Enabled *bool `json:"enabled,omitempty"`

		// Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)
		MaxOldSpaceSize *int64 `json:"max-old-space-size,omitempty"`

		// Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)
		OpensearchRequestTimeout *int64 `json:"opensearch-request-timeout,omitempty"`
	} `json:"opensearch-dashboards,omitempty"`

	// OpenSearch-specific settings
	OpensearchSettings *map[string]interface{} `json:"opensearch-settings,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// Version
	Version *string `json:"version,omitempty"`
}

// UpdateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm defines parameters for UpdateDbaasServiceOpensearch.
type UpdateDbaasServiceOpensearchJSONBodyIndexPatternsSortingAlgorithm string

// UpdateDbaasServiceOpensearchJSONBodyMaintenanceDow defines parameters for UpdateDbaasServiceOpensearch.
type UpdateDbaasServiceOpensearchJSONBodyMaintenanceDow string

// UpdateDbaasOpensearchAclConfigJSONBody defines parameters for UpdateDbaasOpensearchAclConfig.
type UpdateDbaasOpensearchAclConfigJSONBody DbaasOpensearchAclConfig

// CreateDbaasOpensearchUserJSONBody defines parameters for CreateDbaasOpensearchUser.
type CreateDbaasOpensearchUserJSONBody struct {
	Username DbaasUserUsername `json:"username"`
}

// ResetDbaasOpensearchUserPasswordJSONBody defines parameters for ResetDbaasOpensearchUserPassword.
type ResetDbaasOpensearchUserPasswordJSONBody struct {
	Password *DbaasUserPassword `json:"password,omitempty"`
}

// CreateDbaasServicePgJSONBody defines parameters for CreateDbaasServicePg.
type CreateDbaasServicePgJSONBody struct {
	// Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
	AdminPassword *string `json:"admin-password,omitempty"`

	// Custom username for admin user. This must be set only when a new service is being created.
	AdminUsername  *string `json:"admin-username,omitempty"`
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`
	ForkFromService *DbaasServiceName `json:"fork-from-service,omitempty"`

	// Service integrations to be enabled when creating the service.
	Integrations *[]struct {
		DestService *DbaasServiceName `json:"dest-service,omitempty"`

		// Integration settings
		Settings      *map[string]interface{} `json:"settings,omitempty"`
		SourceService *DbaasServiceName       `json:"source-service,omitempty"`

		// Integration type
		Type CreateDbaasServicePgJSONBodyIntegrationsType `json:"type"`
	} `json:"integrations,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServicePgJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// PostgreSQL-specific settings
	PgSettings *map[string]interface{} `json:"pg-settings,omitempty"`

	// PGBouncer connection pooling settings
	PgbouncerSettings *map[string]interface{} `json:"pgbouncer-settings,omitempty"`

	// PGLookout settings
	PglookoutSettings *map[string]interface{} `json:"pglookout-settings,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// ISO time of a backup to recover from for services that support arbitrary times
	RecoveryBackupTime *string `json:"recovery-backup-time,omitempty"`

	// Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
	SharedBuffersPercentage *int64                        `json:"shared-buffers-percentage,omitempty"`
	SynchronousReplication  *EnumPgSynchronousReplication `json:"synchronous-replication,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// TimescaleDB extension configuration values
	TimescaledbSettings *map[string]interface{} `json:"timescaledb-settings,omitempty"`
	Variant             *EnumPgVariant          `json:"variant,omitempty"`

	// PostgreSQL major version
	Version *string `json:"version,omitempty"`

	// Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
	WorkMem *int64 `json:"work-mem,omitempty"`
}

// CreateDbaasServicePgJSONBodyIntegrationsType defines parameters for CreateDbaasServicePg.
type CreateDbaasServicePgJSONBodyIntegrationsType string

// CreateDbaasServicePgJSONBodyMaintenanceDow defines parameters for CreateDbaasServicePg.
type CreateDbaasServicePgJSONBodyMaintenanceDow string

// UpdateDbaasServicePgJSONBody defines parameters for UpdateDbaasServicePg.
type UpdateDbaasServicePgJSONBody struct {
	BackupSchedule *struct {
		// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupHour *int64 `json:"backup-hour,omitempty"`

		// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
		BackupMinute *int64 `json:"backup-minute,omitempty"`
	} `json:"backup-schedule,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServicePgJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// PostgreSQL-specific settings
	PgSettings *map[string]interface{} `json:"pg-settings,omitempty"`

	// PGBouncer connection pooling settings
	PgbouncerSettings *map[string]interface{} `json:"pgbouncer-settings,omitempty"`

	// PGLookout settings
	PglookoutSettings *map[string]interface{} `json:"pglookout-settings,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
	SharedBuffersPercentage *int64                        `json:"shared-buffers-percentage,omitempty"`
	SynchronousReplication  *EnumPgSynchronousReplication `json:"synchronous-replication,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`

	// TimescaleDB extension configuration values
	TimescaledbSettings *map[string]interface{} `json:"timescaledb-settings,omitempty"`
	Variant             *EnumPgVariant          `json:"variant,omitempty"`

	// Version
	Version *string `json:"version,omitempty"`

	// Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
	WorkMem *int64 `json:"work-mem,omitempty"`
}

// UpdateDbaasServicePgJSONBodyMaintenanceDow defines parameters for UpdateDbaasServicePg.
type UpdateDbaasServicePgJSONBodyMaintenanceDow string

// CreateDbaasPgConnectionPoolJSONBody defines parameters for CreateDbaasPgConnectionPool.
type CreateDbaasPgConnectionPoolJSONBody struct {
	DatabaseName DbaasDatabaseName    `json:"database-name"`
	Mode         *EnumPgPoolMode      `json:"mode,omitempty"`
	Name         DbaasPgPoolName      `json:"name"`
	Size         *DbaasPgPoolSize     `json:"size,omitempty"`
	Username     *DbaasPgPoolUsername `json:"username,omitempty"`
}

// UpdateDbaasPgConnectionPoolJSONBody defines parameters for UpdateDbaasPgConnectionPool.
type UpdateDbaasPgConnectionPoolJSONBody struct {
	DatabaseName *DbaasDatabaseName   `json:"database-name,omitempty"`
	Mode         *EnumPgPoolMode      `json:"mode,omitempty"`
	Size         *DbaasPgPoolSize     `json:"size,omitempty"`
	Username     *DbaasPgPoolUsername `json:"username,omitempty"`
}

// CreateDbaasPgDatabaseJSONBody defines parameters for CreateDbaasPgDatabase.
type CreateDbaasPgDatabaseJSONBody struct {
	DatabaseName DbaasDatabaseName `json:"database-name"`

	// Default string sort order (LC_COLLATE) for PostgreSQL database
	LcCollate *string `json:"lc-collate,omitempty"`

	// Default character classification (LC_CTYPE) for PostgreSQL database
	LcCtype *string `json:"lc-ctype,omitempty"`
}

// CreateDbaasPostgresUserJSONBody defines parameters for CreateDbaasPostgresUser.
type CreateDbaasPostgresUserJSONBody struct {
	AllowReplication *bool             `json:"allow-replication,omitempty"`
	Username         DbaasUserUsername `json:"username"`
}

// UpdateDbaasPostgresAllowReplicationJSONBody defines parameters for UpdateDbaasPostgresAllowReplication.
type UpdateDbaasPostgresAllowReplicationJSONBody struct {
	AllowReplication *bool `json:"allow-replication,omitempty"`
}

// ResetDbaasPostgresUserPasswordJSONBody defines parameters for ResetDbaasPostgresUserPassword.
type ResetDbaasPostgresUserPasswordJSONBody struct {
	Password *DbaasUserPassword `json:"password,omitempty"`
}

// CreateDbaasPgUpgradeCheckJSONBody defines parameters for CreateDbaasPgUpgradeCheck.
type CreateDbaasPgUpgradeCheckJSONBody struct {
	// Target version for upgrade
	TargetVersion CreateDbaasPgUpgradeCheckJSONBodyTargetVersion `json:"target-version"`
}

// CreateDbaasPgUpgradeCheckJSONBodyTargetVersion defines parameters for CreateDbaasPgUpgradeCheck.
type CreateDbaasPgUpgradeCheckJSONBodyTargetVersion string

// CreateDbaasServiceRedisJSONBody defines parameters for CreateDbaasServiceRedis.
type CreateDbaasServiceRedisJSONBody struct {
	ForkFromService *DbaasServiceName `json:"fork-from-service,omitempty"`

	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow CreateDbaasServiceRedisJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// Subscription plan
	Plan string `json:"plan"`

	// Name of a backup to recover from for services that support backup names
	RecoveryBackupName *string `json:"recovery-backup-name,omitempty"`

	// Redis.conf settings
	RedisSettings *map[string]interface{} `json:"redis-settings,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// CreateDbaasServiceRedisJSONBodyMaintenanceDow defines parameters for CreateDbaasServiceRedis.
type CreateDbaasServiceRedisJSONBodyMaintenanceDow string

// UpdateDbaasServiceRedisJSONBody defines parameters for UpdateDbaasServiceRedis.
type UpdateDbaasServiceRedisJSONBody struct {
	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IpFilter *[]string `json:"ip-filter,omitempty"`

	// Automatic maintenance settings
	Maintenance *struct {
		// Day of week for installing updates
		Dow UpdateDbaasServiceRedisJSONBodyMaintenanceDow `json:"dow"`

		// Time for installing updates, UTC
		Time string `json:"time"`
	} `json:"maintenance,omitempty"`

	// Migrate data from existing server
	Migration *struct {
		// Database name for bootstrapping the initial connection
		Dbname *string `json:"dbname,omitempty"`

		// Hostname or IP address of the server where to migrate data from
		Host string `json:"host"`

		// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
		IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
		Method    *EnumMigrationMethod `json:"method,omitempty"`

		// Password for authentication with the server where to migrate data from
		Password *string `json:"password,omitempty"`

		// Port number of the server where to migrate data from
		Port int64 `json:"port"`

		// The server where to migrate data from is secured with SSL
		Ssl *bool `json:"ssl,omitempty"`

		// User name for authentication with the server where to migrate data from
		Username *string `json:"username,omitempty"`
	} `json:"migration,omitempty"`

	// Subscription plan
	Plan *string `json:"plan,omitempty"`

	// Redis.conf settings
	RedisSettings *map[string]interface{} `json:"redis-settings,omitempty"`

	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
}

// UpdateDbaasServiceRedisJSONBodyMaintenanceDow defines parameters for UpdateDbaasServiceRedis.
type UpdateDbaasServiceRedisJSONBodyMaintenanceDow string

// GetDbaasServiceLogsJSONBody defines parameters for GetDbaasServiceLogs.
type GetDbaasServiceLogsJSONBody struct {
	// How many log entries to receive at most, up to 500 (default: 100)
	Limit *int64 `json:"limit,omitempty"`

	// Opaque offset identifier
	Offset    *string        `json:"offset,omitempty"`
	SortOrder *EnumSortOrder `json:"sort-order,omitempty"`
}

// GetDbaasServiceMetricsJSONBody defines parameters for GetDbaasServiceMetrics.
type GetDbaasServiceMetricsJSONBody struct {
	// Metrics time period (default: hour)
	Period *GetDbaasServiceMetricsJSONBodyPeriod `json:"period,omitempty"`
}

// GetDbaasServiceMetricsJSONBodyPeriod defines parameters for GetDbaasServiceMetrics.
type GetDbaasServiceMetricsJSONBodyPeriod string

// CreateDbaasTaskMigrationCheckJSONBody defines parameters for CreateDbaasTaskMigrationCheck.
type CreateDbaasTaskMigrationCheckJSONBody struct {
	// Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)
	IgnoreDbs *string              `json:"ignore-dbs,omitempty"`
	Method    *EnumMigrationMethod `json:"method,omitempty"`

	// Service URI of the source MySQL or PostgreSQL database with admin credentials.
	SourceServiceUri string `json:"source-service-uri"`
}

// CreateDnsDomainJSONBody defines parameters for CreateDnsDomain.
type CreateDnsDomainJSONBody struct {
	// Domain name
	UnicodeName *string `json:"unicode-name,omitempty"`
}

// CreateDnsDomainRecordJSONBody defines parameters for CreateDnsDomainRecord.
type CreateDnsDomainRecordJSONBody struct {
	// DNS domain record content
	Content string `json:"content"`

	// DNS domain record name
	Name string `json:"name"`

	// DNS domain record priority
	Priority *int64 `json:"priority,omitempty"`

	// DNS domain record TTL
	Ttl *int64 `json:"ttl,omitempty"`

	// DNS domain record type
	Type CreateDnsDomainRecordJSONBodyType `json:"type"`
}

// CreateDnsDomainRecordJSONBodyType defines parameters for CreateDnsDomainRecord.
type CreateDnsDomainRecordJSONBodyType string

// UpdateDnsDomainRecordJSONBody defines parameters for UpdateDnsDomainRecord.
type UpdateDnsDomainRecordJSONBody struct {
	// DNS domain record content
	Content *string `json:"content,omitempty"`

	// DNS domain record name
	Name *string `json:"name,omitempty"`

	// DNS domain record priority
	Priority *int64 `json:"priority,omitempty"`

	// DNS domain record TTL
	Ttl *int64 `json:"ttl,omitempty"`
}

// CreateElasticIpJSONBody defines parameters for CreateElasticIp.
type CreateElasticIpJSONBody struct {
	// Elastic IP address family (default: :inet4)
	Addressfamily *CreateElasticIpJSONBodyAddressfamily `json:"addressfamily,omitempty"`

	// Elastic IP description
	Description *string `json:"description,omitempty"`

	// Elastic IP address healthcheck
	Healthcheck *ElasticIpHealthcheck `json:"healthcheck,omitempty"`
	Labels      *Labels               `json:"labels,omitempty"`
}

// CreateElasticIpJSONBodyAddressfamily defines parameters for CreateElasticIp.
type CreateElasticIpJSONBodyAddressfamily string

// UpdateElasticIpJSONBody defines parameters for UpdateElasticIp.
type UpdateElasticIpJSONBody struct {
	// Elastic IP description
	Description *string `json:"description,omitempty"`

	// Elastic IP address healthcheck
	Healthcheck *ElasticIpHealthcheck `json:"healthcheck,omitempty"`
	Labels      *Labels               `json:"labels,omitempty"`
}

// ResetElasticIpFieldParamsField defines parameters for ResetElasticIpField.
type ResetElasticIpFieldParamsField string

// AttachInstanceToElasticIpJSONBody defines parameters for AttachInstanceToElasticIp.
type AttachInstanceToElasticIpJSONBody struct {
	// Target Instance
	Instance InstanceTarget `json:"instance"`
}

// DetachInstanceFromElasticIpJSONBody defines parameters for DetachInstanceFromElasticIp.
type DetachInstanceFromElasticIpJSONBody struct {
	// Target Instance
	Instance InstanceTarget `json:"instance"`
}

// ListEventsParams defines parameters for ListEvents.
type ListEventsParams struct {
	From *time.Time `json:"from,omitempty"`
	To   *time.Time `json:"to,omitempty"`
}

// UpdateIamOrganizationPolicyJSONBody defines parameters for UpdateIamOrganizationPolicy.
type UpdateIamOrganizationPolicyJSONBody IamPolicy

// CreateIamRoleJSONBody defines parameters for CreateIamRole.
type CreateIamRoleJSONBody struct {
	// IAM Role description
	Description *string `json:"description,omitempty"`

	// Sets if the IAM Role Policy is editable or not (default: true). This setting cannot be changed after creation
	Editable *bool   `json:"editable,omitempty"`
	Labels   *Labels `json:"labels,omitempty"`

	// IAM Role name
	Name string `json:"name"`

	// IAM Role permissions
	Permissions *[]CreateIamRoleJSONBodyPermissions `json:"permissions,omitempty"`

	// Policy
	Policy *IamPolicy `json:"policy,omitempty"`
}

// CreateIamRoleJSONBodyPermissions defines parameters for CreateIamRole.
type CreateIamRoleJSONBodyPermissions string

// UpdateIamRoleJSONBody defines parameters for UpdateIamRole.
type UpdateIamRoleJSONBody struct {
	// IAM Role description
	Description *string `json:"description,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// IAM Role permissions
	Permissions *[]UpdateIamRoleJSONBodyPermissions `json:"permissions,omitempty"`
}

// UpdateIamRoleJSONBodyPermissions defines parameters for UpdateIamRole.
type UpdateIamRoleJSONBodyPermissions string

// UpdateIamRolePolicyJSONBody defines parameters for UpdateIamRolePolicy.
type UpdateIamRolePolicyJSONBody IamPolicy

// ListInstancesParams defines parameters for ListInstances.
type ListInstancesParams struct {
	ManagerId   *string                         `json:"manager-id,omitempty"`
	ManagerType *ListInstancesParamsManagerType `json:"manager-type,omitempty"`
	IpAddress   *string                         `json:"ip-address,omitempty"`
}

// ListInstancesParamsManagerType defines parameters for ListInstances.
type ListInstancesParamsManagerType string

// CreateInstanceJSONBody defines parameters for CreateInstance.
type CreateInstanceJSONBody struct {
	// Instance Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Start Instance on creation (default: true)
	AutoStart *bool `json:"auto-start,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Instance disk size in GB
	DiskSize int64 `json:"disk-size"`

	// Compute instance type
	InstanceType InstanceType `json:"instance-type"`

	// Enable IPv6. DEPRECATED: use `public-ip-assignments`.
	Ipv6Enabled *bool   `json:"ipv6-enabled,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Instance name
	Name               *string             `json:"name,omitempty"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// SSH key
	SshKey *SshKey `json:"ssh-key,omitempty"`

	// Instance SSH Keys
	SshKeys *[]SshKey `json:"ssh-keys,omitempty"`

	// Instance template
	Template Template `json:"template"`

	// Instance Cloud-init user-data
	UserData *string `json:"user-data,omitempty"`
}

// CreateInstancePoolJSONBody defines parameters for CreateInstancePool.
type CreateInstancePoolJSONBody struct {
	// Instance Pool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Instance Pool description
	Description *string `json:"description,omitempty"`

	// Instances disk size in GB
	DiskSize int64 `json:"disk-size"`

	// Instances Elastic IPs
	ElasticIps *[]ElasticIp `json:"elastic-ips,omitempty"`

	// Prefix to apply to Instances names (default: pool)
	InstancePrefix *string `json:"instance-prefix,omitempty"`

	// Compute instance type
	InstanceType InstanceType `json:"instance-type"`

	// Enable IPv6. DEPRECATED: use `public-ip-assignments`.
	Ipv6Enabled *bool   `json:"ipv6-enabled,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Minimum number of running Instances
	MinAvailable *int64 `json:"min-available,omitempty"`

	// Instance Pool name
	Name string `json:"name"`

	// Instance Pool Private Networks
	PrivateNetworks    *[]PrivateNetwork   `json:"private-networks,omitempty"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Pool Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// Number of Instances
	Size int64 `json:"size"`

	// SSH key
	SshKey *SshKey `json:"ssh-key,omitempty"`

	// Instances SSH Keys
	SshKeys *[]SshKey `json:"ssh-keys,omitempty"`

	// Instance template
	Template Template `json:"template"`

	// Instances Cloud-init user-data
	UserData *string `json:"user-data,omitempty"`
}

// UpdateInstancePoolJSONBody defines parameters for UpdateInstancePool.
type UpdateInstancePoolJSONBody struct {
	// Instance Pool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Instance Pool description
	Description *string `json:"description,omitempty"`

	// Instances disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Instances Elastic IPs
	ElasticIps *[]ElasticIp `json:"elastic-ips"`

	// Prefix to apply to Instances names (default: pool)
	InstancePrefix *string `json:"instance-prefix"`

	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`

	// Enable IPv6. DEPRECATED: use `public-ip-assignments`.
	Ipv6Enabled *bool   `json:"ipv6-enabled,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Minimum number of running Instances
	MinAvailable *int64 `json:"min-available"`

	// Instance Pool name
	Name *string `json:"name,omitempty"`

	// Instance Pool Private Networks
	PrivateNetworks    *[]PrivateNetwork   `json:"private-networks"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Pool Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups"`

	// SSH key
	SshKey *SshKey `json:"ssh-key,omitempty"`

	// Instances SSH keys
	SshKeys *[]SshKey `json:"ssh-keys"`

	// Instance template
	Template *Template `json:"template,omitempty"`

	// Instances Cloud-init user-data
	UserData *string `json:"user-data"`
}

// ResetInstancePoolFieldParamsField defines parameters for ResetInstancePoolField.
type ResetInstancePoolFieldParamsField string

// EvictInstancePoolMembersJSONBody defines parameters for EvictInstancePoolMembers.
type EvictInstancePoolMembersJSONBody struct {
	Instances *[]string `json:"instances,omitempty"`
}

// ScaleInstancePoolJSONBody defines parameters for ScaleInstancePool.
type ScaleInstancePoolJSONBody struct {
	// Number of managed Instances
	Size int64 `json:"size"`
}

// UpdateInstanceJSONBody defines parameters for UpdateInstance.
type UpdateInstanceJSONBody struct {
	Labels *Labels `json:"labels,omitempty"`

	// Instance name
	Name               *string             `json:"name,omitempty"`
	PublicIpAssignment *PublicIpAssignment `json:"public-ip-assignment,omitempty"`

	// Instance Cloud-init user-data
	UserData *string `json:"user-data,omitempty"`
}

// ResetInstanceFieldParamsField defines parameters for ResetInstanceField.
type ResetInstanceFieldParamsField string

// ResetInstanceJSONBody defines parameters for ResetInstance.
type ResetInstanceJSONBody struct {
	// Instance disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Instance template
	Template *Template `json:"template,omitempty"`
}

// ResizeInstanceDiskJSONBody defines parameters for ResizeInstanceDisk.
type ResizeInstanceDiskJSONBody struct {
	// Instance disk size in GB
	DiskSize int64 `json:"disk-size"`
}

// ScaleInstanceJSONBody defines parameters for ScaleInstance.
type ScaleInstanceJSONBody struct {
	// Compute instance type
	InstanceType InstanceType `json:"instance-type"`
}

// StartInstanceJSONBody defines parameters for StartInstance.
type StartInstanceJSONBody struct {
	// Boot in Rescue Mode, using named profile (supported: netboot, netboot-efi)
	RescueProfile *StartInstanceJSONBodyRescueProfile `json:"rescue-profile,omitempty"`
}

// StartInstanceJSONBodyRescueProfile defines parameters for StartInstance.
type StartInstanceJSONBodyRescueProfile string

// RevertInstanceToSnapshotJSONBody defines parameters for RevertInstanceToSnapshot.
type RevertInstanceToSnapshotJSONBody struct {
	// Snapshot ID
	Id string `json:"id"`
}

// CreateLoadBalancerJSONBody defines parameters for CreateLoadBalancer.
type CreateLoadBalancerJSONBody struct {
	// Load Balancer description
	Description *string `json:"description,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Load Balancer name
	Name string `json:"name"`
}

// UpdateLoadBalancerJSONBody defines parameters for UpdateLoadBalancer.
type UpdateLoadBalancerJSONBody struct {
	// Load Balancer description
	Description *string `json:"description,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Load Balancer name
	Name *string `json:"name,omitempty"`
}

// AddServiceToLoadBalancerJSONBody defines parameters for AddServiceToLoadBalancer.
type AddServiceToLoadBalancerJSONBody struct {
	// Load Balancer Service description
	Description *string `json:"description,omitempty"`

	// Load Balancer Service healthcheck
	Healthcheck LoadBalancerServiceHealthcheck `json:"healthcheck"`

	// Instance Pool
	InstancePool InstancePool `json:"instance-pool"`

	// Load Balancer Service name
	Name string `json:"name"`

	// Port exposed on the Load Balancer's public IP
	Port int64 `json:"port"`

	// Network traffic protocol
	Protocol AddServiceToLoadBalancerJSONBodyProtocol `json:"protocol"`

	// Load balancing strategy
	Strategy AddServiceToLoadBalancerJSONBodyStrategy `json:"strategy"`

	// Port on which the network traffic will be forwarded to on the receiving instance
	TargetPort int64 `json:"target-port"`
}

// AddServiceToLoadBalancerJSONBodyProtocol defines parameters for AddServiceToLoadBalancer.
type AddServiceToLoadBalancerJSONBodyProtocol string

// AddServiceToLoadBalancerJSONBodyStrategy defines parameters for AddServiceToLoadBalancer.
type AddServiceToLoadBalancerJSONBodyStrategy string

// UpdateLoadBalancerServiceJSONBody defines parameters for UpdateLoadBalancerService.
type UpdateLoadBalancerServiceJSONBody struct {
	// Load Balancer Service description
	Description *string `json:"description,omitempty"`

	// Load Balancer Service healthcheck
	Healthcheck *LoadBalancerServiceHealthcheck `json:"healthcheck,omitempty"`

	// Load Balancer Service name
	Name *string `json:"name,omitempty"`

	// Port exposed on the Load Balancer's public IP
	Port *int64 `json:"port,omitempty"`

	// Network traffic protocol
	Protocol *UpdateLoadBalancerServiceJSONBodyProtocol `json:"protocol,omitempty"`

	// Load balancing strategy
	Strategy *UpdateLoadBalancerServiceJSONBodyStrategy `json:"strategy,omitempty"`

	// Port on which the network traffic will be forwarded to on the receiving instance
	TargetPort *int64 `json:"target-port,omitempty"`
}

// UpdateLoadBalancerServiceJSONBodyProtocol defines parameters for UpdateLoadBalancerService.
type UpdateLoadBalancerServiceJSONBodyProtocol string

// UpdateLoadBalancerServiceJSONBodyStrategy defines parameters for UpdateLoadBalancerService.
type UpdateLoadBalancerServiceJSONBodyStrategy string

// ResetLoadBalancerServiceFieldParamsField defines parameters for ResetLoadBalancerServiceField.
type ResetLoadBalancerServiceFieldParamsField string

// ResetLoadBalancerFieldParamsField defines parameters for ResetLoadBalancerField.
type ResetLoadBalancerFieldParamsField string

// CreatePrivateNetworkJSONBody defines parameters for CreatePrivateNetwork.
type CreatePrivateNetworkJSONBody struct {
	// Private Network description
	Description *string `json:"description,omitempty"`

	// Private Network end IP address
	EndIp  *string `json:"end-ip,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// Private Network name
	Name string `json:"name"`

	// Private Network netmask
	Netmask *string `json:"netmask,omitempty"`

	// Private Network start IP address
	StartIp *string `json:"start-ip,omitempty"`
}

// UpdatePrivateNetworkJSONBody defines parameters for UpdatePrivateNetwork.
type UpdatePrivateNetworkJSONBody struct {
	// Private Network description
	Description *string `json:"description,omitempty"`

	// Private Network end IP address
	EndIp  *string `json:"end-ip,omitempty"`
	Labels *Labels `json:"labels,omitempty"`

	// Private Network name
	Name *string `json:"name,omitempty"`

	// Private Network netmask
	Netmask *string `json:"netmask,omitempty"`

	// Private Network start IP address
	StartIp *string `json:"start-ip,omitempty"`
}

// ResetPrivateNetworkFieldParamsField defines parameters for ResetPrivateNetworkField.
type ResetPrivateNetworkFieldParamsField string

// AttachInstanceToPrivateNetworkJSONBody defines parameters for AttachInstanceToPrivateNetwork.
type AttachInstanceToPrivateNetworkJSONBody struct {
	// Compute instance
	Instance struct {
		// Instance ID
		Id *string `json:"id,omitempty"`
	} `json:"instance"`

	// Static IP address lease for the corresponding network interface
	Ip *string `json:"ip,omitempty"`
}

// DetachInstanceFromPrivateNetworkJSONBody defines parameters for DetachInstanceFromPrivateNetwork.
type DetachInstanceFromPrivateNetworkJSONBody struct {
	// Instance
	Instance Instance `json:"instance"`
}

// UpdatePrivateNetworkInstanceIpJSONBody defines parameters for UpdatePrivateNetworkInstanceIp.
type UpdatePrivateNetworkInstanceIpJSONBody struct {
	// Instance
	Instance Instance `json:"instance"`

	// Static IP address lease for the corresponding network interface
	Ip *string `json:"ip,omitempty"`
}

// UpdateReverseDnsElasticIpJSONBody defines parameters for UpdateReverseDnsElasticIp.
type UpdateReverseDnsElasticIpJSONBody struct {
	DomainName *string `json:"domain-name,omitempty"`
}

// UpdateReverseDnsInstanceJSONBody defines parameters for UpdateReverseDnsInstance.
type UpdateReverseDnsInstanceJSONBody struct {
	DomainName *string `json:"domain-name,omitempty"`
}

// ListSecurityGroupsParams defines parameters for ListSecurityGroups.
type ListSecurityGroupsParams struct {
	Visibility *ListSecurityGroupsParamsVisibility `json:"visibility,omitempty"`
}

// ListSecurityGroupsParamsVisibility defines parameters for ListSecurityGroups.
type ListSecurityGroupsParamsVisibility string

// CreateSecurityGroupJSONBody defines parameters for CreateSecurityGroup.
type CreateSecurityGroupJSONBody struct {
	// Security Group description
	Description *string `json:"description,omitempty"`

	// Security Group name
	Name string `json:"name"`
}

// AddRuleToSecurityGroupJSONBody defines parameters for AddRuleToSecurityGroup.
type AddRuleToSecurityGroupJSONBody struct {
	// Security Group rule description
	Description *string `json:"description,omitempty"`

	// End port of the range
	EndPort *int64 `json:"end-port,omitempty"`

	// Network flow direction to match
	FlowDirection AddRuleToSecurityGroupJSONBodyFlowDirection `json:"flow-direction"`

	// ICMP details (default: -1 (ANY))
	Icmp *struct {
		Code *int64 `json:"code,omitempty"`
		Type *int64 `json:"type,omitempty"`
	} `json:"icmp,omitempty"`

	// CIDR-formatted network allowed
	Network *string `json:"network,omitempty"`

	// Network protocol
	Protocol AddRuleToSecurityGroupJSONBodyProtocol `json:"protocol"`

	// Security Group
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`

	// Start port of the range
	StartPort *int64 `json:"start-port,omitempty"`
}

// AddRuleToSecurityGroupJSONBodyFlowDirection defines parameters for AddRuleToSecurityGroup.
type AddRuleToSecurityGroupJSONBodyFlowDirection string

// AddRuleToSecurityGroupJSONBodyProtocol defines parameters for AddRuleToSecurityGroup.
type AddRuleToSecurityGroupJSONBodyProtocol string

// AddExternalSourceToSecurityGroupJSONBody defines parameters for AddExternalSourceToSecurityGroup.
type AddExternalSourceToSecurityGroupJSONBody struct {
	// CIDR-formatted network to add
	Cidr string `json:"cidr"`
}

// AttachInstanceToSecurityGroupJSONBody defines parameters for AttachInstanceToSecurityGroup.
type AttachInstanceToSecurityGroupJSONBody struct {
	// Instance
	Instance Instance `json:"instance"`
}

// DetachInstanceFromSecurityGroupJSONBody defines parameters for DetachInstanceFromSecurityGroup.
type DetachInstanceFromSecurityGroupJSONBody struct {
	// Instance
	Instance Instance `json:"instance"`
}

// RemoveExternalSourceFromSecurityGroupJSONBody defines parameters for RemoveExternalSourceFromSecurityGroup.
type RemoveExternalSourceFromSecurityGroupJSONBody struct {
	// CIDR-formatted network to remove
	Cidr string `json:"cidr"`
}

// CreateSksClusterJSONBody defines parameters for CreateSksCluster.
type CreateSksClusterJSONBody struct {
	// Cluster addons
	Addons *[]CreateSksClusterJSONBodyAddons `json:"addons,omitempty"`

	// Enable auto upgrade of the control plane to the latest patch version available
	AutoUpgrade *bool `json:"auto-upgrade,omitempty"`

	// Cluster CNI
	Cni *CreateSksClusterJSONBodyCni `json:"cni,omitempty"`

	// Cluster description
	Description *string `json:"description,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Cluster service level
	Level CreateSksClusterJSONBodyLevel `json:"level"`

	// Cluster name
	Name string `json:"name"`

	// SKS Cluster OpenID config map
	Oidc *SksOidc `json:"oidc,omitempty"`

	// Control plane Kubernetes version
	Version string `json:"version"`
}

// CreateSksClusterJSONBodyAddons defines parameters for CreateSksCluster.
type CreateSksClusterJSONBodyAddons string

// CreateSksClusterJSONBodyCni defines parameters for CreateSksCluster.
type CreateSksClusterJSONBodyCni string

// CreateSksClusterJSONBodyLevel defines parameters for CreateSksCluster.
type CreateSksClusterJSONBodyLevel string

// GenerateSksClusterKubeconfigJSONBody defines parameters for GenerateSksClusterKubeconfig.
type GenerateSksClusterKubeconfigJSONBody SksKubeconfigRequest

// ListSksClusterVersionsParams defines parameters for ListSksClusterVersions.
type ListSksClusterVersionsParams struct {
	IncludeDeprecated *string `json:"include-deprecated,omitempty"`
}

// UpdateSksClusterJSONBody defines parameters for UpdateSksCluster.
type UpdateSksClusterJSONBody struct {
	// Cluster addons
	Addons *[]UpdateSksClusterJSONBodyAddons `json:"addons,omitempty"`

	// Enable auto upgrade of the control plane to the latest patch version available
	AutoUpgrade *bool `json:"auto-upgrade,omitempty"`

	// Cluster description
	Description *string `json:"description,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`

	// Cluster name
	Name *string `json:"name,omitempty"`

	// SKS Cluster OpenID config map
	Oidc *SksOidc `json:"oidc,omitempty"`
}

// UpdateSksClusterJSONBodyAddons defines parameters for UpdateSksCluster.
type UpdateSksClusterJSONBodyAddons string

// GetSksClusterAuthorityCertParamsAuthority defines parameters for GetSksClusterAuthorityCert.
type GetSksClusterAuthorityCertParamsAuthority string

// CreateSksNodepoolJSONBody defines parameters for CreateSksNodepool.
type CreateSksNodepoolJSONBody struct {
	// Nodepool addons
	Addons *[]CreateSksNodepoolJSONBodyAddons `json:"addons,omitempty"`

	// Nodepool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Nodepool description
	Description *string `json:"description,omitempty"`

	// Nodepool instances disk size in GB
	DiskSize int64 `json:"disk-size"`

	// Prefix to apply to instances names (default: pool)
	InstancePrefix *string `json:"instance-prefix,omitempty"`

	// Compute instance type
	InstanceType InstanceType `json:"instance-type"`

	// Kubelet image GC options
	KubeletImageGc *KubeletImageGc `json:"kubelet-image-gc,omitempty"`
	Labels         *Labels         `json:"labels,omitempty"`

	// Nodepool name
	Name string `json:"name"`

	// Nodepool Private Networks
	PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`

	// Nodepool Security Groups
	SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`

	// Number of instances
	Size   int64              `json:"size"`
	Taints *SksNodepoolTaints `json:"taints,omitempty"`
}

// CreateSksNodepoolJSONBodyAddons defines parameters for CreateSksNodepool.
type CreateSksNodepoolJSONBodyAddons string

// UpdateSksNodepoolJSONBody defines parameters for UpdateSksNodepool.
type UpdateSksNodepoolJSONBody struct {
	// Nodepool Anti-affinity Groups
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`

	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`

	// Nodepool description
	Description *string `json:"description,omitempty"`

	// Nodepool instances disk size in GB
	DiskSize *int64 `json:"disk-size,omitempty"`

	// Prefix to apply to managed instances names (default: pool)
	InstancePrefix *string `json:"instance-prefix,omitempty"`

	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	Labels       *Labels       `json:"labels,omitempty"`

	// Nodepool name
	Name *string `json:"name,omitempty"`

	// Nodepool Private Networks
	PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`

	// Nodepool Security Groups
	SecurityGroups *[]SecurityGroup   `json:"security-groups,omitempty"`
	Taints         *SksNodepoolTaints `json:"taints,omitempty"`
}

// ResetSksNodepoolFieldParamsField defines parameters for ResetSksNodepoolField.
type ResetSksNodepoolFieldParamsField string

// EvictSksNodepoolMembersJSONBody defines parameters for EvictSksNodepoolMembers.
type EvictSksNodepoolMembersJSONBody struct {
	Instances *[]string `json:"instances,omitempty"`
}

// ScaleSksNodepoolJSONBody defines parameters for ScaleSksNodepool.
type ScaleSksNodepoolJSONBody struct {
	// Number of instances
	Size int64 `json:"size"`
}

// UpgradeSksClusterJSONBody defines parameters for UpgradeSksCluster.
type UpgradeSksClusterJSONBody struct {
	// Control plane Kubernetes version
	Version string `json:"version"`
}

// ResetSksClusterFieldParamsField defines parameters for ResetSksClusterField.
type ResetSksClusterFieldParamsField string

// PromoteSnapshotToTemplateJSONBody defines parameters for PromoteSnapshotToTemplate.
type PromoteSnapshotToTemplateJSONBody struct {
	// Template default user
	DefaultUser *string `json:"default-user,omitempty"`

	// Template description
	Description *string `json:"description,omitempty"`

	// Template name
	Name string `json:"name"`

	// Enable password-based login in the template
	PasswordEnabled *bool `json:"password-enabled,omitempty"`

	// Enable SSH key-based login in the template
	SshKeyEnabled *bool `json:"ssh-key-enabled,omitempty"`
}

// GetSosPresignedUrlParams defines parameters for GetSosPresignedUrl.
type GetSosPresignedUrlParams struct {
	Key *string `json:"key,omitempty"`
}

// RegisterSshKeyJSONBody defines parameters for RegisterSshKey.
type RegisterSshKeyJSONBody struct {
	// Private Network name
	Name string `json:"name"`

	// Public key value
	PublicKey string `json:"public-key"`
}

// ListTemplatesParams defines parameters for ListTemplates.
type ListTemplatesParams struct {
	Visibility *ListTemplatesParamsVisibility `json:"visibility,omitempty"`
	Family     *string                        `json:"family,omitempty"`
}

// ListTemplatesParamsVisibility defines parameters for ListTemplates.
type ListTemplatesParamsVisibility string

// RegisterTemplateJSONBody defines parameters for RegisterTemplate.
type RegisterTemplateJSONBody struct {
	// Boot mode (default: legacy)
	BootMode *RegisterTemplateJSONBodyBootMode `json:"boot-mode,omitempty"`

	// Template build
	Build *string `json:"build,omitempty"`

	// Template MD5 checksum
	Checksum string `json:"checksum"`

	// Template default user
	DefaultUser *string `json:"default-user,omitempty"`

	// Template description
	Description *string `json:"description,omitempty"`

	// Template maintainer
	Maintainer *string `json:"maintainer,omitempty"`

	// Template name
	Name string `json:"name"`

	// Enable password-based login
	PasswordEnabled bool `json:"password-enabled"`

	// Template size
	Size *int64 `json:"size,omitempty"`

	// Enable SSH key-based login
	SshKeyEnabled bool `json:"ssh-key-enabled"`

	// Template source URL
	Url string `json:"url"`

	// Template version
	Version *string `json:"version,omitempty"`
}

// RegisterTemplateJSONBodyBootMode defines parameters for RegisterTemplate.
type RegisterTemplateJSONBodyBootMode string

// CopyTemplateJSONBody defines parameters for CopyTemplate.
type CopyTemplateJSONBody struct {
	// Zone
	TargetZone Zone `json:"target-zone"`
}

// UpdateTemplateJSONBody defines parameters for UpdateTemplate.
type UpdateTemplateJSONBody struct {
	// Template Description
	Description *string `json:"description,omitempty"`

	// Template name
	Name *string `json:"name,omitempty"`
}

// CreateAccessKeyJSONRequestBody defines body for CreateAccessKey for application/json ContentType.
type CreateAccessKeyJSONRequestBody CreateAccessKeyJSONBody

// CreateAntiAffinityGroupJSONRequestBody defines body for CreateAntiAffinityGroup for application/json ContentType.
type CreateAntiAffinityGroupJSONRequestBody CreateAntiAffinityGroupJSONBody

// CreateApiKeyJSONRequestBody defines body for CreateApiKey for application/json ContentType.
type CreateApiKeyJSONRequestBody CreateApiKeyJSONBody

// CreateDbaasServiceGrafanaJSONRequestBody defines body for CreateDbaasServiceGrafana for application/json ContentType.
type CreateDbaasServiceGrafanaJSONRequestBody CreateDbaasServiceGrafanaJSONBody

// UpdateDbaasServiceGrafanaJSONRequestBody defines body for UpdateDbaasServiceGrafana for application/json ContentType.
type UpdateDbaasServiceGrafanaJSONRequestBody UpdateDbaasServiceGrafanaJSONBody

// CreateDbaasIntegrationJSONRequestBody defines body for CreateDbaasIntegration for application/json ContentType.
type CreateDbaasIntegrationJSONRequestBody CreateDbaasIntegrationJSONBody

// UpdateDbaasIntegrationJSONRequestBody defines body for UpdateDbaasIntegration for application/json ContentType.
type UpdateDbaasIntegrationJSONRequestBody UpdateDbaasIntegrationJSONBody

// CreateDbaasServiceKafkaJSONRequestBody defines body for CreateDbaasServiceKafka for application/json ContentType.
type CreateDbaasServiceKafkaJSONRequestBody CreateDbaasServiceKafkaJSONBody

// UpdateDbaasServiceKafkaJSONRequestBody defines body for UpdateDbaasServiceKafka for application/json ContentType.
type UpdateDbaasServiceKafkaJSONRequestBody UpdateDbaasServiceKafkaJSONBody

// CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody defines body for CreateDbaasKafkaSchemaRegistryAclConfig for application/json ContentType.
type CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody CreateDbaasKafkaSchemaRegistryAclConfigJSONBody

// CreateDbaasKafkaTopicAclConfigJSONRequestBody defines body for CreateDbaasKafkaTopicAclConfig for application/json ContentType.
type CreateDbaasKafkaTopicAclConfigJSONRequestBody CreateDbaasKafkaTopicAclConfigJSONBody

// CreateDbaasKafkaUserJSONRequestBody defines body for CreateDbaasKafkaUser for application/json ContentType.
type CreateDbaasKafkaUserJSONRequestBody CreateDbaasKafkaUserJSONBody

// ResetDbaasKafkaUserPasswordJSONRequestBody defines body for ResetDbaasKafkaUserPassword for application/json ContentType.
type ResetDbaasKafkaUserPasswordJSONRequestBody ResetDbaasKafkaUserPasswordJSONBody

// CreateDbaasServiceMysqlJSONRequestBody defines body for CreateDbaasServiceMysql for application/json ContentType.
type CreateDbaasServiceMysqlJSONRequestBody CreateDbaasServiceMysqlJSONBody

// UpdateDbaasServiceMysqlJSONRequestBody defines body for UpdateDbaasServiceMysql for application/json ContentType.
type UpdateDbaasServiceMysqlJSONRequestBody UpdateDbaasServiceMysqlJSONBody

// CreateDbaasMysqlDatabaseJSONRequestBody defines body for CreateDbaasMysqlDatabase for application/json ContentType.
type CreateDbaasMysqlDatabaseJSONRequestBody CreateDbaasMysqlDatabaseJSONBody

// CreateDbaasMysqlUserJSONRequestBody defines body for CreateDbaasMysqlUser for application/json ContentType.
type CreateDbaasMysqlUserJSONRequestBody CreateDbaasMysqlUserJSONBody

// ResetDbaasMysqlUserPasswordJSONRequestBody defines body for ResetDbaasMysqlUserPassword for application/json ContentType.
type ResetDbaasMysqlUserPasswordJSONRequestBody ResetDbaasMysqlUserPasswordJSONBody

// CreateDbaasServiceOpensearchJSONRequestBody defines body for CreateDbaasServiceOpensearch for application/json ContentType.
type CreateDbaasServiceOpensearchJSONRequestBody CreateDbaasServiceOpensearchJSONBody

// UpdateDbaasServiceOpensearchJSONRequestBody defines body for UpdateDbaasServiceOpensearch for application/json ContentType.
type UpdateDbaasServiceOpensearchJSONRequestBody UpdateDbaasServiceOpensearchJSONBody

// UpdateDbaasOpensearchAclConfigJSONRequestBody defines body for UpdateDbaasOpensearchAclConfig for application/json ContentType.
type UpdateDbaasOpensearchAclConfigJSONRequestBody UpdateDbaasOpensearchAclConfigJSONBody

// CreateDbaasOpensearchUserJSONRequestBody defines body for CreateDbaasOpensearchUser for application/json ContentType.
type CreateDbaasOpensearchUserJSONRequestBody CreateDbaasOpensearchUserJSONBody

// ResetDbaasOpensearchUserPasswordJSONRequestBody defines body for ResetDbaasOpensearchUserPassword for application/json ContentType.
type ResetDbaasOpensearchUserPasswordJSONRequestBody ResetDbaasOpensearchUserPasswordJSONBody

// CreateDbaasServicePgJSONRequestBody defines body for CreateDbaasServicePg for application/json ContentType.
type CreateDbaasServicePgJSONRequestBody CreateDbaasServicePgJSONBody

// UpdateDbaasServicePgJSONRequestBody defines body for UpdateDbaasServicePg for application/json ContentType.
type UpdateDbaasServicePgJSONRequestBody UpdateDbaasServicePgJSONBody

// CreateDbaasPgConnectionPoolJSONRequestBody defines body for CreateDbaasPgConnectionPool for application/json ContentType.
type CreateDbaasPgConnectionPoolJSONRequestBody CreateDbaasPgConnectionPoolJSONBody

// UpdateDbaasPgConnectionPoolJSONRequestBody defines body for UpdateDbaasPgConnectionPool for application/json ContentType.
type UpdateDbaasPgConnectionPoolJSONRequestBody UpdateDbaasPgConnectionPoolJSONBody

// CreateDbaasPgDatabaseJSONRequestBody defines body for CreateDbaasPgDatabase for application/json ContentType.
type CreateDbaasPgDatabaseJSONRequestBody CreateDbaasPgDatabaseJSONBody

// CreateDbaasPostgresUserJSONRequestBody defines body for CreateDbaasPostgresUser for application/json ContentType.
type CreateDbaasPostgresUserJSONRequestBody CreateDbaasPostgresUserJSONBody

// UpdateDbaasPostgresAllowReplicationJSONRequestBody defines body for UpdateDbaasPostgresAllowReplication for application/json ContentType.
type UpdateDbaasPostgresAllowReplicationJSONRequestBody UpdateDbaasPostgresAllowReplicationJSONBody

// ResetDbaasPostgresUserPasswordJSONRequestBody defines body for ResetDbaasPostgresUserPassword for application/json ContentType.
type ResetDbaasPostgresUserPasswordJSONRequestBody ResetDbaasPostgresUserPasswordJSONBody

// CreateDbaasPgUpgradeCheckJSONRequestBody defines body for CreateDbaasPgUpgradeCheck for application/json ContentType.
type CreateDbaasPgUpgradeCheckJSONRequestBody CreateDbaasPgUpgradeCheckJSONBody

// CreateDbaasServiceRedisJSONRequestBody defines body for CreateDbaasServiceRedis for application/json ContentType.
type CreateDbaasServiceRedisJSONRequestBody CreateDbaasServiceRedisJSONBody

// UpdateDbaasServiceRedisJSONRequestBody defines body for UpdateDbaasServiceRedis for application/json ContentType.
type UpdateDbaasServiceRedisJSONRequestBody UpdateDbaasServiceRedisJSONBody

// GetDbaasServiceLogsJSONRequestBody defines body for GetDbaasServiceLogs for application/json ContentType.
type GetDbaasServiceLogsJSONRequestBody GetDbaasServiceLogsJSONBody

// GetDbaasServiceMetricsJSONRequestBody defines body for GetDbaasServiceMetrics for application/json ContentType.
type GetDbaasServiceMetricsJSONRequestBody GetDbaasServiceMetricsJSONBody

// CreateDbaasTaskMigrationCheckJSONRequestBody defines body for CreateDbaasTaskMigrationCheck for application/json ContentType.
type CreateDbaasTaskMigrationCheckJSONRequestBody CreateDbaasTaskMigrationCheckJSONBody

// CreateDnsDomainJSONRequestBody defines body for CreateDnsDomain for application/json ContentType.
type CreateDnsDomainJSONRequestBody CreateDnsDomainJSONBody

// CreateDnsDomainRecordJSONRequestBody defines body for CreateDnsDomainRecord for application/json ContentType.
type CreateDnsDomainRecordJSONRequestBody CreateDnsDomainRecordJSONBody

// UpdateDnsDomainRecordJSONRequestBody defines body for UpdateDnsDomainRecord for application/json ContentType.
type UpdateDnsDomainRecordJSONRequestBody UpdateDnsDomainRecordJSONBody

// CreateElasticIpJSONRequestBody defines body for CreateElasticIp for application/json ContentType.
type CreateElasticIpJSONRequestBody CreateElasticIpJSONBody

// UpdateElasticIpJSONRequestBody defines body for UpdateElasticIp for application/json ContentType.
type UpdateElasticIpJSONRequestBody UpdateElasticIpJSONBody

// AttachInstanceToElasticIpJSONRequestBody defines body for AttachInstanceToElasticIp for application/json ContentType.
type AttachInstanceToElasticIpJSONRequestBody AttachInstanceToElasticIpJSONBody

// DetachInstanceFromElasticIpJSONRequestBody defines body for DetachInstanceFromElasticIp for application/json ContentType.
type DetachInstanceFromElasticIpJSONRequestBody DetachInstanceFromElasticIpJSONBody

// UpdateIamOrganizationPolicyJSONRequestBody defines body for UpdateIamOrganizationPolicy for application/json ContentType.
type UpdateIamOrganizationPolicyJSONRequestBody UpdateIamOrganizationPolicyJSONBody

// CreateIamRoleJSONRequestBody defines body for CreateIamRole for application/json ContentType.
type CreateIamRoleJSONRequestBody CreateIamRoleJSONBody

// UpdateIamRoleJSONRequestBody defines body for UpdateIamRole for application/json ContentType.
type UpdateIamRoleJSONRequestBody UpdateIamRoleJSONBody

// UpdateIamRolePolicyJSONRequestBody defines body for UpdateIamRolePolicy for application/json ContentType.
type UpdateIamRolePolicyJSONRequestBody UpdateIamRolePolicyJSONBody

// CreateInstanceJSONRequestBody defines body for CreateInstance for application/json ContentType.
type CreateInstanceJSONRequestBody CreateInstanceJSONBody

// CreateInstancePoolJSONRequestBody defines body for CreateInstancePool for application/json ContentType.
type CreateInstancePoolJSONRequestBody CreateInstancePoolJSONBody

// UpdateInstancePoolJSONRequestBody defines body for UpdateInstancePool for application/json ContentType.
type UpdateInstancePoolJSONRequestBody UpdateInstancePoolJSONBody

// EvictInstancePoolMembersJSONRequestBody defines body for EvictInstancePoolMembers for application/json ContentType.
type EvictInstancePoolMembersJSONRequestBody EvictInstancePoolMembersJSONBody

// ScaleInstancePoolJSONRequestBody defines body for ScaleInstancePool for application/json ContentType.
type ScaleInstancePoolJSONRequestBody ScaleInstancePoolJSONBody

// UpdateInstanceJSONRequestBody defines body for UpdateInstance for application/json ContentType.
type UpdateInstanceJSONRequestBody UpdateInstanceJSONBody

// ResetInstanceJSONRequestBody defines body for ResetInstance for application/json ContentType.
type ResetInstanceJSONRequestBody ResetInstanceJSONBody

// ResizeInstanceDiskJSONRequestBody defines body for ResizeInstanceDisk for application/json ContentType.
type ResizeInstanceDiskJSONRequestBody ResizeInstanceDiskJSONBody

// ScaleInstanceJSONRequestBody defines body for ScaleInstance for application/json ContentType.
type ScaleInstanceJSONRequestBody ScaleInstanceJSONBody

// StartInstanceJSONRequestBody defines body for StartInstance for application/json ContentType.
type StartInstanceJSONRequestBody StartInstanceJSONBody

// RevertInstanceToSnapshotJSONRequestBody defines body for RevertInstanceToSnapshot for application/json ContentType.
type RevertInstanceToSnapshotJSONRequestBody RevertInstanceToSnapshotJSONBody

// CreateLoadBalancerJSONRequestBody defines body for CreateLoadBalancer for application/json ContentType.
type CreateLoadBalancerJSONRequestBody CreateLoadBalancerJSONBody

// UpdateLoadBalancerJSONRequestBody defines body for UpdateLoadBalancer for application/json ContentType.
type UpdateLoadBalancerJSONRequestBody UpdateLoadBalancerJSONBody

// AddServiceToLoadBalancerJSONRequestBody defines body for AddServiceToLoadBalancer for application/json ContentType.
type AddServiceToLoadBalancerJSONRequestBody AddServiceToLoadBalancerJSONBody

// UpdateLoadBalancerServiceJSONRequestBody defines body for UpdateLoadBalancerService for application/json ContentType.
type UpdateLoadBalancerServiceJSONRequestBody UpdateLoadBalancerServiceJSONBody

// CreatePrivateNetworkJSONRequestBody defines body for CreatePrivateNetwork for application/json ContentType.
type CreatePrivateNetworkJSONRequestBody CreatePrivateNetworkJSONBody

// UpdatePrivateNetworkJSONRequestBody defines body for UpdatePrivateNetwork for application/json ContentType.
type UpdatePrivateNetworkJSONRequestBody UpdatePrivateNetworkJSONBody

// AttachInstanceToPrivateNetworkJSONRequestBody defines body for AttachInstanceToPrivateNetwork for application/json ContentType.
type AttachInstanceToPrivateNetworkJSONRequestBody AttachInstanceToPrivateNetworkJSONBody

// DetachInstanceFromPrivateNetworkJSONRequestBody defines body for DetachInstanceFromPrivateNetwork for application/json ContentType.
type DetachInstanceFromPrivateNetworkJSONRequestBody DetachInstanceFromPrivateNetworkJSONBody

// UpdatePrivateNetworkInstanceIpJSONRequestBody defines body for UpdatePrivateNetworkInstanceIp for application/json ContentType.
type UpdatePrivateNetworkInstanceIpJSONRequestBody UpdatePrivateNetworkInstanceIpJSONBody

// UpdateReverseDnsElasticIpJSONRequestBody defines body for UpdateReverseDnsElasticIp for application/json ContentType.
type UpdateReverseDnsElasticIpJSONRequestBody UpdateReverseDnsElasticIpJSONBody

// UpdateReverseDnsInstanceJSONRequestBody defines body for UpdateReverseDnsInstance for application/json ContentType.
type UpdateReverseDnsInstanceJSONRequestBody UpdateReverseDnsInstanceJSONBody

// CreateSecurityGroupJSONRequestBody defines body for CreateSecurityGroup for application/json ContentType.
type CreateSecurityGroupJSONRequestBody CreateSecurityGroupJSONBody

// AddRuleToSecurityGroupJSONRequestBody defines body for AddRuleToSecurityGroup for application/json ContentType.
type AddRuleToSecurityGroupJSONRequestBody AddRuleToSecurityGroupJSONBody

// AddExternalSourceToSecurityGroupJSONRequestBody defines body for AddExternalSourceToSecurityGroup for application/json ContentType.
type AddExternalSourceToSecurityGroupJSONRequestBody AddExternalSourceToSecurityGroupJSONBody

// AttachInstanceToSecurityGroupJSONRequestBody defines body for AttachInstanceToSecurityGroup for application/json ContentType.
type AttachInstanceToSecurityGroupJSONRequestBody AttachInstanceToSecurityGroupJSONBody

// DetachInstanceFromSecurityGroupJSONRequestBody defines body for DetachInstanceFromSecurityGroup for application/json ContentType.
type DetachInstanceFromSecurityGroupJSONRequestBody DetachInstanceFromSecurityGroupJSONBody

// RemoveExternalSourceFromSecurityGroupJSONRequestBody defines body for RemoveExternalSourceFromSecurityGroup for application/json ContentType.
type RemoveExternalSourceFromSecurityGroupJSONRequestBody RemoveExternalSourceFromSecurityGroupJSONBody

// CreateSksClusterJSONRequestBody defines body for CreateSksCluster for application/json ContentType.
type CreateSksClusterJSONRequestBody CreateSksClusterJSONBody

// GenerateSksClusterKubeconfigJSONRequestBody defines body for GenerateSksClusterKubeconfig for application/json ContentType.
type GenerateSksClusterKubeconfigJSONRequestBody GenerateSksClusterKubeconfigJSONBody

// UpdateSksClusterJSONRequestBody defines body for UpdateSksCluster for application/json ContentType.
type UpdateSksClusterJSONRequestBody UpdateSksClusterJSONBody

// CreateSksNodepoolJSONRequestBody defines body for CreateSksNodepool for application/json ContentType.
type CreateSksNodepoolJSONRequestBody CreateSksNodepoolJSONBody

// UpdateSksNodepoolJSONRequestBody defines body for UpdateSksNodepool for application/json ContentType.
type UpdateSksNodepoolJSONRequestBody UpdateSksNodepoolJSONBody

// EvictSksNodepoolMembersJSONRequestBody defines body for EvictSksNodepoolMembers for application/json ContentType.
type EvictSksNodepoolMembersJSONRequestBody EvictSksNodepoolMembersJSONBody

// ScaleSksNodepoolJSONRequestBody defines body for ScaleSksNodepool for application/json ContentType.
type ScaleSksNodepoolJSONRequestBody ScaleSksNodepoolJSONBody

// UpgradeSksClusterJSONRequestBody defines body for UpgradeSksCluster for application/json ContentType.
type UpgradeSksClusterJSONRequestBody UpgradeSksClusterJSONBody

// PromoteSnapshotToTemplateJSONRequestBody defines body for PromoteSnapshotToTemplate for application/json ContentType.
type PromoteSnapshotToTemplateJSONRequestBody PromoteSnapshotToTemplateJSONBody

// RegisterSshKeyJSONRequestBody defines body for RegisterSshKey for application/json ContentType.
type RegisterSshKeyJSONRequestBody RegisterSshKeyJSONBody

// RegisterTemplateJSONRequestBody defines body for RegisterTemplate for application/json ContentType.
type RegisterTemplateJSONRequestBody RegisterTemplateJSONBody

// CopyTemplateJSONRequestBody defines body for CopyTemplate for application/json ContentType.
type CopyTemplateJSONRequestBody CopyTemplateJSONBody

// UpdateTemplateJSONRequestBody defines body for UpdateTemplate for application/json ContentType.
type UpdateTemplateJSONRequestBody UpdateTemplateJSONBody

// Getter for additional properties for IamPolicy_Services. Returns the specified
// element and whether it was found
func (a IamPolicy_Services) Get(fieldName string) (value IamServicePolicy, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for IamPolicy_Services
func (a *IamPolicy_Services) Set(fieldName string, value IamServicePolicy) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]IamServicePolicy)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for IamPolicy_Services to handle AdditionalProperties
func (a *IamPolicy_Services) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]IamServicePolicy)
		for fieldName, fieldBuf := range object {
			var fieldVal IamServicePolicy
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for IamPolicy_Services to handle AdditionalProperties
func (a IamPolicy_Services) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for Labels. Returns the specified
// element and whether it was found
func (a Labels) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Labels
func (a *Labels) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Labels to handle AdditionalProperties
func (a *Labels) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Labels to handle AdditionalProperties
func (a Labels) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for SksClusterDeprecatedResource. Returns the specified
// element and whether it was found
func (a SksClusterDeprecatedResource) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for SksClusterDeprecatedResource
func (a *SksClusterDeprecatedResource) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for SksClusterDeprecatedResource to handle AdditionalProperties
func (a *SksClusterDeprecatedResource) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for SksClusterDeprecatedResource to handle AdditionalProperties
func (a SksClusterDeprecatedResource) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for SksNodepoolTaints. Returns the specified
// element and whether it was found
func (a SksNodepoolTaints) Get(fieldName string) (value SksNodepoolTaint, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for SksNodepoolTaints
func (a *SksNodepoolTaints) Set(fieldName string, value SksNodepoolTaint) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]SksNodepoolTaint)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for SksNodepoolTaints to handle AdditionalProperties
func (a *SksNodepoolTaints) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]SksNodepoolTaint)
		for fieldName, fieldBuf := range object {
			var fieldVal SksNodepoolTaint
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for SksNodepoolTaints to handle AdditionalProperties
func (a SksNodepoolTaints) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for SksOidc_RequiredClaim. Returns the specified
// element and whether it was found
func (a SksOidc_RequiredClaim) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for SksOidc_RequiredClaim
func (a *SksOidc_RequiredClaim) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for SksOidc_RequiredClaim to handle AdditionalProperties
func (a *SksOidc_RequiredClaim) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for SksOidc_RequiredClaim to handle AdditionalProperties
func (a SksOidc_RequiredClaim) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A list of callbacks for modifying requests which are generated before sending over
	// the network.
	RequestEditors []RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditors = append(c.RequestEditors, fn)
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// ListAccessKeys request
	ListAccessKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateAccessKey request with any body
	CreateAccessKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateAccessKey(ctx context.Context, body CreateAccessKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListAccessKeyKnownOperations request
	ListAccessKeyKnownOperations(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListAccessKeyOperations request
	ListAccessKeyOperations(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RevokeAccessKey request
	RevokeAccessKey(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetAccessKey request
	GetAccessKey(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListAntiAffinityGroups request
	ListAntiAffinityGroups(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateAntiAffinityGroup request with any body
	CreateAntiAffinityGroupWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateAntiAffinityGroup(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteAntiAffinityGroup request
	DeleteAntiAffinityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetAntiAffinityGroup request
	GetAntiAffinityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListApiKeys request
	ListApiKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateApiKey request with any body
	CreateApiKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateApiKey(ctx context.Context, body CreateApiKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteApiKey request
	DeleteApiKey(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetApiKey request
	GetApiKey(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasCaCertificate request
	GetDbaasCaCertificate(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServiceGrafana request
	DeleteDbaasServiceGrafana(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceGrafana request
	GetDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServiceGrafana request with any body
	CreateDbaasServiceGrafanaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServiceGrafana request with any body
	UpdateDbaasServiceGrafanaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasGrafanaMaintenance request
	StartDbaasGrafanaMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasIntegration request with any body
	CreateDbaasIntegrationWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasIntegration(ctx context.Context, body CreateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDbaasIntegrationSettings request
	ListDbaasIntegrationSettings(ctx context.Context, integrationType string, sourceType string, destType string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDbaasIntegrationTypes request
	ListDbaasIntegrationTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasIntegration request
	DeleteDbaasIntegration(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasIntegration request
	GetDbaasIntegration(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasIntegration request with any body
	UpdateDbaasIntegrationWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasIntegration(ctx context.Context, id string, body UpdateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServiceKafka request
	DeleteDbaasServiceKafka(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceKafka request
	GetDbaasServiceKafka(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServiceKafka request with any body
	CreateDbaasServiceKafkaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServiceKafka(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServiceKafka request with any body
	UpdateDbaasServiceKafkaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServiceKafka(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasKafkaAclConfig request
	GetDbaasKafkaAclConfig(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasKafkaMaintenance request
	StartDbaasKafkaMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasKafkaSchemaRegistryAclConfig request with any body
	CreateDbaasKafkaSchemaRegistryAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasKafkaSchemaRegistryAclConfig(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasKafkaSchemaRegistryAclConfig request
	DeleteDbaasKafkaSchemaRegistryAclConfig(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasKafkaTopicAclConfig request with any body
	CreateDbaasKafkaTopicAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasKafkaTopicAclConfig(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaTopicAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasKafkaTopicAclConfig request
	DeleteDbaasKafkaTopicAclConfig(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasKafkaUser request with any body
	CreateDbaasKafkaUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasKafkaUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasKafkaUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasKafkaUser request
	DeleteDbaasKafkaUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetDbaasKafkaUserPassword request with any body
	ResetDbaasKafkaUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResetDbaasKafkaUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasKafkaUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasMigrationStatus request
	GetDbaasMigrationStatus(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServiceMysql request
	DeleteDbaasServiceMysql(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceMysql request
	GetDbaasServiceMysql(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServiceMysql request with any body
	CreateDbaasServiceMysqlWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServiceMysql(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServiceMysql request with any body
	UpdateDbaasServiceMysqlWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServiceMysql(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasMysqlMaintenance request
	StartDbaasMysqlMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StopDbaasMysqlMigration request
	StopDbaasMysqlMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasMysqlDatabase request with any body
	CreateDbaasMysqlDatabaseWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasMysqlDatabase(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasMysqlDatabase request
	DeleteDbaasMysqlDatabase(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasMysqlDatabaseName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasMysqlUser request with any body
	CreateDbaasMysqlUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasMysqlUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasMysqlUser request
	DeleteDbaasMysqlUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetDbaasMysqlUserPassword request with any body
	ResetDbaasMysqlUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResetDbaasMysqlUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasMysqlUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServiceOpensearch request
	DeleteDbaasServiceOpensearch(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceOpensearch request
	GetDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServiceOpensearch request with any body
	CreateDbaasServiceOpensearchWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServiceOpensearch request with any body
	UpdateDbaasServiceOpensearchWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasOpensearchAclConfig request
	GetDbaasOpensearchAclConfig(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasOpensearchAclConfig request with any body
	UpdateDbaasOpensearchAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasOpensearchAclConfig(ctx context.Context, name DbaasServiceName, body UpdateDbaasOpensearchAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasOpensearchMaintenance request
	StartDbaasOpensearchMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasOpensearchUser request with any body
	CreateDbaasOpensearchUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasOpensearchUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasOpensearchUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasOpensearchUser request
	DeleteDbaasOpensearchUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetDbaasOpensearchUserPassword request with any body
	ResetDbaasOpensearchUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResetDbaasOpensearchUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasOpensearchUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServicePg request
	DeleteDbaasServicePg(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServicePg request
	GetDbaasServicePg(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServicePg request with any body
	CreateDbaasServicePgWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServicePg(ctx context.Context, name DbaasServiceName, body CreateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServicePg request with any body
	UpdateDbaasServicePgWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServicePg(ctx context.Context, name DbaasServiceName, body UpdateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasPgMaintenance request
	StartDbaasPgMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StopDbaasPgMigration request
	StopDbaasPgMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasPgConnectionPool request with any body
	CreateDbaasPgConnectionPoolWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasPgConnectionPool request
	DeleteDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasPgConnectionPool request with any body
	UpdateDbaasPgConnectionPoolWithBody(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, body UpdateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasPgDatabase request with any body
	CreateDbaasPgDatabaseWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasPgDatabase(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasPgDatabase request
	DeleteDbaasPgDatabase(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasPgDatabaseName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasPostgresUser request with any body
	CreateDbaasPostgresUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasPostgresUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPostgresUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasPostgresUser request
	DeleteDbaasPostgresUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasPostgresAllowReplication request with any body
	UpdateDbaasPostgresAllowReplicationWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasPostgresAllowReplication(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body UpdateDbaasPostgresAllowReplicationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetDbaasPostgresUserPassword request with any body
	ResetDbaasPostgresUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResetDbaasPostgresUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasPostgresUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasPgUpgradeCheck request with any body
	CreateDbaasPgUpgradeCheckWithBody(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasPgUpgradeCheck(ctx context.Context, service DbaasServiceName, body CreateDbaasPgUpgradeCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasServiceRedis request
	DeleteDbaasServiceRedis(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceRedis request
	GetDbaasServiceRedis(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasServiceRedis request with any body
	CreateDbaasServiceRedisWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasServiceRedis(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDbaasServiceRedis request with any body
	UpdateDbaasServiceRedisWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDbaasServiceRedis(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartDbaasRedisMaintenance request
	StartDbaasRedisMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StopDbaasRedisMigration request
	StopDbaasRedisMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDbaasServices request
	ListDbaasServices(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceLogs request with any body
	GetDbaasServiceLogsWithBody(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	GetDbaasServiceLogs(ctx context.Context, serviceName string, body GetDbaasServiceLogsJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceMetrics request with any body
	GetDbaasServiceMetricsWithBody(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	GetDbaasServiceMetrics(ctx context.Context, serviceName string, body GetDbaasServiceMetricsJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDbaasServiceTypes request
	ListDbaasServiceTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasServiceType request
	GetDbaasServiceType(ctx context.Context, serviceTypeName string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDbaasService request
	DeleteDbaasService(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsGrafana request
	GetDbaasSettingsGrafana(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsKafka request
	GetDbaasSettingsKafka(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsMysql request
	GetDbaasSettingsMysql(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsOpensearch request
	GetDbaasSettingsOpensearch(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsPg request
	GetDbaasSettingsPg(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasSettingsRedis request
	GetDbaasSettingsRedis(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDbaasTaskMigrationCheck request with any body
	CreateDbaasTaskMigrationCheckWithBody(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDbaasTaskMigrationCheck(ctx context.Context, service DbaasServiceName, body CreateDbaasTaskMigrationCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDbaasTask request
	GetDbaasTask(ctx context.Context, service DbaasServiceName, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDeployTargets request
	ListDeployTargets(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDeployTarget request
	GetDeployTarget(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDnsDomains request
	ListDnsDomains(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDnsDomain request with any body
	CreateDnsDomainWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDnsDomain(ctx context.Context, body CreateDnsDomainJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListDnsDomainRecords request
	ListDnsDomainRecords(ctx context.Context, domainId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateDnsDomainRecord request with any body
	CreateDnsDomainRecordWithBody(ctx context.Context, domainId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateDnsDomainRecord(ctx context.Context, domainId string, body CreateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDnsDomainRecord request
	DeleteDnsDomainRecord(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDnsDomainRecord request
	GetDnsDomainRecord(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateDnsDomainRecord request with any body
	UpdateDnsDomainRecordWithBody(ctx context.Context, domainId string, recordId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateDnsDomainRecord(ctx context.Context, domainId string, recordId string, body UpdateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteDnsDomain request
	DeleteDnsDomain(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDnsDomain request
	GetDnsDomain(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetDnsDomainZoneFile request
	GetDnsDomainZoneFile(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListElasticIps request
	ListElasticIps(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateElasticIp request with any body
	CreateElasticIpWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateElasticIp(ctx context.Context, body CreateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteElasticIp request
	DeleteElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetElasticIp request
	GetElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateElasticIp request with any body
	UpdateElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateElasticIp(ctx context.Context, id string, body UpdateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetElasticIpField request
	ResetElasticIpField(ctx context.Context, id string, field ResetElasticIpFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AttachInstanceToElasticIp request with any body
	AttachInstanceToElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AttachInstanceToElasticIp(ctx context.Context, id string, body AttachInstanceToElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DetachInstanceFromElasticIp request with any body
	DetachInstanceFromElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	DetachInstanceFromElasticIp(ctx context.Context, id string, body DetachInstanceFromElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListEvents request
	ListEvents(ctx context.Context, params *ListEventsParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetIamOrganizationPolicy request
	GetIamOrganizationPolicy(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateIamOrganizationPolicy request with any body
	UpdateIamOrganizationPolicyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateIamOrganizationPolicy(ctx context.Context, body UpdateIamOrganizationPolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListIamRoles request
	ListIamRoles(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateIamRole request with any body
	CreateIamRoleWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateIamRole(ctx context.Context, body CreateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteIamRole request
	DeleteIamRole(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetIamRole request
	GetIamRole(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateIamRole request with any body
	UpdateIamRoleWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateIamRole(ctx context.Context, id string, body UpdateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateIamRolePolicy request with any body
	UpdateIamRolePolicyWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateIamRolePolicy(ctx context.Context, id string, body UpdateIamRolePolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListInstances request
	ListInstances(ctx context.Context, params *ListInstancesParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateInstance request with any body
	CreateInstanceWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateInstance(ctx context.Context, body CreateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListInstancePools request
	ListInstancePools(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateInstancePool request with any body
	CreateInstancePoolWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateInstancePool(ctx context.Context, body CreateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteInstancePool request
	DeleteInstancePool(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetInstancePool request
	GetInstancePool(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateInstancePool request with any body
	UpdateInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateInstancePool(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetInstancePoolField request
	ResetInstancePoolField(ctx context.Context, id string, field ResetInstancePoolFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// EvictInstancePoolMembers request with any body
	EvictInstancePoolMembersWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	EvictInstancePoolMembers(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ScaleInstancePool request with any body
	ScaleInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ScaleInstancePool(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListInstanceTypes request
	ListInstanceTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetInstanceType request
	GetInstanceType(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteInstance request
	DeleteInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetInstance request
	GetInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateInstance request with any body
	UpdateInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateInstance(ctx context.Context, id string, body UpdateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetInstanceField request
	ResetInstanceField(ctx context.Context, id string, field ResetInstanceFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AddInstanceProtection request
	AddInstanceProtection(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSnapshot request
	CreateSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RevealInstancePassword request
	RevealInstancePassword(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RebootInstance request
	RebootInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RemoveInstanceProtection request
	RemoveInstanceProtection(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetInstance request with any body
	ResetInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResetInstance(ctx context.Context, id string, body ResetInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetInstancePassword request
	ResetInstancePassword(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResizeInstanceDisk request with any body
	ResizeInstanceDiskWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ResizeInstanceDisk(ctx context.Context, id string, body ResizeInstanceDiskJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ScaleInstance request with any body
	ScaleInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ScaleInstance(ctx context.Context, id string, body ScaleInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StartInstance request with any body
	StartInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	StartInstance(ctx context.Context, id string, body StartInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// StopInstance request
	StopInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RevertInstanceToSnapshot request with any body
	RevertInstanceToSnapshotWithBody(ctx context.Context, instanceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	RevertInstanceToSnapshot(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListLoadBalancers request
	ListLoadBalancers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateLoadBalancer request with any body
	CreateLoadBalancerWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateLoadBalancer(ctx context.Context, body CreateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteLoadBalancer request
	DeleteLoadBalancer(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLoadBalancer request
	GetLoadBalancer(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateLoadBalancer request with any body
	UpdateLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateLoadBalancer(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AddServiceToLoadBalancer request with any body
	AddServiceToLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AddServiceToLoadBalancer(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteLoadBalancerService request
	DeleteLoadBalancerService(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetLoadBalancerService request
	GetLoadBalancerService(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateLoadBalancerService request with any body
	UpdateLoadBalancerServiceWithBody(ctx context.Context, id string, serviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateLoadBalancerService(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetLoadBalancerServiceField request
	ResetLoadBalancerServiceField(ctx context.Context, id string, serviceId string, field ResetLoadBalancerServiceFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetLoadBalancerField request
	ResetLoadBalancerField(ctx context.Context, id string, field ResetLoadBalancerFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetOperation request
	GetOperation(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListPrivateNetworks request
	ListPrivateNetworks(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreatePrivateNetwork request with any body
	CreatePrivateNetworkWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreatePrivateNetwork(ctx context.Context, body CreatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeletePrivateNetwork request
	DeletePrivateNetwork(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetPrivateNetwork request
	GetPrivateNetwork(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdatePrivateNetwork request with any body
	UpdatePrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdatePrivateNetwork(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetPrivateNetworkField request
	ResetPrivateNetworkField(ctx context.Context, id string, field ResetPrivateNetworkFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AttachInstanceToPrivateNetwork request with any body
	AttachInstanceToPrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AttachInstanceToPrivateNetwork(ctx context.Context, id string, body AttachInstanceToPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DetachInstanceFromPrivateNetwork request with any body
	DetachInstanceFromPrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	DetachInstanceFromPrivateNetwork(ctx context.Context, id string, body DetachInstanceFromPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdatePrivateNetworkInstanceIp request with any body
	UpdatePrivateNetworkInstanceIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdatePrivateNetworkInstanceIp(ctx context.Context, id string, body UpdatePrivateNetworkInstanceIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListQuotas request
	ListQuotas(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetQuota request
	GetQuota(ctx context.Context, entity string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteReverseDnsElasticIp request
	DeleteReverseDnsElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetReverseDnsElasticIp request
	GetReverseDnsElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateReverseDnsElasticIp request with any body
	UpdateReverseDnsElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateReverseDnsElasticIp(ctx context.Context, id string, body UpdateReverseDnsElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteReverseDnsInstance request
	DeleteReverseDnsInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetReverseDnsInstance request
	GetReverseDnsInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateReverseDnsInstance request with any body
	UpdateReverseDnsInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateReverseDnsInstance(ctx context.Context, id string, body UpdateReverseDnsInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSecurityGroups request
	ListSecurityGroups(ctx context.Context, params *ListSecurityGroupsParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSecurityGroup request with any body
	CreateSecurityGroupWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateSecurityGroup(ctx context.Context, body CreateSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSecurityGroup request
	DeleteSecurityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSecurityGroup request
	GetSecurityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AddRuleToSecurityGroup request with any body
	AddRuleToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AddRuleToSecurityGroup(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteRuleFromSecurityGroup request
	DeleteRuleFromSecurityGroup(ctx context.Context, id string, ruleId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AddExternalSourceToSecurityGroup request with any body
	AddExternalSourceToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AddExternalSourceToSecurityGroup(ctx context.Context, id string, body AddExternalSourceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// AttachInstanceToSecurityGroup request with any body
	AttachInstanceToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	AttachInstanceToSecurityGroup(ctx context.Context, id string, body AttachInstanceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DetachInstanceFromSecurityGroup request with any body
	DetachInstanceFromSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	DetachInstanceFromSecurityGroup(ctx context.Context, id string, body DetachInstanceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RemoveExternalSourceFromSecurityGroup request with any body
	RemoveExternalSourceFromSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	RemoveExternalSourceFromSecurityGroup(ctx context.Context, id string, body RemoveExternalSourceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSksClusters request
	ListSksClusters(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSksCluster request with any body
	CreateSksClusterWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateSksCluster(ctx context.Context, body CreateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSksClusterDeprecatedResources request
	ListSksClusterDeprecatedResources(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GenerateSksClusterKubeconfig request with any body
	GenerateSksClusterKubeconfigWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	GenerateSksClusterKubeconfig(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSksClusterVersions request
	ListSksClusterVersions(ctx context.Context, params *ListSksClusterVersionsParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSksCluster request
	DeleteSksCluster(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSksCluster request
	GetSksCluster(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateSksCluster request with any body
	UpdateSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateSksCluster(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSksClusterAuthorityCert request
	GetSksClusterAuthorityCert(ctx context.Context, id string, authority GetSksClusterAuthorityCertParamsAuthority, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CreateSksNodepool request with any body
	CreateSksNodepoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CreateSksNodepool(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSksNodepool request
	DeleteSksNodepool(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSksNodepool request
	GetSksNodepool(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateSksNodepool request with any body
	UpdateSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateSksNodepool(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetSksNodepoolField request
	ResetSksNodepoolField(ctx context.Context, id string, sksNodepoolId string, field ResetSksNodepoolFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// EvictSksNodepoolMembers request with any body
	EvictSksNodepoolMembersWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	EvictSksNodepoolMembers(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ScaleSksNodepool request with any body
	ScaleSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	ScaleSksNodepool(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RotateSksCcmCredentials request
	RotateSksCcmCredentials(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RotateSksOperatorsCa request
	RotateSksOperatorsCa(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpgradeSksCluster request with any body
	UpgradeSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpgradeSksCluster(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpgradeSksClusterServiceLevel request
	UpgradeSksClusterServiceLevel(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ResetSksClusterField request
	ResetSksClusterField(ctx context.Context, id string, field ResetSksClusterFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSnapshots request
	ListSnapshots(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSnapshot request
	DeleteSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSnapshot request
	GetSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ExportSnapshot request
	ExportSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// PromoteSnapshotToTemplate request with any body
	PromoteSnapshotToTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	PromoteSnapshotToTemplate(ctx context.Context, id string, body PromoteSnapshotToTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSosBucketsUsage request
	ListSosBucketsUsage(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSosPresignedUrl request
	GetSosPresignedUrl(ctx context.Context, bucket string, params *GetSosPresignedUrlParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListSshKeys request
	ListSshKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RegisterSshKey request with any body
	RegisterSshKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	RegisterSshKey(ctx context.Context, body RegisterSshKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteSshKey request
	DeleteSshKey(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetSshKey request
	GetSshKey(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListTemplates request
	ListTemplates(ctx context.Context, params *ListTemplatesParams, reqEditors ...RequestEditorFn) (*http.Response, error)

	// RegisterTemplate request with any body
	RegisterTemplateWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	RegisterTemplate(ctx context.Context, body RegisterTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// DeleteTemplate request
	DeleteTemplate(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// GetTemplate request
	GetTemplate(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error)

	// CopyTemplate request with any body
	CopyTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	CopyTemplate(ctx context.Context, id string, body CopyTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// UpdateTemplate request with any body
	UpdateTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error)

	UpdateTemplate(ctx context.Context, id string, body UpdateTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error)

	// ListZones request
	ListZones(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error)
}

func (c *Client) ListAccessKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListAccessKeysRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAccessKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateAccessKeyRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAccessKey(ctx context.Context, body CreateAccessKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateAccessKeyRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListAccessKeyKnownOperations(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListAccessKeyKnownOperationsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListAccessKeyOperations(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListAccessKeyOperationsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RevokeAccessKey(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRevokeAccessKeyRequest(c.Server, key)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetAccessKey(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetAccessKeyRequest(c.Server, key)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListAntiAffinityGroups(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListAntiAffinityGroupsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAntiAffinityGroupWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateAntiAffinityGroupRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAntiAffinityGroup(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateAntiAffinityGroupRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteAntiAffinityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteAntiAffinityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetAntiAffinityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetAntiAffinityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListApiKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListApiKeysRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateApiKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateApiKeyRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateApiKey(ctx context.Context, body CreateApiKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateApiKeyRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteApiKey(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteApiKeyRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetApiKey(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetApiKeyRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasCaCertificate(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasCaCertificateRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServiceGrafana(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceGrafanaRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceGrafanaRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceGrafanaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceGrafanaRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceGrafanaRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceGrafanaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceGrafanaRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceGrafana(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceGrafanaRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasGrafanaMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasGrafanaMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasIntegrationWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasIntegrationRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasIntegration(ctx context.Context, body CreateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasIntegrationRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDbaasIntegrationSettings(ctx context.Context, integrationType string, sourceType string, destType string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDbaasIntegrationSettingsRequest(c.Server, integrationType, sourceType, destType)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDbaasIntegrationTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDbaasIntegrationTypesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasIntegration(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasIntegrationRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasIntegration(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasIntegrationRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasIntegrationWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasIntegrationRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasIntegration(ctx context.Context, id string, body UpdateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasIntegrationRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServiceKafka(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceKafkaRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceKafka(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceKafkaRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceKafkaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceKafkaRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceKafka(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceKafkaRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceKafkaWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceKafkaRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceKafka(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceKafkaRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasKafkaAclConfig(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasKafkaAclConfigRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasKafkaMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasKafkaMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaSchemaRegistryAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaSchemaRegistryAclConfigRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaSchemaRegistryAclConfig(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaSchemaRegistryAclConfigRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasKafkaSchemaRegistryAclConfig(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasKafkaSchemaRegistryAclConfigRequest(c.Server, name, aclId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaTopicAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaTopicAclConfigRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaTopicAclConfig(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaTopicAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaTopicAclConfigRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasKafkaTopicAclConfig(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasKafkaTopicAclConfigRequest(c.Server, name, aclId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaUserRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasKafkaUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasKafkaUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasKafkaUserRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasKafkaUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasKafkaUserRequest(c.Server, serviceName, username)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasKafkaUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasKafkaUserPasswordRequestWithBody(c.Server, serviceName, username, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasKafkaUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasKafkaUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasKafkaUserPasswordRequest(c.Server, serviceName, username, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasMigrationStatus(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasMigrationStatusRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServiceMysql(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceMysqlRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceMysql(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceMysqlRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceMysqlWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceMysqlRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceMysql(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceMysqlRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceMysqlWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceMysqlRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceMysql(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceMysqlRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasMysqlMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasMysqlMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StopDbaasMysqlMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStopDbaasMysqlMigrationRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasMysqlDatabaseWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasMysqlDatabaseRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasMysqlDatabase(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasMysqlDatabaseRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasMysqlDatabase(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasMysqlDatabaseName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasMysqlDatabaseRequest(c.Server, serviceName, databaseName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasMysqlUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasMysqlUserRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasMysqlUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasMysqlUserRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasMysqlUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasMysqlUserRequest(c.Server, serviceName, username)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasMysqlUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasMysqlUserPasswordRequestWithBody(c.Server, serviceName, username, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasMysqlUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasMysqlUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasMysqlUserPasswordRequest(c.Server, serviceName, username, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServiceOpensearch(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceOpensearchRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceOpensearchRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceOpensearchWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceOpensearchRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceOpensearchRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceOpensearchWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceOpensearchRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceOpensearch(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceOpensearchRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasOpensearchAclConfig(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasOpensearchAclConfigRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasOpensearchAclConfigWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasOpensearchAclConfigRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasOpensearchAclConfig(ctx context.Context, name DbaasServiceName, body UpdateDbaasOpensearchAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasOpensearchAclConfigRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasOpensearchMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasOpensearchMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasOpensearchUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasOpensearchUserRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasOpensearchUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasOpensearchUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasOpensearchUserRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasOpensearchUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasOpensearchUserRequest(c.Server, serviceName, username)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasOpensearchUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasOpensearchUserPasswordRequestWithBody(c.Server, serviceName, username, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasOpensearchUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasOpensearchUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasOpensearchUserPasswordRequest(c.Server, serviceName, username, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServicePg(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServicePgRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServicePg(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServicePgRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServicePgWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServicePgRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServicePg(ctx context.Context, name DbaasServiceName, body CreateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServicePgRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServicePgWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServicePgRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServicePg(ctx context.Context, name DbaasServiceName, body UpdateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServicePgRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasPgMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasPgMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StopDbaasPgMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStopDbaasPgMigrationRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgConnectionPoolWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgConnectionPoolRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgConnectionPoolRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasPgConnectionPoolRequest(c.Server, serviceName, connectionPoolName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasPgConnectionPoolWithBody(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasPgConnectionPoolRequestWithBody(c.Server, serviceName, connectionPoolName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasPgConnectionPool(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, body UpdateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasPgConnectionPoolRequest(c.Server, serviceName, connectionPoolName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgDatabaseWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgDatabaseRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgDatabase(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgDatabaseRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasPgDatabase(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasPgDatabaseName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasPgDatabaseRequest(c.Server, serviceName, databaseName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPostgresUserWithBody(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPostgresUserRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPostgresUser(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPostgresUserJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPostgresUserRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasPostgresUser(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasPostgresUserRequest(c.Server, serviceName, username)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasPostgresAllowReplicationWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasPostgresAllowReplicationRequestWithBody(c.Server, serviceName, username, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasPostgresAllowReplication(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body UpdateDbaasPostgresAllowReplicationJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasPostgresAllowReplicationRequest(c.Server, serviceName, username, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasPostgresUserPasswordWithBody(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasPostgresUserPasswordRequestWithBody(c.Server, serviceName, username, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetDbaasPostgresUserPassword(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasPostgresUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetDbaasPostgresUserPasswordRequest(c.Server, serviceName, username, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgUpgradeCheckWithBody(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgUpgradeCheckRequestWithBody(c.Server, service, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasPgUpgradeCheck(ctx context.Context, service DbaasServiceName, body CreateDbaasPgUpgradeCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasPgUpgradeCheckRequest(c.Server, service, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasServiceRedis(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceRedisRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceRedis(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceRedisRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceRedisWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceRedisRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasServiceRedis(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasServiceRedisRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceRedisWithBody(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceRedisRequestWithBody(c.Server, name, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDbaasServiceRedis(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDbaasServiceRedisRequest(c.Server, name, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartDbaasRedisMaintenance(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartDbaasRedisMaintenanceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StopDbaasRedisMigration(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStopDbaasRedisMigrationRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDbaasServices(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDbaasServicesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceLogsWithBody(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceLogsRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceLogs(ctx context.Context, serviceName string, body GetDbaasServiceLogsJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceLogsRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceMetricsWithBody(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceMetricsRequestWithBody(c.Server, serviceName, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceMetrics(ctx context.Context, serviceName string, body GetDbaasServiceMetricsJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceMetricsRequest(c.Server, serviceName, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDbaasServiceTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDbaasServiceTypesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasServiceType(ctx context.Context, serviceTypeName string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasServiceTypeRequest(c.Server, serviceTypeName)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDbaasService(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDbaasServiceRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsGrafana(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsGrafanaRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsKafka(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsKafkaRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsMysql(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsMysqlRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsOpensearch(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsOpensearchRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsPg(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsPgRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasSettingsRedis(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasSettingsRedisRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasTaskMigrationCheckWithBody(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasTaskMigrationCheckRequestWithBody(c.Server, service, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDbaasTaskMigrationCheck(ctx context.Context, service DbaasServiceName, body CreateDbaasTaskMigrationCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDbaasTaskMigrationCheckRequest(c.Server, service, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDbaasTask(ctx context.Context, service DbaasServiceName, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDbaasTaskRequest(c.Server, service, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDeployTargets(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDeployTargetsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDeployTarget(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDeployTargetRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDnsDomains(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDnsDomainsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDnsDomainWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDnsDomainRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDnsDomain(ctx context.Context, body CreateDnsDomainJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDnsDomainRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListDnsDomainRecords(ctx context.Context, domainId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListDnsDomainRecordsRequest(c.Server, domainId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDnsDomainRecordWithBody(ctx context.Context, domainId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDnsDomainRecordRequestWithBody(c.Server, domainId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateDnsDomainRecord(ctx context.Context, domainId string, body CreateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateDnsDomainRecordRequest(c.Server, domainId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDnsDomainRecord(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDnsDomainRecordRequest(c.Server, domainId, recordId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDnsDomainRecord(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDnsDomainRecordRequest(c.Server, domainId, recordId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDnsDomainRecordWithBody(ctx context.Context, domainId string, recordId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDnsDomainRecordRequestWithBody(c.Server, domainId, recordId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateDnsDomainRecord(ctx context.Context, domainId string, recordId string, body UpdateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateDnsDomainRecordRequest(c.Server, domainId, recordId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteDnsDomain(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteDnsDomainRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDnsDomain(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDnsDomainRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetDnsDomainZoneFile(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetDnsDomainZoneFileRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListElasticIps(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListElasticIpsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateElasticIpWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateElasticIpRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateElasticIp(ctx context.Context, body CreateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateElasticIpRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteElasticIpRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetElasticIpRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateElasticIpRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateElasticIp(ctx context.Context, id string, body UpdateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateElasticIpRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetElasticIpField(ctx context.Context, id string, field ResetElasticIpFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetElasticIpFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToElasticIpRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToElasticIp(ctx context.Context, id string, body AttachInstanceToElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToElasticIpRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromElasticIpRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromElasticIp(ctx context.Context, id string, body DetachInstanceFromElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromElasticIpRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListEvents(ctx context.Context, params *ListEventsParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListEventsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetIamOrganizationPolicy(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetIamOrganizationPolicyRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamOrganizationPolicyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamOrganizationPolicyRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamOrganizationPolicy(ctx context.Context, body UpdateIamOrganizationPolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamOrganizationPolicyRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListIamRoles(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListIamRolesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateIamRoleWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateIamRoleRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateIamRole(ctx context.Context, body CreateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateIamRoleRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteIamRole(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteIamRoleRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetIamRole(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetIamRoleRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamRoleWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamRoleRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamRole(ctx context.Context, id string, body UpdateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamRoleRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamRolePolicyWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamRolePolicyRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateIamRolePolicy(ctx context.Context, id string, body UpdateIamRolePolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateIamRolePolicyRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListInstances(ctx context.Context, params *ListInstancesParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListInstancesRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstanceWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateInstanceRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstance(ctx context.Context, body CreateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateInstanceRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListInstancePools(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListInstancePoolsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstancePoolWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateInstancePoolRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstancePool(ctx context.Context, body CreateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateInstancePoolRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteInstancePool(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteInstancePoolRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetInstancePool(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetInstancePoolRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateInstancePoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstancePool(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateInstancePoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetInstancePoolField(ctx context.Context, id string, field ResetInstancePoolFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetInstancePoolFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) EvictInstancePoolMembersWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewEvictInstancePoolMembersRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) EvictInstancePoolMembers(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewEvictInstancePoolMembersRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleInstancePoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstancePool(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleInstancePoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListInstanceTypes(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListInstanceTypesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetInstanceType(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetInstanceTypeRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateInstanceRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstance(ctx context.Context, id string, body UpdateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateInstanceRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetInstanceField(ctx context.Context, id string, field ResetInstanceFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetInstanceFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddInstanceProtection(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddInstanceProtectionRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RevealInstancePassword(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRevealInstancePasswordRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RebootInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRebootInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RemoveInstanceProtection(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRemoveInstanceProtectionRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetInstanceRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetInstance(ctx context.Context, id string, body ResetInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetInstanceRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetInstancePassword(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetInstancePasswordRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResizeInstanceDiskWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResizeInstanceDiskRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResizeInstanceDisk(ctx context.Context, id string, body ResizeInstanceDiskJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResizeInstanceDiskRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleInstanceRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstance(ctx context.Context, id string, body ScaleInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleInstanceRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartInstanceRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StartInstance(ctx context.Context, id string, body StartInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStartInstanceRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) StopInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewStopInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RevertInstanceToSnapshotWithBody(ctx context.Context, instanceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRevertInstanceToSnapshotRequestWithBody(c.Server, instanceId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RevertInstanceToSnapshot(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRevertInstanceToSnapshotRequest(c.Server, instanceId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListLoadBalancers(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListLoadBalancersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateLoadBalancerWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateLoadBalancerRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateLoadBalancer(ctx context.Context, body CreateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateLoadBalancerRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteLoadBalancer(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteLoadBalancerRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLoadBalancer(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLoadBalancerRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancer(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddServiceToLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddServiceToLoadBalancerRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddServiceToLoadBalancer(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddServiceToLoadBalancerRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteLoadBalancerService(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteLoadBalancerServiceRequest(c.Server, id, serviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetLoadBalancerService(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetLoadBalancerServiceRequest(c.Server, id, serviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerServiceWithBody(ctx context.Context, id string, serviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerServiceRequestWithBody(c.Server, id, serviceId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerService(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerServiceRequest(c.Server, id, serviceId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetLoadBalancerServiceField(ctx context.Context, id string, serviceId string, field ResetLoadBalancerServiceFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetLoadBalancerServiceFieldRequest(c.Server, id, serviceId, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetLoadBalancerField(ctx context.Context, id string, field ResetLoadBalancerFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetLoadBalancerFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetOperation(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetOperationRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListPrivateNetworks(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListPrivateNetworksRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreatePrivateNetworkWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreatePrivateNetworkRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreatePrivateNetwork(ctx context.Context, body CreatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreatePrivateNetworkRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeletePrivateNetwork(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeletePrivateNetworkRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetPrivateNetwork(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetPrivateNetworkRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetwork(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetPrivateNetworkField(ctx context.Context, id string, field ResetPrivateNetworkFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetPrivateNetworkFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToPrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToPrivateNetworkRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToPrivateNetwork(ctx context.Context, id string, body AttachInstanceToPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToPrivateNetworkRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromPrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromPrivateNetworkRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromPrivateNetwork(ctx context.Context, id string, body DetachInstanceFromPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromPrivateNetworkRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetworkInstanceIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkInstanceIpRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetworkInstanceIp(ctx context.Context, id string, body UpdatePrivateNetworkInstanceIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkInstanceIpRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListQuotas(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListQuotasRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetQuota(ctx context.Context, entity string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetQuotaRequest(c.Server, entity)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteReverseDnsElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteReverseDnsElasticIpRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetReverseDnsElasticIp(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetReverseDnsElasticIpRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateReverseDnsElasticIpWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateReverseDnsElasticIpRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateReverseDnsElasticIp(ctx context.Context, id string, body UpdateReverseDnsElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateReverseDnsElasticIpRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteReverseDnsInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteReverseDnsInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetReverseDnsInstance(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetReverseDnsInstanceRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateReverseDnsInstanceWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateReverseDnsInstanceRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateReverseDnsInstance(ctx context.Context, id string, body UpdateReverseDnsInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateReverseDnsInstanceRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSecurityGroups(ctx context.Context, params *ListSecurityGroupsParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSecurityGroupsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSecurityGroupWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSecurityGroupRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSecurityGroup(ctx context.Context, body CreateSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSecurityGroupRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSecurityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSecurityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSecurityGroup(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSecurityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddRuleToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddRuleToSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddRuleToSecurityGroup(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddRuleToSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteRuleFromSecurityGroup(ctx context.Context, id string, ruleId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteRuleFromSecurityGroupRequest(c.Server, id, ruleId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddExternalSourceToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddExternalSourceToSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AddExternalSourceToSecurityGroup(ctx context.Context, id string, body AddExternalSourceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAddExternalSourceToSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) AttachInstanceToSecurityGroup(ctx context.Context, id string, body AttachInstanceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewAttachInstanceToSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DetachInstanceFromSecurityGroup(ctx context.Context, id string, body DetachInstanceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDetachInstanceFromSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RemoveExternalSourceFromSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRemoveExternalSourceFromSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RemoveExternalSourceFromSecurityGroup(ctx context.Context, id string, body RemoveExternalSourceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRemoveExternalSourceFromSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSksClusters(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSksClustersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksClusterWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSksClusterRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksCluster(ctx context.Context, body CreateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSksClusterRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSksClusterDeprecatedResources(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSksClusterDeprecatedResourcesRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GenerateSksClusterKubeconfigWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGenerateSksClusterKubeconfigRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GenerateSksClusterKubeconfig(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGenerateSksClusterKubeconfigRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSksClusterVersions(ctx context.Context, params *ListSksClusterVersionsParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSksClusterVersionsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksCluster(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSksClusterRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSksCluster(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSksClusterRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSksClusterRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksCluster(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSksClusterRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSksClusterAuthorityCert(ctx context.Context, id string, authority GetSksClusterAuthorityCertParamsAuthority, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSksClusterAuthorityCertRequest(c.Server, id, authority)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksNodepoolWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSksNodepoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksNodepool(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCreateSksNodepoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksNodepool(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSksNodepoolRequest(c.Server, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSksNodepool(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSksNodepoolRequest(c.Server, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSksNodepoolRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksNodepool(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateSksNodepoolRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetSksNodepoolField(ctx context.Context, id string, sksNodepoolId string, field ResetSksNodepoolFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetSksNodepoolFieldRequest(c.Server, id, sksNodepoolId, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) EvictSksNodepoolMembersWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewEvictSksNodepoolMembersRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) EvictSksNodepoolMembers(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewEvictSksNodepoolMembersRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleSksNodepoolRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleSksNodepool(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewScaleSksNodepoolRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RotateSksCcmCredentials(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRotateSksCcmCredentialsRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RotateSksOperatorsCa(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRotateSksOperatorsCaRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpgradeSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpgradeSksClusterRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpgradeSksCluster(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpgradeSksClusterRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpgradeSksClusterServiceLevel(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpgradeSksClusterServiceLevelRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ResetSksClusterField(ctx context.Context, id string, field ResetSksClusterFieldParamsField, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewResetSksClusterFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSnapshots(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSnapshotsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ExportSnapshot(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewExportSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) PromoteSnapshotToTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewPromoteSnapshotToTemplateRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) PromoteSnapshotToTemplate(ctx context.Context, id string, body PromoteSnapshotToTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewPromoteSnapshotToTemplateRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSosBucketsUsage(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSosBucketsUsageRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSosPresignedUrl(ctx context.Context, bucket string, params *GetSosPresignedUrlParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSosPresignedUrlRequest(c.Server, bucket, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListSshKeys(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListSshKeysRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterSshKeyWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRegisterSshKeyRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterSshKey(ctx context.Context, body RegisterSshKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRegisterSshKeyRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSshKey(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteSshKeyRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetSshKey(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetSshKeyRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListTemplates(ctx context.Context, params *ListTemplatesParams, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListTemplatesRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterTemplateWithBody(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRegisterTemplateRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterTemplate(ctx context.Context, body RegisterTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewRegisterTemplateRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteTemplate(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewDeleteTemplateRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) GetTemplate(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewGetTemplateRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CopyTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCopyTemplateRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) CopyTemplate(ctx context.Context, id string, body CopyTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewCopyTemplateRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateTemplateRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateTemplate(ctx context.Context, id string, body UpdateTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewUpdateTemplateRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

func (c *Client) ListZones(ctx context.Context, reqEditors ...RequestEditorFn) (*http.Response, error) {
	req, err := NewListZonesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if err := c.applyEditors(ctx, req, reqEditors); err != nil {
		return nil, err
	}
	return c.Client.Do(req)
}

// NewListAccessKeysRequest generates requests for ListAccessKeys
func NewListAccessKeysRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateAccessKeyRequest calls the generic CreateAccessKey builder with application/json body
func NewCreateAccessKeyRequest(server string, body CreateAccessKeyJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateAccessKeyRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateAccessKeyRequestWithBody generates requests for CreateAccessKey with any type of body
func NewCreateAccessKeyRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListAccessKeyKnownOperationsRequest generates requests for ListAccessKeyKnownOperations
func NewListAccessKeyKnownOperationsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key-known-operations")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListAccessKeyOperationsRequest generates requests for ListAccessKeyOperations
func NewListAccessKeyOperationsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key-operations")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRevokeAccessKeyRequest generates requests for RevokeAccessKey
func NewRevokeAccessKeyRequest(server string, key string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "key", runtime.ParamLocationPath, key)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetAccessKeyRequest generates requests for GetAccessKey
func NewGetAccessKeyRequest(server string, key string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "key", runtime.ParamLocationPath, key)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/access-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListAntiAffinityGroupsRequest generates requests for ListAntiAffinityGroups
func NewListAntiAffinityGroupsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/anti-affinity-group")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateAntiAffinityGroupRequest calls the generic CreateAntiAffinityGroup builder with application/json body
func NewCreateAntiAffinityGroupRequest(server string, body CreateAntiAffinityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateAntiAffinityGroupRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateAntiAffinityGroupRequestWithBody generates requests for CreateAntiAffinityGroup with any type of body
func NewCreateAntiAffinityGroupRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/anti-affinity-group")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteAntiAffinityGroupRequest generates requests for DeleteAntiAffinityGroup
func NewDeleteAntiAffinityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/anti-affinity-group/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetAntiAffinityGroupRequest generates requests for GetAntiAffinityGroup
func NewGetAntiAffinityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/anti-affinity-group/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListApiKeysRequest generates requests for ListApiKeys
func NewListApiKeysRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateApiKeyRequest calls the generic CreateApiKey builder with application/json body
func NewCreateApiKeyRequest(server string, body CreateApiKeyJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateApiKeyRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateApiKeyRequestWithBody generates requests for CreateApiKey with any type of body
func NewCreateApiKeyRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteApiKeyRequest generates requests for DeleteApiKey
func NewDeleteApiKeyRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetApiKeyRequest generates requests for GetApiKey
func NewGetApiKeyRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/api-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasCaCertificateRequest generates requests for GetDbaasCaCertificate
func NewGetDbaasCaCertificateRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-ca-certificate")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteDbaasServiceGrafanaRequest generates requests for DeleteDbaasServiceGrafana
func NewDeleteDbaasServiceGrafanaRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-grafana/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceGrafanaRequest generates requests for GetDbaasServiceGrafana
func NewGetDbaasServiceGrafanaRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-grafana/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServiceGrafanaRequest calls the generic CreateDbaasServiceGrafana builder with application/json body
func NewCreateDbaasServiceGrafanaRequest(server string, name DbaasServiceName, body CreateDbaasServiceGrafanaJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServiceGrafanaRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServiceGrafanaRequestWithBody generates requests for CreateDbaasServiceGrafana with any type of body
func NewCreateDbaasServiceGrafanaRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-grafana/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServiceGrafanaRequest calls the generic UpdateDbaasServiceGrafana builder with application/json body
func NewUpdateDbaasServiceGrafanaRequest(server string, name DbaasServiceName, body UpdateDbaasServiceGrafanaJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServiceGrafanaRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServiceGrafanaRequestWithBody generates requests for UpdateDbaasServiceGrafana with any type of body
func NewUpdateDbaasServiceGrafanaRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-grafana/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartDbaasGrafanaMaintenanceRequest generates requests for StartDbaasGrafanaMaintenance
func NewStartDbaasGrafanaMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-grafana/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasIntegrationRequest calls the generic CreateDbaasIntegration builder with application/json body
func NewCreateDbaasIntegrationRequest(server string, body CreateDbaasIntegrationJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasIntegrationRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateDbaasIntegrationRequestWithBody generates requests for CreateDbaasIntegration with any type of body
func NewCreateDbaasIntegrationRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListDbaasIntegrationSettingsRequest generates requests for ListDbaasIntegrationSettings
func NewListDbaasIntegrationSettingsRequest(server string, integrationType string, sourceType string, destType string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "integration-type", runtime.ParamLocationPath, integrationType)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "source-type", runtime.ParamLocationPath, sourceType)
	if err != nil {
		return nil, err
	}

	var pathParam2 string

	pathParam2, err = runtime.StyleParamWithLocation("simple", false, "dest-type", runtime.ParamLocationPath, destType)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration-settings/%s/%s/%s", pathParam0, pathParam1, pathParam2)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListDbaasIntegrationTypesRequest generates requests for ListDbaasIntegrationTypes
func NewListDbaasIntegrationTypesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration-types")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteDbaasIntegrationRequest generates requests for DeleteDbaasIntegration
func NewDeleteDbaasIntegrationRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasIntegrationRequest generates requests for GetDbaasIntegration
func NewGetDbaasIntegrationRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDbaasIntegrationRequest calls the generic UpdateDbaasIntegration builder with application/json body
func NewUpdateDbaasIntegrationRequest(server string, id string, body UpdateDbaasIntegrationJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasIntegrationRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateDbaasIntegrationRequestWithBody generates requests for UpdateDbaasIntegration with any type of body
func NewUpdateDbaasIntegrationRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-integration/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasServiceKafkaRequest generates requests for DeleteDbaasServiceKafka
func NewDeleteDbaasServiceKafkaRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceKafkaRequest generates requests for GetDbaasServiceKafka
func NewGetDbaasServiceKafkaRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServiceKafkaRequest calls the generic CreateDbaasServiceKafka builder with application/json body
func NewCreateDbaasServiceKafkaRequest(server string, name DbaasServiceName, body CreateDbaasServiceKafkaJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServiceKafkaRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServiceKafkaRequestWithBody generates requests for CreateDbaasServiceKafka with any type of body
func NewCreateDbaasServiceKafkaRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServiceKafkaRequest calls the generic UpdateDbaasServiceKafka builder with application/json body
func NewUpdateDbaasServiceKafkaRequest(server string, name DbaasServiceName, body UpdateDbaasServiceKafkaJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServiceKafkaRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServiceKafkaRequestWithBody generates requests for UpdateDbaasServiceKafka with any type of body
func NewUpdateDbaasServiceKafkaRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDbaasKafkaAclConfigRequest generates requests for GetDbaasKafkaAclConfig
func NewGetDbaasKafkaAclConfigRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/acl-config", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewStartDbaasKafkaMaintenanceRequest generates requests for StartDbaasKafkaMaintenance
func NewStartDbaasKafkaMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasKafkaSchemaRegistryAclConfigRequest calls the generic CreateDbaasKafkaSchemaRegistryAclConfig builder with application/json body
func NewCreateDbaasKafkaSchemaRegistryAclConfigRequest(server string, name DbaasServiceName, body CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasKafkaSchemaRegistryAclConfigRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasKafkaSchemaRegistryAclConfigRequestWithBody generates requests for CreateDbaasKafkaSchemaRegistryAclConfig with any type of body
func NewCreateDbaasKafkaSchemaRegistryAclConfigRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/schema-registry/acl-config", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasKafkaSchemaRegistryAclConfigRequest generates requests for DeleteDbaasKafkaSchemaRegistryAclConfig
func NewDeleteDbaasKafkaSchemaRegistryAclConfigRequest(server string, name DbaasServiceName, aclId DbaasKafkaAclId) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "acl-id", runtime.ParamLocationPath, aclId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/schema-registry/acl-config/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasKafkaTopicAclConfigRequest calls the generic CreateDbaasKafkaTopicAclConfig builder with application/json body
func NewCreateDbaasKafkaTopicAclConfigRequest(server string, name DbaasServiceName, body CreateDbaasKafkaTopicAclConfigJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasKafkaTopicAclConfigRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasKafkaTopicAclConfigRequestWithBody generates requests for CreateDbaasKafkaTopicAclConfig with any type of body
func NewCreateDbaasKafkaTopicAclConfigRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/topic/acl-config", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasKafkaTopicAclConfigRequest generates requests for DeleteDbaasKafkaTopicAclConfig
func NewDeleteDbaasKafkaTopicAclConfigRequest(server string, name DbaasServiceName, aclId DbaasKafkaAclId) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "acl-id", runtime.ParamLocationPath, aclId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/topic/acl-config/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasKafkaUserRequest calls the generic CreateDbaasKafkaUser builder with application/json body
func NewCreateDbaasKafkaUserRequest(server string, serviceName DbaasServiceName, body CreateDbaasKafkaUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasKafkaUserRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasKafkaUserRequestWithBody generates requests for CreateDbaasKafkaUser with any type of body
func NewCreateDbaasKafkaUserRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/user", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasKafkaUserRequest generates requests for DeleteDbaasKafkaUser
func NewDeleteDbaasKafkaUserRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/user/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetDbaasKafkaUserPasswordRequest calls the generic ResetDbaasKafkaUserPassword builder with application/json body
func NewResetDbaasKafkaUserPasswordRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasKafkaUserPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResetDbaasKafkaUserPasswordRequestWithBody(server, serviceName, username, "application/json", bodyReader)
}

// NewResetDbaasKafkaUserPasswordRequestWithBody generates requests for ResetDbaasKafkaUserPassword with any type of body
func NewResetDbaasKafkaUserPasswordRequestWithBody(server string, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-kafka/%s/user/%s/password/reset", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDbaasMigrationStatusRequest generates requests for GetDbaasMigrationStatus
func NewGetDbaasMigrationStatusRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-migration-status/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteDbaasServiceMysqlRequest generates requests for DeleteDbaasServiceMysql
func NewDeleteDbaasServiceMysqlRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceMysqlRequest generates requests for GetDbaasServiceMysql
func NewGetDbaasServiceMysqlRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServiceMysqlRequest calls the generic CreateDbaasServiceMysql builder with application/json body
func NewCreateDbaasServiceMysqlRequest(server string, name DbaasServiceName, body CreateDbaasServiceMysqlJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServiceMysqlRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServiceMysqlRequestWithBody generates requests for CreateDbaasServiceMysql with any type of body
func NewCreateDbaasServiceMysqlRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServiceMysqlRequest calls the generic UpdateDbaasServiceMysql builder with application/json body
func NewUpdateDbaasServiceMysqlRequest(server string, name DbaasServiceName, body UpdateDbaasServiceMysqlJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServiceMysqlRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServiceMysqlRequestWithBody generates requests for UpdateDbaasServiceMysql with any type of body
func NewUpdateDbaasServiceMysqlRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartDbaasMysqlMaintenanceRequest generates requests for StartDbaasMysqlMaintenance
func NewStartDbaasMysqlMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewStopDbaasMysqlMigrationRequest generates requests for StopDbaasMysqlMigration
func NewStopDbaasMysqlMigrationRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/migration/stop", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasMysqlDatabaseRequest calls the generic CreateDbaasMysqlDatabase builder with application/json body
func NewCreateDbaasMysqlDatabaseRequest(server string, serviceName DbaasServiceName, body CreateDbaasMysqlDatabaseJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasMysqlDatabaseRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasMysqlDatabaseRequestWithBody generates requests for CreateDbaasMysqlDatabase with any type of body
func NewCreateDbaasMysqlDatabaseRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/database", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasMysqlDatabaseRequest generates requests for DeleteDbaasMysqlDatabase
func NewDeleteDbaasMysqlDatabaseRequest(server string, serviceName DbaasServiceName, databaseName DbaasMysqlDatabaseName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "database-name", runtime.ParamLocationPath, databaseName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/database/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasMysqlUserRequest calls the generic CreateDbaasMysqlUser builder with application/json body
func NewCreateDbaasMysqlUserRequest(server string, serviceName DbaasServiceName, body CreateDbaasMysqlUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasMysqlUserRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasMysqlUserRequestWithBody generates requests for CreateDbaasMysqlUser with any type of body
func NewCreateDbaasMysqlUserRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/user", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasMysqlUserRequest generates requests for DeleteDbaasMysqlUser
func NewDeleteDbaasMysqlUserRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/user/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetDbaasMysqlUserPasswordRequest calls the generic ResetDbaasMysqlUserPassword builder with application/json body
func NewResetDbaasMysqlUserPasswordRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasMysqlUserPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResetDbaasMysqlUserPasswordRequestWithBody(server, serviceName, username, "application/json", bodyReader)
}

// NewResetDbaasMysqlUserPasswordRequestWithBody generates requests for ResetDbaasMysqlUserPassword with any type of body
func NewResetDbaasMysqlUserPasswordRequestWithBody(server string, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-mysql/%s/user/%s/password/reset", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasServiceOpensearchRequest generates requests for DeleteDbaasServiceOpensearch
func NewDeleteDbaasServiceOpensearchRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceOpensearchRequest generates requests for GetDbaasServiceOpensearch
func NewGetDbaasServiceOpensearchRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServiceOpensearchRequest calls the generic CreateDbaasServiceOpensearch builder with application/json body
func NewCreateDbaasServiceOpensearchRequest(server string, name DbaasServiceName, body CreateDbaasServiceOpensearchJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServiceOpensearchRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServiceOpensearchRequestWithBody generates requests for CreateDbaasServiceOpensearch with any type of body
func NewCreateDbaasServiceOpensearchRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServiceOpensearchRequest calls the generic UpdateDbaasServiceOpensearch builder with application/json body
func NewUpdateDbaasServiceOpensearchRequest(server string, name DbaasServiceName, body UpdateDbaasServiceOpensearchJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServiceOpensearchRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServiceOpensearchRequestWithBody generates requests for UpdateDbaasServiceOpensearch with any type of body
func NewUpdateDbaasServiceOpensearchRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDbaasOpensearchAclConfigRequest generates requests for GetDbaasOpensearchAclConfig
func NewGetDbaasOpensearchAclConfigRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/acl-config", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDbaasOpensearchAclConfigRequest calls the generic UpdateDbaasOpensearchAclConfig builder with application/json body
func NewUpdateDbaasOpensearchAclConfigRequest(server string, name DbaasServiceName, body UpdateDbaasOpensearchAclConfigJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasOpensearchAclConfigRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasOpensearchAclConfigRequestWithBody generates requests for UpdateDbaasOpensearchAclConfig with any type of body
func NewUpdateDbaasOpensearchAclConfigRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/acl-config", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartDbaasOpensearchMaintenanceRequest generates requests for StartDbaasOpensearchMaintenance
func NewStartDbaasOpensearchMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasOpensearchUserRequest calls the generic CreateDbaasOpensearchUser builder with application/json body
func NewCreateDbaasOpensearchUserRequest(server string, serviceName DbaasServiceName, body CreateDbaasOpensearchUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasOpensearchUserRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasOpensearchUserRequestWithBody generates requests for CreateDbaasOpensearchUser with any type of body
func NewCreateDbaasOpensearchUserRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/user", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasOpensearchUserRequest generates requests for DeleteDbaasOpensearchUser
func NewDeleteDbaasOpensearchUserRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/user/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetDbaasOpensearchUserPasswordRequest calls the generic ResetDbaasOpensearchUserPassword builder with application/json body
func NewResetDbaasOpensearchUserPasswordRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasOpensearchUserPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResetDbaasOpensearchUserPasswordRequestWithBody(server, serviceName, username, "application/json", bodyReader)
}

// NewResetDbaasOpensearchUserPasswordRequestWithBody generates requests for ResetDbaasOpensearchUserPassword with any type of body
func NewResetDbaasOpensearchUserPasswordRequestWithBody(server string, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-opensearch/%s/user/%s/password/reset", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasServicePgRequest generates requests for DeleteDbaasServicePg
func NewDeleteDbaasServicePgRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServicePgRequest generates requests for GetDbaasServicePg
func NewGetDbaasServicePgRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServicePgRequest calls the generic CreateDbaasServicePg builder with application/json body
func NewCreateDbaasServicePgRequest(server string, name DbaasServiceName, body CreateDbaasServicePgJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServicePgRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServicePgRequestWithBody generates requests for CreateDbaasServicePg with any type of body
func NewCreateDbaasServicePgRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServicePgRequest calls the generic UpdateDbaasServicePg builder with application/json body
func NewUpdateDbaasServicePgRequest(server string, name DbaasServiceName, body UpdateDbaasServicePgJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServicePgRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServicePgRequestWithBody generates requests for UpdateDbaasServicePg with any type of body
func NewUpdateDbaasServicePgRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartDbaasPgMaintenanceRequest generates requests for StartDbaasPgMaintenance
func NewStartDbaasPgMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewStopDbaasPgMigrationRequest generates requests for StopDbaasPgMigration
func NewStopDbaasPgMigrationRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/migration/stop", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasPgConnectionPoolRequest calls the generic CreateDbaasPgConnectionPool builder with application/json body
func NewCreateDbaasPgConnectionPoolRequest(server string, serviceName DbaasServiceName, body CreateDbaasPgConnectionPoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasPgConnectionPoolRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasPgConnectionPoolRequestWithBody generates requests for CreateDbaasPgConnectionPool with any type of body
func NewCreateDbaasPgConnectionPoolRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/connection-pool", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasPgConnectionPoolRequest generates requests for DeleteDbaasPgConnectionPool
func NewDeleteDbaasPgConnectionPoolRequest(server string, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "connection-pool-name", runtime.ParamLocationPath, connectionPoolName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/connection-pool/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDbaasPgConnectionPoolRequest calls the generic UpdateDbaasPgConnectionPool builder with application/json body
func NewUpdateDbaasPgConnectionPoolRequest(server string, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, body UpdateDbaasPgConnectionPoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasPgConnectionPoolRequestWithBody(server, serviceName, connectionPoolName, "application/json", bodyReader)
}

// NewUpdateDbaasPgConnectionPoolRequestWithBody generates requests for UpdateDbaasPgConnectionPool with any type of body
func NewUpdateDbaasPgConnectionPoolRequestWithBody(server string, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "connection-pool-name", runtime.ParamLocationPath, connectionPoolName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/connection-pool/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewCreateDbaasPgDatabaseRequest calls the generic CreateDbaasPgDatabase builder with application/json body
func NewCreateDbaasPgDatabaseRequest(server string, serviceName DbaasServiceName, body CreateDbaasPgDatabaseJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasPgDatabaseRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasPgDatabaseRequestWithBody generates requests for CreateDbaasPgDatabase with any type of body
func NewCreateDbaasPgDatabaseRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/database", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasPgDatabaseRequest generates requests for DeleteDbaasPgDatabase
func NewDeleteDbaasPgDatabaseRequest(server string, serviceName DbaasServiceName, databaseName DbaasPgDatabaseName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "database-name", runtime.ParamLocationPath, databaseName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/database/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasPostgresUserRequest calls the generic CreateDbaasPostgresUser builder with application/json body
func NewCreateDbaasPostgresUserRequest(server string, serviceName DbaasServiceName, body CreateDbaasPostgresUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasPostgresUserRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewCreateDbaasPostgresUserRequestWithBody generates requests for CreateDbaasPostgresUser with any type of body
func NewCreateDbaasPostgresUserRequestWithBody(server string, serviceName DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/user", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasPostgresUserRequest generates requests for DeleteDbaasPostgresUser
func NewDeleteDbaasPostgresUserRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/user/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDbaasPostgresAllowReplicationRequest calls the generic UpdateDbaasPostgresAllowReplication builder with application/json body
func NewUpdateDbaasPostgresAllowReplicationRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername, body UpdateDbaasPostgresAllowReplicationJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasPostgresAllowReplicationRequestWithBody(server, serviceName, username, "application/json", bodyReader)
}

// NewUpdateDbaasPostgresAllowReplicationRequestWithBody generates requests for UpdateDbaasPostgresAllowReplication with any type of body
func NewUpdateDbaasPostgresAllowReplicationRequestWithBody(server string, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/user/%s/allow-replication", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetDbaasPostgresUserPasswordRequest calls the generic ResetDbaasPostgresUserPassword builder with application/json body
func NewResetDbaasPostgresUserPasswordRequest(server string, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasPostgresUserPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResetDbaasPostgresUserPasswordRequestWithBody(server, serviceName, username, "application/json", bodyReader)
}

// NewResetDbaasPostgresUserPasswordRequestWithBody generates requests for ResetDbaasPostgresUserPassword with any type of body
func NewResetDbaasPostgresUserPasswordRequestWithBody(server string, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "username", runtime.ParamLocationPath, username)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/user/%s/password/reset", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewCreateDbaasPgUpgradeCheckRequest calls the generic CreateDbaasPgUpgradeCheck builder with application/json body
func NewCreateDbaasPgUpgradeCheckRequest(server string, service DbaasServiceName, body CreateDbaasPgUpgradeCheckJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasPgUpgradeCheckRequestWithBody(server, service, "application/json", bodyReader)
}

// NewCreateDbaasPgUpgradeCheckRequestWithBody generates requests for CreateDbaasPgUpgradeCheck with any type of body
func NewCreateDbaasPgUpgradeCheckRequestWithBody(server string, service DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service", runtime.ParamLocationPath, service)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-postgres/%s/upgrade-check", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDbaasServiceRedisRequest generates requests for DeleteDbaasServiceRedis
func NewDeleteDbaasServiceRedisRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceRedisRequest generates requests for GetDbaasServiceRedis
func NewGetDbaasServiceRedisRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasServiceRedisRequest calls the generic CreateDbaasServiceRedis builder with application/json body
func NewCreateDbaasServiceRedisRequest(server string, name DbaasServiceName, body CreateDbaasServiceRedisJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasServiceRedisRequestWithBody(server, name, "application/json", bodyReader)
}

// NewCreateDbaasServiceRedisRequestWithBody generates requests for CreateDbaasServiceRedis with any type of body
func NewCreateDbaasServiceRedisRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateDbaasServiceRedisRequest calls the generic UpdateDbaasServiceRedis builder with application/json body
func NewUpdateDbaasServiceRedisRequest(server string, name DbaasServiceName, body UpdateDbaasServiceRedisJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDbaasServiceRedisRequestWithBody(server, name, "application/json", bodyReader)
}

// NewUpdateDbaasServiceRedisRequestWithBody generates requests for UpdateDbaasServiceRedis with any type of body
func NewUpdateDbaasServiceRedisRequestWithBody(server string, name DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartDbaasRedisMaintenanceRequest generates requests for StartDbaasRedisMaintenance
func NewStartDbaasRedisMaintenanceRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s/maintenance/start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewStopDbaasRedisMigrationRequest generates requests for StopDbaasRedisMigration
func NewStopDbaasRedisMigrationRequest(server string, name DbaasServiceName) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-redis/%s/migration/stop", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListDbaasServicesRequest generates requests for ListDbaasServices
func NewListDbaasServicesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceLogsRequest calls the generic GetDbaasServiceLogs builder with application/json body
func NewGetDbaasServiceLogsRequest(server string, serviceName string, body GetDbaasServiceLogsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewGetDbaasServiceLogsRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewGetDbaasServiceLogsRequestWithBody generates requests for GetDbaasServiceLogs with any type of body
func NewGetDbaasServiceLogsRequestWithBody(server string, serviceName string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service-logs/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDbaasServiceMetricsRequest calls the generic GetDbaasServiceMetrics builder with application/json body
func NewGetDbaasServiceMetricsRequest(server string, serviceName string, body GetDbaasServiceMetricsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewGetDbaasServiceMetricsRequestWithBody(server, serviceName, "application/json", bodyReader)
}

// NewGetDbaasServiceMetricsRequestWithBody generates requests for GetDbaasServiceMetrics with any type of body
func NewGetDbaasServiceMetricsRequestWithBody(server string, serviceName string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-name", runtime.ParamLocationPath, serviceName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service-metrics/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListDbaasServiceTypesRequest generates requests for ListDbaasServiceTypes
func NewListDbaasServiceTypesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service-type")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasServiceTypeRequest generates requests for GetDbaasServiceType
func NewGetDbaasServiceTypeRequest(server string, serviceTypeName string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service-type-name", runtime.ParamLocationPath, serviceTypeName)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service-type/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteDbaasServiceRequest generates requests for DeleteDbaasService
func NewDeleteDbaasServiceRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-service/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsGrafanaRequest generates requests for GetDbaasSettingsGrafana
func NewGetDbaasSettingsGrafanaRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-grafana")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsKafkaRequest generates requests for GetDbaasSettingsKafka
func NewGetDbaasSettingsKafkaRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-kafka")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsMysqlRequest generates requests for GetDbaasSettingsMysql
func NewGetDbaasSettingsMysqlRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-mysql")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsOpensearchRequest generates requests for GetDbaasSettingsOpensearch
func NewGetDbaasSettingsOpensearchRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-opensearch")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsPgRequest generates requests for GetDbaasSettingsPg
func NewGetDbaasSettingsPgRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-pg")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDbaasSettingsRedisRequest generates requests for GetDbaasSettingsRedis
func NewGetDbaasSettingsRedisRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-settings-redis")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDbaasTaskMigrationCheckRequest calls the generic CreateDbaasTaskMigrationCheck builder with application/json body
func NewCreateDbaasTaskMigrationCheckRequest(server string, service DbaasServiceName, body CreateDbaasTaskMigrationCheckJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDbaasTaskMigrationCheckRequestWithBody(server, service, "application/json", bodyReader)
}

// NewCreateDbaasTaskMigrationCheckRequestWithBody generates requests for CreateDbaasTaskMigrationCheck with any type of body
func NewCreateDbaasTaskMigrationCheckRequestWithBody(server string, service DbaasServiceName, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service", runtime.ParamLocationPath, service)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-task-migration-check/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetDbaasTaskRequest generates requests for GetDbaasTask
func NewGetDbaasTaskRequest(server string, service DbaasServiceName, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "service", runtime.ParamLocationPath, service)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dbaas-task/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListDeployTargetsRequest generates requests for ListDeployTargets
func NewListDeployTargetsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/deploy-target")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDeployTargetRequest generates requests for GetDeployTarget
func NewGetDeployTargetRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/deploy-target/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListDnsDomainsRequest generates requests for ListDnsDomains
func NewListDnsDomainsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDnsDomainRequest calls the generic CreateDnsDomain builder with application/json body
func NewCreateDnsDomainRequest(server string, body CreateDnsDomainJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDnsDomainRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateDnsDomainRequestWithBody generates requests for CreateDnsDomain with any type of body
func NewCreateDnsDomainRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListDnsDomainRecordsRequest generates requests for ListDnsDomainRecords
func NewListDnsDomainRecordsRequest(server string, domainId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "domain-id", runtime.ParamLocationPath, domainId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/record", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateDnsDomainRecordRequest calls the generic CreateDnsDomainRecord builder with application/json body
func NewCreateDnsDomainRecordRequest(server string, domainId string, body CreateDnsDomainRecordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateDnsDomainRecordRequestWithBody(server, domainId, "application/json", bodyReader)
}

// NewCreateDnsDomainRecordRequestWithBody generates requests for CreateDnsDomainRecord with any type of body
func NewCreateDnsDomainRecordRequestWithBody(server string, domainId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "domain-id", runtime.ParamLocationPath, domainId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/record", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDnsDomainRecordRequest generates requests for DeleteDnsDomainRecord
func NewDeleteDnsDomainRecordRequest(server string, domainId string, recordId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "domain-id", runtime.ParamLocationPath, domainId)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "record-id", runtime.ParamLocationPath, recordId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/record/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDnsDomainRecordRequest generates requests for GetDnsDomainRecord
func NewGetDnsDomainRecordRequest(server string, domainId string, recordId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "domain-id", runtime.ParamLocationPath, domainId)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "record-id", runtime.ParamLocationPath, recordId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/record/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateDnsDomainRecordRequest calls the generic UpdateDnsDomainRecord builder with application/json body
func NewUpdateDnsDomainRecordRequest(server string, domainId string, recordId string, body UpdateDnsDomainRecordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateDnsDomainRecordRequestWithBody(server, domainId, recordId, "application/json", bodyReader)
}

// NewUpdateDnsDomainRecordRequestWithBody generates requests for UpdateDnsDomainRecord with any type of body
func NewUpdateDnsDomainRecordRequestWithBody(server string, domainId string, recordId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "domain-id", runtime.ParamLocationPath, domainId)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "record-id", runtime.ParamLocationPath, recordId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/record/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteDnsDomainRequest generates requests for DeleteDnsDomain
func NewDeleteDnsDomainRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDnsDomainRequest generates requests for GetDnsDomain
func NewGetDnsDomainRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetDnsDomainZoneFileRequest generates requests for GetDnsDomainZoneFile
func NewGetDnsDomainZoneFileRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/dns-domain/%s/zone", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListElasticIpsRequest generates requests for ListElasticIps
func NewListElasticIpsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateElasticIpRequest calls the generic CreateElasticIp builder with application/json body
func NewCreateElasticIpRequest(server string, body CreateElasticIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateElasticIpRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateElasticIpRequestWithBody generates requests for CreateElasticIp with any type of body
func NewCreateElasticIpRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteElasticIpRequest generates requests for DeleteElasticIp
func NewDeleteElasticIpRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetElasticIpRequest generates requests for GetElasticIp
func NewGetElasticIpRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateElasticIpRequest calls the generic UpdateElasticIp builder with application/json body
func NewUpdateElasticIpRequest(server string, id string, body UpdateElasticIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateElasticIpRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateElasticIpRequestWithBody generates requests for UpdateElasticIp with any type of body
func NewUpdateElasticIpRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetElasticIpFieldRequest generates requests for ResetElasticIpField
func NewResetElasticIpFieldRequest(server string, id string, field ResetElasticIpFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAttachInstanceToElasticIpRequest calls the generic AttachInstanceToElasticIp builder with application/json body
func NewAttachInstanceToElasticIpRequest(server string, id string, body AttachInstanceToElasticIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAttachInstanceToElasticIpRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAttachInstanceToElasticIpRequestWithBody generates requests for AttachInstanceToElasticIp with any type of body
func NewAttachInstanceToElasticIpRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s:attach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDetachInstanceFromElasticIpRequest calls the generic DetachInstanceFromElasticIp builder with application/json body
func NewDetachInstanceFromElasticIpRequest(server string, id string, body DetachInstanceFromElasticIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewDetachInstanceFromElasticIpRequestWithBody(server, id, "application/json", bodyReader)
}

// NewDetachInstanceFromElasticIpRequestWithBody generates requests for DetachInstanceFromElasticIp with any type of body
func NewDetachInstanceFromElasticIpRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/elastic-ip/%s:detach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListEventsRequest generates requests for ListEvents
func NewListEventsRequest(server string, params *ListEventsParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/event")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.From != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "from", runtime.ParamLocationQuery, *params.From); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.To != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "to", runtime.ParamLocationQuery, *params.To); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetIamOrganizationPolicyRequest generates requests for GetIamOrganizationPolicy
func NewGetIamOrganizationPolicyRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-organization-policy")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateIamOrganizationPolicyRequest calls the generic UpdateIamOrganizationPolicy builder with application/json body
func NewUpdateIamOrganizationPolicyRequest(server string, body UpdateIamOrganizationPolicyJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateIamOrganizationPolicyRequestWithBody(server, "application/json", bodyReader)
}

// NewUpdateIamOrganizationPolicyRequestWithBody generates requests for UpdateIamOrganizationPolicy with any type of body
func NewUpdateIamOrganizationPolicyRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-organization-policy")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListIamRolesRequest generates requests for ListIamRoles
func NewListIamRolesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateIamRoleRequest calls the generic CreateIamRole builder with application/json body
func NewCreateIamRoleRequest(server string, body CreateIamRoleJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateIamRoleRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateIamRoleRequestWithBody generates requests for CreateIamRole with any type of body
func NewCreateIamRoleRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteIamRoleRequest generates requests for DeleteIamRole
func NewDeleteIamRoleRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetIamRoleRequest generates requests for GetIamRole
func NewGetIamRoleRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateIamRoleRequest calls the generic UpdateIamRole builder with application/json body
func NewUpdateIamRoleRequest(server string, id string, body UpdateIamRoleJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateIamRoleRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateIamRoleRequestWithBody generates requests for UpdateIamRole with any type of body
func NewUpdateIamRoleRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateIamRolePolicyRequest calls the generic UpdateIamRolePolicy builder with application/json body
func NewUpdateIamRolePolicyRequest(server string, id string, body UpdateIamRolePolicyJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateIamRolePolicyRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateIamRolePolicyRequestWithBody generates requests for UpdateIamRolePolicy with any type of body
func NewUpdateIamRolePolicyRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/iam-role/%s:policy", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListInstancesRequest generates requests for ListInstances
func NewListInstancesRequest(server string, params *ListInstancesParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.ManagerId != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "manager-id", runtime.ParamLocationQuery, *params.ManagerId); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.ManagerType != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "manager-type", runtime.ParamLocationQuery, *params.ManagerType); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.IpAddress != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "ip-address", runtime.ParamLocationQuery, *params.IpAddress); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateInstanceRequest calls the generic CreateInstance builder with application/json body
func NewCreateInstanceRequest(server string, body CreateInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateInstanceRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateInstanceRequestWithBody generates requests for CreateInstance with any type of body
func NewCreateInstanceRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListInstancePoolsRequest generates requests for ListInstancePools
func NewListInstancePoolsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateInstancePoolRequest calls the generic CreateInstancePool builder with application/json body
func NewCreateInstancePoolRequest(server string, body CreateInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateInstancePoolRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateInstancePoolRequestWithBody generates requests for CreateInstancePool with any type of body
func NewCreateInstancePoolRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteInstancePoolRequest generates requests for DeleteInstancePool
func NewDeleteInstancePoolRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetInstancePoolRequest generates requests for GetInstancePool
func NewGetInstancePoolRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateInstancePoolRequest calls the generic UpdateInstancePool builder with application/json body
func NewUpdateInstancePoolRequest(server string, id string, body UpdateInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateInstancePoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateInstancePoolRequestWithBody generates requests for UpdateInstancePool with any type of body
func NewUpdateInstancePoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetInstancePoolFieldRequest generates requests for ResetInstancePoolField
func NewResetInstancePoolFieldRequest(server string, id string, field ResetInstancePoolFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewEvictInstancePoolMembersRequest calls the generic EvictInstancePoolMembers builder with application/json body
func NewEvictInstancePoolMembersRequest(server string, id string, body EvictInstancePoolMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewEvictInstancePoolMembersRequestWithBody(server, id, "application/json", bodyReader)
}

// NewEvictInstancePoolMembersRequestWithBody generates requests for EvictInstancePoolMembers with any type of body
func NewEvictInstancePoolMembersRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s:evict", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewScaleInstancePoolRequest calls the generic ScaleInstancePool builder with application/json body
func NewScaleInstancePoolRequest(server string, id string, body ScaleInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewScaleInstancePoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewScaleInstancePoolRequestWithBody generates requests for ScaleInstancePool with any type of body
func NewScaleInstancePoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-pool/%s:scale", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListInstanceTypesRequest generates requests for ListInstanceTypes
func NewListInstanceTypesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-type")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetInstanceTypeRequest generates requests for GetInstanceType
func NewGetInstanceTypeRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance-type/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteInstanceRequest generates requests for DeleteInstance
func NewDeleteInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetInstanceRequest generates requests for GetInstance
func NewGetInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateInstanceRequest calls the generic UpdateInstance builder with application/json body
func NewUpdateInstanceRequest(server string, id string, body UpdateInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateInstanceRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateInstanceRequestWithBody generates requests for UpdateInstance with any type of body
func NewUpdateInstanceRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetInstanceFieldRequest generates requests for ResetInstanceField
func NewResetInstanceFieldRequest(server string, id string, field ResetInstanceFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAddInstanceProtectionRequest generates requests for AddInstanceProtection
func NewAddInstanceProtectionRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:add-protection", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSnapshotRequest generates requests for CreateSnapshot
func NewCreateSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:create-snapshot", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRevealInstancePasswordRequest generates requests for RevealInstancePassword
func NewRevealInstancePasswordRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:password", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRebootInstanceRequest generates requests for RebootInstance
func NewRebootInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:reboot", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRemoveInstanceProtectionRequest generates requests for RemoveInstanceProtection
func NewRemoveInstanceProtectionRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:remove-protection", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetInstanceRequest calls the generic ResetInstance builder with application/json body
func NewResetInstanceRequest(server string, id string, body ResetInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResetInstanceRequestWithBody(server, id, "application/json", bodyReader)
}

// NewResetInstanceRequestWithBody generates requests for ResetInstance with any type of body
func NewResetInstanceRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:reset", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetInstancePasswordRequest generates requests for ResetInstancePassword
func NewResetInstancePasswordRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:reset-password", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResizeInstanceDiskRequest calls the generic ResizeInstanceDisk builder with application/json body
func NewResizeInstanceDiskRequest(server string, id string, body ResizeInstanceDiskJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewResizeInstanceDiskRequestWithBody(server, id, "application/json", bodyReader)
}

// NewResizeInstanceDiskRequestWithBody generates requests for ResizeInstanceDisk with any type of body
func NewResizeInstanceDiskRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:resize-disk", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewScaleInstanceRequest calls the generic ScaleInstance builder with application/json body
func NewScaleInstanceRequest(server string, id string, body ScaleInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewScaleInstanceRequestWithBody(server, id, "application/json", bodyReader)
}

// NewScaleInstanceRequestWithBody generates requests for ScaleInstance with any type of body
func NewScaleInstanceRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:scale", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStartInstanceRequest calls the generic StartInstance builder with application/json body
func NewStartInstanceRequest(server string, id string, body StartInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewStartInstanceRequestWithBody(server, id, "application/json", bodyReader)
}

// NewStartInstanceRequestWithBody generates requests for StartInstance with any type of body
func NewStartInstanceRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:start", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewStopInstanceRequest generates requests for StopInstance
func NewStopInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:stop", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRevertInstanceToSnapshotRequest calls the generic RevertInstanceToSnapshot builder with application/json body
func NewRevertInstanceToSnapshotRequest(server string, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRevertInstanceToSnapshotRequestWithBody(server, instanceId, "application/json", bodyReader)
}

// NewRevertInstanceToSnapshotRequestWithBody generates requests for RevertInstanceToSnapshot with any type of body
func NewRevertInstanceToSnapshotRequestWithBody(server string, instanceId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "instance-id", runtime.ParamLocationPath, instanceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/instance/%s:revert-snapshot", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListLoadBalancersRequest generates requests for ListLoadBalancers
func NewListLoadBalancersRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateLoadBalancerRequest calls the generic CreateLoadBalancer builder with application/json body
func NewCreateLoadBalancerRequest(server string, body CreateLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateLoadBalancerRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateLoadBalancerRequestWithBody generates requests for CreateLoadBalancer with any type of body
func NewCreateLoadBalancerRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteLoadBalancerRequest generates requests for DeleteLoadBalancer
func NewDeleteLoadBalancerRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLoadBalancerRequest generates requests for GetLoadBalancer
func NewGetLoadBalancerRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLoadBalancerRequest calls the generic UpdateLoadBalancer builder with application/json body
func NewUpdateLoadBalancerRequest(server string, id string, body UpdateLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLoadBalancerRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateLoadBalancerRequestWithBody generates requests for UpdateLoadBalancer with any type of body
func NewUpdateLoadBalancerRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewAddServiceToLoadBalancerRequest calls the generic AddServiceToLoadBalancer builder with application/json body
func NewAddServiceToLoadBalancerRequest(server string, id string, body AddServiceToLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAddServiceToLoadBalancerRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAddServiceToLoadBalancerRequestWithBody generates requests for AddServiceToLoadBalancer with any type of body
func NewAddServiceToLoadBalancerRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/service", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteLoadBalancerServiceRequest generates requests for DeleteLoadBalancerService
func NewDeleteLoadBalancerServiceRequest(server string, id string, serviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "service-id", runtime.ParamLocationPath, serviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLoadBalancerServiceRequest generates requests for GetLoadBalancerService
func NewGetLoadBalancerServiceRequest(server string, id string, serviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "service-id", runtime.ParamLocationPath, serviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLoadBalancerServiceRequest calls the generic UpdateLoadBalancerService builder with application/json body
func NewUpdateLoadBalancerServiceRequest(server string, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLoadBalancerServiceRequestWithBody(server, id, serviceId, "application/json", bodyReader)
}

// NewUpdateLoadBalancerServiceRequestWithBody generates requests for UpdateLoadBalancerService with any type of body
func NewUpdateLoadBalancerServiceRequestWithBody(server string, id string, serviceId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "service-id", runtime.ParamLocationPath, serviceId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetLoadBalancerServiceFieldRequest generates requests for ResetLoadBalancerServiceField
func NewResetLoadBalancerServiceFieldRequest(server string, id string, serviceId string, field ResetLoadBalancerServiceFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "service-id", runtime.ParamLocationPath, serviceId)
	if err != nil {
		return nil, err
	}

	var pathParam2 string

	pathParam2, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/service/%s/%s", pathParam0, pathParam1, pathParam2)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetLoadBalancerFieldRequest generates requests for ResetLoadBalancerField
func NewResetLoadBalancerFieldRequest(server string, id string, field ResetLoadBalancerFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/load-balancer/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetOperationRequest generates requests for GetOperation
func NewGetOperationRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/operation/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListPrivateNetworksRequest generates requests for ListPrivateNetworks
func NewListPrivateNetworksRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreatePrivateNetworkRequest calls the generic CreatePrivateNetwork builder with application/json body
func NewCreatePrivateNetworkRequest(server string, body CreatePrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreatePrivateNetworkRequestWithBody(server, "application/json", bodyReader)
}

// NewCreatePrivateNetworkRequestWithBody generates requests for CreatePrivateNetwork with any type of body
func NewCreatePrivateNetworkRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeletePrivateNetworkRequest generates requests for DeletePrivateNetwork
func NewDeletePrivateNetworkRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetPrivateNetworkRequest generates requests for GetPrivateNetwork
func NewGetPrivateNetworkRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdatePrivateNetworkRequest calls the generic UpdatePrivateNetwork builder with application/json body
func NewUpdatePrivateNetworkRequest(server string, id string, body UpdatePrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdatePrivateNetworkRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdatePrivateNetworkRequestWithBody generates requests for UpdatePrivateNetwork with any type of body
func NewUpdatePrivateNetworkRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetPrivateNetworkFieldRequest generates requests for ResetPrivateNetworkField
func NewResetPrivateNetworkFieldRequest(server string, id string, field ResetPrivateNetworkFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAttachInstanceToPrivateNetworkRequest calls the generic AttachInstanceToPrivateNetwork builder with application/json body
func NewAttachInstanceToPrivateNetworkRequest(server string, id string, body AttachInstanceToPrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAttachInstanceToPrivateNetworkRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAttachInstanceToPrivateNetworkRequestWithBody generates requests for AttachInstanceToPrivateNetwork with any type of body
func NewAttachInstanceToPrivateNetworkRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s:attach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDetachInstanceFromPrivateNetworkRequest calls the generic DetachInstanceFromPrivateNetwork builder with application/json body
func NewDetachInstanceFromPrivateNetworkRequest(server string, id string, body DetachInstanceFromPrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewDetachInstanceFromPrivateNetworkRequestWithBody(server, id, "application/json", bodyReader)
}

// NewDetachInstanceFromPrivateNetworkRequestWithBody generates requests for DetachInstanceFromPrivateNetwork with any type of body
func NewDetachInstanceFromPrivateNetworkRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s:detach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdatePrivateNetworkInstanceIpRequest calls the generic UpdatePrivateNetworkInstanceIp builder with application/json body
func NewUpdatePrivateNetworkInstanceIpRequest(server string, id string, body UpdatePrivateNetworkInstanceIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdatePrivateNetworkInstanceIpRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdatePrivateNetworkInstanceIpRequestWithBody generates requests for UpdatePrivateNetworkInstanceIp with any type of body
func NewUpdatePrivateNetworkInstanceIpRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/private-network/%s:update-ip", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListQuotasRequest generates requests for ListQuotas
func NewListQuotasRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/quota")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetQuotaRequest generates requests for GetQuota
func NewGetQuotaRequest(server string, entity string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "entity", runtime.ParamLocationPath, entity)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/quota/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteReverseDnsElasticIpRequest generates requests for DeleteReverseDnsElasticIp
func NewDeleteReverseDnsElasticIpRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetReverseDnsElasticIpRequest generates requests for GetReverseDnsElasticIp
func NewGetReverseDnsElasticIpRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateReverseDnsElasticIpRequest calls the generic UpdateReverseDnsElasticIp builder with application/json body
func NewUpdateReverseDnsElasticIpRequest(server string, id string, body UpdateReverseDnsElasticIpJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateReverseDnsElasticIpRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateReverseDnsElasticIpRequestWithBody generates requests for UpdateReverseDnsElasticIp with any type of body
func NewUpdateReverseDnsElasticIpRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/elastic-ip/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteReverseDnsInstanceRequest generates requests for DeleteReverseDnsInstance
func NewDeleteReverseDnsInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetReverseDnsInstanceRequest generates requests for GetReverseDnsInstance
func NewGetReverseDnsInstanceRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateReverseDnsInstanceRequest calls the generic UpdateReverseDnsInstance builder with application/json body
func NewUpdateReverseDnsInstanceRequest(server string, id string, body UpdateReverseDnsInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateReverseDnsInstanceRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateReverseDnsInstanceRequestWithBody generates requests for UpdateReverseDnsInstance with any type of body
func NewUpdateReverseDnsInstanceRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/reverse-dns/instance/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListSecurityGroupsRequest generates requests for ListSecurityGroups
func NewListSecurityGroupsRequest(server string, params *ListSecurityGroupsParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Visibility != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "visibility", runtime.ParamLocationQuery, *params.Visibility); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSecurityGroupRequest calls the generic CreateSecurityGroup builder with application/json body
func NewCreateSecurityGroupRequest(server string, body CreateSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSecurityGroupRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSecurityGroupRequestWithBody generates requests for CreateSecurityGroup with any type of body
func NewCreateSecurityGroupRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteSecurityGroupRequest generates requests for DeleteSecurityGroup
func NewDeleteSecurityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSecurityGroupRequest generates requests for GetSecurityGroup
func NewGetSecurityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAddRuleToSecurityGroupRequest calls the generic AddRuleToSecurityGroup builder with application/json body
func NewAddRuleToSecurityGroupRequest(server string, id string, body AddRuleToSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAddRuleToSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAddRuleToSecurityGroupRequestWithBody generates requests for AddRuleToSecurityGroup with any type of body
func NewAddRuleToSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s/rules", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteRuleFromSecurityGroupRequest generates requests for DeleteRuleFromSecurityGroup
func NewDeleteRuleFromSecurityGroupRequest(server string, id string, ruleId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "rule-id", runtime.ParamLocationPath, ruleId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s/rules/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAddExternalSourceToSecurityGroupRequest calls the generic AddExternalSourceToSecurityGroup builder with application/json body
func NewAddExternalSourceToSecurityGroupRequest(server string, id string, body AddExternalSourceToSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAddExternalSourceToSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAddExternalSourceToSecurityGroupRequestWithBody generates requests for AddExternalSourceToSecurityGroup with any type of body
func NewAddExternalSourceToSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s:add-source", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewAttachInstanceToSecurityGroupRequest calls the generic AttachInstanceToSecurityGroup builder with application/json body
func NewAttachInstanceToSecurityGroupRequest(server string, id string, body AttachInstanceToSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAttachInstanceToSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAttachInstanceToSecurityGroupRequestWithBody generates requests for AttachInstanceToSecurityGroup with any type of body
func NewAttachInstanceToSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s:attach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDetachInstanceFromSecurityGroupRequest calls the generic DetachInstanceFromSecurityGroup builder with application/json body
func NewDetachInstanceFromSecurityGroupRequest(server string, id string, body DetachInstanceFromSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewDetachInstanceFromSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewDetachInstanceFromSecurityGroupRequestWithBody generates requests for DetachInstanceFromSecurityGroup with any type of body
func NewDetachInstanceFromSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s:detach", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewRemoveExternalSourceFromSecurityGroupRequest calls the generic RemoveExternalSourceFromSecurityGroup builder with application/json body
func NewRemoveExternalSourceFromSecurityGroupRequest(server string, id string, body RemoveExternalSourceFromSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRemoveExternalSourceFromSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewRemoveExternalSourceFromSecurityGroupRequestWithBody generates requests for RemoveExternalSourceFromSecurityGroup with any type of body
func NewRemoveExternalSourceFromSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/security-group/%s:remove-source", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListSksClustersRequest generates requests for ListSksClusters
func NewListSksClustersRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSksClusterRequest calls the generic CreateSksCluster builder with application/json body
func NewCreateSksClusterRequest(server string, body CreateSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSksClusterRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSksClusterRequestWithBody generates requests for CreateSksCluster with any type of body
func NewCreateSksClusterRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListSksClusterDeprecatedResourcesRequest generates requests for ListSksClusterDeprecatedResources
func NewListSksClusterDeprecatedResourcesRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster-deprecated-resources/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGenerateSksClusterKubeconfigRequest calls the generic GenerateSksClusterKubeconfig builder with application/json body
func NewGenerateSksClusterKubeconfigRequest(server string, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewGenerateSksClusterKubeconfigRequestWithBody(server, id, "application/json", bodyReader)
}

// NewGenerateSksClusterKubeconfigRequestWithBody generates requests for GenerateSksClusterKubeconfig with any type of body
func NewGenerateSksClusterKubeconfigRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster-kubeconfig/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListSksClusterVersionsRequest generates requests for ListSksClusterVersions
func NewListSksClusterVersionsRequest(server string, params *ListSksClusterVersionsParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster-version")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.IncludeDeprecated != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "include-deprecated", runtime.ParamLocationQuery, *params.IncludeDeprecated); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteSksClusterRequest generates requests for DeleteSksCluster
func NewDeleteSksClusterRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSksClusterRequest generates requests for GetSksCluster
func NewGetSksClusterRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSksClusterRequest calls the generic UpdateSksCluster builder with application/json body
func NewUpdateSksClusterRequest(server string, id string, body UpdateSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSksClusterRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateSksClusterRequestWithBody generates requests for UpdateSksCluster with any type of body
func NewUpdateSksClusterRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewGetSksClusterAuthorityCertRequest generates requests for GetSksClusterAuthorityCert
func NewGetSksClusterAuthorityCertRequest(server string, id string, authority GetSksClusterAuthorityCertParamsAuthority) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "authority", runtime.ParamLocationPath, authority)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/authority/%s/cert", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSksNodepoolRequest calls the generic CreateSksNodepool builder with application/json body
func NewCreateSksNodepoolRequest(server string, id string, body CreateSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSksNodepoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewCreateSksNodepoolRequestWithBody generates requests for CreateSksNodepool with any type of body
func NewCreateSksNodepoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteSksNodepoolRequest generates requests for DeleteSksNodepool
func NewDeleteSksNodepoolRequest(server string, id string, sksNodepoolId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSksNodepoolRequest generates requests for GetSksNodepool
func NewGetSksNodepoolRequest(server string, id string, sksNodepoolId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSksNodepoolRequest calls the generic UpdateSksNodepool builder with application/json body
func NewUpdateSksNodepoolRequest(server string, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSksNodepoolRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewUpdateSksNodepoolRequestWithBody generates requests for UpdateSksNodepool with any type of body
func NewUpdateSksNodepoolRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewResetSksNodepoolFieldRequest generates requests for ResetSksNodepoolField
func NewResetSksNodepoolFieldRequest(server string, id string, sksNodepoolId string, field ResetSksNodepoolFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	var pathParam2 string

	pathParam2, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s/%s", pathParam0, pathParam1, pathParam2)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewEvictSksNodepoolMembersRequest calls the generic EvictSksNodepoolMembers builder with application/json body
func NewEvictSksNodepoolMembersRequest(server string, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewEvictSksNodepoolMembersRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewEvictSksNodepoolMembersRequestWithBody generates requests for EvictSksNodepoolMembers with any type of body
func NewEvictSksNodepoolMembersRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s:evict", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewScaleSksNodepoolRequest calls the generic ScaleSksNodepool builder with application/json body
func NewScaleSksNodepoolRequest(server string, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewScaleSksNodepoolRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewScaleSksNodepoolRequestWithBody generates requests for ScaleSksNodepool with any type of body
func NewScaleSksNodepoolRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "sks-nodepool-id", runtime.ParamLocationPath, sksNodepoolId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s:scale", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewRotateSksCcmCredentialsRequest generates requests for RotateSksCcmCredentials
func NewRotateSksCcmCredentialsRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/rotate-ccm-credentials", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRotateSksOperatorsCaRequest generates requests for RotateSksOperatorsCa
func NewRotateSksOperatorsCaRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/rotate-operators-ca", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpgradeSksClusterRequest calls the generic UpgradeSksCluster builder with application/json body
func NewUpgradeSksClusterRequest(server string, id string, body UpgradeSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpgradeSksClusterRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpgradeSksClusterRequestWithBody generates requests for UpgradeSksCluster with any type of body
func NewUpgradeSksClusterRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/upgrade", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpgradeSksClusterServiceLevelRequest generates requests for UpgradeSksClusterServiceLevel
func NewUpgradeSksClusterServiceLevelRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/upgrade-service-level", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewResetSksClusterFieldRequest generates requests for ResetSksClusterField
func NewResetSksClusterFieldRequest(server string, id string, field ResetSksClusterFieldParamsField) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "field", runtime.ParamLocationPath, field)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sks-cluster/%s/%s", pathParam0, pathParam1)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListSnapshotsRequest generates requests for ListSnapshots
func NewListSnapshotsRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/snapshot")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteSnapshotRequest generates requests for DeleteSnapshot
func NewDeleteSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/snapshot/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSnapshotRequest generates requests for GetSnapshot
func NewGetSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/snapshot/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewExportSnapshotRequest generates requests for ExportSnapshot
func NewExportSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/snapshot/%s:export", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewPromoteSnapshotToTemplateRequest calls the generic PromoteSnapshotToTemplate builder with application/json body
func NewPromoteSnapshotToTemplateRequest(server string, id string, body PromoteSnapshotToTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPromoteSnapshotToTemplateRequestWithBody(server, id, "application/json", bodyReader)
}

// NewPromoteSnapshotToTemplateRequestWithBody generates requests for PromoteSnapshotToTemplate with any type of body
func NewPromoteSnapshotToTemplateRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/snapshot/%s:promote", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListSosBucketsUsageRequest generates requests for ListSosBucketsUsage
func NewListSosBucketsUsageRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sos-buckets-usage")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSosPresignedUrlRequest generates requests for GetSosPresignedUrl
func NewGetSosPresignedUrlRequest(server string, bucket string, params *GetSosPresignedUrlParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucket", runtime.ParamLocationPath, bucket)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/sos/%s/presigned-url", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Key != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "key", runtime.ParamLocationQuery, *params.Key); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListSshKeysRequest generates requests for ListSshKeys
func NewListSshKeysRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/ssh-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRegisterSshKeyRequest calls the generic RegisterSshKey builder with application/json body
func NewRegisterSshKeyRequest(server string, body RegisterSshKeyJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRegisterSshKeyRequestWithBody(server, "application/json", bodyReader)
}

// NewRegisterSshKeyRequestWithBody generates requests for RegisterSshKey with any type of body
func NewRegisterSshKeyRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/ssh-key")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteSshKeyRequest generates requests for DeleteSshKey
func NewDeleteSshKeyRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/ssh-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSshKeyRequest generates requests for GetSshKey
func NewGetSshKeyRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/ssh-key/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListTemplatesRequest generates requests for ListTemplates
func NewListTemplatesRequest(server string, params *ListTemplatesParams) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Visibility != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "visibility", runtime.ParamLocationQuery, *params.Visibility); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Family != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "family", runtime.ParamLocationQuery, *params.Family); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRegisterTemplateRequest calls the generic RegisterTemplate builder with application/json body
func NewRegisterTemplateRequest(server string, body RegisterTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRegisterTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewRegisterTemplateRequestWithBody generates requests for RegisterTemplate with any type of body
func NewRegisterTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewDeleteTemplateRequest generates requests for DeleteTemplate
func NewDeleteTemplateRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetTemplateRequest generates requests for GetTemplate
func NewGetTemplateRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCopyTemplateRequest calls the generic CopyTemplate builder with application/json body
func NewCopyTemplateRequest(server string, id string, body CopyTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCopyTemplateRequestWithBody(server, id, "application/json", bodyReader)
}

// NewCopyTemplateRequestWithBody generates requests for CopyTemplate with any type of body
func NewCopyTemplateRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewUpdateTemplateRequest calls the generic UpdateTemplate builder with application/json body
func NewUpdateTemplateRequest(server string, id string, body UpdateTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateTemplateRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateTemplateRequestWithBody generates requests for UpdateTemplate with any type of body
func NewUpdateTemplateRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "id", runtime.ParamLocationPath, id)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/template/%s", pathParam0)
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)

	return req, nil
}

// NewListZonesRequest generates requests for ListZones
func NewListZonesRequest(server string) (*http.Request, error) {
	var err error

	serverURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("/zone")
	if operationPath[0] == '/' {
		operationPath = "." + operationPath
	}

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

func (c *Client) applyEditors(ctx context.Context, req *http.Request, additionalEditors []RequestEditorFn) error {
	for _, r := range c.RequestEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	for _, r := range additionalEditors {
		if err := r(ctx, req); err != nil {
			return err
		}
	}
	return nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// ListAccessKeys request
	ListAccessKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeysResponse, error)

	// CreateAccessKey request with any body
	CreateAccessKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateAccessKeyResponse, error)

	CreateAccessKeyWithResponse(ctx context.Context, body CreateAccessKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateAccessKeyResponse, error)

	// ListAccessKeyKnownOperations request
	ListAccessKeyKnownOperationsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeyKnownOperationsResponse, error)

	// ListAccessKeyOperations request
	ListAccessKeyOperationsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeyOperationsResponse, error)

	// RevokeAccessKey request
	RevokeAccessKeyWithResponse(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*RevokeAccessKeyResponse, error)

	// GetAccessKey request
	GetAccessKeyWithResponse(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*GetAccessKeyResponse, error)

	// ListAntiAffinityGroups request
	ListAntiAffinityGroupsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAntiAffinityGroupsResponse, error)

	// CreateAntiAffinityGroup request with any body
	CreateAntiAffinityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateAntiAffinityGroupResponse, error)

	CreateAntiAffinityGroupWithResponse(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateAntiAffinityGroupResponse, error)

	// DeleteAntiAffinityGroup request
	DeleteAntiAffinityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteAntiAffinityGroupResponse, error)

	// GetAntiAffinityGroup request
	GetAntiAffinityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetAntiAffinityGroupResponse, error)

	// ListApiKeys request
	ListApiKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListApiKeysResponse, error)

	// CreateApiKey request with any body
	CreateApiKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateApiKeyResponse, error)

	CreateApiKeyWithResponse(ctx context.Context, body CreateApiKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateApiKeyResponse, error)

	// DeleteApiKey request
	DeleteApiKeyWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteApiKeyResponse, error)

	// GetApiKey request
	GetApiKeyWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetApiKeyResponse, error)

	// GetDbaasCaCertificate request
	GetDbaasCaCertificateWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasCaCertificateResponse, error)

	// DeleteDbaasServiceGrafana request
	DeleteDbaasServiceGrafanaWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceGrafanaResponse, error)

	// GetDbaasServiceGrafana request
	GetDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceGrafanaResponse, error)

	// CreateDbaasServiceGrafana request with any body
	CreateDbaasServiceGrafanaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceGrafanaResponse, error)

	CreateDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceGrafanaResponse, error)

	// UpdateDbaasServiceGrafana request with any body
	UpdateDbaasServiceGrafanaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceGrafanaResponse, error)

	UpdateDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceGrafanaResponse, error)

	// StartDbaasGrafanaMaintenance request
	StartDbaasGrafanaMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasGrafanaMaintenanceResponse, error)

	// CreateDbaasIntegration request with any body
	CreateDbaasIntegrationWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasIntegrationResponse, error)

	CreateDbaasIntegrationWithResponse(ctx context.Context, body CreateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasIntegrationResponse, error)

	// ListDbaasIntegrationSettings request
	ListDbaasIntegrationSettingsWithResponse(ctx context.Context, integrationType string, sourceType string, destType string, reqEditors ...RequestEditorFn) (*ListDbaasIntegrationSettingsResponse, error)

	// ListDbaasIntegrationTypes request
	ListDbaasIntegrationTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasIntegrationTypesResponse, error)

	// DeleteDbaasIntegration request
	DeleteDbaasIntegrationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteDbaasIntegrationResponse, error)

	// GetDbaasIntegration request
	GetDbaasIntegrationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDbaasIntegrationResponse, error)

	// UpdateDbaasIntegration request with any body
	UpdateDbaasIntegrationWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasIntegrationResponse, error)

	UpdateDbaasIntegrationWithResponse(ctx context.Context, id string, body UpdateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasIntegrationResponse, error)

	// DeleteDbaasServiceKafka request
	DeleteDbaasServiceKafkaWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceKafkaResponse, error)

	// GetDbaasServiceKafka request
	GetDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceKafkaResponse, error)

	// CreateDbaasServiceKafka request with any body
	CreateDbaasServiceKafkaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceKafkaResponse, error)

	CreateDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceKafkaResponse, error)

	// UpdateDbaasServiceKafka request with any body
	UpdateDbaasServiceKafkaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceKafkaResponse, error)

	UpdateDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceKafkaResponse, error)

	// GetDbaasKafkaAclConfig request
	GetDbaasKafkaAclConfigWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasKafkaAclConfigResponse, error)

	// StartDbaasKafkaMaintenance request
	StartDbaasKafkaMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasKafkaMaintenanceResponse, error)

	// CreateDbaasKafkaSchemaRegistryAclConfig request with any body
	CreateDbaasKafkaSchemaRegistryAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaSchemaRegistryAclConfigResponse, error)

	CreateDbaasKafkaSchemaRegistryAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaSchemaRegistryAclConfigResponse, error)

	// DeleteDbaasKafkaSchemaRegistryAclConfig request
	DeleteDbaasKafkaSchemaRegistryAclConfigWithResponse(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaSchemaRegistryAclConfigResponse, error)

	// CreateDbaasKafkaTopicAclConfig request with any body
	CreateDbaasKafkaTopicAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaTopicAclConfigResponse, error)

	CreateDbaasKafkaTopicAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaTopicAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaTopicAclConfigResponse, error)

	// DeleteDbaasKafkaTopicAclConfig request
	DeleteDbaasKafkaTopicAclConfigWithResponse(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaTopicAclConfigResponse, error)

	// CreateDbaasKafkaUser request with any body
	CreateDbaasKafkaUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaUserResponse, error)

	CreateDbaasKafkaUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasKafkaUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaUserResponse, error)

	// DeleteDbaasKafkaUser request
	DeleteDbaasKafkaUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaUserResponse, error)

	// ResetDbaasKafkaUserPassword request with any body
	ResetDbaasKafkaUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasKafkaUserPasswordResponse, error)

	ResetDbaasKafkaUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasKafkaUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasKafkaUserPasswordResponse, error)

	// GetDbaasMigrationStatus request
	GetDbaasMigrationStatusWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasMigrationStatusResponse, error)

	// DeleteDbaasServiceMysql request
	DeleteDbaasServiceMysqlWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceMysqlResponse, error)

	// GetDbaasServiceMysql request
	GetDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceMysqlResponse, error)

	// CreateDbaasServiceMysql request with any body
	CreateDbaasServiceMysqlWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceMysqlResponse, error)

	CreateDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceMysqlResponse, error)

	// UpdateDbaasServiceMysql request with any body
	UpdateDbaasServiceMysqlWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceMysqlResponse, error)

	UpdateDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceMysqlResponse, error)

	// StartDbaasMysqlMaintenance request
	StartDbaasMysqlMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasMysqlMaintenanceResponse, error)

	// StopDbaasMysqlMigration request
	StopDbaasMysqlMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasMysqlMigrationResponse, error)

	// CreateDbaasMysqlDatabase request with any body
	CreateDbaasMysqlDatabaseWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlDatabaseResponse, error)

	CreateDbaasMysqlDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlDatabaseResponse, error)

	// DeleteDbaasMysqlDatabase request
	DeleteDbaasMysqlDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasMysqlDatabaseName, reqEditors ...RequestEditorFn) (*DeleteDbaasMysqlDatabaseResponse, error)

	// CreateDbaasMysqlUser request with any body
	CreateDbaasMysqlUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlUserResponse, error)

	CreateDbaasMysqlUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlUserResponse, error)

	// DeleteDbaasMysqlUser request
	DeleteDbaasMysqlUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasMysqlUserResponse, error)

	// ResetDbaasMysqlUserPassword request with any body
	ResetDbaasMysqlUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasMysqlUserPasswordResponse, error)

	ResetDbaasMysqlUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasMysqlUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasMysqlUserPasswordResponse, error)

	// DeleteDbaasServiceOpensearch request
	DeleteDbaasServiceOpensearchWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceOpensearchResponse, error)

	// GetDbaasServiceOpensearch request
	GetDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceOpensearchResponse, error)

	// CreateDbaasServiceOpensearch request with any body
	CreateDbaasServiceOpensearchWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceOpensearchResponse, error)

	CreateDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceOpensearchResponse, error)

	// UpdateDbaasServiceOpensearch request with any body
	UpdateDbaasServiceOpensearchWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceOpensearchResponse, error)

	UpdateDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceOpensearchResponse, error)

	// GetDbaasOpensearchAclConfig request
	GetDbaasOpensearchAclConfigWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasOpensearchAclConfigResponse, error)

	// UpdateDbaasOpensearchAclConfig request with any body
	UpdateDbaasOpensearchAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasOpensearchAclConfigResponse, error)

	UpdateDbaasOpensearchAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasOpensearchAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasOpensearchAclConfigResponse, error)

	// StartDbaasOpensearchMaintenance request
	StartDbaasOpensearchMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasOpensearchMaintenanceResponse, error)

	// CreateDbaasOpensearchUser request with any body
	CreateDbaasOpensearchUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasOpensearchUserResponse, error)

	CreateDbaasOpensearchUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasOpensearchUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasOpensearchUserResponse, error)

	// DeleteDbaasOpensearchUser request
	DeleteDbaasOpensearchUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasOpensearchUserResponse, error)

	// ResetDbaasOpensearchUserPassword request with any body
	ResetDbaasOpensearchUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasOpensearchUserPasswordResponse, error)

	ResetDbaasOpensearchUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasOpensearchUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasOpensearchUserPasswordResponse, error)

	// DeleteDbaasServicePg request
	DeleteDbaasServicePgWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServicePgResponse, error)

	// GetDbaasServicePg request
	GetDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServicePgResponse, error)

	// CreateDbaasServicePg request with any body
	CreateDbaasServicePgWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServicePgResponse, error)

	CreateDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServicePgResponse, error)

	// UpdateDbaasServicePg request with any body
	UpdateDbaasServicePgWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServicePgResponse, error)

	UpdateDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServicePgResponse, error)

	// StartDbaasPgMaintenance request
	StartDbaasPgMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasPgMaintenanceResponse, error)

	// StopDbaasPgMigration request
	StopDbaasPgMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasPgMigrationResponse, error)

	// CreateDbaasPgConnectionPool request with any body
	CreateDbaasPgConnectionPoolWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgConnectionPoolResponse, error)

	CreateDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgConnectionPoolResponse, error)

	// DeleteDbaasPgConnectionPool request
	DeleteDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, reqEditors ...RequestEditorFn) (*DeleteDbaasPgConnectionPoolResponse, error)

	// UpdateDbaasPgConnectionPool request with any body
	UpdateDbaasPgConnectionPoolWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasPgConnectionPoolResponse, error)

	UpdateDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, body UpdateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasPgConnectionPoolResponse, error)

	// CreateDbaasPgDatabase request with any body
	CreateDbaasPgDatabaseWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgDatabaseResponse, error)

	CreateDbaasPgDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgDatabaseResponse, error)

	// DeleteDbaasPgDatabase request
	DeleteDbaasPgDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasPgDatabaseName, reqEditors ...RequestEditorFn) (*DeleteDbaasPgDatabaseResponse, error)

	// CreateDbaasPostgresUser request with any body
	CreateDbaasPostgresUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPostgresUserResponse, error)

	CreateDbaasPostgresUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPostgresUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPostgresUserResponse, error)

	// DeleteDbaasPostgresUser request
	DeleteDbaasPostgresUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasPostgresUserResponse, error)

	// UpdateDbaasPostgresAllowReplication request with any body
	UpdateDbaasPostgresAllowReplicationWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasPostgresAllowReplicationResponse, error)

	UpdateDbaasPostgresAllowReplicationWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body UpdateDbaasPostgresAllowReplicationJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasPostgresAllowReplicationResponse, error)

	// ResetDbaasPostgresUserPassword request with any body
	ResetDbaasPostgresUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasPostgresUserPasswordResponse, error)

	ResetDbaasPostgresUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasPostgresUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasPostgresUserPasswordResponse, error)

	// CreateDbaasPgUpgradeCheck request with any body
	CreateDbaasPgUpgradeCheckWithBodyWithResponse(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgUpgradeCheckResponse, error)

	CreateDbaasPgUpgradeCheckWithResponse(ctx context.Context, service DbaasServiceName, body CreateDbaasPgUpgradeCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgUpgradeCheckResponse, error)

	// DeleteDbaasServiceRedis request
	DeleteDbaasServiceRedisWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceRedisResponse, error)

	// GetDbaasServiceRedis request
	GetDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceRedisResponse, error)

	// CreateDbaasServiceRedis request with any body
	CreateDbaasServiceRedisWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceRedisResponse, error)

	CreateDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceRedisResponse, error)

	// UpdateDbaasServiceRedis request with any body
	UpdateDbaasServiceRedisWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceRedisResponse, error)

	UpdateDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceRedisResponse, error)

	// StartDbaasRedisMaintenance request
	StartDbaasRedisMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasRedisMaintenanceResponse, error)

	// StopDbaasRedisMigration request
	StopDbaasRedisMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasRedisMigrationResponse, error)

	// ListDbaasServices request
	ListDbaasServicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasServicesResponse, error)

	// GetDbaasServiceLogs request with any body
	GetDbaasServiceLogsWithBodyWithResponse(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GetDbaasServiceLogsResponse, error)

	GetDbaasServiceLogsWithResponse(ctx context.Context, serviceName string, body GetDbaasServiceLogsJSONRequestBody, reqEditors ...RequestEditorFn) (*GetDbaasServiceLogsResponse, error)

	// GetDbaasServiceMetrics request with any body
	GetDbaasServiceMetricsWithBodyWithResponse(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GetDbaasServiceMetricsResponse, error)

	GetDbaasServiceMetricsWithResponse(ctx context.Context, serviceName string, body GetDbaasServiceMetricsJSONRequestBody, reqEditors ...RequestEditorFn) (*GetDbaasServiceMetricsResponse, error)

	// ListDbaasServiceTypes request
	ListDbaasServiceTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasServiceTypesResponse, error)

	// GetDbaasServiceType request
	GetDbaasServiceTypeWithResponse(ctx context.Context, serviceTypeName string, reqEditors ...RequestEditorFn) (*GetDbaasServiceTypeResponse, error)

	// DeleteDbaasService request
	DeleteDbaasServiceWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceResponse, error)

	// GetDbaasSettingsGrafana request
	GetDbaasSettingsGrafanaWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsGrafanaResponse, error)

	// GetDbaasSettingsKafka request
	GetDbaasSettingsKafkaWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsKafkaResponse, error)

	// GetDbaasSettingsMysql request
	GetDbaasSettingsMysqlWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsMysqlResponse, error)

	// GetDbaasSettingsOpensearch request
	GetDbaasSettingsOpensearchWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsOpensearchResponse, error)

	// GetDbaasSettingsPg request
	GetDbaasSettingsPgWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsPgResponse, error)

	// GetDbaasSettingsRedis request
	GetDbaasSettingsRedisWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsRedisResponse, error)

	// CreateDbaasTaskMigrationCheck request with any body
	CreateDbaasTaskMigrationCheckWithBodyWithResponse(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasTaskMigrationCheckResponse, error)

	CreateDbaasTaskMigrationCheckWithResponse(ctx context.Context, service DbaasServiceName, body CreateDbaasTaskMigrationCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasTaskMigrationCheckResponse, error)

	// GetDbaasTask request
	GetDbaasTaskWithResponse(ctx context.Context, service DbaasServiceName, id string, reqEditors ...RequestEditorFn) (*GetDbaasTaskResponse, error)

	// ListDeployTargets request
	ListDeployTargetsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDeployTargetsResponse, error)

	// GetDeployTarget request
	GetDeployTargetWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDeployTargetResponse, error)

	// ListDnsDomains request
	ListDnsDomainsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDnsDomainsResponse, error)

	// CreateDnsDomain request with any body
	CreateDnsDomainWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDnsDomainResponse, error)

	CreateDnsDomainWithResponse(ctx context.Context, body CreateDnsDomainJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDnsDomainResponse, error)

	// ListDnsDomainRecords request
	ListDnsDomainRecordsWithResponse(ctx context.Context, domainId string, reqEditors ...RequestEditorFn) (*ListDnsDomainRecordsResponse, error)

	// CreateDnsDomainRecord request with any body
	CreateDnsDomainRecordWithBodyWithResponse(ctx context.Context, domainId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDnsDomainRecordResponse, error)

	CreateDnsDomainRecordWithResponse(ctx context.Context, domainId string, body CreateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDnsDomainRecordResponse, error)

	// DeleteDnsDomainRecord request
	DeleteDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*DeleteDnsDomainRecordResponse, error)

	// GetDnsDomainRecord request
	GetDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*GetDnsDomainRecordResponse, error)

	// UpdateDnsDomainRecord request with any body
	UpdateDnsDomainRecordWithBodyWithResponse(ctx context.Context, domainId string, recordId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDnsDomainRecordResponse, error)

	UpdateDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, body UpdateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDnsDomainRecordResponse, error)

	// DeleteDnsDomain request
	DeleteDnsDomainWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteDnsDomainResponse, error)

	// GetDnsDomain request
	GetDnsDomainWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDnsDomainResponse, error)

	// GetDnsDomainZoneFile request
	GetDnsDomainZoneFileWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDnsDomainZoneFileResponse, error)

	// ListElasticIps request
	ListElasticIpsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListElasticIpsResponse, error)

	// CreateElasticIp request with any body
	CreateElasticIpWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateElasticIpResponse, error)

	CreateElasticIpWithResponse(ctx context.Context, body CreateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateElasticIpResponse, error)

	// DeleteElasticIp request
	DeleteElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteElasticIpResponse, error)

	// GetElasticIp request
	GetElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetElasticIpResponse, error)

	// UpdateElasticIp request with any body
	UpdateElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateElasticIpResponse, error)

	UpdateElasticIpWithResponse(ctx context.Context, id string, body UpdateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateElasticIpResponse, error)

	// ResetElasticIpField request
	ResetElasticIpFieldWithResponse(ctx context.Context, id string, field ResetElasticIpFieldParamsField, reqEditors ...RequestEditorFn) (*ResetElasticIpFieldResponse, error)

	// AttachInstanceToElasticIp request with any body
	AttachInstanceToElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToElasticIpResponse, error)

	AttachInstanceToElasticIpWithResponse(ctx context.Context, id string, body AttachInstanceToElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToElasticIpResponse, error)

	// DetachInstanceFromElasticIp request with any body
	DetachInstanceFromElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromElasticIpResponse, error)

	DetachInstanceFromElasticIpWithResponse(ctx context.Context, id string, body DetachInstanceFromElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromElasticIpResponse, error)

	// ListEvents request
	ListEventsWithResponse(ctx context.Context, params *ListEventsParams, reqEditors ...RequestEditorFn) (*ListEventsResponse, error)

	// GetIamOrganizationPolicy request
	GetIamOrganizationPolicyWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetIamOrganizationPolicyResponse, error)

	// UpdateIamOrganizationPolicy request with any body
	UpdateIamOrganizationPolicyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamOrganizationPolicyResponse, error)

	UpdateIamOrganizationPolicyWithResponse(ctx context.Context, body UpdateIamOrganizationPolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamOrganizationPolicyResponse, error)

	// ListIamRoles request
	ListIamRolesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListIamRolesResponse, error)

	// CreateIamRole request with any body
	CreateIamRoleWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateIamRoleResponse, error)

	CreateIamRoleWithResponse(ctx context.Context, body CreateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateIamRoleResponse, error)

	// DeleteIamRole request
	DeleteIamRoleWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteIamRoleResponse, error)

	// GetIamRole request
	GetIamRoleWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetIamRoleResponse, error)

	// UpdateIamRole request with any body
	UpdateIamRoleWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamRoleResponse, error)

	UpdateIamRoleWithResponse(ctx context.Context, id string, body UpdateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamRoleResponse, error)

	// UpdateIamRolePolicy request with any body
	UpdateIamRolePolicyWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamRolePolicyResponse, error)

	UpdateIamRolePolicyWithResponse(ctx context.Context, id string, body UpdateIamRolePolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamRolePolicyResponse, error)

	// ListInstances request
	ListInstancesWithResponse(ctx context.Context, params *ListInstancesParams, reqEditors ...RequestEditorFn) (*ListInstancesResponse, error)

	// CreateInstance request with any body
	CreateInstanceWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateInstanceResponse, error)

	CreateInstanceWithResponse(ctx context.Context, body CreateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateInstanceResponse, error)

	// ListInstancePools request
	ListInstancePoolsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListInstancePoolsResponse, error)

	// CreateInstancePool request with any body
	CreateInstancePoolWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateInstancePoolResponse, error)

	CreateInstancePoolWithResponse(ctx context.Context, body CreateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateInstancePoolResponse, error)

	// DeleteInstancePool request
	DeleteInstancePoolWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteInstancePoolResponse, error)

	// GetInstancePool request
	GetInstancePoolWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstancePoolResponse, error)

	// UpdateInstancePool request with any body
	UpdateInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateInstancePoolResponse, error)

	UpdateInstancePoolWithResponse(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateInstancePoolResponse, error)

	// ResetInstancePoolField request
	ResetInstancePoolFieldWithResponse(ctx context.Context, id string, field ResetInstancePoolFieldParamsField, reqEditors ...RequestEditorFn) (*ResetInstancePoolFieldResponse, error)

	// EvictInstancePoolMembers request with any body
	EvictInstancePoolMembersWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*EvictInstancePoolMembersResponse, error)

	EvictInstancePoolMembersWithResponse(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*EvictInstancePoolMembersResponse, error)

	// ScaleInstancePool request with any body
	ScaleInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleInstancePoolResponse, error)

	ScaleInstancePoolWithResponse(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleInstancePoolResponse, error)

	// ListInstanceTypes request
	ListInstanceTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListInstanceTypesResponse, error)

	// GetInstanceType request
	GetInstanceTypeWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstanceTypeResponse, error)

	// DeleteInstance request
	DeleteInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteInstanceResponse, error)

	// GetInstance request
	GetInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstanceResponse, error)

	// UpdateInstance request with any body
	UpdateInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateInstanceResponse, error)

	UpdateInstanceWithResponse(ctx context.Context, id string, body UpdateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateInstanceResponse, error)

	// ResetInstanceField request
	ResetInstanceFieldWithResponse(ctx context.Context, id string, field ResetInstanceFieldParamsField, reqEditors ...RequestEditorFn) (*ResetInstanceFieldResponse, error)

	// AddInstanceProtection request
	AddInstanceProtectionWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*AddInstanceProtectionResponse, error)

	// CreateSnapshot request
	CreateSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*CreateSnapshotResponse, error)

	// RevealInstancePassword request
	RevealInstancePasswordWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RevealInstancePasswordResponse, error)

	// RebootInstance request
	RebootInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RebootInstanceResponse, error)

	// RemoveInstanceProtection request
	RemoveInstanceProtectionWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RemoveInstanceProtectionResponse, error)

	// ResetInstance request with any body
	ResetInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetInstanceResponse, error)

	ResetInstanceWithResponse(ctx context.Context, id string, body ResetInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetInstanceResponse, error)

	// ResetInstancePassword request
	ResetInstancePasswordWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ResetInstancePasswordResponse, error)

	// ResizeInstanceDisk request with any body
	ResizeInstanceDiskWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResizeInstanceDiskResponse, error)

	ResizeInstanceDiskWithResponse(ctx context.Context, id string, body ResizeInstanceDiskJSONRequestBody, reqEditors ...RequestEditorFn) (*ResizeInstanceDiskResponse, error)

	// ScaleInstance request with any body
	ScaleInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleInstanceResponse, error)

	ScaleInstanceWithResponse(ctx context.Context, id string, body ScaleInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleInstanceResponse, error)

	// StartInstance request with any body
	StartInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*StartInstanceResponse, error)

	StartInstanceWithResponse(ctx context.Context, id string, body StartInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*StartInstanceResponse, error)

	// StopInstance request
	StopInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*StopInstanceResponse, error)

	// RevertInstanceToSnapshot request with any body
	RevertInstanceToSnapshotWithBodyWithResponse(ctx context.Context, instanceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RevertInstanceToSnapshotResponse, error)

	RevertInstanceToSnapshotWithResponse(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody, reqEditors ...RequestEditorFn) (*RevertInstanceToSnapshotResponse, error)

	// ListLoadBalancers request
	ListLoadBalancersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListLoadBalancersResponse, error)

	// CreateLoadBalancer request with any body
	CreateLoadBalancerWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateLoadBalancerResponse, error)

	CreateLoadBalancerWithResponse(ctx context.Context, body CreateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateLoadBalancerResponse, error)

	// DeleteLoadBalancer request
	DeleteLoadBalancerWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteLoadBalancerResponse, error)

	// GetLoadBalancer request
	GetLoadBalancerWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetLoadBalancerResponse, error)

	// UpdateLoadBalancer request with any body
	UpdateLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerResponse, error)

	UpdateLoadBalancerWithResponse(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerResponse, error)

	// AddServiceToLoadBalancer request with any body
	AddServiceToLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddServiceToLoadBalancerResponse, error)

	AddServiceToLoadBalancerWithResponse(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*AddServiceToLoadBalancerResponse, error)

	// DeleteLoadBalancerService request
	DeleteLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*DeleteLoadBalancerServiceResponse, error)

	// GetLoadBalancerService request
	GetLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*GetLoadBalancerServiceResponse, error)

	// UpdateLoadBalancerService request with any body
	UpdateLoadBalancerServiceWithBodyWithResponse(ctx context.Context, id string, serviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerServiceResponse, error)

	UpdateLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerServiceResponse, error)

	// ResetLoadBalancerServiceField request
	ResetLoadBalancerServiceFieldWithResponse(ctx context.Context, id string, serviceId string, field ResetLoadBalancerServiceFieldParamsField, reqEditors ...RequestEditorFn) (*ResetLoadBalancerServiceFieldResponse, error)

	// ResetLoadBalancerField request
	ResetLoadBalancerFieldWithResponse(ctx context.Context, id string, field ResetLoadBalancerFieldParamsField, reqEditors ...RequestEditorFn) (*ResetLoadBalancerFieldResponse, error)

	// GetOperation request
	GetOperationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetOperationResponse, error)

	// ListPrivateNetworks request
	ListPrivateNetworksWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListPrivateNetworksResponse, error)

	// CreatePrivateNetwork request with any body
	CreatePrivateNetworkWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreatePrivateNetworkResponse, error)

	CreatePrivateNetworkWithResponse(ctx context.Context, body CreatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*CreatePrivateNetworkResponse, error)

	// DeletePrivateNetwork request
	DeletePrivateNetworkWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeletePrivateNetworkResponse, error)

	// GetPrivateNetwork request
	GetPrivateNetworkWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetPrivateNetworkResponse, error)

	// UpdatePrivateNetwork request with any body
	UpdatePrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkResponse, error)

	UpdatePrivateNetworkWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkResponse, error)

	// ResetPrivateNetworkField request
	ResetPrivateNetworkFieldWithResponse(ctx context.Context, id string, field ResetPrivateNetworkFieldParamsField, reqEditors ...RequestEditorFn) (*ResetPrivateNetworkFieldResponse, error)

	// AttachInstanceToPrivateNetwork request with any body
	AttachInstanceToPrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToPrivateNetworkResponse, error)

	AttachInstanceToPrivateNetworkWithResponse(ctx context.Context, id string, body AttachInstanceToPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToPrivateNetworkResponse, error)

	// DetachInstanceFromPrivateNetwork request with any body
	DetachInstanceFromPrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromPrivateNetworkResponse, error)

	DetachInstanceFromPrivateNetworkWithResponse(ctx context.Context, id string, body DetachInstanceFromPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromPrivateNetworkResponse, error)

	// UpdatePrivateNetworkInstanceIp request with any body
	UpdatePrivateNetworkInstanceIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkInstanceIpResponse, error)

	UpdatePrivateNetworkInstanceIpWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkInstanceIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkInstanceIpResponse, error)

	// ListQuotas request
	ListQuotasWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListQuotasResponse, error)

	// GetQuota request
	GetQuotaWithResponse(ctx context.Context, entity string, reqEditors ...RequestEditorFn) (*GetQuotaResponse, error)

	// DeleteReverseDnsElasticIp request
	DeleteReverseDnsElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteReverseDnsElasticIpResponse, error)

	// GetReverseDnsElasticIp request
	GetReverseDnsElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetReverseDnsElasticIpResponse, error)

	// UpdateReverseDnsElasticIp request with any body
	UpdateReverseDnsElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateReverseDnsElasticIpResponse, error)

	UpdateReverseDnsElasticIpWithResponse(ctx context.Context, id string, body UpdateReverseDnsElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateReverseDnsElasticIpResponse, error)

	// DeleteReverseDnsInstance request
	DeleteReverseDnsInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteReverseDnsInstanceResponse, error)

	// GetReverseDnsInstance request
	GetReverseDnsInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetReverseDnsInstanceResponse, error)

	// UpdateReverseDnsInstance request with any body
	UpdateReverseDnsInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateReverseDnsInstanceResponse, error)

	UpdateReverseDnsInstanceWithResponse(ctx context.Context, id string, body UpdateReverseDnsInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateReverseDnsInstanceResponse, error)

	// ListSecurityGroups request
	ListSecurityGroupsWithResponse(ctx context.Context, params *ListSecurityGroupsParams, reqEditors ...RequestEditorFn) (*ListSecurityGroupsResponse, error)

	// CreateSecurityGroup request with any body
	CreateSecurityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSecurityGroupResponse, error)

	CreateSecurityGroupWithResponse(ctx context.Context, body CreateSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSecurityGroupResponse, error)

	// DeleteSecurityGroup request
	DeleteSecurityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSecurityGroupResponse, error)

	// GetSecurityGroup request
	GetSecurityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSecurityGroupResponse, error)

	// AddRuleToSecurityGroup request with any body
	AddRuleToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddRuleToSecurityGroupResponse, error)

	AddRuleToSecurityGroupWithResponse(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AddRuleToSecurityGroupResponse, error)

	// DeleteRuleFromSecurityGroup request
	DeleteRuleFromSecurityGroupWithResponse(ctx context.Context, id string, ruleId string, reqEditors ...RequestEditorFn) (*DeleteRuleFromSecurityGroupResponse, error)

	// AddExternalSourceToSecurityGroup request with any body
	AddExternalSourceToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddExternalSourceToSecurityGroupResponse, error)

	AddExternalSourceToSecurityGroupWithResponse(ctx context.Context, id string, body AddExternalSourceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AddExternalSourceToSecurityGroupResponse, error)

	// AttachInstanceToSecurityGroup request with any body
	AttachInstanceToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToSecurityGroupResponse, error)

	AttachInstanceToSecurityGroupWithResponse(ctx context.Context, id string, body AttachInstanceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToSecurityGroupResponse, error)

	// DetachInstanceFromSecurityGroup request with any body
	DetachInstanceFromSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromSecurityGroupResponse, error)

	DetachInstanceFromSecurityGroupWithResponse(ctx context.Context, id string, body DetachInstanceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromSecurityGroupResponse, error)

	// RemoveExternalSourceFromSecurityGroup request with any body
	RemoveExternalSourceFromSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RemoveExternalSourceFromSecurityGroupResponse, error)

	RemoveExternalSourceFromSecurityGroupWithResponse(ctx context.Context, id string, body RemoveExternalSourceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*RemoveExternalSourceFromSecurityGroupResponse, error)

	// ListSksClusters request
	ListSksClustersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSksClustersResponse, error)

	// CreateSksCluster request with any body
	CreateSksClusterWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSksClusterResponse, error)

	CreateSksClusterWithResponse(ctx context.Context, body CreateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSksClusterResponse, error)

	// ListSksClusterDeprecatedResources request
	ListSksClusterDeprecatedResourcesWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ListSksClusterDeprecatedResourcesResponse, error)

	// GenerateSksClusterKubeconfig request with any body
	GenerateSksClusterKubeconfigWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GenerateSksClusterKubeconfigResponse, error)

	GenerateSksClusterKubeconfigWithResponse(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody, reqEditors ...RequestEditorFn) (*GenerateSksClusterKubeconfigResponse, error)

	// ListSksClusterVersions request
	ListSksClusterVersionsWithResponse(ctx context.Context, params *ListSksClusterVersionsParams, reqEditors ...RequestEditorFn) (*ListSksClusterVersionsResponse, error)

	// DeleteSksCluster request
	DeleteSksClusterWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSksClusterResponse, error)

	// GetSksCluster request
	GetSksClusterWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSksClusterResponse, error)

	// UpdateSksCluster request with any body
	UpdateSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSksClusterResponse, error)

	UpdateSksClusterWithResponse(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSksClusterResponse, error)

	// GetSksClusterAuthorityCert request
	GetSksClusterAuthorityCertWithResponse(ctx context.Context, id string, authority GetSksClusterAuthorityCertParamsAuthority, reqEditors ...RequestEditorFn) (*GetSksClusterAuthorityCertResponse, error)

	// CreateSksNodepool request with any body
	CreateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSksNodepoolResponse, error)

	CreateSksNodepoolWithResponse(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSksNodepoolResponse, error)

	// DeleteSksNodepool request
	DeleteSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*DeleteSksNodepoolResponse, error)

	// GetSksNodepool request
	GetSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*GetSksNodepoolResponse, error)

	// UpdateSksNodepool request with any body
	UpdateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSksNodepoolResponse, error)

	UpdateSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSksNodepoolResponse, error)

	// ResetSksNodepoolField request
	ResetSksNodepoolFieldWithResponse(ctx context.Context, id string, sksNodepoolId string, field ResetSksNodepoolFieldParamsField, reqEditors ...RequestEditorFn) (*ResetSksNodepoolFieldResponse, error)

	// EvictSksNodepoolMembers request with any body
	EvictSksNodepoolMembersWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*EvictSksNodepoolMembersResponse, error)

	EvictSksNodepoolMembersWithResponse(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*EvictSksNodepoolMembersResponse, error)

	// ScaleSksNodepool request with any body
	ScaleSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleSksNodepoolResponse, error)

	ScaleSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleSksNodepoolResponse, error)

	// RotateSksCcmCredentials request
	RotateSksCcmCredentialsWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RotateSksCcmCredentialsResponse, error)

	// RotateSksOperatorsCa request
	RotateSksOperatorsCaWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RotateSksOperatorsCaResponse, error)

	// UpgradeSksCluster request with any body
	UpgradeSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpgradeSksClusterResponse, error)

	UpgradeSksClusterWithResponse(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*UpgradeSksClusterResponse, error)

	// UpgradeSksClusterServiceLevel request
	UpgradeSksClusterServiceLevelWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*UpgradeSksClusterServiceLevelResponse, error)

	// ResetSksClusterField request
	ResetSksClusterFieldWithResponse(ctx context.Context, id string, field ResetSksClusterFieldParamsField, reqEditors ...RequestEditorFn) (*ResetSksClusterFieldResponse, error)

	// ListSnapshots request
	ListSnapshotsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSnapshotsResponse, error)

	// DeleteSnapshot request
	DeleteSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSnapshotResponse, error)

	// GetSnapshot request
	GetSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSnapshotResponse, error)

	// ExportSnapshot request
	ExportSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ExportSnapshotResponse, error)

	// PromoteSnapshotToTemplate request with any body
	PromoteSnapshotToTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*PromoteSnapshotToTemplateResponse, error)

	PromoteSnapshotToTemplateWithResponse(ctx context.Context, id string, body PromoteSnapshotToTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*PromoteSnapshotToTemplateResponse, error)

	// ListSosBucketsUsage request
	ListSosBucketsUsageWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSosBucketsUsageResponse, error)

	// GetSosPresignedUrl request
	GetSosPresignedUrlWithResponse(ctx context.Context, bucket string, params *GetSosPresignedUrlParams, reqEditors ...RequestEditorFn) (*GetSosPresignedUrlResponse, error)

	// ListSshKeys request
	ListSshKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSshKeysResponse, error)

	// RegisterSshKey request with any body
	RegisterSshKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RegisterSshKeyResponse, error)

	RegisterSshKeyWithResponse(ctx context.Context, body RegisterSshKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*RegisterSshKeyResponse, error)

	// DeleteSshKey request
	DeleteSshKeyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteSshKeyResponse, error)

	// GetSshKey request
	GetSshKeyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*GetSshKeyResponse, error)

	// ListTemplates request
	ListTemplatesWithResponse(ctx context.Context, params *ListTemplatesParams, reqEditors ...RequestEditorFn) (*ListTemplatesResponse, error)

	// RegisterTemplate request with any body
	RegisterTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RegisterTemplateResponse, error)

	RegisterTemplateWithResponse(ctx context.Context, body RegisterTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*RegisterTemplateResponse, error)

	// DeleteTemplate request
	DeleteTemplateWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteTemplateResponse, error)

	// GetTemplate request
	GetTemplateWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetTemplateResponse, error)

	// CopyTemplate request with any body
	CopyTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CopyTemplateResponse, error)

	CopyTemplateWithResponse(ctx context.Context, id string, body CopyTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*CopyTemplateResponse, error)

	// UpdateTemplate request with any body
	UpdateTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateTemplateResponse, error)

	UpdateTemplateWithResponse(ctx context.Context, id string, body UpdateTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateTemplateResponse, error)

	// ListZones request
	ListZonesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListZonesResponse, error)
}

type ListAccessKeysResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		AccessKeys *[]AccessKey `json:"access-keys,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListAccessKeysResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListAccessKeysResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateAccessKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AccessKey
}

// Status returns HTTPResponse.Status
func (r CreateAccessKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateAccessKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListAccessKeyKnownOperationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		AccessKeyOperations *[]AccessKeyOperation `json:"access-key-operations,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListAccessKeyKnownOperationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListAccessKeyKnownOperationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListAccessKeyOperationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		AccessKeyOperations *[]AccessKeyOperation `json:"access-key-operations,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListAccessKeyOperationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListAccessKeyOperationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RevokeAccessKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RevokeAccessKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RevokeAccessKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetAccessKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AccessKey
}

// Status returns HTTPResponse.Status
func (r GetAccessKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetAccessKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListAntiAffinityGroupsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListAntiAffinityGroupsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListAntiAffinityGroupsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AntiAffinityGroup
}

// Status returns HTTPResponse.Status
func (r GetAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListApiKeysResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		ApiKeys *[]IamApiKey `json:"api-keys,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListApiKeysResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListApiKeysResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateApiKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IamApiKeyCreated
}

// Status returns HTTPResponse.Status
func (r CreateApiKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateApiKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteApiKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteApiKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteApiKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetApiKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IamApiKey
}

// Status returns HTTPResponse.Status
func (r GetApiKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetApiKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasCaCertificateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Certificate *string `json:"certificate,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasCaCertificateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasCaCertificateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceGrafanaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceGrafanaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceGrafanaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceGrafanaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceGrafana
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceGrafanaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceGrafanaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServiceGrafanaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServiceGrafanaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServiceGrafanaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServiceGrafanaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServiceGrafanaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServiceGrafanaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasGrafanaMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasGrafanaMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasGrafanaMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasIntegrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasIntegrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasIntegrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDbaasIntegrationSettingsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		// The JSON schema representing the settings for the given integration type, source, and destination service types.
		Settings *struct {
			AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
			Properties           *map[string]interface{} `json:"properties,omitempty"`
			Title                *string                 `json:"title,omitempty"`
			Type                 *string                 `json:"type,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDbaasIntegrationSettingsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDbaasIntegrationSettingsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDbaasIntegrationTypesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DbaasIntegrationTypes *[]DbaasIntegrationType `json:"dbaas-integration-types,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDbaasIntegrationTypesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDbaasIntegrationTypesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasIntegrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasIntegrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasIntegrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasIntegrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasIntegration
}

// Status returns HTTPResponse.Status
func (r GetDbaasIntegrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasIntegrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasIntegrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasIntegrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasIntegrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceKafkaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceKafkaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceKafkaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceKafkaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceKafka
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceKafkaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceKafkaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServiceKafkaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServiceKafkaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServiceKafkaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServiceKafkaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServiceKafkaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServiceKafkaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasKafkaAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasKafkaAcls
}

// Status returns HTTPResponse.Status
func (r GetDbaasKafkaAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasKafkaAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasKafkaMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasKafkaMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasKafkaMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasKafkaSchemaRegistryAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasKafkaSchemaRegistryAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasKafkaSchemaRegistryAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasKafkaSchemaRegistryAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasKafkaSchemaRegistryAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasKafkaSchemaRegistryAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasKafkaTopicAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasKafkaTopicAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasKafkaTopicAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasKafkaTopicAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasKafkaTopicAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasKafkaTopicAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasKafkaUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasKafkaUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasKafkaUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasKafkaUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasKafkaUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasKafkaUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetDbaasKafkaUserPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetDbaasKafkaUserPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetDbaasKafkaUserPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasMigrationStatusResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasMigrationStatus
}

// Status returns HTTPResponse.Status
func (r GetDbaasMigrationStatusResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasMigrationStatusResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceMysqlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceMysqlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceMysqlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceMysqlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceMysql
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceMysqlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceMysqlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServiceMysqlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServiceMysqlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServiceMysqlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServiceMysqlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServiceMysqlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServiceMysqlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasMysqlMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasMysqlMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasMysqlMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StopDbaasMysqlMigrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StopDbaasMysqlMigrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StopDbaasMysqlMigrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasMysqlDatabaseResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasMysqlDatabaseResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasMysqlDatabaseResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasMysqlDatabaseResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasMysqlDatabaseResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasMysqlDatabaseResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasMysqlUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasMysqlUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasMysqlUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasMysqlUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasMysqlUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasMysqlUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetDbaasMysqlUserPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetDbaasMysqlUserPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetDbaasMysqlUserPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceOpensearchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceOpensearchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceOpensearchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceOpensearchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceOpensearch
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceOpensearchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceOpensearchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServiceOpensearchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServiceOpensearchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServiceOpensearchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServiceOpensearchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServiceOpensearchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServiceOpensearchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasOpensearchAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasOpensearchAclConfig
}

// Status returns HTTPResponse.Status
func (r GetDbaasOpensearchAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasOpensearchAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasOpensearchAclConfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasOpensearchAclConfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasOpensearchAclConfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasOpensearchMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasOpensearchMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasOpensearchMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasOpensearchUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasOpensearchUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasOpensearchUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasOpensearchUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasOpensearchUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasOpensearchUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetDbaasOpensearchUserPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetDbaasOpensearchUserPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetDbaasOpensearchUserPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServicePgResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServicePgResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServicePgResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServicePgResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServicePg
}

// Status returns HTTPResponse.Status
func (r GetDbaasServicePgResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServicePgResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServicePgResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServicePgResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServicePgResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServicePgResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServicePgResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServicePgResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasPgMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasPgMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasPgMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StopDbaasPgMigrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StopDbaasPgMigrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StopDbaasPgMigrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasPgConnectionPoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasPgConnectionPoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasPgConnectionPoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasPgConnectionPoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasPgConnectionPoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasPgConnectionPoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasPgConnectionPoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasPgConnectionPoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasPgConnectionPoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasPgDatabaseResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasPgDatabaseResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasPgDatabaseResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasPgDatabaseResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasPgDatabaseResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasPgDatabaseResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasPostgresUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasPostgresUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasPostgresUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasPostgresUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasPostgresUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasPostgresUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasPostgresAllowReplicationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasPostgresUsers
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasPostgresAllowReplicationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasPostgresAllowReplicationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetDbaasPostgresUserPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetDbaasPostgresUserPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetDbaasPostgresUserPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasPgUpgradeCheckResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasTask
}

// Status returns HTTPResponse.Status
func (r CreateDbaasPgUpgradeCheckResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasPgUpgradeCheckResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceRedisResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceRedisResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceRedisResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceRedisResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceRedis
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceRedisResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceRedisResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasServiceRedisResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasServiceRedisResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasServiceRedisResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDbaasServiceRedisResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDbaasServiceRedisResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDbaasServiceRedisResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartDbaasRedisMaintenanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartDbaasRedisMaintenanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartDbaasRedisMaintenanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StopDbaasRedisMigrationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StopDbaasRedisMigrationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StopDbaasRedisMigrationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDbaasServicesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DbaasServices *[]DbaasServiceCommon `json:"dbaas-services,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDbaasServicesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDbaasServicesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceLogsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceLogs
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceLogsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceLogsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceMetricsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Metrics *map[string]interface{} `json:"metrics,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceMetricsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceMetricsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDbaasServiceTypesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DbaasServiceTypes *[]DbaasServiceType `json:"dbaas-service-types,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDbaasServiceTypesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDbaasServiceTypesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasServiceTypeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasServiceType
}

// Status returns HTTPResponse.Status
func (r GetDbaasServiceTypeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasServiceTypeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDbaasServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDbaasServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDbaasServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsGrafanaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// Grafana configuration values
			Grafana *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"grafana,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsGrafanaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsGrafanaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsKafkaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// Kafka broker configuration values
			Kafka *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"kafka,omitempty"`

			// Kafka Connect configuration values
			KafkaConnect *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"kafka-connect,omitempty"`

			// Kafka REST configuration
			KafkaRest *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"kafka-rest,omitempty"`

			// Schema Registry configuration
			SchemaRegistry *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"schema-registry,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsKafkaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsKafkaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsMysqlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// mysql.conf configuration values
			Mysql *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"mysql,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsMysqlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsMysqlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsOpensearchResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// OpenSearch configuration values
			Opensearch *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"opensearch,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsOpensearchResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsOpensearchResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsPgResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// postgresql.conf configuration values
			Pg *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"pg,omitempty"`

			// PGBouncer connection pooling settings
			Pgbouncer *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"pgbouncer,omitempty"`

			// PGLookout settings
			Pglookout *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"pglookout,omitempty"`

			// TimescaleDB extension configuration values
			Timescaledb *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"timescaledb,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsPgResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsPgResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasSettingsRedisResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Settings *struct {
			// Redis configuration values
			Redis *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"redis,omitempty"`
		} `json:"settings,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDbaasSettingsRedisResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasSettingsRedisResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDbaasTaskMigrationCheckResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDbaasTaskMigrationCheckResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDbaasTaskMigrationCheckResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDbaasTaskResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DbaasTask
}

// Status returns HTTPResponse.Status
func (r GetDbaasTaskResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDbaasTaskResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDeployTargetsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DeployTargets *[]DeployTarget `json:"deploy-targets,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDeployTargetsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDeployTargetsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDeployTargetResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DeployTarget
}

// Status returns HTTPResponse.Status
func (r GetDeployTargetResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDeployTargetResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDnsDomainsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DnsDomains *[]DnsDomain `json:"dns-domains,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDnsDomainsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDnsDomainsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDnsDomainResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DnsDomain
}

// Status returns HTTPResponse.Status
func (r CreateDnsDomainResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDnsDomainResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListDnsDomainRecordsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		DnsDomainRecords *[]DnsDomainRecord `json:"dns-domain-records,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListDnsDomainRecordsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListDnsDomainRecordsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateDnsDomainRecordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateDnsDomainRecordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateDnsDomainRecordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDnsDomainRecordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDnsDomainRecordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDnsDomainRecordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDnsDomainRecordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DnsDomainRecord
}

// Status returns HTTPResponse.Status
func (r GetDnsDomainRecordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDnsDomainRecordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateDnsDomainRecordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateDnsDomainRecordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateDnsDomainRecordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDnsDomainResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteDnsDomainResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDnsDomainResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDnsDomainResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DnsDomain
}

// Status returns HTTPResponse.Status
func (r GetDnsDomainResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDnsDomainResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDnsDomainZoneFileResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		ZoneFile *string `json:"zone-file,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetDnsDomainZoneFileResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDnsDomainZoneFileResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListElasticIpsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		ElasticIps *[]ElasticIp `json:"elastic-ips,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListElasticIpsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListElasticIpsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ElasticIp
}

// Status returns HTTPResponse.Status
func (r GetElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetElasticIpFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetElasticIpFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetElasticIpFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AttachInstanceToElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AttachInstanceToElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AttachInstanceToElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DetachInstanceFromElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DetachInstanceFromElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DetachInstanceFromElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListEventsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Event
}

// Status returns HTTPResponse.Status
func (r ListEventsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListEventsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetIamOrganizationPolicyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IamPolicy
}

// Status returns HTTPResponse.Status
func (r GetIamOrganizationPolicyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetIamOrganizationPolicyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateIamOrganizationPolicyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateIamOrganizationPolicyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateIamOrganizationPolicyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListIamRolesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		IamRoles *[]IamRole `json:"iam-roles,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListIamRolesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListIamRolesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateIamRoleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateIamRoleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateIamRoleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteIamRoleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteIamRoleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteIamRoleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetIamRoleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IamRole
}

// Status returns HTTPResponse.Status
func (r GetIamRoleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetIamRoleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateIamRoleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateIamRoleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateIamRoleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateIamRolePolicyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateIamRolePolicyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateIamRolePolicyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListInstancesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Instances *[]Instance `json:"instances,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListInstancesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListInstancesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListInstancePoolsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		InstancePools *[]InstancePool `json:"instance-pools,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListInstancePoolsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListInstancePoolsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *InstancePool
}

// Status returns HTTPResponse.Status
func (r GetInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetInstancePoolFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetInstancePoolFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetInstancePoolFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type EvictInstancePoolMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r EvictInstancePoolMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r EvictInstancePoolMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ScaleInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ScaleInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ScaleInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListInstanceTypesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		InstanceTypes *[]InstanceType `json:"instance-types,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListInstanceTypesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListInstanceTypesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetInstanceTypeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *InstanceType
}

// Status returns HTTPResponse.Status
func (r GetInstanceTypeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetInstanceTypeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Instance
}

// Status returns HTTPResponse.Status
func (r GetInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetInstanceFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetInstanceFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetInstanceFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddInstanceProtectionResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *map[string]interface{}
}

// Status returns HTTPResponse.Status
func (r AddInstanceProtectionResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddInstanceProtectionResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RevealInstancePasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *InstancePassword
}

// Status returns HTTPResponse.Status
func (r RevealInstancePasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RevealInstancePasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RebootInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RebootInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RebootInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RemoveInstanceProtectionResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *map[string]interface{}
}

// Status returns HTTPResponse.Status
func (r RemoveInstanceProtectionResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RemoveInstanceProtectionResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetInstancePasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetInstancePasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetInstancePasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResizeInstanceDiskResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResizeInstanceDiskResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResizeInstanceDiskResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ScaleInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ScaleInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ScaleInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StartInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StartInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StartInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type StopInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r StopInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r StopInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RevertInstanceToSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RevertInstanceToSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RevertInstanceToSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListLoadBalancersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		LoadBalancers *[]LoadBalancer `json:"load-balancers,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListLoadBalancersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListLoadBalancersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LoadBalancer
}

// Status returns HTTPResponse.Status
func (r GetLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddServiceToLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AddServiceToLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddServiceToLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LoadBalancerService
}

// Status returns HTTPResponse.Status
func (r GetLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetLoadBalancerServiceFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetLoadBalancerServiceFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetLoadBalancerServiceFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetLoadBalancerFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetLoadBalancerFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetLoadBalancerFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOperationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r GetOperationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOperationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListPrivateNetworksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListPrivateNetworksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListPrivateNetworksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreatePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreatePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreatePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeletePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeletePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeletePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetPrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *PrivateNetwork
}

// Status returns HTTPResponse.Status
func (r GetPrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetPrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdatePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdatePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdatePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetPrivateNetworkFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetPrivateNetworkFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetPrivateNetworkFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AttachInstanceToPrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AttachInstanceToPrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AttachInstanceToPrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DetachInstanceFromPrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DetachInstanceFromPrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DetachInstanceFromPrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdatePrivateNetworkInstanceIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdatePrivateNetworkInstanceIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdatePrivateNetworkInstanceIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListQuotasResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Quotas *[]Quota `json:"quotas,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListQuotasResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListQuotasResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetQuotaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Quota
}

// Status returns HTTPResponse.Status
func (r GetQuotaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetQuotaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteReverseDnsElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteReverseDnsElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteReverseDnsElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetReverseDnsElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ReverseDnsRecord
}

// Status returns HTTPResponse.Status
func (r GetReverseDnsElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetReverseDnsElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateReverseDnsElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateReverseDnsElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateReverseDnsElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteReverseDnsInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteReverseDnsInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteReverseDnsInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetReverseDnsInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ReverseDnsRecord
}

// Status returns HTTPResponse.Status
func (r GetReverseDnsInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetReverseDnsInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateReverseDnsInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateReverseDnsInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateReverseDnsInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSecurityGroupsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSecurityGroupsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSecurityGroupsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SecurityGroup
}

// Status returns HTTPResponse.Status
func (r GetSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddRuleToSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AddRuleToSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddRuleToSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteRuleFromSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteRuleFromSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteRuleFromSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddExternalSourceToSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AddExternalSourceToSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddExternalSourceToSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AttachInstanceToSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AttachInstanceToSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AttachInstanceToSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DetachInstanceFromSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DetachInstanceFromSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DetachInstanceFromSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RemoveExternalSourceFromSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RemoveExternalSourceFromSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RemoveExternalSourceFromSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSksClustersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SksClusters *[]SksCluster `json:"sks-clusters,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSksClustersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSksClustersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSksClusterDeprecatedResourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]SksClusterDeprecatedResource
}

// Status returns HTTPResponse.Status
func (r ListSksClusterDeprecatedResourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSksClusterDeprecatedResourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GenerateSksClusterKubeconfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Kubeconfig *string `json:"kubeconfig,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GenerateSksClusterKubeconfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GenerateSksClusterKubeconfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSksClusterVersionsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SksClusterVersions *[]string `json:"sks-cluster-versions,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSksClusterVersionsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSksClusterVersionsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SksCluster
}

// Status returns HTTPResponse.Status
func (r GetSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSksClusterAuthorityCertResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Cacert *string `json:"cacert,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetSksClusterAuthorityCertResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSksClusterAuthorityCertResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SksNodepool
}

// Status returns HTTPResponse.Status
func (r GetSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetSksNodepoolFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetSksNodepoolFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetSksNodepoolFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type EvictSksNodepoolMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r EvictSksNodepoolMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r EvictSksNodepoolMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ScaleSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ScaleSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ScaleSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RotateSksCcmCredentialsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RotateSksCcmCredentialsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RotateSksCcmCredentialsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RotateSksOperatorsCaResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RotateSksOperatorsCaResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RotateSksOperatorsCaResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpgradeSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpgradeSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpgradeSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpgradeSksClusterServiceLevelResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpgradeSksClusterServiceLevelResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpgradeSksClusterServiceLevelResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ResetSksClusterFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ResetSksClusterFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ResetSksClusterFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSnapshotsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Snapshots *[]Snapshot `json:"snapshots,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSnapshotsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSnapshotsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Snapshot
}

// Status returns HTTPResponse.Status
func (r GetSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ExportSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ExportSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ExportSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PromoteSnapshotToTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r PromoteSnapshotToTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PromoteSnapshotToTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSosBucketsUsageResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SosBucketsUsage *[]SosBucketUsage `json:"sos-buckets-usage,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSosBucketsUsageResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSosBucketsUsageResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSosPresignedUrlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Url *string `json:"url,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetSosPresignedUrlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSosPresignedUrlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSshKeysResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SshKeys *[]SshKey `json:"ssh-keys,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSshKeysResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSshKeysResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RegisterSshKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RegisterSshKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RegisterSshKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSshKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSshKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSshKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSshKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SshKey
}

// Status returns HTTPResponse.Status
func (r GetSshKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSshKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Templates *[]Template `json:"templates,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RegisterTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RegisterTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RegisterTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Template
}

// Status returns HTTPResponse.Status
func (r GetTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CopyTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CopyTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CopyTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListZonesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Zones *[]Zone `json:"zones,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListZonesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListZonesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ListAccessKeysWithResponse request returning *ListAccessKeysResponse
func (c *ClientWithResponses) ListAccessKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeysResponse, error) {
	rsp, err := c.ListAccessKeys(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListAccessKeysResponse(rsp)
}

// CreateAccessKeyWithBodyWithResponse request with arbitrary body returning *CreateAccessKeyResponse
func (c *ClientWithResponses) CreateAccessKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateAccessKeyResponse, error) {
	rsp, err := c.CreateAccessKeyWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateAccessKeyResponse(rsp)
}

func (c *ClientWithResponses) CreateAccessKeyWithResponse(ctx context.Context, body CreateAccessKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateAccessKeyResponse, error) {
	rsp, err := c.CreateAccessKey(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateAccessKeyResponse(rsp)
}

// ListAccessKeyKnownOperationsWithResponse request returning *ListAccessKeyKnownOperationsResponse
func (c *ClientWithResponses) ListAccessKeyKnownOperationsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeyKnownOperationsResponse, error) {
	rsp, err := c.ListAccessKeyKnownOperations(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListAccessKeyKnownOperationsResponse(rsp)
}

// ListAccessKeyOperationsWithResponse request returning *ListAccessKeyOperationsResponse
func (c *ClientWithResponses) ListAccessKeyOperationsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAccessKeyOperationsResponse, error) {
	rsp, err := c.ListAccessKeyOperations(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListAccessKeyOperationsResponse(rsp)
}

// RevokeAccessKeyWithResponse request returning *RevokeAccessKeyResponse
func (c *ClientWithResponses) RevokeAccessKeyWithResponse(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*RevokeAccessKeyResponse, error) {
	rsp, err := c.RevokeAccessKey(ctx, key, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRevokeAccessKeyResponse(rsp)
}

// GetAccessKeyWithResponse request returning *GetAccessKeyResponse
func (c *ClientWithResponses) GetAccessKeyWithResponse(ctx context.Context, key string, reqEditors ...RequestEditorFn) (*GetAccessKeyResponse, error) {
	rsp, err := c.GetAccessKey(ctx, key, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetAccessKeyResponse(rsp)
}

// ListAntiAffinityGroupsWithResponse request returning *ListAntiAffinityGroupsResponse
func (c *ClientWithResponses) ListAntiAffinityGroupsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListAntiAffinityGroupsResponse, error) {
	rsp, err := c.ListAntiAffinityGroups(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListAntiAffinityGroupsResponse(rsp)
}

// CreateAntiAffinityGroupWithBodyWithResponse request with arbitrary body returning *CreateAntiAffinityGroupResponse
func (c *ClientWithResponses) CreateAntiAffinityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateAntiAffinityGroupResponse, error) {
	rsp, err := c.CreateAntiAffinityGroupWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateAntiAffinityGroupResponse(rsp)
}

func (c *ClientWithResponses) CreateAntiAffinityGroupWithResponse(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateAntiAffinityGroupResponse, error) {
	rsp, err := c.CreateAntiAffinityGroup(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateAntiAffinityGroupResponse(rsp)
}

// DeleteAntiAffinityGroupWithResponse request returning *DeleteAntiAffinityGroupResponse
func (c *ClientWithResponses) DeleteAntiAffinityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteAntiAffinityGroupResponse, error) {
	rsp, err := c.DeleteAntiAffinityGroup(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteAntiAffinityGroupResponse(rsp)
}

// GetAntiAffinityGroupWithResponse request returning *GetAntiAffinityGroupResponse
func (c *ClientWithResponses) GetAntiAffinityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetAntiAffinityGroupResponse, error) {
	rsp, err := c.GetAntiAffinityGroup(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetAntiAffinityGroupResponse(rsp)
}

// ListApiKeysWithResponse request returning *ListApiKeysResponse
func (c *ClientWithResponses) ListApiKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListApiKeysResponse, error) {
	rsp, err := c.ListApiKeys(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListApiKeysResponse(rsp)
}

// CreateApiKeyWithBodyWithResponse request with arbitrary body returning *CreateApiKeyResponse
func (c *ClientWithResponses) CreateApiKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateApiKeyResponse, error) {
	rsp, err := c.CreateApiKeyWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateApiKeyResponse(rsp)
}

func (c *ClientWithResponses) CreateApiKeyWithResponse(ctx context.Context, body CreateApiKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateApiKeyResponse, error) {
	rsp, err := c.CreateApiKey(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateApiKeyResponse(rsp)
}

// DeleteApiKeyWithResponse request returning *DeleteApiKeyResponse
func (c *ClientWithResponses) DeleteApiKeyWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteApiKeyResponse, error) {
	rsp, err := c.DeleteApiKey(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteApiKeyResponse(rsp)
}

// GetApiKeyWithResponse request returning *GetApiKeyResponse
func (c *ClientWithResponses) GetApiKeyWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetApiKeyResponse, error) {
	rsp, err := c.GetApiKey(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetApiKeyResponse(rsp)
}

// GetDbaasCaCertificateWithResponse request returning *GetDbaasCaCertificateResponse
func (c *ClientWithResponses) GetDbaasCaCertificateWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasCaCertificateResponse, error) {
	rsp, err := c.GetDbaasCaCertificate(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasCaCertificateResponse(rsp)
}

// DeleteDbaasServiceGrafanaWithResponse request returning *DeleteDbaasServiceGrafanaResponse
func (c *ClientWithResponses) DeleteDbaasServiceGrafanaWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceGrafanaResponse, error) {
	rsp, err := c.DeleteDbaasServiceGrafana(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceGrafanaResponse(rsp)
}

// GetDbaasServiceGrafanaWithResponse request returning *GetDbaasServiceGrafanaResponse
func (c *ClientWithResponses) GetDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceGrafanaResponse, error) {
	rsp, err := c.GetDbaasServiceGrafana(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceGrafanaResponse(rsp)
}

// CreateDbaasServiceGrafanaWithBodyWithResponse request with arbitrary body returning *CreateDbaasServiceGrafanaResponse
func (c *ClientWithResponses) CreateDbaasServiceGrafanaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceGrafanaResponse, error) {
	rsp, err := c.CreateDbaasServiceGrafanaWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceGrafanaResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceGrafanaResponse, error) {
	rsp, err := c.CreateDbaasServiceGrafana(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceGrafanaResponse(rsp)
}

// UpdateDbaasServiceGrafanaWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServiceGrafanaResponse
func (c *ClientWithResponses) UpdateDbaasServiceGrafanaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceGrafanaResponse, error) {
	rsp, err := c.UpdateDbaasServiceGrafanaWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceGrafanaResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServiceGrafanaWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceGrafanaJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceGrafanaResponse, error) {
	rsp, err := c.UpdateDbaasServiceGrafana(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceGrafanaResponse(rsp)
}

// StartDbaasGrafanaMaintenanceWithResponse request returning *StartDbaasGrafanaMaintenanceResponse
func (c *ClientWithResponses) StartDbaasGrafanaMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasGrafanaMaintenanceResponse, error) {
	rsp, err := c.StartDbaasGrafanaMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasGrafanaMaintenanceResponse(rsp)
}

// CreateDbaasIntegrationWithBodyWithResponse request with arbitrary body returning *CreateDbaasIntegrationResponse
func (c *ClientWithResponses) CreateDbaasIntegrationWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasIntegrationResponse, error) {
	rsp, err := c.CreateDbaasIntegrationWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasIntegrationResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasIntegrationWithResponse(ctx context.Context, body CreateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasIntegrationResponse, error) {
	rsp, err := c.CreateDbaasIntegration(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasIntegrationResponse(rsp)
}

// ListDbaasIntegrationSettingsWithResponse request returning *ListDbaasIntegrationSettingsResponse
func (c *ClientWithResponses) ListDbaasIntegrationSettingsWithResponse(ctx context.Context, integrationType string, sourceType string, destType string, reqEditors ...RequestEditorFn) (*ListDbaasIntegrationSettingsResponse, error) {
	rsp, err := c.ListDbaasIntegrationSettings(ctx, integrationType, sourceType, destType, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDbaasIntegrationSettingsResponse(rsp)
}

// ListDbaasIntegrationTypesWithResponse request returning *ListDbaasIntegrationTypesResponse
func (c *ClientWithResponses) ListDbaasIntegrationTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasIntegrationTypesResponse, error) {
	rsp, err := c.ListDbaasIntegrationTypes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDbaasIntegrationTypesResponse(rsp)
}

// DeleteDbaasIntegrationWithResponse request returning *DeleteDbaasIntegrationResponse
func (c *ClientWithResponses) DeleteDbaasIntegrationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteDbaasIntegrationResponse, error) {
	rsp, err := c.DeleteDbaasIntegration(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasIntegrationResponse(rsp)
}

// GetDbaasIntegrationWithResponse request returning *GetDbaasIntegrationResponse
func (c *ClientWithResponses) GetDbaasIntegrationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDbaasIntegrationResponse, error) {
	rsp, err := c.GetDbaasIntegration(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasIntegrationResponse(rsp)
}

// UpdateDbaasIntegrationWithBodyWithResponse request with arbitrary body returning *UpdateDbaasIntegrationResponse
func (c *ClientWithResponses) UpdateDbaasIntegrationWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasIntegrationResponse, error) {
	rsp, err := c.UpdateDbaasIntegrationWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasIntegrationResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasIntegrationWithResponse(ctx context.Context, id string, body UpdateDbaasIntegrationJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasIntegrationResponse, error) {
	rsp, err := c.UpdateDbaasIntegration(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasIntegrationResponse(rsp)
}

// DeleteDbaasServiceKafkaWithResponse request returning *DeleteDbaasServiceKafkaResponse
func (c *ClientWithResponses) DeleteDbaasServiceKafkaWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceKafkaResponse, error) {
	rsp, err := c.DeleteDbaasServiceKafka(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceKafkaResponse(rsp)
}

// GetDbaasServiceKafkaWithResponse request returning *GetDbaasServiceKafkaResponse
func (c *ClientWithResponses) GetDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceKafkaResponse, error) {
	rsp, err := c.GetDbaasServiceKafka(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceKafkaResponse(rsp)
}

// CreateDbaasServiceKafkaWithBodyWithResponse request with arbitrary body returning *CreateDbaasServiceKafkaResponse
func (c *ClientWithResponses) CreateDbaasServiceKafkaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceKafkaResponse, error) {
	rsp, err := c.CreateDbaasServiceKafkaWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceKafkaResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceKafkaResponse, error) {
	rsp, err := c.CreateDbaasServiceKafka(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceKafkaResponse(rsp)
}

// UpdateDbaasServiceKafkaWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServiceKafkaResponse
func (c *ClientWithResponses) UpdateDbaasServiceKafkaWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceKafkaResponse, error) {
	rsp, err := c.UpdateDbaasServiceKafkaWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceKafkaResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServiceKafkaWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceKafkaJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceKafkaResponse, error) {
	rsp, err := c.UpdateDbaasServiceKafka(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceKafkaResponse(rsp)
}

// GetDbaasKafkaAclConfigWithResponse request returning *GetDbaasKafkaAclConfigResponse
func (c *ClientWithResponses) GetDbaasKafkaAclConfigWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasKafkaAclConfigResponse, error) {
	rsp, err := c.GetDbaasKafkaAclConfig(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasKafkaAclConfigResponse(rsp)
}

// StartDbaasKafkaMaintenanceWithResponse request returning *StartDbaasKafkaMaintenanceResponse
func (c *ClientWithResponses) StartDbaasKafkaMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasKafkaMaintenanceResponse, error) {
	rsp, err := c.StartDbaasKafkaMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasKafkaMaintenanceResponse(rsp)
}

// CreateDbaasKafkaSchemaRegistryAclConfigWithBodyWithResponse request with arbitrary body returning *CreateDbaasKafkaSchemaRegistryAclConfigResponse
func (c *ClientWithResponses) CreateDbaasKafkaSchemaRegistryAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaSchemaRegistryAclConfigResponse, error) {
	rsp, err := c.CreateDbaasKafkaSchemaRegistryAclConfigWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaSchemaRegistryAclConfigResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasKafkaSchemaRegistryAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaSchemaRegistryAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaSchemaRegistryAclConfigResponse, error) {
	rsp, err := c.CreateDbaasKafkaSchemaRegistryAclConfig(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaSchemaRegistryAclConfigResponse(rsp)
}

// DeleteDbaasKafkaSchemaRegistryAclConfigWithResponse request returning *DeleteDbaasKafkaSchemaRegistryAclConfigResponse
func (c *ClientWithResponses) DeleteDbaasKafkaSchemaRegistryAclConfigWithResponse(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaSchemaRegistryAclConfigResponse, error) {
	rsp, err := c.DeleteDbaasKafkaSchemaRegistryAclConfig(ctx, name, aclId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasKafkaSchemaRegistryAclConfigResponse(rsp)
}

// CreateDbaasKafkaTopicAclConfigWithBodyWithResponse request with arbitrary body returning *CreateDbaasKafkaTopicAclConfigResponse
func (c *ClientWithResponses) CreateDbaasKafkaTopicAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaTopicAclConfigResponse, error) {
	rsp, err := c.CreateDbaasKafkaTopicAclConfigWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaTopicAclConfigResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasKafkaTopicAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasKafkaTopicAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaTopicAclConfigResponse, error) {
	rsp, err := c.CreateDbaasKafkaTopicAclConfig(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaTopicAclConfigResponse(rsp)
}

// DeleteDbaasKafkaTopicAclConfigWithResponse request returning *DeleteDbaasKafkaTopicAclConfigResponse
func (c *ClientWithResponses) DeleteDbaasKafkaTopicAclConfigWithResponse(ctx context.Context, name DbaasServiceName, aclId DbaasKafkaAclId, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaTopicAclConfigResponse, error) {
	rsp, err := c.DeleteDbaasKafkaTopicAclConfig(ctx, name, aclId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasKafkaTopicAclConfigResponse(rsp)
}

// CreateDbaasKafkaUserWithBodyWithResponse request with arbitrary body returning *CreateDbaasKafkaUserResponse
func (c *ClientWithResponses) CreateDbaasKafkaUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaUserResponse, error) {
	rsp, err := c.CreateDbaasKafkaUserWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaUserResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasKafkaUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasKafkaUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasKafkaUserResponse, error) {
	rsp, err := c.CreateDbaasKafkaUser(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasKafkaUserResponse(rsp)
}

// DeleteDbaasKafkaUserWithResponse request returning *DeleteDbaasKafkaUserResponse
func (c *ClientWithResponses) DeleteDbaasKafkaUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasKafkaUserResponse, error) {
	rsp, err := c.DeleteDbaasKafkaUser(ctx, serviceName, username, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasKafkaUserResponse(rsp)
}

// ResetDbaasKafkaUserPasswordWithBodyWithResponse request with arbitrary body returning *ResetDbaasKafkaUserPasswordResponse
func (c *ClientWithResponses) ResetDbaasKafkaUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasKafkaUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasKafkaUserPasswordWithBody(ctx, serviceName, username, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasKafkaUserPasswordResponse(rsp)
}

func (c *ClientWithResponses) ResetDbaasKafkaUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasKafkaUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasKafkaUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasKafkaUserPassword(ctx, serviceName, username, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasKafkaUserPasswordResponse(rsp)
}

// GetDbaasMigrationStatusWithResponse request returning *GetDbaasMigrationStatusResponse
func (c *ClientWithResponses) GetDbaasMigrationStatusWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasMigrationStatusResponse, error) {
	rsp, err := c.GetDbaasMigrationStatus(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasMigrationStatusResponse(rsp)
}

// DeleteDbaasServiceMysqlWithResponse request returning *DeleteDbaasServiceMysqlResponse
func (c *ClientWithResponses) DeleteDbaasServiceMysqlWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceMysqlResponse, error) {
	rsp, err := c.DeleteDbaasServiceMysql(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceMysqlResponse(rsp)
}

// GetDbaasServiceMysqlWithResponse request returning *GetDbaasServiceMysqlResponse
func (c *ClientWithResponses) GetDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceMysqlResponse, error) {
	rsp, err := c.GetDbaasServiceMysql(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceMysqlResponse(rsp)
}

// CreateDbaasServiceMysqlWithBodyWithResponse request with arbitrary body returning *CreateDbaasServiceMysqlResponse
func (c *ClientWithResponses) CreateDbaasServiceMysqlWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceMysqlResponse, error) {
	rsp, err := c.CreateDbaasServiceMysqlWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceMysqlResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceMysqlResponse, error) {
	rsp, err := c.CreateDbaasServiceMysql(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceMysqlResponse(rsp)
}

// UpdateDbaasServiceMysqlWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServiceMysqlResponse
func (c *ClientWithResponses) UpdateDbaasServiceMysqlWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceMysqlResponse, error) {
	rsp, err := c.UpdateDbaasServiceMysqlWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceMysqlResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServiceMysqlWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceMysqlJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceMysqlResponse, error) {
	rsp, err := c.UpdateDbaasServiceMysql(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceMysqlResponse(rsp)
}

// StartDbaasMysqlMaintenanceWithResponse request returning *StartDbaasMysqlMaintenanceResponse
func (c *ClientWithResponses) StartDbaasMysqlMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasMysqlMaintenanceResponse, error) {
	rsp, err := c.StartDbaasMysqlMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasMysqlMaintenanceResponse(rsp)
}

// StopDbaasMysqlMigrationWithResponse request returning *StopDbaasMysqlMigrationResponse
func (c *ClientWithResponses) StopDbaasMysqlMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasMysqlMigrationResponse, error) {
	rsp, err := c.StopDbaasMysqlMigration(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStopDbaasMysqlMigrationResponse(rsp)
}

// CreateDbaasMysqlDatabaseWithBodyWithResponse request with arbitrary body returning *CreateDbaasMysqlDatabaseResponse
func (c *ClientWithResponses) CreateDbaasMysqlDatabaseWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlDatabaseResponse, error) {
	rsp, err := c.CreateDbaasMysqlDatabaseWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasMysqlDatabaseResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasMysqlDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlDatabaseResponse, error) {
	rsp, err := c.CreateDbaasMysqlDatabase(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasMysqlDatabaseResponse(rsp)
}

// DeleteDbaasMysqlDatabaseWithResponse request returning *DeleteDbaasMysqlDatabaseResponse
func (c *ClientWithResponses) DeleteDbaasMysqlDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasMysqlDatabaseName, reqEditors ...RequestEditorFn) (*DeleteDbaasMysqlDatabaseResponse, error) {
	rsp, err := c.DeleteDbaasMysqlDatabase(ctx, serviceName, databaseName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasMysqlDatabaseResponse(rsp)
}

// CreateDbaasMysqlUserWithBodyWithResponse request with arbitrary body returning *CreateDbaasMysqlUserResponse
func (c *ClientWithResponses) CreateDbaasMysqlUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlUserResponse, error) {
	rsp, err := c.CreateDbaasMysqlUserWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasMysqlUserResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasMysqlUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasMysqlUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasMysqlUserResponse, error) {
	rsp, err := c.CreateDbaasMysqlUser(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasMysqlUserResponse(rsp)
}

// DeleteDbaasMysqlUserWithResponse request returning *DeleteDbaasMysqlUserResponse
func (c *ClientWithResponses) DeleteDbaasMysqlUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasMysqlUserResponse, error) {
	rsp, err := c.DeleteDbaasMysqlUser(ctx, serviceName, username, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasMysqlUserResponse(rsp)
}

// ResetDbaasMysqlUserPasswordWithBodyWithResponse request with arbitrary body returning *ResetDbaasMysqlUserPasswordResponse
func (c *ClientWithResponses) ResetDbaasMysqlUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasMysqlUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasMysqlUserPasswordWithBody(ctx, serviceName, username, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasMysqlUserPasswordResponse(rsp)
}

func (c *ClientWithResponses) ResetDbaasMysqlUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasMysqlUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasMysqlUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasMysqlUserPassword(ctx, serviceName, username, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasMysqlUserPasswordResponse(rsp)
}

// DeleteDbaasServiceOpensearchWithResponse request returning *DeleteDbaasServiceOpensearchResponse
func (c *ClientWithResponses) DeleteDbaasServiceOpensearchWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceOpensearchResponse, error) {
	rsp, err := c.DeleteDbaasServiceOpensearch(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceOpensearchResponse(rsp)
}

// GetDbaasServiceOpensearchWithResponse request returning *GetDbaasServiceOpensearchResponse
func (c *ClientWithResponses) GetDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceOpensearchResponse, error) {
	rsp, err := c.GetDbaasServiceOpensearch(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceOpensearchResponse(rsp)
}

// CreateDbaasServiceOpensearchWithBodyWithResponse request with arbitrary body returning *CreateDbaasServiceOpensearchResponse
func (c *ClientWithResponses) CreateDbaasServiceOpensearchWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceOpensearchResponse, error) {
	rsp, err := c.CreateDbaasServiceOpensearchWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceOpensearchResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceOpensearchResponse, error) {
	rsp, err := c.CreateDbaasServiceOpensearch(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceOpensearchResponse(rsp)
}

// UpdateDbaasServiceOpensearchWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServiceOpensearchResponse
func (c *ClientWithResponses) UpdateDbaasServiceOpensearchWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceOpensearchResponse, error) {
	rsp, err := c.UpdateDbaasServiceOpensearchWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceOpensearchResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServiceOpensearchWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceOpensearchJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceOpensearchResponse, error) {
	rsp, err := c.UpdateDbaasServiceOpensearch(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceOpensearchResponse(rsp)
}

// GetDbaasOpensearchAclConfigWithResponse request returning *GetDbaasOpensearchAclConfigResponse
func (c *ClientWithResponses) GetDbaasOpensearchAclConfigWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasOpensearchAclConfigResponse, error) {
	rsp, err := c.GetDbaasOpensearchAclConfig(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasOpensearchAclConfigResponse(rsp)
}

// UpdateDbaasOpensearchAclConfigWithBodyWithResponse request with arbitrary body returning *UpdateDbaasOpensearchAclConfigResponse
func (c *ClientWithResponses) UpdateDbaasOpensearchAclConfigWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasOpensearchAclConfigResponse, error) {
	rsp, err := c.UpdateDbaasOpensearchAclConfigWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasOpensearchAclConfigResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasOpensearchAclConfigWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasOpensearchAclConfigJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasOpensearchAclConfigResponse, error) {
	rsp, err := c.UpdateDbaasOpensearchAclConfig(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasOpensearchAclConfigResponse(rsp)
}

// StartDbaasOpensearchMaintenanceWithResponse request returning *StartDbaasOpensearchMaintenanceResponse
func (c *ClientWithResponses) StartDbaasOpensearchMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasOpensearchMaintenanceResponse, error) {
	rsp, err := c.StartDbaasOpensearchMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasOpensearchMaintenanceResponse(rsp)
}

// CreateDbaasOpensearchUserWithBodyWithResponse request with arbitrary body returning *CreateDbaasOpensearchUserResponse
func (c *ClientWithResponses) CreateDbaasOpensearchUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasOpensearchUserResponse, error) {
	rsp, err := c.CreateDbaasOpensearchUserWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasOpensearchUserResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasOpensearchUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasOpensearchUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasOpensearchUserResponse, error) {
	rsp, err := c.CreateDbaasOpensearchUser(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasOpensearchUserResponse(rsp)
}

// DeleteDbaasOpensearchUserWithResponse request returning *DeleteDbaasOpensearchUserResponse
func (c *ClientWithResponses) DeleteDbaasOpensearchUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasOpensearchUserResponse, error) {
	rsp, err := c.DeleteDbaasOpensearchUser(ctx, serviceName, username, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasOpensearchUserResponse(rsp)
}

// ResetDbaasOpensearchUserPasswordWithBodyWithResponse request with arbitrary body returning *ResetDbaasOpensearchUserPasswordResponse
func (c *ClientWithResponses) ResetDbaasOpensearchUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasOpensearchUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasOpensearchUserPasswordWithBody(ctx, serviceName, username, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasOpensearchUserPasswordResponse(rsp)
}

func (c *ClientWithResponses) ResetDbaasOpensearchUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasOpensearchUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasOpensearchUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasOpensearchUserPassword(ctx, serviceName, username, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasOpensearchUserPasswordResponse(rsp)
}

// DeleteDbaasServicePgWithResponse request returning *DeleteDbaasServicePgResponse
func (c *ClientWithResponses) DeleteDbaasServicePgWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServicePgResponse, error) {
	rsp, err := c.DeleteDbaasServicePg(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServicePgResponse(rsp)
}

// GetDbaasServicePgWithResponse request returning *GetDbaasServicePgResponse
func (c *ClientWithResponses) GetDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServicePgResponse, error) {
	rsp, err := c.GetDbaasServicePg(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServicePgResponse(rsp)
}

// CreateDbaasServicePgWithBodyWithResponse request with arbitrary body returning *CreateDbaasServicePgResponse
func (c *ClientWithResponses) CreateDbaasServicePgWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServicePgResponse, error) {
	rsp, err := c.CreateDbaasServicePgWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServicePgResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServicePgResponse, error) {
	rsp, err := c.CreateDbaasServicePg(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServicePgResponse(rsp)
}

// UpdateDbaasServicePgWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServicePgResponse
func (c *ClientWithResponses) UpdateDbaasServicePgWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServicePgResponse, error) {
	rsp, err := c.UpdateDbaasServicePgWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServicePgResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServicePgWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServicePgJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServicePgResponse, error) {
	rsp, err := c.UpdateDbaasServicePg(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServicePgResponse(rsp)
}

// StartDbaasPgMaintenanceWithResponse request returning *StartDbaasPgMaintenanceResponse
func (c *ClientWithResponses) StartDbaasPgMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasPgMaintenanceResponse, error) {
	rsp, err := c.StartDbaasPgMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasPgMaintenanceResponse(rsp)
}

// StopDbaasPgMigrationWithResponse request returning *StopDbaasPgMigrationResponse
func (c *ClientWithResponses) StopDbaasPgMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasPgMigrationResponse, error) {
	rsp, err := c.StopDbaasPgMigration(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStopDbaasPgMigrationResponse(rsp)
}

// CreateDbaasPgConnectionPoolWithBodyWithResponse request with arbitrary body returning *CreateDbaasPgConnectionPoolResponse
func (c *ClientWithResponses) CreateDbaasPgConnectionPoolWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgConnectionPoolResponse, error) {
	rsp, err := c.CreateDbaasPgConnectionPoolWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgConnectionPoolResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgConnectionPoolResponse, error) {
	rsp, err := c.CreateDbaasPgConnectionPool(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgConnectionPoolResponse(rsp)
}

// DeleteDbaasPgConnectionPoolWithResponse request returning *DeleteDbaasPgConnectionPoolResponse
func (c *ClientWithResponses) DeleteDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, reqEditors ...RequestEditorFn) (*DeleteDbaasPgConnectionPoolResponse, error) {
	rsp, err := c.DeleteDbaasPgConnectionPool(ctx, serviceName, connectionPoolName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasPgConnectionPoolResponse(rsp)
}

// UpdateDbaasPgConnectionPoolWithBodyWithResponse request with arbitrary body returning *UpdateDbaasPgConnectionPoolResponse
func (c *ClientWithResponses) UpdateDbaasPgConnectionPoolWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasPgConnectionPoolResponse, error) {
	rsp, err := c.UpdateDbaasPgConnectionPoolWithBody(ctx, serviceName, connectionPoolName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasPgConnectionPoolResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasPgConnectionPoolWithResponse(ctx context.Context, serviceName DbaasServiceName, connectionPoolName DbaasPgPoolName, body UpdateDbaasPgConnectionPoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasPgConnectionPoolResponse, error) {
	rsp, err := c.UpdateDbaasPgConnectionPool(ctx, serviceName, connectionPoolName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasPgConnectionPoolResponse(rsp)
}

// CreateDbaasPgDatabaseWithBodyWithResponse request with arbitrary body returning *CreateDbaasPgDatabaseResponse
func (c *ClientWithResponses) CreateDbaasPgDatabaseWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgDatabaseResponse, error) {
	rsp, err := c.CreateDbaasPgDatabaseWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgDatabaseResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasPgDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPgDatabaseJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgDatabaseResponse, error) {
	rsp, err := c.CreateDbaasPgDatabase(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgDatabaseResponse(rsp)
}

// DeleteDbaasPgDatabaseWithResponse request returning *DeleteDbaasPgDatabaseResponse
func (c *ClientWithResponses) DeleteDbaasPgDatabaseWithResponse(ctx context.Context, serviceName DbaasServiceName, databaseName DbaasPgDatabaseName, reqEditors ...RequestEditorFn) (*DeleteDbaasPgDatabaseResponse, error) {
	rsp, err := c.DeleteDbaasPgDatabase(ctx, serviceName, databaseName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasPgDatabaseResponse(rsp)
}

// CreateDbaasPostgresUserWithBodyWithResponse request with arbitrary body returning *CreateDbaasPostgresUserResponse
func (c *ClientWithResponses) CreateDbaasPostgresUserWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPostgresUserResponse, error) {
	rsp, err := c.CreateDbaasPostgresUserWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPostgresUserResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasPostgresUserWithResponse(ctx context.Context, serviceName DbaasServiceName, body CreateDbaasPostgresUserJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPostgresUserResponse, error) {
	rsp, err := c.CreateDbaasPostgresUser(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPostgresUserResponse(rsp)
}

// DeleteDbaasPostgresUserWithResponse request returning *DeleteDbaasPostgresUserResponse
func (c *ClientWithResponses) DeleteDbaasPostgresUserWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, reqEditors ...RequestEditorFn) (*DeleteDbaasPostgresUserResponse, error) {
	rsp, err := c.DeleteDbaasPostgresUser(ctx, serviceName, username, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasPostgresUserResponse(rsp)
}

// UpdateDbaasPostgresAllowReplicationWithBodyWithResponse request with arbitrary body returning *UpdateDbaasPostgresAllowReplicationResponse
func (c *ClientWithResponses) UpdateDbaasPostgresAllowReplicationWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasPostgresAllowReplicationResponse, error) {
	rsp, err := c.UpdateDbaasPostgresAllowReplicationWithBody(ctx, serviceName, username, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasPostgresAllowReplicationResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasPostgresAllowReplicationWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body UpdateDbaasPostgresAllowReplicationJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasPostgresAllowReplicationResponse, error) {
	rsp, err := c.UpdateDbaasPostgresAllowReplication(ctx, serviceName, username, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasPostgresAllowReplicationResponse(rsp)
}

// ResetDbaasPostgresUserPasswordWithBodyWithResponse request with arbitrary body returning *ResetDbaasPostgresUserPasswordResponse
func (c *ClientWithResponses) ResetDbaasPostgresUserPasswordWithBodyWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetDbaasPostgresUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasPostgresUserPasswordWithBody(ctx, serviceName, username, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasPostgresUserPasswordResponse(rsp)
}

func (c *ClientWithResponses) ResetDbaasPostgresUserPasswordWithResponse(ctx context.Context, serviceName DbaasServiceName, username DbaasUserUsername, body ResetDbaasPostgresUserPasswordJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetDbaasPostgresUserPasswordResponse, error) {
	rsp, err := c.ResetDbaasPostgresUserPassword(ctx, serviceName, username, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetDbaasPostgresUserPasswordResponse(rsp)
}

// CreateDbaasPgUpgradeCheckWithBodyWithResponse request with arbitrary body returning *CreateDbaasPgUpgradeCheckResponse
func (c *ClientWithResponses) CreateDbaasPgUpgradeCheckWithBodyWithResponse(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasPgUpgradeCheckResponse, error) {
	rsp, err := c.CreateDbaasPgUpgradeCheckWithBody(ctx, service, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgUpgradeCheckResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasPgUpgradeCheckWithResponse(ctx context.Context, service DbaasServiceName, body CreateDbaasPgUpgradeCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasPgUpgradeCheckResponse, error) {
	rsp, err := c.CreateDbaasPgUpgradeCheck(ctx, service, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasPgUpgradeCheckResponse(rsp)
}

// DeleteDbaasServiceRedisWithResponse request returning *DeleteDbaasServiceRedisResponse
func (c *ClientWithResponses) DeleteDbaasServiceRedisWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceRedisResponse, error) {
	rsp, err := c.DeleteDbaasServiceRedis(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceRedisResponse(rsp)
}

// GetDbaasServiceRedisWithResponse request returning *GetDbaasServiceRedisResponse
func (c *ClientWithResponses) GetDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*GetDbaasServiceRedisResponse, error) {
	rsp, err := c.GetDbaasServiceRedis(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceRedisResponse(rsp)
}

// CreateDbaasServiceRedisWithBodyWithResponse request with arbitrary body returning *CreateDbaasServiceRedisResponse
func (c *ClientWithResponses) CreateDbaasServiceRedisWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasServiceRedisResponse, error) {
	rsp, err := c.CreateDbaasServiceRedisWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceRedisResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, body CreateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasServiceRedisResponse, error) {
	rsp, err := c.CreateDbaasServiceRedis(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasServiceRedisResponse(rsp)
}

// UpdateDbaasServiceRedisWithBodyWithResponse request with arbitrary body returning *UpdateDbaasServiceRedisResponse
func (c *ClientWithResponses) UpdateDbaasServiceRedisWithBodyWithResponse(ctx context.Context, name DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceRedisResponse, error) {
	rsp, err := c.UpdateDbaasServiceRedisWithBody(ctx, name, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceRedisResponse(rsp)
}

func (c *ClientWithResponses) UpdateDbaasServiceRedisWithResponse(ctx context.Context, name DbaasServiceName, body UpdateDbaasServiceRedisJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDbaasServiceRedisResponse, error) {
	rsp, err := c.UpdateDbaasServiceRedis(ctx, name, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDbaasServiceRedisResponse(rsp)
}

// StartDbaasRedisMaintenanceWithResponse request returning *StartDbaasRedisMaintenanceResponse
func (c *ClientWithResponses) StartDbaasRedisMaintenanceWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StartDbaasRedisMaintenanceResponse, error) {
	rsp, err := c.StartDbaasRedisMaintenance(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartDbaasRedisMaintenanceResponse(rsp)
}

// StopDbaasRedisMigrationWithResponse request returning *StopDbaasRedisMigrationResponse
func (c *ClientWithResponses) StopDbaasRedisMigrationWithResponse(ctx context.Context, name DbaasServiceName, reqEditors ...RequestEditorFn) (*StopDbaasRedisMigrationResponse, error) {
	rsp, err := c.StopDbaasRedisMigration(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStopDbaasRedisMigrationResponse(rsp)
}

// ListDbaasServicesWithResponse request returning *ListDbaasServicesResponse
func (c *ClientWithResponses) ListDbaasServicesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasServicesResponse, error) {
	rsp, err := c.ListDbaasServices(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDbaasServicesResponse(rsp)
}

// GetDbaasServiceLogsWithBodyWithResponse request with arbitrary body returning *GetDbaasServiceLogsResponse
func (c *ClientWithResponses) GetDbaasServiceLogsWithBodyWithResponse(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GetDbaasServiceLogsResponse, error) {
	rsp, err := c.GetDbaasServiceLogsWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceLogsResponse(rsp)
}

func (c *ClientWithResponses) GetDbaasServiceLogsWithResponse(ctx context.Context, serviceName string, body GetDbaasServiceLogsJSONRequestBody, reqEditors ...RequestEditorFn) (*GetDbaasServiceLogsResponse, error) {
	rsp, err := c.GetDbaasServiceLogs(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceLogsResponse(rsp)
}

// GetDbaasServiceMetricsWithBodyWithResponse request with arbitrary body returning *GetDbaasServiceMetricsResponse
func (c *ClientWithResponses) GetDbaasServiceMetricsWithBodyWithResponse(ctx context.Context, serviceName string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GetDbaasServiceMetricsResponse, error) {
	rsp, err := c.GetDbaasServiceMetricsWithBody(ctx, serviceName, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceMetricsResponse(rsp)
}

func (c *ClientWithResponses) GetDbaasServiceMetricsWithResponse(ctx context.Context, serviceName string, body GetDbaasServiceMetricsJSONRequestBody, reqEditors ...RequestEditorFn) (*GetDbaasServiceMetricsResponse, error) {
	rsp, err := c.GetDbaasServiceMetrics(ctx, serviceName, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceMetricsResponse(rsp)
}

// ListDbaasServiceTypesWithResponse request returning *ListDbaasServiceTypesResponse
func (c *ClientWithResponses) ListDbaasServiceTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDbaasServiceTypesResponse, error) {
	rsp, err := c.ListDbaasServiceTypes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDbaasServiceTypesResponse(rsp)
}

// GetDbaasServiceTypeWithResponse request returning *GetDbaasServiceTypeResponse
func (c *ClientWithResponses) GetDbaasServiceTypeWithResponse(ctx context.Context, serviceTypeName string, reqEditors ...RequestEditorFn) (*GetDbaasServiceTypeResponse, error) {
	rsp, err := c.GetDbaasServiceType(ctx, serviceTypeName, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasServiceTypeResponse(rsp)
}

// DeleteDbaasServiceWithResponse request returning *DeleteDbaasServiceResponse
func (c *ClientWithResponses) DeleteDbaasServiceWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteDbaasServiceResponse, error) {
	rsp, err := c.DeleteDbaasService(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDbaasServiceResponse(rsp)
}

// GetDbaasSettingsGrafanaWithResponse request returning *GetDbaasSettingsGrafanaResponse
func (c *ClientWithResponses) GetDbaasSettingsGrafanaWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsGrafanaResponse, error) {
	rsp, err := c.GetDbaasSettingsGrafana(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsGrafanaResponse(rsp)
}

// GetDbaasSettingsKafkaWithResponse request returning *GetDbaasSettingsKafkaResponse
func (c *ClientWithResponses) GetDbaasSettingsKafkaWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsKafkaResponse, error) {
	rsp, err := c.GetDbaasSettingsKafka(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsKafkaResponse(rsp)
}

// GetDbaasSettingsMysqlWithResponse request returning *GetDbaasSettingsMysqlResponse
func (c *ClientWithResponses) GetDbaasSettingsMysqlWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsMysqlResponse, error) {
	rsp, err := c.GetDbaasSettingsMysql(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsMysqlResponse(rsp)
}

// GetDbaasSettingsOpensearchWithResponse request returning *GetDbaasSettingsOpensearchResponse
func (c *ClientWithResponses) GetDbaasSettingsOpensearchWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsOpensearchResponse, error) {
	rsp, err := c.GetDbaasSettingsOpensearch(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsOpensearchResponse(rsp)
}

// GetDbaasSettingsPgWithResponse request returning *GetDbaasSettingsPgResponse
func (c *ClientWithResponses) GetDbaasSettingsPgWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsPgResponse, error) {
	rsp, err := c.GetDbaasSettingsPg(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsPgResponse(rsp)
}

// GetDbaasSettingsRedisWithResponse request returning *GetDbaasSettingsRedisResponse
func (c *ClientWithResponses) GetDbaasSettingsRedisWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetDbaasSettingsRedisResponse, error) {
	rsp, err := c.GetDbaasSettingsRedis(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasSettingsRedisResponse(rsp)
}

// CreateDbaasTaskMigrationCheckWithBodyWithResponse request with arbitrary body returning *CreateDbaasTaskMigrationCheckResponse
func (c *ClientWithResponses) CreateDbaasTaskMigrationCheckWithBodyWithResponse(ctx context.Context, service DbaasServiceName, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDbaasTaskMigrationCheckResponse, error) {
	rsp, err := c.CreateDbaasTaskMigrationCheckWithBody(ctx, service, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasTaskMigrationCheckResponse(rsp)
}

func (c *ClientWithResponses) CreateDbaasTaskMigrationCheckWithResponse(ctx context.Context, service DbaasServiceName, body CreateDbaasTaskMigrationCheckJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDbaasTaskMigrationCheckResponse, error) {
	rsp, err := c.CreateDbaasTaskMigrationCheck(ctx, service, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDbaasTaskMigrationCheckResponse(rsp)
}

// GetDbaasTaskWithResponse request returning *GetDbaasTaskResponse
func (c *ClientWithResponses) GetDbaasTaskWithResponse(ctx context.Context, service DbaasServiceName, id string, reqEditors ...RequestEditorFn) (*GetDbaasTaskResponse, error) {
	rsp, err := c.GetDbaasTask(ctx, service, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDbaasTaskResponse(rsp)
}

// ListDeployTargetsWithResponse request returning *ListDeployTargetsResponse
func (c *ClientWithResponses) ListDeployTargetsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDeployTargetsResponse, error) {
	rsp, err := c.ListDeployTargets(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDeployTargetsResponse(rsp)
}

// GetDeployTargetWithResponse request returning *GetDeployTargetResponse
func (c *ClientWithResponses) GetDeployTargetWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDeployTargetResponse, error) {
	rsp, err := c.GetDeployTarget(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDeployTargetResponse(rsp)
}

// ListDnsDomainsWithResponse request returning *ListDnsDomainsResponse
func (c *ClientWithResponses) ListDnsDomainsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListDnsDomainsResponse, error) {
	rsp, err := c.ListDnsDomains(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDnsDomainsResponse(rsp)
}

// CreateDnsDomainWithBodyWithResponse request with arbitrary body returning *CreateDnsDomainResponse
func (c *ClientWithResponses) CreateDnsDomainWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDnsDomainResponse, error) {
	rsp, err := c.CreateDnsDomainWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDnsDomainResponse(rsp)
}

func (c *ClientWithResponses) CreateDnsDomainWithResponse(ctx context.Context, body CreateDnsDomainJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDnsDomainResponse, error) {
	rsp, err := c.CreateDnsDomain(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDnsDomainResponse(rsp)
}

// ListDnsDomainRecordsWithResponse request returning *ListDnsDomainRecordsResponse
func (c *ClientWithResponses) ListDnsDomainRecordsWithResponse(ctx context.Context, domainId string, reqEditors ...RequestEditorFn) (*ListDnsDomainRecordsResponse, error) {
	rsp, err := c.ListDnsDomainRecords(ctx, domainId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListDnsDomainRecordsResponse(rsp)
}

// CreateDnsDomainRecordWithBodyWithResponse request with arbitrary body returning *CreateDnsDomainRecordResponse
func (c *ClientWithResponses) CreateDnsDomainRecordWithBodyWithResponse(ctx context.Context, domainId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateDnsDomainRecordResponse, error) {
	rsp, err := c.CreateDnsDomainRecordWithBody(ctx, domainId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDnsDomainRecordResponse(rsp)
}

func (c *ClientWithResponses) CreateDnsDomainRecordWithResponse(ctx context.Context, domainId string, body CreateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateDnsDomainRecordResponse, error) {
	rsp, err := c.CreateDnsDomainRecord(ctx, domainId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateDnsDomainRecordResponse(rsp)
}

// DeleteDnsDomainRecordWithResponse request returning *DeleteDnsDomainRecordResponse
func (c *ClientWithResponses) DeleteDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*DeleteDnsDomainRecordResponse, error) {
	rsp, err := c.DeleteDnsDomainRecord(ctx, domainId, recordId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDnsDomainRecordResponse(rsp)
}

// GetDnsDomainRecordWithResponse request returning *GetDnsDomainRecordResponse
func (c *ClientWithResponses) GetDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, reqEditors ...RequestEditorFn) (*GetDnsDomainRecordResponse, error) {
	rsp, err := c.GetDnsDomainRecord(ctx, domainId, recordId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDnsDomainRecordResponse(rsp)
}

// UpdateDnsDomainRecordWithBodyWithResponse request with arbitrary body returning *UpdateDnsDomainRecordResponse
func (c *ClientWithResponses) UpdateDnsDomainRecordWithBodyWithResponse(ctx context.Context, domainId string, recordId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateDnsDomainRecordResponse, error) {
	rsp, err := c.UpdateDnsDomainRecordWithBody(ctx, domainId, recordId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDnsDomainRecordResponse(rsp)
}

func (c *ClientWithResponses) UpdateDnsDomainRecordWithResponse(ctx context.Context, domainId string, recordId string, body UpdateDnsDomainRecordJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateDnsDomainRecordResponse, error) {
	rsp, err := c.UpdateDnsDomainRecord(ctx, domainId, recordId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateDnsDomainRecordResponse(rsp)
}

// DeleteDnsDomainWithResponse request returning *DeleteDnsDomainResponse
func (c *ClientWithResponses) DeleteDnsDomainWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteDnsDomainResponse, error) {
	rsp, err := c.DeleteDnsDomain(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDnsDomainResponse(rsp)
}

// GetDnsDomainWithResponse request returning *GetDnsDomainResponse
func (c *ClientWithResponses) GetDnsDomainWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDnsDomainResponse, error) {
	rsp, err := c.GetDnsDomain(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDnsDomainResponse(rsp)
}

// GetDnsDomainZoneFileWithResponse request returning *GetDnsDomainZoneFileResponse
func (c *ClientWithResponses) GetDnsDomainZoneFileWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetDnsDomainZoneFileResponse, error) {
	rsp, err := c.GetDnsDomainZoneFile(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetDnsDomainZoneFileResponse(rsp)
}

// ListElasticIpsWithResponse request returning *ListElasticIpsResponse
func (c *ClientWithResponses) ListElasticIpsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListElasticIpsResponse, error) {
	rsp, err := c.ListElasticIps(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListElasticIpsResponse(rsp)
}

// CreateElasticIpWithBodyWithResponse request with arbitrary body returning *CreateElasticIpResponse
func (c *ClientWithResponses) CreateElasticIpWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateElasticIpResponse, error) {
	rsp, err := c.CreateElasticIpWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateElasticIpResponse(rsp)
}

func (c *ClientWithResponses) CreateElasticIpWithResponse(ctx context.Context, body CreateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateElasticIpResponse, error) {
	rsp, err := c.CreateElasticIp(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateElasticIpResponse(rsp)
}

// DeleteElasticIpWithResponse request returning *DeleteElasticIpResponse
func (c *ClientWithResponses) DeleteElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteElasticIpResponse, error) {
	rsp, err := c.DeleteElasticIp(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteElasticIpResponse(rsp)
}

// GetElasticIpWithResponse request returning *GetElasticIpResponse
func (c *ClientWithResponses) GetElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetElasticIpResponse, error) {
	rsp, err := c.GetElasticIp(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetElasticIpResponse(rsp)
}

// UpdateElasticIpWithBodyWithResponse request with arbitrary body returning *UpdateElasticIpResponse
func (c *ClientWithResponses) UpdateElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateElasticIpResponse, error) {
	rsp, err := c.UpdateElasticIpWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateElasticIpResponse(rsp)
}

func (c *ClientWithResponses) UpdateElasticIpWithResponse(ctx context.Context, id string, body UpdateElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateElasticIpResponse, error) {
	rsp, err := c.UpdateElasticIp(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateElasticIpResponse(rsp)
}

// ResetElasticIpFieldWithResponse request returning *ResetElasticIpFieldResponse
func (c *ClientWithResponses) ResetElasticIpFieldWithResponse(ctx context.Context, id string, field ResetElasticIpFieldParamsField, reqEditors ...RequestEditorFn) (*ResetElasticIpFieldResponse, error) {
	rsp, err := c.ResetElasticIpField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetElasticIpFieldResponse(rsp)
}

// AttachInstanceToElasticIpWithBodyWithResponse request with arbitrary body returning *AttachInstanceToElasticIpResponse
func (c *ClientWithResponses) AttachInstanceToElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToElasticIpResponse, error) {
	rsp, err := c.AttachInstanceToElasticIpWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToElasticIpResponse(rsp)
}

func (c *ClientWithResponses) AttachInstanceToElasticIpWithResponse(ctx context.Context, id string, body AttachInstanceToElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToElasticIpResponse, error) {
	rsp, err := c.AttachInstanceToElasticIp(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToElasticIpResponse(rsp)
}

// DetachInstanceFromElasticIpWithBodyWithResponse request with arbitrary body returning *DetachInstanceFromElasticIpResponse
func (c *ClientWithResponses) DetachInstanceFromElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromElasticIpResponse, error) {
	rsp, err := c.DetachInstanceFromElasticIpWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromElasticIpResponse(rsp)
}

func (c *ClientWithResponses) DetachInstanceFromElasticIpWithResponse(ctx context.Context, id string, body DetachInstanceFromElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromElasticIpResponse, error) {
	rsp, err := c.DetachInstanceFromElasticIp(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromElasticIpResponse(rsp)
}

// ListEventsWithResponse request returning *ListEventsResponse
func (c *ClientWithResponses) ListEventsWithResponse(ctx context.Context, params *ListEventsParams, reqEditors ...RequestEditorFn) (*ListEventsResponse, error) {
	rsp, err := c.ListEvents(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListEventsResponse(rsp)
}

// GetIamOrganizationPolicyWithResponse request returning *GetIamOrganizationPolicyResponse
func (c *ClientWithResponses) GetIamOrganizationPolicyWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*GetIamOrganizationPolicyResponse, error) {
	rsp, err := c.GetIamOrganizationPolicy(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetIamOrganizationPolicyResponse(rsp)
}

// UpdateIamOrganizationPolicyWithBodyWithResponse request with arbitrary body returning *UpdateIamOrganizationPolicyResponse
func (c *ClientWithResponses) UpdateIamOrganizationPolicyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamOrganizationPolicyResponse, error) {
	rsp, err := c.UpdateIamOrganizationPolicyWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamOrganizationPolicyResponse(rsp)
}

func (c *ClientWithResponses) UpdateIamOrganizationPolicyWithResponse(ctx context.Context, body UpdateIamOrganizationPolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamOrganizationPolicyResponse, error) {
	rsp, err := c.UpdateIamOrganizationPolicy(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamOrganizationPolicyResponse(rsp)
}

// ListIamRolesWithResponse request returning *ListIamRolesResponse
func (c *ClientWithResponses) ListIamRolesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListIamRolesResponse, error) {
	rsp, err := c.ListIamRoles(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListIamRolesResponse(rsp)
}

// CreateIamRoleWithBodyWithResponse request with arbitrary body returning *CreateIamRoleResponse
func (c *ClientWithResponses) CreateIamRoleWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateIamRoleResponse, error) {
	rsp, err := c.CreateIamRoleWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateIamRoleResponse(rsp)
}

func (c *ClientWithResponses) CreateIamRoleWithResponse(ctx context.Context, body CreateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateIamRoleResponse, error) {
	rsp, err := c.CreateIamRole(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateIamRoleResponse(rsp)
}

// DeleteIamRoleWithResponse request returning *DeleteIamRoleResponse
func (c *ClientWithResponses) DeleteIamRoleWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteIamRoleResponse, error) {
	rsp, err := c.DeleteIamRole(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteIamRoleResponse(rsp)
}

// GetIamRoleWithResponse request returning *GetIamRoleResponse
func (c *ClientWithResponses) GetIamRoleWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetIamRoleResponse, error) {
	rsp, err := c.GetIamRole(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetIamRoleResponse(rsp)
}

// UpdateIamRoleWithBodyWithResponse request with arbitrary body returning *UpdateIamRoleResponse
func (c *ClientWithResponses) UpdateIamRoleWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamRoleResponse, error) {
	rsp, err := c.UpdateIamRoleWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamRoleResponse(rsp)
}

func (c *ClientWithResponses) UpdateIamRoleWithResponse(ctx context.Context, id string, body UpdateIamRoleJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamRoleResponse, error) {
	rsp, err := c.UpdateIamRole(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamRoleResponse(rsp)
}

// UpdateIamRolePolicyWithBodyWithResponse request with arbitrary body returning *UpdateIamRolePolicyResponse
func (c *ClientWithResponses) UpdateIamRolePolicyWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateIamRolePolicyResponse, error) {
	rsp, err := c.UpdateIamRolePolicyWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamRolePolicyResponse(rsp)
}

func (c *ClientWithResponses) UpdateIamRolePolicyWithResponse(ctx context.Context, id string, body UpdateIamRolePolicyJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateIamRolePolicyResponse, error) {
	rsp, err := c.UpdateIamRolePolicy(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateIamRolePolicyResponse(rsp)
}

// ListInstancesWithResponse request returning *ListInstancesResponse
func (c *ClientWithResponses) ListInstancesWithResponse(ctx context.Context, params *ListInstancesParams, reqEditors ...RequestEditorFn) (*ListInstancesResponse, error) {
	rsp, err := c.ListInstances(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListInstancesResponse(rsp)
}

// CreateInstanceWithBodyWithResponse request with arbitrary body returning *CreateInstanceResponse
func (c *ClientWithResponses) CreateInstanceWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateInstanceResponse, error) {
	rsp, err := c.CreateInstanceWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstanceResponse(rsp)
}

func (c *ClientWithResponses) CreateInstanceWithResponse(ctx context.Context, body CreateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateInstanceResponse, error) {
	rsp, err := c.CreateInstance(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstanceResponse(rsp)
}

// ListInstancePoolsWithResponse request returning *ListInstancePoolsResponse
func (c *ClientWithResponses) ListInstancePoolsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListInstancePoolsResponse, error) {
	rsp, err := c.ListInstancePools(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListInstancePoolsResponse(rsp)
}

// CreateInstancePoolWithBodyWithResponse request with arbitrary body returning *CreateInstancePoolResponse
func (c *ClientWithResponses) CreateInstancePoolWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateInstancePoolResponse, error) {
	rsp, err := c.CreateInstancePoolWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) CreateInstancePoolWithResponse(ctx context.Context, body CreateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateInstancePoolResponse, error) {
	rsp, err := c.CreateInstancePool(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstancePoolResponse(rsp)
}

// DeleteInstancePoolWithResponse request returning *DeleteInstancePoolResponse
func (c *ClientWithResponses) DeleteInstancePoolWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteInstancePoolResponse, error) {
	rsp, err := c.DeleteInstancePool(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteInstancePoolResponse(rsp)
}

// GetInstancePoolWithResponse request returning *GetInstancePoolResponse
func (c *ClientWithResponses) GetInstancePoolWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstancePoolResponse, error) {
	rsp, err := c.GetInstancePool(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetInstancePoolResponse(rsp)
}

// UpdateInstancePoolWithBodyWithResponse request with arbitrary body returning *UpdateInstancePoolResponse
func (c *ClientWithResponses) UpdateInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateInstancePoolResponse, error) {
	rsp, err := c.UpdateInstancePoolWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) UpdateInstancePoolWithResponse(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateInstancePoolResponse, error) {
	rsp, err := c.UpdateInstancePool(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstancePoolResponse(rsp)
}

// ResetInstancePoolFieldWithResponse request returning *ResetInstancePoolFieldResponse
func (c *ClientWithResponses) ResetInstancePoolFieldWithResponse(ctx context.Context, id string, field ResetInstancePoolFieldParamsField, reqEditors ...RequestEditorFn) (*ResetInstancePoolFieldResponse, error) {
	rsp, err := c.ResetInstancePoolField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetInstancePoolFieldResponse(rsp)
}

// EvictInstancePoolMembersWithBodyWithResponse request with arbitrary body returning *EvictInstancePoolMembersResponse
func (c *ClientWithResponses) EvictInstancePoolMembersWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*EvictInstancePoolMembersResponse, error) {
	rsp, err := c.EvictInstancePoolMembersWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseEvictInstancePoolMembersResponse(rsp)
}

func (c *ClientWithResponses) EvictInstancePoolMembersWithResponse(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*EvictInstancePoolMembersResponse, error) {
	rsp, err := c.EvictInstancePoolMembers(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseEvictInstancePoolMembersResponse(rsp)
}

// ScaleInstancePoolWithBodyWithResponse request with arbitrary body returning *ScaleInstancePoolResponse
func (c *ClientWithResponses) ScaleInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleInstancePoolResponse, error) {
	rsp, err := c.ScaleInstancePoolWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) ScaleInstancePoolWithResponse(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleInstancePoolResponse, error) {
	rsp, err := c.ScaleInstancePool(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstancePoolResponse(rsp)
}

// ListInstanceTypesWithResponse request returning *ListInstanceTypesResponse
func (c *ClientWithResponses) ListInstanceTypesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListInstanceTypesResponse, error) {
	rsp, err := c.ListInstanceTypes(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListInstanceTypesResponse(rsp)
}

// GetInstanceTypeWithResponse request returning *GetInstanceTypeResponse
func (c *ClientWithResponses) GetInstanceTypeWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstanceTypeResponse, error) {
	rsp, err := c.GetInstanceType(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetInstanceTypeResponse(rsp)
}

// DeleteInstanceWithResponse request returning *DeleteInstanceResponse
func (c *ClientWithResponses) DeleteInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteInstanceResponse, error) {
	rsp, err := c.DeleteInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteInstanceResponse(rsp)
}

// GetInstanceWithResponse request returning *GetInstanceResponse
func (c *ClientWithResponses) GetInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetInstanceResponse, error) {
	rsp, err := c.GetInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetInstanceResponse(rsp)
}

// UpdateInstanceWithBodyWithResponse request with arbitrary body returning *UpdateInstanceResponse
func (c *ClientWithResponses) UpdateInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateInstanceResponse, error) {
	rsp, err := c.UpdateInstanceWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstanceResponse(rsp)
}

func (c *ClientWithResponses) UpdateInstanceWithResponse(ctx context.Context, id string, body UpdateInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateInstanceResponse, error) {
	rsp, err := c.UpdateInstance(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstanceResponse(rsp)
}

// ResetInstanceFieldWithResponse request returning *ResetInstanceFieldResponse
func (c *ClientWithResponses) ResetInstanceFieldWithResponse(ctx context.Context, id string, field ResetInstanceFieldParamsField, reqEditors ...RequestEditorFn) (*ResetInstanceFieldResponse, error) {
	rsp, err := c.ResetInstanceField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetInstanceFieldResponse(rsp)
}

// AddInstanceProtectionWithResponse request returning *AddInstanceProtectionResponse
func (c *ClientWithResponses) AddInstanceProtectionWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*AddInstanceProtectionResponse, error) {
	rsp, err := c.AddInstanceProtection(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddInstanceProtectionResponse(rsp)
}

// CreateSnapshotWithResponse request returning *CreateSnapshotResponse
func (c *ClientWithResponses) CreateSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*CreateSnapshotResponse, error) {
	rsp, err := c.CreateSnapshot(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSnapshotResponse(rsp)
}

// RevealInstancePasswordWithResponse request returning *RevealInstancePasswordResponse
func (c *ClientWithResponses) RevealInstancePasswordWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RevealInstancePasswordResponse, error) {
	rsp, err := c.RevealInstancePassword(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRevealInstancePasswordResponse(rsp)
}

// RebootInstanceWithResponse request returning *RebootInstanceResponse
func (c *ClientWithResponses) RebootInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RebootInstanceResponse, error) {
	rsp, err := c.RebootInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRebootInstanceResponse(rsp)
}

// RemoveInstanceProtectionWithResponse request returning *RemoveInstanceProtectionResponse
func (c *ClientWithResponses) RemoveInstanceProtectionWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RemoveInstanceProtectionResponse, error) {
	rsp, err := c.RemoveInstanceProtection(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRemoveInstanceProtectionResponse(rsp)
}

// ResetInstanceWithBodyWithResponse request with arbitrary body returning *ResetInstanceResponse
func (c *ClientWithResponses) ResetInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResetInstanceResponse, error) {
	rsp, err := c.ResetInstanceWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetInstanceResponse(rsp)
}

func (c *ClientWithResponses) ResetInstanceWithResponse(ctx context.Context, id string, body ResetInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*ResetInstanceResponse, error) {
	rsp, err := c.ResetInstance(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetInstanceResponse(rsp)
}

// ResetInstancePasswordWithResponse request returning *ResetInstancePasswordResponse
func (c *ClientWithResponses) ResetInstancePasswordWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ResetInstancePasswordResponse, error) {
	rsp, err := c.ResetInstancePassword(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetInstancePasswordResponse(rsp)
}

// ResizeInstanceDiskWithBodyWithResponse request with arbitrary body returning *ResizeInstanceDiskResponse
func (c *ClientWithResponses) ResizeInstanceDiskWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ResizeInstanceDiskResponse, error) {
	rsp, err := c.ResizeInstanceDiskWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResizeInstanceDiskResponse(rsp)
}

func (c *ClientWithResponses) ResizeInstanceDiskWithResponse(ctx context.Context, id string, body ResizeInstanceDiskJSONRequestBody, reqEditors ...RequestEditorFn) (*ResizeInstanceDiskResponse, error) {
	rsp, err := c.ResizeInstanceDisk(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResizeInstanceDiskResponse(rsp)
}

// ScaleInstanceWithBodyWithResponse request with arbitrary body returning *ScaleInstanceResponse
func (c *ClientWithResponses) ScaleInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleInstanceResponse, error) {
	rsp, err := c.ScaleInstanceWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstanceResponse(rsp)
}

func (c *ClientWithResponses) ScaleInstanceWithResponse(ctx context.Context, id string, body ScaleInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleInstanceResponse, error) {
	rsp, err := c.ScaleInstance(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstanceResponse(rsp)
}

// StartInstanceWithBodyWithResponse request with arbitrary body returning *StartInstanceResponse
func (c *ClientWithResponses) StartInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*StartInstanceResponse, error) {
	rsp, err := c.StartInstanceWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartInstanceResponse(rsp)
}

func (c *ClientWithResponses) StartInstanceWithResponse(ctx context.Context, id string, body StartInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*StartInstanceResponse, error) {
	rsp, err := c.StartInstance(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStartInstanceResponse(rsp)
}

// StopInstanceWithResponse request returning *StopInstanceResponse
func (c *ClientWithResponses) StopInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*StopInstanceResponse, error) {
	rsp, err := c.StopInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseStopInstanceResponse(rsp)
}

// RevertInstanceToSnapshotWithBodyWithResponse request with arbitrary body returning *RevertInstanceToSnapshotResponse
func (c *ClientWithResponses) RevertInstanceToSnapshotWithBodyWithResponse(ctx context.Context, instanceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RevertInstanceToSnapshotResponse, error) {
	rsp, err := c.RevertInstanceToSnapshotWithBody(ctx, instanceId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRevertInstanceToSnapshotResponse(rsp)
}

func (c *ClientWithResponses) RevertInstanceToSnapshotWithResponse(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody, reqEditors ...RequestEditorFn) (*RevertInstanceToSnapshotResponse, error) {
	rsp, err := c.RevertInstanceToSnapshot(ctx, instanceId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRevertInstanceToSnapshotResponse(rsp)
}

// ListLoadBalancersWithResponse request returning *ListLoadBalancersResponse
func (c *ClientWithResponses) ListLoadBalancersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListLoadBalancersResponse, error) {
	rsp, err := c.ListLoadBalancers(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListLoadBalancersResponse(rsp)
}

// CreateLoadBalancerWithBodyWithResponse request with arbitrary body returning *CreateLoadBalancerResponse
func (c *ClientWithResponses) CreateLoadBalancerWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateLoadBalancerResponse, error) {
	rsp, err := c.CreateLoadBalancerWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) CreateLoadBalancerWithResponse(ctx context.Context, body CreateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateLoadBalancerResponse, error) {
	rsp, err := c.CreateLoadBalancer(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateLoadBalancerResponse(rsp)
}

// DeleteLoadBalancerWithResponse request returning *DeleteLoadBalancerResponse
func (c *ClientWithResponses) DeleteLoadBalancerWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteLoadBalancerResponse, error) {
	rsp, err := c.DeleteLoadBalancer(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLoadBalancerResponse(rsp)
}

// GetLoadBalancerWithResponse request returning *GetLoadBalancerResponse
func (c *ClientWithResponses) GetLoadBalancerWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetLoadBalancerResponse, error) {
	rsp, err := c.GetLoadBalancer(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLoadBalancerResponse(rsp)
}

// UpdateLoadBalancerWithBodyWithResponse request with arbitrary body returning *UpdateLoadBalancerResponse
func (c *ClientWithResponses) UpdateLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerResponse, error) {
	rsp, err := c.UpdateLoadBalancerWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) UpdateLoadBalancerWithResponse(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerResponse, error) {
	rsp, err := c.UpdateLoadBalancer(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerResponse(rsp)
}

// AddServiceToLoadBalancerWithBodyWithResponse request with arbitrary body returning *AddServiceToLoadBalancerResponse
func (c *ClientWithResponses) AddServiceToLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddServiceToLoadBalancerResponse, error) {
	rsp, err := c.AddServiceToLoadBalancerWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddServiceToLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) AddServiceToLoadBalancerWithResponse(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody, reqEditors ...RequestEditorFn) (*AddServiceToLoadBalancerResponse, error) {
	rsp, err := c.AddServiceToLoadBalancer(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddServiceToLoadBalancerResponse(rsp)
}

// DeleteLoadBalancerServiceWithResponse request returning *DeleteLoadBalancerServiceResponse
func (c *ClientWithResponses) DeleteLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*DeleteLoadBalancerServiceResponse, error) {
	rsp, err := c.DeleteLoadBalancerService(ctx, id, serviceId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLoadBalancerServiceResponse(rsp)
}

// GetLoadBalancerServiceWithResponse request returning *GetLoadBalancerServiceResponse
func (c *ClientWithResponses) GetLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, reqEditors ...RequestEditorFn) (*GetLoadBalancerServiceResponse, error) {
	rsp, err := c.GetLoadBalancerService(ctx, id, serviceId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetLoadBalancerServiceResponse(rsp)
}

// UpdateLoadBalancerServiceWithBodyWithResponse request with arbitrary body returning *UpdateLoadBalancerServiceResponse
func (c *ClientWithResponses) UpdateLoadBalancerServiceWithBodyWithResponse(ctx context.Context, id string, serviceId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerServiceResponse, error) {
	rsp, err := c.UpdateLoadBalancerServiceWithBody(ctx, id, serviceId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerServiceResponse(rsp)
}

func (c *ClientWithResponses) UpdateLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateLoadBalancerServiceResponse, error) {
	rsp, err := c.UpdateLoadBalancerService(ctx, id, serviceId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerServiceResponse(rsp)
}

// ResetLoadBalancerServiceFieldWithResponse request returning *ResetLoadBalancerServiceFieldResponse
func (c *ClientWithResponses) ResetLoadBalancerServiceFieldWithResponse(ctx context.Context, id string, serviceId string, field ResetLoadBalancerServiceFieldParamsField, reqEditors ...RequestEditorFn) (*ResetLoadBalancerServiceFieldResponse, error) {
	rsp, err := c.ResetLoadBalancerServiceField(ctx, id, serviceId, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetLoadBalancerServiceFieldResponse(rsp)
}

// ResetLoadBalancerFieldWithResponse request returning *ResetLoadBalancerFieldResponse
func (c *ClientWithResponses) ResetLoadBalancerFieldWithResponse(ctx context.Context, id string, field ResetLoadBalancerFieldParamsField, reqEditors ...RequestEditorFn) (*ResetLoadBalancerFieldResponse, error) {
	rsp, err := c.ResetLoadBalancerField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetLoadBalancerFieldResponse(rsp)
}

// GetOperationWithResponse request returning *GetOperationResponse
func (c *ClientWithResponses) GetOperationWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetOperationResponse, error) {
	rsp, err := c.GetOperation(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetOperationResponse(rsp)
}

// ListPrivateNetworksWithResponse request returning *ListPrivateNetworksResponse
func (c *ClientWithResponses) ListPrivateNetworksWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListPrivateNetworksResponse, error) {
	rsp, err := c.ListPrivateNetworks(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListPrivateNetworksResponse(rsp)
}

// CreatePrivateNetworkWithBodyWithResponse request with arbitrary body returning *CreatePrivateNetworkResponse
func (c *ClientWithResponses) CreatePrivateNetworkWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreatePrivateNetworkResponse, error) {
	rsp, err := c.CreatePrivateNetworkWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreatePrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) CreatePrivateNetworkWithResponse(ctx context.Context, body CreatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*CreatePrivateNetworkResponse, error) {
	rsp, err := c.CreatePrivateNetwork(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreatePrivateNetworkResponse(rsp)
}

// DeletePrivateNetworkWithResponse request returning *DeletePrivateNetworkResponse
func (c *ClientWithResponses) DeletePrivateNetworkWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeletePrivateNetworkResponse, error) {
	rsp, err := c.DeletePrivateNetwork(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeletePrivateNetworkResponse(rsp)
}

// GetPrivateNetworkWithResponse request returning *GetPrivateNetworkResponse
func (c *ClientWithResponses) GetPrivateNetworkWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetPrivateNetworkResponse, error) {
	rsp, err := c.GetPrivateNetwork(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetPrivateNetworkResponse(rsp)
}

// UpdatePrivateNetworkWithBodyWithResponse request with arbitrary body returning *UpdatePrivateNetworkResponse
func (c *ClientWithResponses) UpdatePrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkResponse, error) {
	rsp, err := c.UpdatePrivateNetworkWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) UpdatePrivateNetworkWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkResponse, error) {
	rsp, err := c.UpdatePrivateNetwork(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkResponse(rsp)
}

// ResetPrivateNetworkFieldWithResponse request returning *ResetPrivateNetworkFieldResponse
func (c *ClientWithResponses) ResetPrivateNetworkFieldWithResponse(ctx context.Context, id string, field ResetPrivateNetworkFieldParamsField, reqEditors ...RequestEditorFn) (*ResetPrivateNetworkFieldResponse, error) {
	rsp, err := c.ResetPrivateNetworkField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetPrivateNetworkFieldResponse(rsp)
}

// AttachInstanceToPrivateNetworkWithBodyWithResponse request with arbitrary body returning *AttachInstanceToPrivateNetworkResponse
func (c *ClientWithResponses) AttachInstanceToPrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToPrivateNetworkResponse, error) {
	rsp, err := c.AttachInstanceToPrivateNetworkWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToPrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) AttachInstanceToPrivateNetworkWithResponse(ctx context.Context, id string, body AttachInstanceToPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToPrivateNetworkResponse, error) {
	rsp, err := c.AttachInstanceToPrivateNetwork(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToPrivateNetworkResponse(rsp)
}

// DetachInstanceFromPrivateNetworkWithBodyWithResponse request with arbitrary body returning *DetachInstanceFromPrivateNetworkResponse
func (c *ClientWithResponses) DetachInstanceFromPrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromPrivateNetworkResponse, error) {
	rsp, err := c.DetachInstanceFromPrivateNetworkWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromPrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) DetachInstanceFromPrivateNetworkWithResponse(ctx context.Context, id string, body DetachInstanceFromPrivateNetworkJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromPrivateNetworkResponse, error) {
	rsp, err := c.DetachInstanceFromPrivateNetwork(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromPrivateNetworkResponse(rsp)
}

// UpdatePrivateNetworkInstanceIpWithBodyWithResponse request with arbitrary body returning *UpdatePrivateNetworkInstanceIpResponse
func (c *ClientWithResponses) UpdatePrivateNetworkInstanceIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkInstanceIpResponse, error) {
	rsp, err := c.UpdatePrivateNetworkInstanceIpWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkInstanceIpResponse(rsp)
}

func (c *ClientWithResponses) UpdatePrivateNetworkInstanceIpWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkInstanceIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdatePrivateNetworkInstanceIpResponse, error) {
	rsp, err := c.UpdatePrivateNetworkInstanceIp(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkInstanceIpResponse(rsp)
}

// ListQuotasWithResponse request returning *ListQuotasResponse
func (c *ClientWithResponses) ListQuotasWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListQuotasResponse, error) {
	rsp, err := c.ListQuotas(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListQuotasResponse(rsp)
}

// GetQuotaWithResponse request returning *GetQuotaResponse
func (c *ClientWithResponses) GetQuotaWithResponse(ctx context.Context, entity string, reqEditors ...RequestEditorFn) (*GetQuotaResponse, error) {
	rsp, err := c.GetQuota(ctx, entity, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetQuotaResponse(rsp)
}

// DeleteReverseDnsElasticIpWithResponse request returning *DeleteReverseDnsElasticIpResponse
func (c *ClientWithResponses) DeleteReverseDnsElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteReverseDnsElasticIpResponse, error) {
	rsp, err := c.DeleteReverseDnsElasticIp(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteReverseDnsElasticIpResponse(rsp)
}

// GetReverseDnsElasticIpWithResponse request returning *GetReverseDnsElasticIpResponse
func (c *ClientWithResponses) GetReverseDnsElasticIpWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetReverseDnsElasticIpResponse, error) {
	rsp, err := c.GetReverseDnsElasticIp(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetReverseDnsElasticIpResponse(rsp)
}

// UpdateReverseDnsElasticIpWithBodyWithResponse request with arbitrary body returning *UpdateReverseDnsElasticIpResponse
func (c *ClientWithResponses) UpdateReverseDnsElasticIpWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateReverseDnsElasticIpResponse, error) {
	rsp, err := c.UpdateReverseDnsElasticIpWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateReverseDnsElasticIpResponse(rsp)
}

func (c *ClientWithResponses) UpdateReverseDnsElasticIpWithResponse(ctx context.Context, id string, body UpdateReverseDnsElasticIpJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateReverseDnsElasticIpResponse, error) {
	rsp, err := c.UpdateReverseDnsElasticIp(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateReverseDnsElasticIpResponse(rsp)
}

// DeleteReverseDnsInstanceWithResponse request returning *DeleteReverseDnsInstanceResponse
func (c *ClientWithResponses) DeleteReverseDnsInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteReverseDnsInstanceResponse, error) {
	rsp, err := c.DeleteReverseDnsInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteReverseDnsInstanceResponse(rsp)
}

// GetReverseDnsInstanceWithResponse request returning *GetReverseDnsInstanceResponse
func (c *ClientWithResponses) GetReverseDnsInstanceWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetReverseDnsInstanceResponse, error) {
	rsp, err := c.GetReverseDnsInstance(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetReverseDnsInstanceResponse(rsp)
}

// UpdateReverseDnsInstanceWithBodyWithResponse request with arbitrary body returning *UpdateReverseDnsInstanceResponse
func (c *ClientWithResponses) UpdateReverseDnsInstanceWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateReverseDnsInstanceResponse, error) {
	rsp, err := c.UpdateReverseDnsInstanceWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateReverseDnsInstanceResponse(rsp)
}

func (c *ClientWithResponses) UpdateReverseDnsInstanceWithResponse(ctx context.Context, id string, body UpdateReverseDnsInstanceJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateReverseDnsInstanceResponse, error) {
	rsp, err := c.UpdateReverseDnsInstance(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateReverseDnsInstanceResponse(rsp)
}

// ListSecurityGroupsWithResponse request returning *ListSecurityGroupsResponse
func (c *ClientWithResponses) ListSecurityGroupsWithResponse(ctx context.Context, params *ListSecurityGroupsParams, reqEditors ...RequestEditorFn) (*ListSecurityGroupsResponse, error) {
	rsp, err := c.ListSecurityGroups(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSecurityGroupsResponse(rsp)
}

// CreateSecurityGroupWithBodyWithResponse request with arbitrary body returning *CreateSecurityGroupResponse
func (c *ClientWithResponses) CreateSecurityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSecurityGroupResponse, error) {
	rsp, err := c.CreateSecurityGroupWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) CreateSecurityGroupWithResponse(ctx context.Context, body CreateSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSecurityGroupResponse, error) {
	rsp, err := c.CreateSecurityGroup(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSecurityGroupResponse(rsp)
}

// DeleteSecurityGroupWithResponse request returning *DeleteSecurityGroupResponse
func (c *ClientWithResponses) DeleteSecurityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSecurityGroupResponse, error) {
	rsp, err := c.DeleteSecurityGroup(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSecurityGroupResponse(rsp)
}

// GetSecurityGroupWithResponse request returning *GetSecurityGroupResponse
func (c *ClientWithResponses) GetSecurityGroupWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSecurityGroupResponse, error) {
	rsp, err := c.GetSecurityGroup(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSecurityGroupResponse(rsp)
}

// AddRuleToSecurityGroupWithBodyWithResponse request with arbitrary body returning *AddRuleToSecurityGroupResponse
func (c *ClientWithResponses) AddRuleToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddRuleToSecurityGroupResponse, error) {
	rsp, err := c.AddRuleToSecurityGroupWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddRuleToSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) AddRuleToSecurityGroupWithResponse(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AddRuleToSecurityGroupResponse, error) {
	rsp, err := c.AddRuleToSecurityGroup(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddRuleToSecurityGroupResponse(rsp)
}

// DeleteRuleFromSecurityGroupWithResponse request returning *DeleteRuleFromSecurityGroupResponse
func (c *ClientWithResponses) DeleteRuleFromSecurityGroupWithResponse(ctx context.Context, id string, ruleId string, reqEditors ...RequestEditorFn) (*DeleteRuleFromSecurityGroupResponse, error) {
	rsp, err := c.DeleteRuleFromSecurityGroup(ctx, id, ruleId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteRuleFromSecurityGroupResponse(rsp)
}

// AddExternalSourceToSecurityGroupWithBodyWithResponse request with arbitrary body returning *AddExternalSourceToSecurityGroupResponse
func (c *ClientWithResponses) AddExternalSourceToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AddExternalSourceToSecurityGroupResponse, error) {
	rsp, err := c.AddExternalSourceToSecurityGroupWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddExternalSourceToSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) AddExternalSourceToSecurityGroupWithResponse(ctx context.Context, id string, body AddExternalSourceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AddExternalSourceToSecurityGroupResponse, error) {
	rsp, err := c.AddExternalSourceToSecurityGroup(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAddExternalSourceToSecurityGroupResponse(rsp)
}

// AttachInstanceToSecurityGroupWithBodyWithResponse request with arbitrary body returning *AttachInstanceToSecurityGroupResponse
func (c *ClientWithResponses) AttachInstanceToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*AttachInstanceToSecurityGroupResponse, error) {
	rsp, err := c.AttachInstanceToSecurityGroupWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) AttachInstanceToSecurityGroupWithResponse(ctx context.Context, id string, body AttachInstanceToSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*AttachInstanceToSecurityGroupResponse, error) {
	rsp, err := c.AttachInstanceToSecurityGroup(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseAttachInstanceToSecurityGroupResponse(rsp)
}

// DetachInstanceFromSecurityGroupWithBodyWithResponse request with arbitrary body returning *DetachInstanceFromSecurityGroupResponse
func (c *ClientWithResponses) DetachInstanceFromSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*DetachInstanceFromSecurityGroupResponse, error) {
	rsp, err := c.DetachInstanceFromSecurityGroupWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) DetachInstanceFromSecurityGroupWithResponse(ctx context.Context, id string, body DetachInstanceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*DetachInstanceFromSecurityGroupResponse, error) {
	rsp, err := c.DetachInstanceFromSecurityGroup(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDetachInstanceFromSecurityGroupResponse(rsp)
}

// RemoveExternalSourceFromSecurityGroupWithBodyWithResponse request with arbitrary body returning *RemoveExternalSourceFromSecurityGroupResponse
func (c *ClientWithResponses) RemoveExternalSourceFromSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RemoveExternalSourceFromSecurityGroupResponse, error) {
	rsp, err := c.RemoveExternalSourceFromSecurityGroupWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRemoveExternalSourceFromSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) RemoveExternalSourceFromSecurityGroupWithResponse(ctx context.Context, id string, body RemoveExternalSourceFromSecurityGroupJSONRequestBody, reqEditors ...RequestEditorFn) (*RemoveExternalSourceFromSecurityGroupResponse, error) {
	rsp, err := c.RemoveExternalSourceFromSecurityGroup(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRemoveExternalSourceFromSecurityGroupResponse(rsp)
}

// ListSksClustersWithResponse request returning *ListSksClustersResponse
func (c *ClientWithResponses) ListSksClustersWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSksClustersResponse, error) {
	rsp, err := c.ListSksClusters(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSksClustersResponse(rsp)
}

// CreateSksClusterWithBodyWithResponse request with arbitrary body returning *CreateSksClusterResponse
func (c *ClientWithResponses) CreateSksClusterWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSksClusterResponse, error) {
	rsp, err := c.CreateSksClusterWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksClusterResponse(rsp)
}

func (c *ClientWithResponses) CreateSksClusterWithResponse(ctx context.Context, body CreateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSksClusterResponse, error) {
	rsp, err := c.CreateSksCluster(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksClusterResponse(rsp)
}

// ListSksClusterDeprecatedResourcesWithResponse request returning *ListSksClusterDeprecatedResourcesResponse
func (c *ClientWithResponses) ListSksClusterDeprecatedResourcesWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ListSksClusterDeprecatedResourcesResponse, error) {
	rsp, err := c.ListSksClusterDeprecatedResources(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSksClusterDeprecatedResourcesResponse(rsp)
}

// GenerateSksClusterKubeconfigWithBodyWithResponse request with arbitrary body returning *GenerateSksClusterKubeconfigResponse
func (c *ClientWithResponses) GenerateSksClusterKubeconfigWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*GenerateSksClusterKubeconfigResponse, error) {
	rsp, err := c.GenerateSksClusterKubeconfigWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGenerateSksClusterKubeconfigResponse(rsp)
}

func (c *ClientWithResponses) GenerateSksClusterKubeconfigWithResponse(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody, reqEditors ...RequestEditorFn) (*GenerateSksClusterKubeconfigResponse, error) {
	rsp, err := c.GenerateSksClusterKubeconfig(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGenerateSksClusterKubeconfigResponse(rsp)
}

// ListSksClusterVersionsWithResponse request returning *ListSksClusterVersionsResponse
func (c *ClientWithResponses) ListSksClusterVersionsWithResponse(ctx context.Context, params *ListSksClusterVersionsParams, reqEditors ...RequestEditorFn) (*ListSksClusterVersionsResponse, error) {
	rsp, err := c.ListSksClusterVersions(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSksClusterVersionsResponse(rsp)
}

// DeleteSksClusterWithResponse request returning *DeleteSksClusterResponse
func (c *ClientWithResponses) DeleteSksClusterWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSksClusterResponse, error) {
	rsp, err := c.DeleteSksCluster(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksClusterResponse(rsp)
}

// GetSksClusterWithResponse request returning *GetSksClusterResponse
func (c *ClientWithResponses) GetSksClusterWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSksClusterResponse, error) {
	rsp, err := c.GetSksCluster(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSksClusterResponse(rsp)
}

// UpdateSksClusterWithBodyWithResponse request with arbitrary body returning *UpdateSksClusterResponse
func (c *ClientWithResponses) UpdateSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSksClusterResponse, error) {
	rsp, err := c.UpdateSksClusterWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksClusterResponse(rsp)
}

func (c *ClientWithResponses) UpdateSksClusterWithResponse(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSksClusterResponse, error) {
	rsp, err := c.UpdateSksCluster(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksClusterResponse(rsp)
}

// GetSksClusterAuthorityCertWithResponse request returning *GetSksClusterAuthorityCertResponse
func (c *ClientWithResponses) GetSksClusterAuthorityCertWithResponse(ctx context.Context, id string, authority GetSksClusterAuthorityCertParamsAuthority, reqEditors ...RequestEditorFn) (*GetSksClusterAuthorityCertResponse, error) {
	rsp, err := c.GetSksClusterAuthorityCert(ctx, id, authority, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSksClusterAuthorityCertResponse(rsp)
}

// CreateSksNodepoolWithBodyWithResponse request with arbitrary body returning *CreateSksNodepoolResponse
func (c *ClientWithResponses) CreateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CreateSksNodepoolResponse, error) {
	rsp, err := c.CreateSksNodepoolWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) CreateSksNodepoolWithResponse(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*CreateSksNodepoolResponse, error) {
	rsp, err := c.CreateSksNodepool(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksNodepoolResponse(rsp)
}

// DeleteSksNodepoolWithResponse request returning *DeleteSksNodepoolResponse
func (c *ClientWithResponses) DeleteSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*DeleteSksNodepoolResponse, error) {
	rsp, err := c.DeleteSksNodepool(ctx, id, sksNodepoolId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksNodepoolResponse(rsp)
}

// GetSksNodepoolWithResponse request returning *GetSksNodepoolResponse
func (c *ClientWithResponses) GetSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, reqEditors ...RequestEditorFn) (*GetSksNodepoolResponse, error) {
	rsp, err := c.GetSksNodepool(ctx, id, sksNodepoolId, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSksNodepoolResponse(rsp)
}

// UpdateSksNodepoolWithBodyWithResponse request with arbitrary body returning *UpdateSksNodepoolResponse
func (c *ClientWithResponses) UpdateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateSksNodepoolResponse, error) {
	rsp, err := c.UpdateSksNodepoolWithBody(ctx, id, sksNodepoolId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) UpdateSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateSksNodepoolResponse, error) {
	rsp, err := c.UpdateSksNodepool(ctx, id, sksNodepoolId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksNodepoolResponse(rsp)
}

// ResetSksNodepoolFieldWithResponse request returning *ResetSksNodepoolFieldResponse
func (c *ClientWithResponses) ResetSksNodepoolFieldWithResponse(ctx context.Context, id string, sksNodepoolId string, field ResetSksNodepoolFieldParamsField, reqEditors ...RequestEditorFn) (*ResetSksNodepoolFieldResponse, error) {
	rsp, err := c.ResetSksNodepoolField(ctx, id, sksNodepoolId, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetSksNodepoolFieldResponse(rsp)
}

// EvictSksNodepoolMembersWithBodyWithResponse request with arbitrary body returning *EvictSksNodepoolMembersResponse
func (c *ClientWithResponses) EvictSksNodepoolMembersWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*EvictSksNodepoolMembersResponse, error) {
	rsp, err := c.EvictSksNodepoolMembersWithBody(ctx, id, sksNodepoolId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseEvictSksNodepoolMembersResponse(rsp)
}

func (c *ClientWithResponses) EvictSksNodepoolMembersWithResponse(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody, reqEditors ...RequestEditorFn) (*EvictSksNodepoolMembersResponse, error) {
	rsp, err := c.EvictSksNodepoolMembers(ctx, id, sksNodepoolId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseEvictSksNodepoolMembersResponse(rsp)
}

// ScaleSksNodepoolWithBodyWithResponse request with arbitrary body returning *ScaleSksNodepoolResponse
func (c *ClientWithResponses) ScaleSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*ScaleSksNodepoolResponse, error) {
	rsp, err := c.ScaleSksNodepoolWithBody(ctx, id, sksNodepoolId, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) ScaleSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody, reqEditors ...RequestEditorFn) (*ScaleSksNodepoolResponse, error) {
	rsp, err := c.ScaleSksNodepool(ctx, id, sksNodepoolId, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseScaleSksNodepoolResponse(rsp)
}

// RotateSksCcmCredentialsWithResponse request returning *RotateSksCcmCredentialsResponse
func (c *ClientWithResponses) RotateSksCcmCredentialsWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RotateSksCcmCredentialsResponse, error) {
	rsp, err := c.RotateSksCcmCredentials(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRotateSksCcmCredentialsResponse(rsp)
}

// RotateSksOperatorsCaWithResponse request returning *RotateSksOperatorsCaResponse
func (c *ClientWithResponses) RotateSksOperatorsCaWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*RotateSksOperatorsCaResponse, error) {
	rsp, err := c.RotateSksOperatorsCa(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRotateSksOperatorsCaResponse(rsp)
}

// UpgradeSksClusterWithBodyWithResponse request with arbitrary body returning *UpgradeSksClusterResponse
func (c *ClientWithResponses) UpgradeSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpgradeSksClusterResponse, error) {
	rsp, err := c.UpgradeSksClusterWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpgradeSksClusterResponse(rsp)
}

func (c *ClientWithResponses) UpgradeSksClusterWithResponse(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody, reqEditors ...RequestEditorFn) (*UpgradeSksClusterResponse, error) {
	rsp, err := c.UpgradeSksCluster(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpgradeSksClusterResponse(rsp)
}

// UpgradeSksClusterServiceLevelWithResponse request returning *UpgradeSksClusterServiceLevelResponse
func (c *ClientWithResponses) UpgradeSksClusterServiceLevelWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*UpgradeSksClusterServiceLevelResponse, error) {
	rsp, err := c.UpgradeSksClusterServiceLevel(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpgradeSksClusterServiceLevelResponse(rsp)
}

// ResetSksClusterFieldWithResponse request returning *ResetSksClusterFieldResponse
func (c *ClientWithResponses) ResetSksClusterFieldWithResponse(ctx context.Context, id string, field ResetSksClusterFieldParamsField, reqEditors ...RequestEditorFn) (*ResetSksClusterFieldResponse, error) {
	rsp, err := c.ResetSksClusterField(ctx, id, field, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseResetSksClusterFieldResponse(rsp)
}

// ListSnapshotsWithResponse request returning *ListSnapshotsResponse
func (c *ClientWithResponses) ListSnapshotsWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSnapshotsResponse, error) {
	rsp, err := c.ListSnapshots(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSnapshotsResponse(rsp)
}

// DeleteSnapshotWithResponse request returning *DeleteSnapshotResponse
func (c *ClientWithResponses) DeleteSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteSnapshotResponse, error) {
	rsp, err := c.DeleteSnapshot(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSnapshotResponse(rsp)
}

// GetSnapshotWithResponse request returning *GetSnapshotResponse
func (c *ClientWithResponses) GetSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetSnapshotResponse, error) {
	rsp, err := c.GetSnapshot(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSnapshotResponse(rsp)
}

// ExportSnapshotWithResponse request returning *ExportSnapshotResponse
func (c *ClientWithResponses) ExportSnapshotWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*ExportSnapshotResponse, error) {
	rsp, err := c.ExportSnapshot(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseExportSnapshotResponse(rsp)
}

// PromoteSnapshotToTemplateWithBodyWithResponse request with arbitrary body returning *PromoteSnapshotToTemplateResponse
func (c *ClientWithResponses) PromoteSnapshotToTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*PromoteSnapshotToTemplateResponse, error) {
	rsp, err := c.PromoteSnapshotToTemplateWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParsePromoteSnapshotToTemplateResponse(rsp)
}

func (c *ClientWithResponses) PromoteSnapshotToTemplateWithResponse(ctx context.Context, id string, body PromoteSnapshotToTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*PromoteSnapshotToTemplateResponse, error) {
	rsp, err := c.PromoteSnapshotToTemplate(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParsePromoteSnapshotToTemplateResponse(rsp)
}

// ListSosBucketsUsageWithResponse request returning *ListSosBucketsUsageResponse
func (c *ClientWithResponses) ListSosBucketsUsageWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSosBucketsUsageResponse, error) {
	rsp, err := c.ListSosBucketsUsage(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSosBucketsUsageResponse(rsp)
}

// GetSosPresignedUrlWithResponse request returning *GetSosPresignedUrlResponse
func (c *ClientWithResponses) GetSosPresignedUrlWithResponse(ctx context.Context, bucket string, params *GetSosPresignedUrlParams, reqEditors ...RequestEditorFn) (*GetSosPresignedUrlResponse, error) {
	rsp, err := c.GetSosPresignedUrl(ctx, bucket, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSosPresignedUrlResponse(rsp)
}

// ListSshKeysWithResponse request returning *ListSshKeysResponse
func (c *ClientWithResponses) ListSshKeysWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListSshKeysResponse, error) {
	rsp, err := c.ListSshKeys(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListSshKeysResponse(rsp)
}

// RegisterSshKeyWithBodyWithResponse request with arbitrary body returning *RegisterSshKeyResponse
func (c *ClientWithResponses) RegisterSshKeyWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RegisterSshKeyResponse, error) {
	rsp, err := c.RegisterSshKeyWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRegisterSshKeyResponse(rsp)
}

func (c *ClientWithResponses) RegisterSshKeyWithResponse(ctx context.Context, body RegisterSshKeyJSONRequestBody, reqEditors ...RequestEditorFn) (*RegisterSshKeyResponse, error) {
	rsp, err := c.RegisterSshKey(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRegisterSshKeyResponse(rsp)
}

// DeleteSshKeyWithResponse request returning *DeleteSshKeyResponse
func (c *ClientWithResponses) DeleteSshKeyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*DeleteSshKeyResponse, error) {
	rsp, err := c.DeleteSshKey(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSshKeyResponse(rsp)
}

// GetSshKeyWithResponse request returning *GetSshKeyResponse
func (c *ClientWithResponses) GetSshKeyWithResponse(ctx context.Context, name string, reqEditors ...RequestEditorFn) (*GetSshKeyResponse, error) {
	rsp, err := c.GetSshKey(ctx, name, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetSshKeyResponse(rsp)
}

// ListTemplatesWithResponse request returning *ListTemplatesResponse
func (c *ClientWithResponses) ListTemplatesWithResponse(ctx context.Context, params *ListTemplatesParams, reqEditors ...RequestEditorFn) (*ListTemplatesResponse, error) {
	rsp, err := c.ListTemplates(ctx, params, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListTemplatesResponse(rsp)
}

// RegisterTemplateWithBodyWithResponse request with arbitrary body returning *RegisterTemplateResponse
func (c *ClientWithResponses) RegisterTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*RegisterTemplateResponse, error) {
	rsp, err := c.RegisterTemplateWithBody(ctx, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRegisterTemplateResponse(rsp)
}

func (c *ClientWithResponses) RegisterTemplateWithResponse(ctx context.Context, body RegisterTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*RegisterTemplateResponse, error) {
	rsp, err := c.RegisterTemplate(ctx, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseRegisterTemplateResponse(rsp)
}

// DeleteTemplateWithResponse request returning *DeleteTemplateResponse
func (c *ClientWithResponses) DeleteTemplateWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*DeleteTemplateResponse, error) {
	rsp, err := c.DeleteTemplate(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTemplateResponse(rsp)
}

// GetTemplateWithResponse request returning *GetTemplateResponse
func (c *ClientWithResponses) GetTemplateWithResponse(ctx context.Context, id string, reqEditors ...RequestEditorFn) (*GetTemplateResponse, error) {
	rsp, err := c.GetTemplate(ctx, id, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseGetTemplateResponse(rsp)
}

// CopyTemplateWithBodyWithResponse request with arbitrary body returning *CopyTemplateResponse
func (c *ClientWithResponses) CopyTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*CopyTemplateResponse, error) {
	rsp, err := c.CopyTemplateWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCopyTemplateResponse(rsp)
}

func (c *ClientWithResponses) CopyTemplateWithResponse(ctx context.Context, id string, body CopyTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*CopyTemplateResponse, error) {
	rsp, err := c.CopyTemplate(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseCopyTemplateResponse(rsp)
}

// UpdateTemplateWithBodyWithResponse request with arbitrary body returning *UpdateTemplateResponse
func (c *ClientWithResponses) UpdateTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader, reqEditors ...RequestEditorFn) (*UpdateTemplateResponse, error) {
	rsp, err := c.UpdateTemplateWithBody(ctx, id, contentType, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateTemplateResponse(rsp)
}

func (c *ClientWithResponses) UpdateTemplateWithResponse(ctx context.Context, id string, body UpdateTemplateJSONRequestBody, reqEditors ...RequestEditorFn) (*UpdateTemplateResponse, error) {
	rsp, err := c.UpdateTemplate(ctx, id, body, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseUpdateTemplateResponse(rsp)
}

// ListZonesWithResponse request returning *ListZonesResponse
func (c *ClientWithResponses) ListZonesWithResponse(ctx context.Context, reqEditors ...RequestEditorFn) (*ListZonesResponse, error) {
	rsp, err := c.ListZones(ctx, reqEditors...)
	if err != nil {
		return nil, err
	}
	return ParseListZonesResponse(rsp)
}

// ParseListAccessKeysResponse parses an HTTP response from a ListAccessKeysWithResponse call
func ParseListAccessKeysResponse(rsp *http.Response) (*ListAccessKeysResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListAccessKeysResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			AccessKeys *[]AccessKey `json:"access-keys,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateAccessKeyResponse parses an HTTP response from a CreateAccessKeyWithResponse call
func ParseCreateAccessKeyResponse(rsp *http.Response) (*CreateAccessKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateAccessKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AccessKey
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListAccessKeyKnownOperationsResponse parses an HTTP response from a ListAccessKeyKnownOperationsWithResponse call
func ParseListAccessKeyKnownOperationsResponse(rsp *http.Response) (*ListAccessKeyKnownOperationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListAccessKeyKnownOperationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			AccessKeyOperations *[]AccessKeyOperation `json:"access-key-operations,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListAccessKeyOperationsResponse parses an HTTP response from a ListAccessKeyOperationsWithResponse call
func ParseListAccessKeyOperationsResponse(rsp *http.Response) (*ListAccessKeyOperationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListAccessKeyOperationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			AccessKeyOperations *[]AccessKeyOperation `json:"access-key-operations,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseRevokeAccessKeyResponse parses an HTTP response from a RevokeAccessKeyWithResponse call
func ParseRevokeAccessKeyResponse(rsp *http.Response) (*RevokeAccessKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RevokeAccessKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetAccessKeyResponse parses an HTTP response from a GetAccessKeyWithResponse call
func ParseGetAccessKeyResponse(rsp *http.Response) (*GetAccessKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetAccessKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AccessKey
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListAntiAffinityGroupsResponse parses an HTTP response from a ListAntiAffinityGroupsWithResponse call
func ParseListAntiAffinityGroupsResponse(rsp *http.Response) (*ListAntiAffinityGroupsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListAntiAffinityGroupsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateAntiAffinityGroupResponse parses an HTTP response from a CreateAntiAffinityGroupWithResponse call
func ParseCreateAntiAffinityGroupResponse(rsp *http.Response) (*CreateAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteAntiAffinityGroupResponse parses an HTTP response from a DeleteAntiAffinityGroupWithResponse call
func ParseDeleteAntiAffinityGroupResponse(rsp *http.Response) (*DeleteAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetAntiAffinityGroupResponse parses an HTTP response from a GetAntiAffinityGroupWithResponse call
func ParseGetAntiAffinityGroupResponse(rsp *http.Response) (*GetAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AntiAffinityGroup
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListApiKeysResponse parses an HTTP response from a ListApiKeysWithResponse call
func ParseListApiKeysResponse(rsp *http.Response) (*ListApiKeysResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListApiKeysResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			ApiKeys *[]IamApiKey `json:"api-keys,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateApiKeyResponse parses an HTTP response from a CreateApiKeyWithResponse call
func ParseCreateApiKeyResponse(rsp *http.Response) (*CreateApiKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateApiKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest IamApiKeyCreated
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteApiKeyResponse parses an HTTP response from a DeleteApiKeyWithResponse call
func ParseDeleteApiKeyResponse(rsp *http.Response) (*DeleteApiKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteApiKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetApiKeyResponse parses an HTTP response from a GetApiKeyWithResponse call
func ParseGetApiKeyResponse(rsp *http.Response) (*GetApiKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetApiKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest IamApiKey
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasCaCertificateResponse parses an HTTP response from a GetDbaasCaCertificateWithResponse call
func ParseGetDbaasCaCertificateResponse(rsp *http.Response) (*GetDbaasCaCertificateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasCaCertificateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Certificate *string `json:"certificate,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceGrafanaResponse parses an HTTP response from a DeleteDbaasServiceGrafanaWithResponse call
func ParseDeleteDbaasServiceGrafanaResponse(rsp *http.Response) (*DeleteDbaasServiceGrafanaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceGrafanaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceGrafanaResponse parses an HTTP response from a GetDbaasServiceGrafanaWithResponse call
func ParseGetDbaasServiceGrafanaResponse(rsp *http.Response) (*GetDbaasServiceGrafanaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceGrafanaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceGrafana
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServiceGrafanaResponse parses an HTTP response from a CreateDbaasServiceGrafanaWithResponse call
func ParseCreateDbaasServiceGrafanaResponse(rsp *http.Response) (*CreateDbaasServiceGrafanaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServiceGrafanaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServiceGrafanaResponse parses an HTTP response from a UpdateDbaasServiceGrafanaWithResponse call
func ParseUpdateDbaasServiceGrafanaResponse(rsp *http.Response) (*UpdateDbaasServiceGrafanaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServiceGrafanaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasGrafanaMaintenanceResponse parses an HTTP response from a StartDbaasGrafanaMaintenanceWithResponse call
func ParseStartDbaasGrafanaMaintenanceResponse(rsp *http.Response) (*StartDbaasGrafanaMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasGrafanaMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasIntegrationResponse parses an HTTP response from a CreateDbaasIntegrationWithResponse call
func ParseCreateDbaasIntegrationResponse(rsp *http.Response) (*CreateDbaasIntegrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasIntegrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListDbaasIntegrationSettingsResponse parses an HTTP response from a ListDbaasIntegrationSettingsWithResponse call
func ParseListDbaasIntegrationSettingsResponse(rsp *http.Response) (*ListDbaasIntegrationSettingsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListDbaasIntegrationSettingsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			// The JSON schema representing the settings for the given integration type, source, and destination service types.
			Settings *struct {
				AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
				Properties           *map[string]interface{} `json:"properties,omitempty"`
				Title                *string                 `json:"title,omitempty"`
				Type                 *string                 `json:"type,omitempty"`
			} `json:"settings,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListDbaasIntegrationTypesResponse parses an HTTP response from a ListDbaasIntegrationTypesWithResponse call
func ParseListDbaasIntegrationTypesResponse(rsp *http.Response) (*ListDbaasIntegrationTypesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListDbaasIntegrationTypesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			DbaasIntegrationTypes *[]DbaasIntegrationType `json:"dbaas-integration-types,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasIntegrationResponse parses an HTTP response from a DeleteDbaasIntegrationWithResponse call
func ParseDeleteDbaasIntegrationResponse(rsp *http.Response) (*DeleteDbaasIntegrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasIntegrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasIntegrationResponse parses an HTTP response from a GetDbaasIntegrationWithResponse call
func ParseGetDbaasIntegrationResponse(rsp *http.Response) (*GetDbaasIntegrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasIntegrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasIntegration
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasIntegrationResponse parses an HTTP response from a UpdateDbaasIntegrationWithResponse call
func ParseUpdateDbaasIntegrationResponse(rsp *http.Response) (*UpdateDbaasIntegrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasIntegrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceKafkaResponse parses an HTTP response from a DeleteDbaasServiceKafkaWithResponse call
func ParseDeleteDbaasServiceKafkaResponse(rsp *http.Response) (*DeleteDbaasServiceKafkaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceKafkaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceKafkaResponse parses an HTTP response from a GetDbaasServiceKafkaWithResponse call
func ParseGetDbaasServiceKafkaResponse(rsp *http.Response) (*GetDbaasServiceKafkaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceKafkaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceKafka
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServiceKafkaResponse parses an HTTP response from a CreateDbaasServiceKafkaWithResponse call
func ParseCreateDbaasServiceKafkaResponse(rsp *http.Response) (*CreateDbaasServiceKafkaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServiceKafkaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServiceKafkaResponse parses an HTTP response from a UpdateDbaasServiceKafkaWithResponse call
func ParseUpdateDbaasServiceKafkaResponse(rsp *http.Response) (*UpdateDbaasServiceKafkaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServiceKafkaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasKafkaAclConfigResponse parses an HTTP response from a GetDbaasKafkaAclConfigWithResponse call
func ParseGetDbaasKafkaAclConfigResponse(rsp *http.Response) (*GetDbaasKafkaAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasKafkaAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasKafkaAcls
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasKafkaMaintenanceResponse parses an HTTP response from a StartDbaasKafkaMaintenanceWithResponse call
func ParseStartDbaasKafkaMaintenanceResponse(rsp *http.Response) (*StartDbaasKafkaMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasKafkaMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasKafkaSchemaRegistryAclConfigResponse parses an HTTP response from a CreateDbaasKafkaSchemaRegistryAclConfigWithResponse call
func ParseCreateDbaasKafkaSchemaRegistryAclConfigResponse(rsp *http.Response) (*CreateDbaasKafkaSchemaRegistryAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasKafkaSchemaRegistryAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasKafkaSchemaRegistryAclConfigResponse parses an HTTP response from a DeleteDbaasKafkaSchemaRegistryAclConfigWithResponse call
func ParseDeleteDbaasKafkaSchemaRegistryAclConfigResponse(rsp *http.Response) (*DeleteDbaasKafkaSchemaRegistryAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasKafkaSchemaRegistryAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasKafkaTopicAclConfigResponse parses an HTTP response from a CreateDbaasKafkaTopicAclConfigWithResponse call
func ParseCreateDbaasKafkaTopicAclConfigResponse(rsp *http.Response) (*CreateDbaasKafkaTopicAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasKafkaTopicAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasKafkaTopicAclConfigResponse parses an HTTP response from a DeleteDbaasKafkaTopicAclConfigWithResponse call
func ParseDeleteDbaasKafkaTopicAclConfigResponse(rsp *http.Response) (*DeleteDbaasKafkaTopicAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasKafkaTopicAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasKafkaUserResponse parses an HTTP response from a CreateDbaasKafkaUserWithResponse call
func ParseCreateDbaasKafkaUserResponse(rsp *http.Response) (*CreateDbaasKafkaUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasKafkaUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasKafkaUserResponse parses an HTTP response from a DeleteDbaasKafkaUserWithResponse call
func ParseDeleteDbaasKafkaUserResponse(rsp *http.Response) (*DeleteDbaasKafkaUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasKafkaUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseResetDbaasKafkaUserPasswordResponse parses an HTTP response from a ResetDbaasKafkaUserPasswordWithResponse call
func ParseResetDbaasKafkaUserPasswordResponse(rsp *http.Response) (*ResetDbaasKafkaUserPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResetDbaasKafkaUserPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasMigrationStatusResponse parses an HTTP response from a GetDbaasMigrationStatusWithResponse call
func ParseGetDbaasMigrationStatusResponse(rsp *http.Response) (*GetDbaasMigrationStatusResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasMigrationStatusResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasMigrationStatus
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceMysqlResponse parses an HTTP response from a DeleteDbaasServiceMysqlWithResponse call
func ParseDeleteDbaasServiceMysqlResponse(rsp *http.Response) (*DeleteDbaasServiceMysqlResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceMysqlResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceMysqlResponse parses an HTTP response from a GetDbaasServiceMysqlWithResponse call
func ParseGetDbaasServiceMysqlResponse(rsp *http.Response) (*GetDbaasServiceMysqlResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceMysqlResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceMysql
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServiceMysqlResponse parses an HTTP response from a CreateDbaasServiceMysqlWithResponse call
func ParseCreateDbaasServiceMysqlResponse(rsp *http.Response) (*CreateDbaasServiceMysqlResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServiceMysqlResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServiceMysqlResponse parses an HTTP response from a UpdateDbaasServiceMysqlWithResponse call
func ParseUpdateDbaasServiceMysqlResponse(rsp *http.Response) (*UpdateDbaasServiceMysqlResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServiceMysqlResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasMysqlMaintenanceResponse parses an HTTP response from a StartDbaasMysqlMaintenanceWithResponse call
func ParseStartDbaasMysqlMaintenanceResponse(rsp *http.Response) (*StartDbaasMysqlMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasMysqlMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStopDbaasMysqlMigrationResponse parses an HTTP response from a StopDbaasMysqlMigrationWithResponse call
func ParseStopDbaasMysqlMigrationResponse(rsp *http.Response) (*StopDbaasMysqlMigrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StopDbaasMysqlMigrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasMysqlDatabaseResponse parses an HTTP response from a CreateDbaasMysqlDatabaseWithResponse call
func ParseCreateDbaasMysqlDatabaseResponse(rsp *http.Response) (*CreateDbaasMysqlDatabaseResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasMysqlDatabaseResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasMysqlDatabaseResponse parses an HTTP response from a DeleteDbaasMysqlDatabaseWithResponse call
func ParseDeleteDbaasMysqlDatabaseResponse(rsp *http.Response) (*DeleteDbaasMysqlDatabaseResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasMysqlDatabaseResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasMysqlUserResponse parses an HTTP response from a CreateDbaasMysqlUserWithResponse call
func ParseCreateDbaasMysqlUserResponse(rsp *http.Response) (*CreateDbaasMysqlUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasMysqlUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasMysqlUserResponse parses an HTTP response from a DeleteDbaasMysqlUserWithResponse call
func ParseDeleteDbaasMysqlUserResponse(rsp *http.Response) (*DeleteDbaasMysqlUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasMysqlUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseResetDbaasMysqlUserPasswordResponse parses an HTTP response from a ResetDbaasMysqlUserPasswordWithResponse call
func ParseResetDbaasMysqlUserPasswordResponse(rsp *http.Response) (*ResetDbaasMysqlUserPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResetDbaasMysqlUserPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceOpensearchResponse parses an HTTP response from a DeleteDbaasServiceOpensearchWithResponse call
func ParseDeleteDbaasServiceOpensearchResponse(rsp *http.Response) (*DeleteDbaasServiceOpensearchResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceOpensearchResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceOpensearchResponse parses an HTTP response from a GetDbaasServiceOpensearchWithResponse call
func ParseGetDbaasServiceOpensearchResponse(rsp *http.Response) (*GetDbaasServiceOpensearchResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceOpensearchResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceOpensearch
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServiceOpensearchResponse parses an HTTP response from a CreateDbaasServiceOpensearchWithResponse call
func ParseCreateDbaasServiceOpensearchResponse(rsp *http.Response) (*CreateDbaasServiceOpensearchResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServiceOpensearchResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServiceOpensearchResponse parses an HTTP response from a UpdateDbaasServiceOpensearchWithResponse call
func ParseUpdateDbaasServiceOpensearchResponse(rsp *http.Response) (*UpdateDbaasServiceOpensearchResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServiceOpensearchResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasOpensearchAclConfigResponse parses an HTTP response from a GetDbaasOpensearchAclConfigWithResponse call
func ParseGetDbaasOpensearchAclConfigResponse(rsp *http.Response) (*GetDbaasOpensearchAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasOpensearchAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasOpensearchAclConfig
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasOpensearchAclConfigResponse parses an HTTP response from a UpdateDbaasOpensearchAclConfigWithResponse call
func ParseUpdateDbaasOpensearchAclConfigResponse(rsp *http.Response) (*UpdateDbaasOpensearchAclConfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasOpensearchAclConfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasOpensearchMaintenanceResponse parses an HTTP response from a StartDbaasOpensearchMaintenanceWithResponse call
func ParseStartDbaasOpensearchMaintenanceResponse(rsp *http.Response) (*StartDbaasOpensearchMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasOpensearchMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasOpensearchUserResponse parses an HTTP response from a CreateDbaasOpensearchUserWithResponse call
func ParseCreateDbaasOpensearchUserResponse(rsp *http.Response) (*CreateDbaasOpensearchUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasOpensearchUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasOpensearchUserResponse parses an HTTP response from a DeleteDbaasOpensearchUserWithResponse call
func ParseDeleteDbaasOpensearchUserResponse(rsp *http.Response) (*DeleteDbaasOpensearchUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasOpensearchUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseResetDbaasOpensearchUserPasswordResponse parses an HTTP response from a ResetDbaasOpensearchUserPasswordWithResponse call
func ParseResetDbaasOpensearchUserPasswordResponse(rsp *http.Response) (*ResetDbaasOpensearchUserPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResetDbaasOpensearchUserPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServicePgResponse parses an HTTP response from a DeleteDbaasServicePgWithResponse call
func ParseDeleteDbaasServicePgResponse(rsp *http.Response) (*DeleteDbaasServicePgResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServicePgResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServicePgResponse parses an HTTP response from a GetDbaasServicePgWithResponse call
func ParseGetDbaasServicePgResponse(rsp *http.Response) (*GetDbaasServicePgResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServicePgResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServicePg
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServicePgResponse parses an HTTP response from a CreateDbaasServicePgWithResponse call
func ParseCreateDbaasServicePgResponse(rsp *http.Response) (*CreateDbaasServicePgResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServicePgResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServicePgResponse parses an HTTP response from a UpdateDbaasServicePgWithResponse call
func ParseUpdateDbaasServicePgResponse(rsp *http.Response) (*UpdateDbaasServicePgResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServicePgResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasPgMaintenanceResponse parses an HTTP response from a StartDbaasPgMaintenanceWithResponse call
func ParseStartDbaasPgMaintenanceResponse(rsp *http.Response) (*StartDbaasPgMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasPgMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStopDbaasPgMigrationResponse parses an HTTP response from a StopDbaasPgMigrationWithResponse call
func ParseStopDbaasPgMigrationResponse(rsp *http.Response) (*StopDbaasPgMigrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StopDbaasPgMigrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasPgConnectionPoolResponse parses an HTTP response from a CreateDbaasPgConnectionPoolWithResponse call
func ParseCreateDbaasPgConnectionPoolResponse(rsp *http.Response) (*CreateDbaasPgConnectionPoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasPgConnectionPoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasPgConnectionPoolResponse parses an HTTP response from a DeleteDbaasPgConnectionPoolWithResponse call
func ParseDeleteDbaasPgConnectionPoolResponse(rsp *http.Response) (*DeleteDbaasPgConnectionPoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasPgConnectionPoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasPgConnectionPoolResponse parses an HTTP response from a UpdateDbaasPgConnectionPoolWithResponse call
func ParseUpdateDbaasPgConnectionPoolResponse(rsp *http.Response) (*UpdateDbaasPgConnectionPoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasPgConnectionPoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasPgDatabaseResponse parses an HTTP response from a CreateDbaasPgDatabaseWithResponse call
func ParseCreateDbaasPgDatabaseResponse(rsp *http.Response) (*CreateDbaasPgDatabaseResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasPgDatabaseResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasPgDatabaseResponse parses an HTTP response from a DeleteDbaasPgDatabaseWithResponse call
func ParseDeleteDbaasPgDatabaseResponse(rsp *http.Response) (*DeleteDbaasPgDatabaseResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasPgDatabaseResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasPostgresUserResponse parses an HTTP response from a CreateDbaasPostgresUserWithResponse call
func ParseCreateDbaasPostgresUserResponse(rsp *http.Response) (*CreateDbaasPostgresUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasPostgresUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasPostgresUserResponse parses an HTTP response from a DeleteDbaasPostgresUserWithResponse call
func ParseDeleteDbaasPostgresUserResponse(rsp *http.Response) (*DeleteDbaasPostgresUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasPostgresUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasPostgresAllowReplicationResponse parses an HTTP response from a UpdateDbaasPostgresAllowReplicationWithResponse call
func ParseUpdateDbaasPostgresAllowReplicationResponse(rsp *http.Response) (*UpdateDbaasPostgresAllowReplicationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasPostgresAllowReplicationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasPostgresUsers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseResetDbaasPostgresUserPasswordResponse parses an HTTP response from a ResetDbaasPostgresUserPasswordWithResponse call
func ParseResetDbaasPostgresUserPasswordResponse(rsp *http.Response) (*ResetDbaasPostgresUserPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResetDbaasPostgresUserPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasPgUpgradeCheckResponse parses an HTTP response from a CreateDbaasPgUpgradeCheckWithResponse call
func ParseCreateDbaasPgUpgradeCheckResponse(rsp *http.Response) (*CreateDbaasPgUpgradeCheckResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasPgUpgradeCheckResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasTask
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceRedisResponse parses an HTTP response from a DeleteDbaasServiceRedisWithResponse call
func ParseDeleteDbaasServiceRedisResponse(rsp *http.Response) (*DeleteDbaasServiceRedisResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceRedisResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceRedisResponse parses an HTTP response from a GetDbaasServiceRedisWithResponse call
func ParseGetDbaasServiceRedisResponse(rsp *http.Response) (*GetDbaasServiceRedisResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceRedisResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceRedis
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateDbaasServiceRedisResponse parses an HTTP response from a CreateDbaasServiceRedisWithResponse call
func ParseCreateDbaasServiceRedisResponse(rsp *http.Response) (*CreateDbaasServiceRedisResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &CreateDbaasServiceRedisResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateDbaasServiceRedisResponse parses an HTTP response from a UpdateDbaasServiceRedisWithResponse call
func ParseUpdateDbaasServiceRedisResponse(rsp *http.Response) (*UpdateDbaasServiceRedisResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UpdateDbaasServiceRedisResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStartDbaasRedisMaintenanceResponse parses an HTTP response from a StartDbaasRedisMaintenanceWithResponse call
func ParseStartDbaasRedisMaintenanceResponse(rsp *http.Response) (*StartDbaasRedisMaintenanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StartDbaasRedisMaintenanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseStopDbaasRedisMigrationResponse parses an HTTP response from a StopDbaasRedisMigrationWithResponse call
func ParseStopDbaasRedisMigrationResponse(rsp *http.Response) (*StopDbaasRedisMigrationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &StopDbaasRedisMigrationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListDbaasServicesResponse parses an HTTP response from a ListDbaasServicesWithResponse call
func ParseListDbaasServicesResponse(rsp *http.Response) (*ListDbaasServicesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListDbaasServicesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			DbaasServices *[]DbaasServiceCommon `json:"dbaas-services,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceLogsResponse parses an HTTP response from a GetDbaasServiceLogsWithResponse call
func ParseGetDbaasServiceLogsResponse(rsp *http.Response) (*GetDbaasServiceLogsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceLogsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceLogs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceMetricsResponse parses an HTTP response from a GetDbaasServiceMetricsWithResponse call
func ParseGetDbaasServiceMetricsResponse(rsp *http.Response) (*GetDbaasServiceMetricsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceMetricsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Metrics *map[string]interface{} `json:"metrics,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListDbaasServiceTypesResponse parses an HTTP response from a ListDbaasServiceTypesWithResponse call
func ParseListDbaasServiceTypesResponse(rsp *http.Response) (*ListDbaasServiceTypesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ListDbaasServiceTypesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			DbaasServiceTypes *[]DbaasServiceType `json:"dbaas-service-types,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasServiceTypeResponse parses an HTTP response from a GetDbaasServiceTypeWithResponse call
func ParseGetDbaasServiceTypeResponse(rsp *http.Response) (*GetDbaasServiceTypeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasServiceTypeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DbaasServiceType
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteDbaasServiceResponse parses an HTTP response from a DeleteDbaasServiceWithResponse call
func ParseDeleteDbaasServiceResponse(rsp *http.Response) (*DeleteDbaasServiceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DeleteDbaasServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasSettingsGrafanaResponse parses an HTTP response from a GetDbaasSettingsGrafanaWithResponse call
func ParseGetDbaasSettingsGrafanaResponse(rsp *http.Response) (*GetDbaasSettingsGrafanaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasSettingsGrafanaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Settings *struct {
				// Grafana configuration values
				Grafana *struct {
					AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
					Properties           *map[string]interface{} `json:"properties,omitempty"`
					Title                *string                 `json:"title,omitempty"`
					Type                 *string                 `json:"type,omitempty"`
				} `json:"grafana,omitempty"`
			} `json:"settings,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetDbaasSettingsKafkaResponse parses an HTTP response from a GetDbaasSettingsKafkaWithResponse call
func ParseGetDbaasSettingsKafkaResponse(rsp *http.Response) (*GetDbaasSettingsKafkaResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &GetDbaasSettingsKafkaResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Settings *struct {
				// Kafka broker configuration values
				Kafka *struct {
					AdditionalProperties *bool                   `json:"additionalProperties,omitempty"`
					Properties           *map[string]interface{} `json:"properties,omitempty"`
					Title                *string                 `json:"