/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;

public class IndexOf
extends CollatingFunction {
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        GenericAtomicComparer comparer = this.getAtomicComparer(2, context);
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue val = (AtomicValue)this.argument[1].evaluateItem(context);
        return new IndexIterator(seq, val, comparer);
    }

    public static class IndexIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicValue value;
        private GenericAtomicComparer comparer;
        private int index = 0;
        private int position = 0;
        private Item current = null;
        private BuiltInAtomicType primitiveTypeRequired;

        public IndexIterator(SequenceIterator base, AtomicValue value, GenericAtomicComparer comparer) {
            this.base = base;
            this.value = value;
            this.comparer = comparer;
            this.primitiveTypeRequired = value.getPrimitiveType();
        }

        public Item next() throws XPathException {
            AtomicValue i;
            while ((i = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!Type.isComparable(this.primitiveTypeRequired, i.getPrimitiveType(), false)) continue;
                try {
                    if (!this.comparer.comparesEqual(i, this.value)) continue;
                    this.current = Int64Value.makeIntegerValue(this.index);
                    ++this.position;
                    return this.current;
                }
                catch (ClassCastException classCastException) {
                }
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

