/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.sort.LRUCache;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.value.Whitespace;

public class StandardURIChecker
implements URIChecker,
Serializable {
    private static StandardURIChecker THE_INSTANCE = new StandardURIChecker();
    private static ThreadLocal<LRUCache<CharSequence, Boolean>> caches = new ThreadLocal();

    public static StandardURIChecker getInstance() {
        return THE_INSTANCE;
    }

    protected StandardURIChecker() {
    }

    public boolean isValidURI(CharSequence value) {
        LRUCache<CharSequence, Boolean> cache = caches.get();
        if (cache == null) {
            cache = new LRUCache(50);
            caches.set(cache);
        }
        if (cache.get(value) != null) {
            return true;
        }
        String sv = Whitespace.trim(value);
        if (sv.length() == 0) {
            return true;
        }
        try {
            new URI(sv);
            cache.put(value, Boolean.TRUE);
            return true;
        }
        catch (URISyntaxException e) {
            sv = ((Object)EscapeURI.iriToUri(sv)).toString();
            try {
                new URI(sv);
                cache.put(value, Boolean.TRUE);
                return true;
            }
            catch (URISyntaxException e2) {
                return false;
            }
        }
    }

    public static void main(String[] args) {
        System.err.println(args[0] + " is valid? - " + StandardURIChecker.getInstance().isValidURI(args[0]));
    }
}

