/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class UntypedAtomicConverter
extends UnaryExpression {
    private AtomicType requiredItemType;
    private boolean allConverted;
    private boolean singleton = false;
    private RoleLocator role;

    public UntypedAtomicConverter(Expression sequence, AtomicType requiredItemType, boolean allConverted, RoleLocator role) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.allConverted = allConverted;
        this.role = role;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public ItemType getRequiredItemType() {
        return this.requiredItemType;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public boolean areAllItemsConverted() {
        return this.allConverted;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType it = this.operand.getItemType(th);
        boolean bl = this.singleton = it.isAtomicType() && !Cardinality.allowsMany(this.operand.getCardinality());
        if (this.allConverted) {
            return this.requiredItemType;
        }
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType(th), th);
    }

    public int computeCardinality() {
        if (this.singleton) {
            return 24576;
        }
        return super.computeCardinality();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.allConverted && this.requiredItemType.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot convert untypedAtomic values to QNames or NOTATIONs");
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral(((Value)SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))).reduce());
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType type = this.operand.getItemType(th);
        if (type instanceof NodeTest) {
            return this;
        }
        boolean bl = this.singleton = type.isAtomicType() && !Cardinality.allowsMany(this.operand.getCardinality());
        if (this.operand instanceof Atomizer && type.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.requiredItemType == BuiltInAtomicType.STRING && ((Atomizer)this.operand).getBaseExpression().getItemType(th) instanceof NodeTest) {
            Expression nodeExp = ((Atomizer)this.operand).getBaseExpression();
            if (nodeExp.getCardinality() != 16384) {
                SystemFunction fn = (SystemFunction)SystemFunction.makeSystemFunction("string", new Expression[]{new ContextItemExpression()});
                fn.setContainer(this.getContainer());
                ForEach map = new ForEach(nodeExp, fn);
                map.setContainer(this.getContainer());
                return map;
            }
            SystemFunction fn = (SystemFunction)SystemFunction.makeSystemFunction("string", new Expression[]{nodeExp});
            fn.setContainer(this.getContainer());
            return fn;
        }
        if (type.equals(BuiltInAtomicType.ANY_ATOMIC) || type instanceof AnyItemType || type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return this;
        }
        return this.operand;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e;
        ItemType et;
        AtomicType it;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (this.operand instanceof CastExpression && th.isSubType(it = ((CastExpression)this.operand).getTargetType(), BuiltInAtomicType.UNTYPED_ATOMIC) && (et = (e = ((CastExpression)this.operand).getBaseExpression()).getItemType(th)) instanceof AtomicType && th.isSubType(et, this.requiredItemType)) {
            return e;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000 | 0x2000000;
    }

    public Expression copy() {
        return new UntypedAtomicConverter(this.getBaseExpression().copy(), this.requiredItemType, this.allConverted, this.role);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return new ItemMappingIterator(base, this.getMappingFunction(context), true);
    }

    public ItemMappingFunction getMappingFunction(final XPathContext context) {
        final ConversionRules rules = context.getConfiguration().getConversionRules();
        return new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                if (item instanceof UntypedAtomicValue) {
                    ConversionResult val = ((UntypedAtomicValue)item).convert(UntypedAtomicConverter.this.requiredItemType, true, rules);
                    if (val instanceof ValidationFailure) {
                        String msg = UntypedAtomicConverter.this.role.composeRequiredMessage(UntypedAtomicConverter.this.requiredItemType, context.getNamePool());
                        msg = msg + ". " + ((ValidationFailure)val).getMessage();
                        XPathException err = new XPathException(msg);
                        err.setErrorCode(UntypedAtomicConverter.this.role.getErrorCode());
                        err.setLocator(UntypedAtomicConverter.this);
                        throw err;
                    }
                    return (AtomicValue)val;
                }
                return item;
            }
        };
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            ConversionResult val = ((UntypedAtomicValue)item).convert(this.requiredItemType, true, rules);
            if (val instanceof ValidationFailure) {
                String msg = this.role.composeRequiredMessage(this.requiredItemType, context.getNamePool());
                msg = msg + ". " + ((ValidationFailure)val).getMessage();
                XPathException err = new XPathException(msg);
                err.setErrorCode(this.role.getErrorCode());
                err.setLocator(this);
                throw err;
            }
            return (AtomicValue)val;
        }
        return item;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("convertUntypedAtomic");
        out.emitAttribute("to", this.requiredItemType.toString(out.getConfiguration().getNamePool()));
        out.emitAttribute("all", this.allConverted ? "true" : "false");
        this.operand.explain(out);
        out.endElement();
    }

    protected String displayOperator(Configuration config) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(config.getNamePool());
    }

    public String getExpressionName() {
        return "convertUntypedAtomic";
    }
}

