/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.Log;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.Type;

public class InstructionVisitor
extends EmptyVisitor {
    private ConstantPoolGen poolGen;
    private Log log;
    private Design design;

    public InstructionVisitor(ConstantPoolGen poolGen, Log log, Design d) {
        this.poolGen = poolGen;
        this.log = log;
        this.design = d;
    }

    public void visitCHECKCAST(CHECKCAST c) {
        Type t = c.getType(this.poolGen);
        this.log.log("         instr(checkcast)=" + t, 4);
        String type = t.toString();
        this.design.checkClass(type);
    }

    public void visitLoadInstruction(LoadInstruction l) {
        Type t = l.getType(this.poolGen);
        this.log.log("         instr(loadinstr)=" + t, 4);
        String type = t.toString();
        this.design.checkClass(type);
    }

    public void visitNEW(NEW n) {
        Type t = n.getType(this.poolGen);
        this.log.log("         instr(new)=" + t, 4);
        String type = t.toString();
        this.design.checkClass(type);
    }

    public void visitANEWARRAY(ANEWARRAY n) {
        Type t = n.getType(this.poolGen);
        this.log.log("         instr(anewarray)=" + t, 4);
        String type = t.toString();
        this.design.checkClass(type);
    }

    public void visitINSTANCEOF(INSTANCEOF i) {
        Type t = i.getType(this.poolGen);
        this.log.log("         instr(instanceof)=" + t, 4);
        String type = t.toString();
        this.design.checkClass(type);
    }

    public void visitINVOKESTATIC(INVOKESTATIC s) {
        String t = s.getClassName(this.poolGen);
        this.log.log("         instr(invokestatic)=" + t, 4);
        this.design.checkClass(t);
    }

    public void visitPUTSTATIC(PUTSTATIC s) {
        String one = s.getClassName(this.poolGen);
        String two = s.getFieldName(this.poolGen);
        String three = s.getName(this.poolGen);
        String four = s.getSignature(this.poolGen);
        String five = s.getClassType(this.poolGen) + "";
        String six = s.getFieldType(this.poolGen) + "";
        this.log.log("         instr(putstatic)a=" + one, 4);
        this.log.log("         instr(putstatic)b=" + two, 4);
        this.log.log("         instr(putstatic)c=" + three, 4);
        this.log.log("         instr(putstatic)d=" + four, 4);
        this.log.log("         instr(putstatic)e=" + five, 4);
        this.log.log("         instr(putstatic)f=" + six, 4);
        String className = s.getFieldName(this.poolGen);
        if ("staticField".equals(className)) {
            return;
        }
        if (!className.startsWith("class$") && !className.startsWith("array$")) {
            return;
        }
        this.log.log("         instr(putstatic)1=" + className, 4);
        className = className.substring(6, className.length());
        this.log.log("         instr(putstatic)2=" + className, 4);
        className = className.replace('$', '.');
        this.log.log("         instr(putstatic)3=" + className, 4);
        this.design.checkClass(className);
    }
}

