/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends ExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "system-property");
    private ThreadLocal<XProcRuntime> tl_runtime = new ThreadLocal<XProcRuntime>(){

        @Override
        protected synchronized XProcRuntime initialValue() {
            return null;
        }
    };

    protected SystemProperty() {
    }

    public SystemProperty(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SystemPropertyCall();
    }

    private class SystemPropertyCall
    extends ExtensionFunctionCall {
        private StaticContext staticContext = null;

        private SystemPropertyCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.staticContext = context;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            StructuredQName propertyName = null;
            XProcRuntime runtime = (XProcRuntime)SystemProperty.this.tl_runtime.get();
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            try {
                SequenceIterator iter = arguments[0];
                String lexicalQName = iter.next().getStringValue();
                propertyName = StructuredQName.fromLexicalQName((CharSequence)lexicalQName, (boolean)false, (NameChecker)context.getConfiguration().getNameChecker(), (NamespaceResolver)this.staticContext.getNamespaceResolver());
            }
            catch (XPathException e) {
                if (e.getErrorCodeLocalPart() == null || e.getErrorCodeLocalPart().equals("FOCA0002") || e.getErrorCodeLocalPart().equals("FONS0004")) {
                    e.setErrorCode("XTDE1390");
                }
                throw e;
            }
            String uri = propertyName.getNamespaceURI();
            String local = propertyName.getLocalName();
            String value = "";
            if (uri.equals("http://www.w3.org/ns/xproc")) {
                if ("episode".equals(local)) {
                    value = runtime.getEpisode();
                } else if ("language".equals(local)) {
                    value = runtime.getLanguage();
                } else if ("product-name".equals(local)) {
                    value = runtime.getProductName();
                } else if ("product-version".equals(local)) {
                    value = runtime.getProductVersion();
                } else if ("vendor".equals(local)) {
                    value = runtime.getVendor();
                } else if ("vendor-uri".equals(local)) {
                    value = runtime.getVendorURI();
                } else if ("version".equals(local)) {
                    value = runtime.getXProcVersion();
                } else if ("xpath-version".equals(local)) {
                    value = runtime.getXPathVersion();
                } else if ("psvi-supported".equals(local)) {
                    value = runtime.getPSVISupported() ? "true" : "false";
                }
            } else if (uri.equals("http://xmlcalabash.com/ns/extensions")) {
                if ("transparent-json".equals(local)) {
                    value = runtime.transparentJSON() ? "true" : "false";
                } else if ("json-flavor".equals(local)) {
                    value = runtime.jsonFlavor();
                } else if ("general-values".equals(local)) {
                    value = runtime.getAllowGeneralExpressions() ? "true" : "false";
                } else if ("xpointer-on-text".equals(local)) {
                    value = runtime.getAllowXPointerOnText() ? "true" : "false";
                } else if ("use-xslt-1.0".equals(local) || "use-xslt-10".equals(local)) {
                    value = runtime.getUseXslt10Processor() ? "true" : "false";
                } else if ("saxon-version".equals(local)) {
                    value = runtime.getConfiguration().getProcessor().getSaxonProductVersion();
                } else if ("saxon-edition".equals(local)) {
                    value = runtime.getConfiguration().saxonProcessor;
                }
            }
            return SingletonIterator.makeIterator((Item)new StringValue((CharSequence)value));
        }
    }
}

