/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NAssign
extends NNode {
    static final long serialVersionUID = 928890389856851537L;
    public List<NNode> targets;
    public NNode rvalue;

    public NAssign(List<NNode> targets, NNode rvalue) {
        this(targets, rvalue, 0, 1);
    }

    public NAssign(List<NNode> targets, NNode rvalue, int start, int end) {
        super(start, end);
        this.targets = targets;
        this.rvalue = rvalue;
        this.addChildren(targets);
        this.addChildren(rvalue);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        NameBinder binder = NameBinder.make();
        for (NNode target : this.targets) {
            binder.bind(s, target, (NType)new NUnknownType());
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NType valueType = NAssign.resolveExpr(this.rvalue, s);
        switch (this.targets.size()) {
            case 0: {
                break;
            }
            case 1: {
                NameBinder.make().bind(s, this.targets.get(0), valueType);
                break;
            }
            default: {
                NameBinder.make().bind(s, this.targets, valueType);
            }
        }
        return this.setType(valueType);
    }

    public String toString() {
        return "<Assign:" + this.targets + "=" + this.rvalue + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.targets, v);
            this.visitNode(this.rvalue, v);
        }
    }
}

