/* Generated by re2c */
// re2rust $INPUT -o $OUTPUT

#[derive(Debug, PartialEq)]
struct SemVer(u32, u32, u32); // version: (major, minor, patch)

fn s2n(str: &[u8]) -> u32 { // convert a pre-parsed string to a number
    let mut n = 0;
    for i in str { n = n * 10 + *i as u32 - 48; }
    return n;
}

fn parse(str: &[u8]) -> Option<SemVer> {
    let (mut cur, mut mar) = (0, 0);

    // User-defined tag variables that are available in semantic action.
    let (t1, mut t2, t3, t4, t5);

    // Autogenerated tag variables used by the lexer to track tag values.
    const NONE: usize = std::usize::MAX;
    let mut yyt1 = NONE;let mut yyt2 = NONE;let mut yyt3 = NONE;let mut yyt4 = NONE;

    
{
	#[allow(unused_assignments)]
	let mut yych : u8 = 0;
	let mut yystate : usize = 0;
	'yyl: loop {
		match yystate {
			0 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x30 ..= 0x39 => {
						yyt1 = cur;
						cur += 1;
						yystate = 3;
						continue 'yyl;
					}
					_ => {
						cur += 1;
						yystate = 1;
						continue 'yyl;
					}
				}
			}
			1 => {
				yystate = 2;
				continue 'yyl;
			}
			2 => { return None; }
			3 => {
				mar = cur;
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x2E => {
						cur += 1;
						yystate = 4;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						cur += 1;
						yystate = 6;
						continue 'yyl;
					}
					_ => {
						yystate = 2;
						continue 'yyl;
					}
				}
			}
			4 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x30 ..= 0x39 => {
						yyt2 = cur;
						cur += 1;
						yystate = 7;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			5 => {
				cur = mar;
				yystate = 2;
				continue 'yyl;
			}
			6 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x2E => {
						cur += 1;
						yystate = 4;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						cur += 1;
						yystate = 6;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			7 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x00 => {
						yyt3 = cur;
						yyt4 = NONE;
						cur += 1;
						yystate = 8;
						continue 'yyl;
					}
					0x2E => {
						yyt3 = cur;
						cur += 1;
						yystate = 9;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						cur += 1;
						yystate = 7;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			8 => {
				t1 = yyt1;
				t3 = yyt2;
				t4 = yyt3;
				t5 = yyt4;
				t2 = yyt2;
				t2 -= --1isize as usize;
				{
            let major = s2n(&str[t1..t2]);
            let minor = s2n(&str[t3..t4]);
            let patch = if t5 != NONE {s2n(&str[t5..cur - 1])} else {0};
            return Some(SemVer(major, minor, patch));
        }
			}
			9 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x30 ..= 0x39 => {
						yyt4 = cur;
						cur += 1;
						yystate = 10;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			10 => {
				yych = unsafe {*str.get_unchecked(cur)};
				match yych {
					0x00 => {
						cur += 1;
						yystate = 8;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						cur += 1;
						yystate = 10;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			_ => {
				panic!("internal lexer error")
			}
		}
	}
}

}

fn main() {
    assert_eq!(parse(b"23.34\0"), Some(SemVer(23, 34, 0)));
    assert_eq!(parse(b"1.2.99999\0"), Some(SemVer(1, 2, 99999)));
    assert_eq!(parse(b"1.a\0"), None);
}
