/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLParam
extends XSLVariableDeclaration {
    Expression conversion = null;

    protected boolean allowsValue() {
        return !(this.getParent() instanceof XSLFunction);
    }

    protected boolean allowsRequired() {
        return ((StyleElement)this.getParent()).mayContainParam("required");
    }

    protected boolean allowsTunnelAttribute() {
        return true;
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo parent = this.getParent();
        this.global = parent instanceof XSLStylesheet;
        if (!(parent instanceof StyleElement) || !((StyleElement)parent).mayContainParam(null)) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet", "XTSE0010");
        }
        if (!this.global) {
            NodeInfo node;
            AxisIterator preceding = this.iterateAxis((byte)11);
            while ((node = (NodeInfo)preceding.next()) != null) {
                if (node instanceof XSLParam) {
                    if (!this.getVariableQName().equals(((XSLParam)node).getVariableQName())) continue;
                    this.compileError("The name of the parameter is not unique", "XTSE0580");
                    continue;
                }
                if (node instanceof StyleElement) {
                    this.compileError("xsl:param must not be preceded by other instructions", "XTSE0010");
                    continue;
                }
                if (Whitespace.isWhite(node.getStringValueCS())) continue;
                this.compileError("xsl:param must not be preceded by text", "XTSE0010");
            }
            SlotManager p = this.getContainingSlotManager();
            if (p == null) {
                this.compileError("Local variable must be declared within a template or function", "XTSE0010");
            } else {
                this.setSlotNumber(p.allocateSlotNumber(this.getVariableQName()));
            }
        }
        if (this.requiredParam) {
            if (this.select != null) {
                this.compileError("The select attribute should be omitted when required='yes'", "XTSE0010");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate(decl);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        GeneralVariable inst;
        if (this.redundant) {
            return null;
        }
        if (this.getParent() instanceof XSLFunction) {
            return null;
        }
        int slot = this.getSlotNumber();
        if (this.requiredType != null) {
            SuppliedParameterReference pref = new SuppliedParameterReference(slot);
            pref.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
            RoleLocator role = new RoleLocator(8, (Serializable)((Object)this.getVariableDisplayName()), 0);
            role.setErrorCode("XTTE0590");
            this.conversion = TypeChecker.staticTypeCheck(pref, this.requiredType, false, role, this.makeExpressionVisitor());
        }
        if (this.global) {
            inst = new GlobalParam();
            ((GlobalVariable)inst).setExecutable(this.getExecutable());
            inst.setContainer((Container)((Object)inst));
            if (this.isRequiredParam()) {
                this.getExecutable().addRequiredParam(this.getVariableQName());
            }
            if (this.select != null) {
                this.select.setContainer((GlobalVariable)inst);
            }
            this.compiledVariable = inst;
        } else {
            PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
            inst = new LocalParam();
            ((LocalParam)inst).setConversion(this.conversion);
            ((LocalParam)inst).setParameterId(psm.allocateUniqueParameterNumber(this.getVariableQName()));
        }
        this.initializeInstruction(exec, decl, inst);
        inst.setVariableQName(this.getVariableQName());
        inst.setSlotNumber(slot);
        inst.setRequiredType(this.getRequiredType());
        this.fixupBinding(inst);
        this.compiledVariable = inst;
        return inst;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType != null) {
            return this.requiredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

