/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.NamespaceIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMAttributeMap
implements NamedNodeMap {
    private NodeInfo parent;
    private int numberOfNamespaces = -1;

    public DOMAttributeMap(NodeInfo parent) {
        this.parent = parent;
    }

    public Node getNamedItem(String name) {
        NodeInfo att;
        if (name.equals("xmlns")) {
            int[] nsarray = this.parent.getDeclaredNamespaces(null);
            for (int i = 0; i < nsarray.length; ++i) {
                if (nsarray[i] == -1) {
                    return null;
                }
                if ((nsarray[i] >> 16 & 0xFFFF) != 0) continue;
                NamespaceIterator.NamespaceNodeImpl nn = new NamespaceIterator.NamespaceNodeImpl(this.parent, nsarray[i], i + 1);
                return NodeOverNodeInfo.wrap(nn);
            }
            return null;
        }
        if (name.startsWith("xmlns:")) {
            String prefix = name.substring(6);
            if (prefix.equals("xml")) {
                NamespaceIterator.NamespaceNodeImpl nn = new NamespaceIterator.NamespaceNodeImpl(this.parent, 1, 0);
                return NodeOverNodeInfo.wrap(nn);
            }
            int[] buffer = new int[8];
            int[] nsarray = this.parent.getDeclaredNamespaces(buffer);
            for (int i = 0; i < nsarray.length; ++i) {
                if (nsarray[i] == -1) {
                    return null;
                }
                if (!prefix.equals(this.parent.getNamePool().getPrefixFromNamespaceCode(nsarray[i]))) continue;
                NamespaceIterator.NamespaceNodeImpl nn = new NamespaceIterator.NamespaceNodeImpl(this.parent, nsarray[i], i + 1);
                return NodeOverNodeInfo.wrap(nn);
            }
            return null;
        }
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        do {
            if ((att = (NodeInfo)atts.next()) != null) continue;
            return null;
        } while (!name.equals(att.getDisplayName()));
        return NodeOverNodeInfo.wrap(att);
    }

    public Node item(int index) {
        if (index < 0) {
            return null;
        }
        if (index == 0) {
            NamespaceIterator.NamespaceNodeImpl nn = new NamespaceIterator.NamespaceNodeImpl(this.parent, 65537, 0);
            return NodeOverNodeInfo.wrap(nn);
        }
        int nscount = this.getNumberOfNamespaces();
        if (index < nscount) {
            int[] buffer = new int[8];
            int[] nsList = this.parent.getDeclaredNamespaces(buffer);
            int nscode = nsList[index - 1];
            NamespaceIterator.NamespaceNodeImpl nn = new NamespaceIterator.NamespaceNodeImpl(this.parent, nscode, index);
            return NodeOverNodeInfo.wrap(nn);
        }
        int pos = 0;
        int attNr = index - nscount;
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        NodeInfo att;
        while ((att = (NodeInfo)atts.next()) != null) {
            if (pos == attNr) {
                return NodeOverNodeInfo.wrap(att);
            }
            ++pos;
        }
        return null;
    }

    private int getNumberOfNamespaces() {
        if (this.numberOfNamespaces == -1) {
            int[] buffer = new int[8];
            int[] nsList = this.parent.getDeclaredNamespaces(buffer);
            int count = nsList.length;
            for (int i = 0; i < count; ++i) {
                if (nsList[i] != -1) continue;
                count = i;
                break;
            }
            this.numberOfNamespaces = count + 1;
        }
        return this.numberOfNamespaces;
    }

    public int getLength() {
        int length = 0;
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        while (atts.next() != null) {
            ++length;
        }
        return this.getNumberOfNamespaces() + length;
    }

    public Node getNamedItemNS(String uri, String localName) {
        NodeInfo att;
        if (uri == null) {
            uri = "";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return this.getNamedItem("xmlns:" + localName);
        }
        if (uri.equals("") && localName.equals("xmlns")) {
            return this.getNamedItem("xmlns");
        }
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        do {
            if ((att = (NodeInfo)atts.next()) != null) continue;
            return null;
        } while (!uri.equals(att.getURI()) || !localName.equals(att.getLocalPart()));
        return NodeOverNodeInfo.wrap(att);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeNamedItem(String name) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeNamedItemNS(String uri, String localName) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }
}

