/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.StringTokenizer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.StringValue;

public class StringTokenIterator
implements UnfailingIterator {
    private String theString;
    private String delimiters;
    private StringTokenizer tokenizer;
    private String current;
    private int position = 0;

    public StringTokenIterator(String string) {
        this.theString = string;
        this.delimiters = null;
        this.tokenizer = new StringTokenizer(string, " \t\n\r", false);
    }

    public StringTokenIterator(String string, String delimiters) {
        this.theString = string;
        this.delimiters = delimiters;
        this.tokenizer = new StringTokenizer(string, delimiters, false);
    }

    public Item next() {
        if (this.tokenizer.hasMoreElements()) {
            this.current = (String)this.tokenizer.nextElement();
            ++this.position;
            return new StringValue(this.current);
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    public Item current() {
        return this.current == null ? null : new StringValue(this.current);
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        if (this.delimiters == null) {
            return new StringTokenIterator(this.theString);
        }
        return new StringTokenIterator(this.theString, this.delimiters);
    }

    public int getProperties() {
        return 0;
    }
}

