# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="libpcap-based tool to collect network traffic data and emit it as NetFlow flows"
HOMEPAGE="https://fprobe.sourceforge.net"
SRC_URI="https://downloads.sourceforge.net/fprobe/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ppc x86"
IUSE="debug messages"

RDEPEND="net-libs/libpcap"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}"/fprobe-1.1-pidfile-sanity.patch
	"${FILESDIR}"/fprobe-1.1-setgroups.patch
	"${FILESDIR}"/fprobe-1.1-autoconf.patch
)

src_prepare() {
	default

	# Clang 16, bug #899924
	eautoreconf
}

src_configure() {
	econf \
		$(use_enable debug) \
		$(use_enable messages)
}

src_install() {
	default

	docinto contrib
	dodoc contrib/tg.sh

	newinitd "${FILESDIR}"/init.d-fprobe-r1 fprobe
	newconfd "${FILESDIR}"/conf.d-fprobe-r1 fprobe
}
