# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=hatchling
PYTHON_COMPAT=( python3_{11..14} )

inherit distutils-r1

DESCRIPTION="Python 3 client for the beanstalkd work queue"
HOMEPAGE="
	https://greenstalk.readthedocs.io/
	https://github.com/justinmayhew/greenstalk/
	https://pypi.org/project/greenstalk/
"
SRC_URI="
	https://github.com/justinmayhew/greenstalk/archive/v${PV}.tar.gz
		-> ${P}.gh.tar.gz
"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~x86"

BDEPEND="
	test? (
		app-misc/beanstalkd
	)
"

EPYTEST_PLUGINS=()
distutils_enable_tests pytest
