/*  MaitreTarot.
 *  (C) 2002 Yves Mettier <ymettier@libertysurf.fr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <libintl.h>
#define _(a) gettext (a)
#include <stdlib.h>
#include <maitretarot.h>
#include "main.h"
#include "config_utils.h"



#define DEFAULT_CONFIG_SERVER_PORT "2551"
#define DEFAULT_CONFIG_HOST_NAME "localhost"
#define DEFAULT_CONFIG_PLAYER_NAME "no_name"

#define DEFAULT_CONFIG_STRING "<?xml version=\"1.0\" standalone='yes'?>\n" \
                              "<maitretarot>\n" \
                              "  <client name='mt_ncurses_client' type='ia'>\n" \
                              "    <port>" DEFAULT_CONFIG_SERVER_PORT "</port>\n" \
                              "    <host_name><![CDATA[" DEFAULT_CONFIG_HOST_NAME "]]></host_name>\n" \
                              "    <player_name><![CDATA[" DEFAULT_CONFIG_PLAYER_NAME "]]>></player_name>\n" \
                              "  </client>\n" \
                              "</maitretarot>"






gint
conf_update_with_command_line (config_t * conf, int argc, char **argv)
{
  int i;
  args_e prev_arg;

  prev_arg = ARGS_UNSET;
  for (i = 0; i < argc; i++)
    {
      if (prev_arg == ARGS_UNSET)
	{
	  if (!strcmp (argv[i], "-h"))
	    {
	      show_usage (argv[0]);
	      return (-1);
	    }
	  else if (!strcmp (argv[i], "--help"))
	    {
	      show_usage (argv[0]);
	      return (-1);
	    }
	  else if (!strcmp (argv[i], "--version"))
	    {
	      g_print (VERSION);
	      return (-2);
	    }
	  else if (!strcmp (argv[i], "-v"))
	    {
	      g_print (VERSION);
	      return (-2);
	    }
	  else if (!strncmp (argv[i], "--port=", sizeof ("--port")))
	    {
	      conf->port = atoi (&(argv[i][sizeof ("--port")]));
	    }
	  else if (!strncmp
		   (argv[i], "--player-name=", sizeof ("--player-name")))
	    {
	      if (conf->player_name)
		g_string_free (conf->player_name, TRUE);
	      conf->player_name =
		g_string_new (&(argv[i][sizeof ("--player-name")]));
	    }
	  else if (!strncmp (argv[i], "--server=", sizeof ("--server")))
	    {
	      if (conf->host_name)
		g_string_free (conf->host_name, TRUE);
	      conf->host_name =
		g_string_new (&(argv[i][sizeof ("--server")]));
	    }
	  else if (!strcmp (argv[i], "-p"))
	    {
	      prev_arg = ARGS_PORT;
	    }
	  else if (!strcmp (argv[i], "-c"))
	    {
	      prev_arg = ARGS_CONFIG_FILE_NAME;
	    }
	  else if (!strcmp (argv[i], "-n"))
	    {
	      prev_arg = ARGS_PLAYERNAME;
	    }
	  else if (!strcmp (argv[i], "-s"))
	    {
	      prev_arg = ARGS_SERVER;
	    }
	}
      else if (prev_arg == ARGS_PORT)
	{
	  conf->port = atoi (argv[i]);
	  prev_arg = ARGS_UNSET;
	}
      else if (prev_arg == ARGS_PLAYERNAME)
	{
	  if (conf->player_name)
	    g_string_free (conf->player_name, TRUE);
	  conf->player_name = g_string_new (argv[i]);
	  prev_arg = ARGS_UNSET;
	}
      else if (prev_arg == ARGS_SERVER)
	{
	  if (conf->host_name)
	    g_string_free (conf->host_name, TRUE);
	  conf->host_name = g_string_new (argv[i]);
	  prev_arg = ARGS_UNSET;
	}
      else
	{
	  g_printerr (_("This case should never appear"));
	}
    }

  return (0);
}

void
conf_free (config_t * conf)
{
  if (conf->host_name)
    g_string_free (conf->host_name, TRUE);
  if (conf->player_name)
    g_string_free (conf->player_name, TRUE);
  g_free (conf);
}

config_t *
config_read (int argc, char **argv)
{
  config_t *conf;
  const gchar *key;
  int i;
  const gchar default_config_file_name[] = CONFIGFILENAME;
  const gchar *config_file_name = NULL;

/* Find if a config file name was specified in the command line */
  for (i = 0; i < argc; i++)
    {
      if (!strcmp (argv[i], "-c"))
	{
	  i++;
	  if (i < argc)
	    {
	      config_file_name = argv[i];
	      break;
	    }
	  else
	    {
	      show_usage (argv[0]);
	      return (NULL);
	    }
	}
      else if (!strncmp
	       (argv[i], "--config-file-name=",
		sizeof ("--config-file-name")))
	{
	  config_file_name = &(argv[i][sizeof ("--config-file-name")]);
	  break;
	}
    }
  if (!config_file_name)
    config_file_name = default_config_file_name;

/* Init the config */

  if (!libmt_xmlconfig_init_from_file (config_file_name))
    {
      g_message (_("Could not load config file. Using the default one. "));
      if (!libmt_xmlconfig_init_from_string (DEFAULT_CONFIG_STRING))
	{
	  g_error (_("Could use the default config. Aborting. "));
	  return (NULL);
	}
    }
  conf = g_malloc (sizeof (config_t));
  if (!conf)
    g_error (_("Not enough memory. Aborting."));


  /* Port */
  conf->port = 0;
  key = libmt_xmlconfig_get_value
    ("/maitretarot/client[@name='mt_ncurses_client']/port/text()");
  if (key)
    conf->port = atoi (key);
  if (conf->port == 0)
    conf->port = atoi (DEFAULT_CONFIG_SERVER_PORT);

  /* host name */
  conf->host_name = NULL;
  key = libmt_xmlconfig_get_value
    ("/maitretarot/client[@name='mt_ncurses_client']/host_name/text()");
  if (key)
    conf->host_name = g_string_new (key);
  if (!conf->host_name)
    conf->host_name = g_string_new (DEFAULT_CONFIG_HOST_NAME);

  /* player name */
  conf->player_name = NULL;
  key = libmt_xmlconfig_get_value
    ("/maitretarot/client[@name='mt_ncurses_client']/player_name/text()");
  if (key)
    conf->player_name = g_string_new (key);
  if (!conf->player_name)
    conf->player_name = g_string_new (DEFAULT_CONFIG_PLAYER_NAME);

  i = conf_update_with_command_line (conf, argc, argv);
  if (i != 0)
    {
      conf_free (conf);
      return (NULL);
    }
  return (conf);
}

void
config_print (config_t * config)
{
  printf ("\n==========================================\n"
	  "Dump of config_t structure\n"
	  "==========================================\n");
  printf ("host_name = '%s'\n", config->host_name->str);
  printf ("port = '%d'\n", config->port);
  printf ("player_name = '%s'\n", config->player_name->str);
  printf ("==========================================\n");
}
