/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.util.CollectionUtils;

@ThreadSafe
public class AmbiguousBindingReporter {
    private static final String INDENT = "  ";
    private static final Comparator<Provider> PROVIDER_COMPARATOR = new Comparator<Provider>(){

        @Override
        public int compare(Provider o1, Provider o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private final String referenceType;
    private final String referenceDescription;
    private final List<Provider> providers;

    public AmbiguousBindingReporter(ModelReference<?> reference, ModelPath path1, ModelRuleDescriptor creator1, ModelPath path2, ModelRuleDescriptor creator2) {
        this(reference.getType().toString(), reference.getDescription(), (List<Provider>)ImmutableList.of((Object)new Provider(String.valueOf(path1), String.valueOf(creator1)), (Object)new Provider(String.valueOf(path2), String.valueOf(creator2))));
    }

    public AmbiguousBindingReporter(String referenceType, String referenceDescription, List<Provider> providers) {
        this.referenceType = referenceType;
        this.referenceDescription = referenceDescription;
        this.providers = CollectionUtils.sort(providers, PROVIDER_COMPARATOR);
    }

    public String asString() {
        StringWriter string = new StringWriter();
        this.writeTo(new PrintWriter(string));
        return string.toString();
    }

    public void writeTo(PrintWriter writer) {
        writer.print("Type-only model reference of type ");
        writer.print(this.referenceType);
        if (this.referenceDescription != null) {
            writer.print(" (");
            writer.print(this.referenceDescription);
            writer.print(")");
        }
        writer.println(" is ambiguous as multiple model elements are available for this type:");
        boolean first = true;
        for (Provider provider : this.providers) {
            if (!first) {
                writer.println();
            }
            writer.print(INDENT);
            writer.print("- ");
            writer.print(provider.getPath());
            writer.print(" (created by: ");
            writer.print(provider.getDescription());
            writer.print(")");
            first = false;
        }
    }

    public static class Provider {
        private final String description;
        private final String path;

        public Provider(String path, String description) {
            this.description = description;
            this.path = path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPath() {
            return this.path;
        }
    }
}

