/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    private static final long serialVersionUID = 1427967607557438968L;
    public static final String CLASS_NAME = "DataView";
    private static final int Id_constructor = 1;
    private static final int Id_getInt8 = 2;
    private static final int Id_getUint8 = 3;
    private static final int Id_getInt16 = 4;
    private static final int Id_getUint16 = 5;
    private static final int Id_getInt32 = 6;
    private static final int Id_getUint32 = 7;
    private static final int Id_getFloat32 = 8;
    private static final int Id_getFloat64 = 9;
    private static final int Id_setInt8 = 10;
    private static final int Id_setUint8 = 11;
    private static final int Id_setInt16 = 12;
    private static final int Id_setUint16 = 13;
    private static final int Id_setInt32 = 14;
    private static final int Id_setUint32 = 15;
    private static final int Id_setFloat32 = 16;
    private static final int Id_setFloat64 = 17;
    private static final int MAX_PROTOTYPE_ID = 17;

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeDataView nativeDataView = new NativeDataView();
        nativeDataView.exportAsJSClass(17, scriptable, bl);
    }

    private void rangeCheck(int n, int n2) {
        if (n < 0 || n + n2 > this.byteLength) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
    }

    private void checkOffset(Object[] objectArray, int n) {
        if (objectArray.length <= n) {
            throw ScriptRuntime.constructError("TypeError", "missing required offset parameter");
        }
        if (Undefined.instance.equals(objectArray[n])) {
            throw ScriptRuntime.constructError("RangeError", "invalid offset");
        }
    }

    private void checkValue(Object[] objectArray, int n) {
        if (objectArray.length <= n) {
            throw ScriptRuntime.constructError("TypeError", "missing required value parameter");
        }
        if (Undefined.instance.equals(objectArray[n])) {
            throw ScriptRuntime.constructError("RangeError", "invalid value parameter");
        }
    }

    private static NativeDataView realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeDataView)) {
            throw NativeDataView.incompatibleCallError(idFunctionObject);
        }
        return (NativeDataView)scriptable;
    }

    private NativeDataView js_constructor(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        if (n2 < 0) {
            throw ScriptRuntime.constructError("RangeError", "length out of range");
        }
        if (n < 0 || n + n2 > nativeArrayBuffer.getLength()) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        return new NativeDataView(nativeArrayBuffer, n, n2);
    }

    private Object js_getInt(int n, boolean bl, Object[] objectArray) {
        this.checkOffset(objectArray, 0);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl2 = NativeDataView.isArg(objectArray, 1) && n > 1 && ScriptRuntime.toBoolean(objectArray[1]);
        switch (n) {
            case 1: {
                return bl ? ByteIo.readInt8(this.arrayBuffer.buffer, n2) : ByteIo.readUint8(this.arrayBuffer.buffer, n2);
            }
            case 2: {
                return bl ? ByteIo.readInt16(this.arrayBuffer.buffer, n2, bl2) : ByteIo.readUint16(this.arrayBuffer.buffer, n2, bl2);
            }
            case 4: {
                return bl ? ByteIo.readInt32(this.arrayBuffer.buffer, n2, bl2) : ByteIo.readUint32(this.arrayBuffer.buffer, n2, bl2);
            }
        }
        throw new AssertionError();
    }

    private Object js_getFloat(int n, Object[] objectArray) {
        this.checkOffset(objectArray, 0);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl = NativeDataView.isArg(objectArray, 1) && n > 1 && ScriptRuntime.toBoolean(objectArray[1]);
        switch (n) {
            case 4: {
                return ByteIo.readFloat32(this.arrayBuffer.buffer, n2, bl);
            }
            case 8: {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, n2, bl);
            }
        }
        throw new AssertionError();
    }

    private void js_setInt(int n, boolean bl, Object[] objectArray) {
        this.checkOffset(objectArray, 0);
        this.checkValue(objectArray, 1);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl2 = NativeDataView.isArg(objectArray, 2) && n > 1 && ScriptRuntime.toBoolean(objectArray[2]);
        switch (n) {
            case 1: {
                if (bl) {
                    ByteIo.writeInt8(this.arrayBuffer.buffer, n2, Conversions.toInt8(objectArray[1]));
                    break;
                }
                ByteIo.writeUint8(this.arrayBuffer.buffer, n2, Conversions.toUint8(objectArray[1]));
                break;
            }
            case 2: {
                if (bl) {
                    ByteIo.writeInt16(this.arrayBuffer.buffer, n2, Conversions.toInt16(objectArray[1]), bl2);
                    break;
                }
                ByteIo.writeUint16(this.arrayBuffer.buffer, n2, Conversions.toUint16(objectArray[1]), bl2);
                break;
            }
            case 4: {
                if (bl) {
                    ByteIo.writeInt32(this.arrayBuffer.buffer, n2, Conversions.toInt32(objectArray[1]), bl2);
                    break;
                }
                ByteIo.writeUint32(this.arrayBuffer.buffer, n2, Conversions.toUint32(objectArray[1]), bl2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void js_setFloat(int n, Object[] objectArray) {
        this.checkOffset(objectArray, 0);
        this.checkValue(objectArray, 1);
        int n2 = ScriptRuntime.toInt32(objectArray[0]);
        this.rangeCheck(n2, n);
        boolean bl = NativeDataView.isArg(objectArray, 2) && n > 1 && ScriptRuntime.toBoolean(objectArray[2]);
        double d = ScriptRuntime.toNumber(objectArray[1]);
        switch (n) {
            case 4: {
                ByteIo.writeFloat32(this.arrayBuffer.buffer, n2, d, bl);
                break;
            }
            case 8: {
                ByteIo.writeFloat64(this.arrayBuffer.buffer, n2, d, bl);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(this.getClassName())) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (NativeDataView.isArg(objectArray, 0) && objectArray[0] instanceof NativeArrayBuffer) {
                    NativeArrayBuffer nativeArrayBuffer = (NativeArrayBuffer)objectArray[0];
                    int n2 = NativeDataView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                    int n3 = NativeDataView.isArg(objectArray, 2) ? ScriptRuntime.toInt32(objectArray[2]) : nativeArrayBuffer.getLength() - n2;
                    return this.js_constructor(nativeArrayBuffer, n2, n3);
                }
                throw ScriptRuntime.constructError("TypeError", "Missing parameters");
            }
            case 2: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(1, true, objectArray);
            }
            case 3: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(1, false, objectArray);
            }
            case 4: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(2, true, objectArray);
            }
            case 5: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(2, false, objectArray);
            }
            case 6: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(4, true, objectArray);
            }
            case 7: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(4, false, objectArray);
            }
            case 8: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getFloat(4, objectArray);
            }
            case 9: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getFloat(8, objectArray);
            }
            case 10: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(1, true, objectArray);
                return Undefined.instance;
            }
            case 11: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(1, false, objectArray);
                return Undefined.instance;
            }
            case 12: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(2, true, objectArray);
                return Undefined.instance;
            }
            case 13: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(2, false, objectArray);
                return Undefined.instance;
            }
            case 14: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(4, true, objectArray);
                return Undefined.instance;
            }
            case 15: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(4, false, objectArray);
                return Undefined.instance;
            }
            case 16: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setFloat(4, objectArray);
                return Undefined.instance;
            }
            case 17: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setFloat(8, objectArray);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "getInt8";
                break;
            }
            case 3: {
                n2 = 1;
                string = "getUint8";
                break;
            }
            case 4: {
                n2 = 1;
                string = "getInt16";
                break;
            }
            case 5: {
                n2 = 1;
                string = "getUint16";
                break;
            }
            case 6: {
                n2 = 1;
                string = "getInt32";
                break;
            }
            case 7: {
                n2 = 1;
                string = "getUint32";
                break;
            }
            case 8: {
                n2 = 1;
                string = "getFloat32";
                break;
            }
            case 9: {
                n2 = 1;
                string = "getFloat64";
                break;
            }
            case 10: {
                n2 = 2;
                string = "setInt8";
                break;
            }
            case 11: {
                n2 = 2;
                string = "setUint8";
                break;
            }
            case 12: {
                n2 = 2;
                string = "setInt16";
                break;
            }
            case 13: {
                n2 = 2;
                string = "setUint16";
                break;
            }
            case 14: {
                n2 = 2;
                string = "setInt32";
                break;
            }
            case 15: {
                n2 = 2;
                string = "setUint32";
                break;
            }
            case 16: {
                n2 = 2;
                string = "setFloat32";
                break;
            }
            case 17: {
                n2 = 2;
                string = "setFloat64";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(this.getClassName(), n, string, n2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block19: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 7: {
                    char c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getInt8";
                        n = 2;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setInt8";
                    n = 10;
                    break;
                }
                case 8: {
                    char c = string.charAt(6);
                    if (c == '1') {
                        c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getInt16";
                            n = 4;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "setInt16";
                        n = 12;
                        break;
                    }
                    if (c == '3') {
                        c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getInt32";
                            n = 6;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "setInt32";
                        n = 14;
                        break;
                    }
                    if (c != 't') break;
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getUint8";
                        n = 3;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setUint8";
                    n = 11;
                    break;
                }
                case 9: {
                    char c = string.charAt(0);
                    if (c == 'g') {
                        c = string.charAt(8);
                        if (c == '2') {
                            string2 = "getUint32";
                            n = 7;
                            break;
                        }
                        if (c != '6') break;
                        string2 = "getUint16";
                        n = 5;
                        break;
                    }
                    if (c != 's') break;
                    c = string.charAt(8);
                    if (c == '2') {
                        string2 = "setUint32";
                        n = 15;
                        break;
                    }
                    if (c != '6') break;
                    string2 = "setUint16";
                    n = 13;
                    break;
                }
                case 10: {
                    char c = string.charAt(0);
                    if (c == 'g') {
                        c = string.charAt(9);
                        if (c == '2') {
                            string2 = "getFloat32";
                            n = 8;
                            break;
                        }
                        if (c != '4') break;
                        string2 = "getFloat64";
                        n = 9;
                        break;
                    }
                    if (c != 's') break;
                    c = string.charAt(9);
                    if (c == '2') {
                        string2 = "setFloat32";
                        n = 16;
                        break;
                    }
                    if (c != '4') break;
                    string2 = "setFloat64";
                    n = 17;
                    break;
                }
                case 11: {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block19;
            n = 0;
        }
        return n;
    }
}

